/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.directmemory.ODirectMemoryAllocator;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.listener.OListenerManger;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.profiler.OProfilerStub;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.OSignalHandler;
import com.orientechnologies.orient.core.OrientShutdownHook;
import com.orientechnologies.orient.core.cache.OLocalRecordCacheFactory;
import com.orientechnologies.orient.core.cache.OLocalRecordCacheFactoryImpl;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategyFactory;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseThreadLocalFactory;
import com.orientechnologies.orient.core.db.OrientDBEmbedded;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.record.ORecordFactoryManager;
import com.orientechnologies.orient.core.security.OSecuritySystem;
import com.orientechnologies.orient.core.shutdown.OShutdownHandler;
import com.orientechnologies.orient.core.storage.OStorage;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Orient
extends OListenerManger<OOrientListener> {
    public static final String ORIENTDB_HOME = "ORIENTDB_HOME";
    public static final String URL_SYNTAX = "<engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*";
    private static volatile Orient instance;
    private static final Lock initLock;
    private static volatile boolean registerDatabaseByPath;
    private final ConcurrentMap<String, OEngine> engines = new ConcurrentHashMap<String, OEngine>();
    private final Map<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY> dbLifecycleListeners = new LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY>();
    private final OScriptManager scriptManager = new OScriptManager();
    private final ThreadGroup threadGroup;
    private final ReadWriteLock engineLock = new ReentrantReadWriteLock();
    private final ORecordConflictStrategyFactory recordConflictStrategy = new ORecordConflictStrategyFactory();
    private final ReferenceQueue<OOrientStartupListener> removedStartupListenersQueue = new ReferenceQueue();
    private final ReferenceQueue<OOrientShutdownListener> removedShutdownListenersQueue = new ReferenceQueue();
    private final Set<OOrientStartupListener> startupListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WeakHashSetValueHolder<OOrientStartupListener>> weakStartupListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WeakHashSetValueHolder<OOrientShutdownListener>> weakShutdownListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final PriorityQueue<OShutdownHandler> shutdownHandlers = new PriorityQueue<OShutdownHandler>(11, new Comparator<OShutdownHandler>(){

        @Override
        public int compare(OShutdownHandler handlerOne, OShutdownHandler handlerTwo) {
            if (handlerOne.getPriority() > handlerTwo.getPriority()) {
                return 1;
            }
            if (handlerOne.getPriority() < handlerTwo.getPriority()) {
                return -1;
            }
            return 0;
        }
    });
    private final OLocalRecordCacheFactory localRecordCache = new OLocalRecordCacheFactoryImpl();
    private Set<OrientDBEmbedded> factories = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<OrientDBInternal> runningInstances = new HashSet<OrientDBInternal>();
    private final String os;
    private volatile Timer timer;
    private volatile ORecordFactoryManager recordFactoryManager = new ORecordFactoryManager();
    private OrientShutdownHook shutdownHook;
    private volatile OAbstractProfiler profiler;
    private ODatabaseThreadLocalFactory databaseThreadFactory;
    private volatile boolean active = false;
    private ThreadPoolExecutor workers;
    private OSignalHandler signalHandler;
    private volatile OSecuritySystem security;
    private boolean runningDistributed = false;
    private volatile boolean insideWebContainer;
    private static boolean initInProgress;

    Orient(boolean insideWebContainer) {
        super(true);
        this.insideWebContainer = insideWebContainer;
        this.os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        this.threadGroup = new ThreadGroup("OrientDB");
        this.threadGroup.setDaemon(false);
    }

    public boolean isInsideWebContainer() {
        return this.insideWebContainer;
    }

    public static Orient instance() {
        if (instance != null) {
            return instance;
        }
        return Orient.startUp(false);
    }

    public static Orient startUp(boolean insideWebContainer) {
        initLock.lock();
        try {
            if (initInProgress) {
                Orient orient = null;
                return orient;
            }
            initInProgress = true;
            if (instance != null) {
                Orient orient = instance;
                return orient;
            }
            Orient orient = new Orient(false);
            orient.startup();
            instance = orient;
        }
        finally {
            initInProgress = false;
            initLock.unlock();
        }
        return instance;
    }

    public static String getHomePath() {
        String v = System.getProperty("orient.home");
        if (v == null) {
            v = OSystemVariableResolver.resolveVariable(ORIENTDB_HOME);
        }
        return OFileUtils.getPath(v);
    }

    public static String getTempPath() {
        return OFileUtils.getPath(System.getProperty("java.io.tmpdir") + "/orientdb/");
    }

    public static boolean isRegisterDatabaseByPath() {
        return registerDatabaseByPath;
    }

    public static void setRegisterDatabaseByPath(boolean iValue) {
        registerDatabaseByPath = iValue;
    }

    public ORecordConflictStrategyFactory getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Orient startup() {
        this.engineLock.writeLock().lock();
        try {
            if (this.active) {
                Orient orient = this;
                return orient;
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.profiler = new OProfilerStub(false);
            this.shutdownHook = new OrientShutdownHook();
            if (this.signalHandler == null) {
                this.signalHandler = new OSignalHandler();
                this.signalHandler.installDefaultSignals();
            }
            int cores = Runtime.getRuntime().availableProcessors();
            this.workers = new OThreadPoolExecutorWithLogging(cores, cores * 3, 10L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(cores * 500){

                @Override
                public boolean offer(Runnable e) {
                    try {
                        this.put(e);
                        return true;
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
            });
            this.registerEngines();
            if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
                OGlobalConfiguration.dumpConfiguration(System.out);
            }
            this.active = true;
            for (OOrientStartupListener oOrientStartupListener : this.startupListeners) {
                try {
                    if (oOrientStartupListener == null) continue;
                    oOrientStartupListener.onStartup();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error on startup", e, new Object[0]);
                }
            }
            this.purgeWeakStartupListeners();
            for (WeakHashSetValueHolder weakHashSetValueHolder : this.weakStartupListeners) {
                try {
                    OOrientStartupListener l;
                    if (weakHashSetValueHolder == null || (l = (OOrientStartupListener)weakHashSetValueHolder.get()) == null) continue;
                    l.onStartup();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error on startup", e, new Object[0]);
                }
            }
            this.initShutdownQueue();
            this.registerWeakOrientStartupListener(this.profiler);
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
        return this;
    }

    public void addShutdownHandler(OShutdownHandler shutdownHandler) {
        this.engineLock.writeLock().lock();
        try {
            this.shutdownHandlers.add(shutdownHandler);
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
    }

    private void initShutdownQueue() {
        this.addShutdownHandler(new OShutdownWorkersHandler());
        this.addShutdownHandler(new OShutdownOrientDBInstancesHandler());
        this.addShutdownHandler(new OShutdownPendingThreadsHandler());
        this.addShutdownHandler(new OShutdownProfilerHandler());
        this.addShutdownHandler(new OShutdownCallListenersHandler());
    }

    private void registerEngines() {
        ClassLoader classLoader = Orient.class.getClassLoader();
        Iterator<OEngine> engines = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OEngine.class, classLoader);
        OEngine engine = null;
        while (engines.hasNext()) {
            try {
                engine = engines.next();
                this.registerEngine(engine);
            }
            catch (IllegalArgumentException e) {
                if (engine == null) continue;
                OLogManager.instance().debug((Object)this, "Failed to replace engine " + engine.getName(), e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Orient shutdown() {
        this.engineLock.writeLock().lock();
        try {
            if (!this.active) {
                Orient orient = this;
                return orient;
            }
            this.active = false;
            OLogManager.instance().info((Object)this, "Orient Engine is shutting down...", new Object[0]);
            for (OShutdownHandler handler : this.shutdownHandlers) {
                try {
                    OLogManager.instance().debug((Object)this, "Shutdown handler %s is going to be called", handler);
                    handler.shutdown();
                    OLogManager.instance().debug((Object)this, "Shutdown handler %s completed", handler);
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Exception during calling of shutdown handler %s", e, handler);
                }
            }
            this.shutdownHandlers.clear();
            OLogManager.instance().info((Object)this, "Clearing byte buffer pool", new Object[0]);
            OByteBufferPool.instance(null).clear();
            OByteBufferPool.instance(null).checkMemoryLeaks();
            ODirectMemoryAllocator.instance().checkMemoryLeaks();
            OLogManager.instance().info((Object)this, "OrientDB Engine shutdown complete", new Object[0]);
            OLogManager.instance().flush();
        }
        finally {
            try {
                this.removeShutdownHook();
            }
            finally {
                try {
                    this.removeSignalHandler();
                }
                finally {
                    this.engineLock.writeLock().unlock();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerTask scheduleTask(final Runnable task, long delay, long period) {
        this.engineLock.readLock().lock();
        try {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during execution of task " + task.getClass().getSimpleName(), e, new Object[0]);
                    }
                    catch (Error e) {
                        OLogManager.instance().error(this, "Error during execution of task " + task.getClass().getSimpleName(), e, new Object[0]);
                        throw e;
                    }
                }
            };
            if (this.active) {
                if (period > 0L) {
                    this.timer.schedule(timerTask, delay, period);
                } else {
                    this.timer.schedule(timerTask, delay);
                }
            } else {
                OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be scheduled.", new Object[0]);
            }
            TimerTask timerTask2 = timerTask;
            return timerTask2;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerTask scheduleTask(final Runnable task, Date firstTime, long period) {
        this.engineLock.readLock().lock();
        try {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during execution of task " + task.getClass().getSimpleName(), e, new Object[0]);
                    }
                    catch (Error e) {
                        OLogManager.instance().error(this, "Error during execution of task " + task.getClass().getSimpleName(), e, new Object[0]);
                        throw e;
                    }
                }
            };
            if (this.active) {
                if (period > 0L) {
                    this.timer.schedule(timerTask, firstTime, period);
                } else {
                    this.timer.schedule(timerTask, firstTime);
                }
            } else {
                OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be scheduled.", new Object[0]);
            }
            TimerTask timerTask2 = timerTask;
            return timerTask2;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Deprecated
    public ThreadPoolExecutor getWorkers() {
        return this.workers;
    }

    public Future<?> submit(Runnable runnable) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                Future<?> future = this.workers.submit(runnable);
                return future;
            }
            OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be submitted.", new Object[0]);
            throw new IllegalStateException("OrientDB engine is down. Task will not be submitted.");
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public <V> Future<V> submit(Callable<V> callable) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                Future<V> future = this.workers.submit(callable);
                return future;
            }
            OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be submitted.", new Object[0]);
            throw new IllegalStateException("OrientDB engine is down. Task will not be submitted.");
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public boolean isWindowsOS() {
        return this.os.contains("win");
    }

    public void registerEngine(OEngine iEngine) throws IllegalArgumentException {
        OEngine oEngine = (OEngine)this.engines.get(iEngine.getName());
        if (oEngine != null && !oEngine.getClass().isAssignableFrom(iEngine.getClass())) {
            throw new IllegalArgumentException("Cannot replace storage " + iEngine.getName());
        }
        this.engines.put(iEngine.getName(), iEngine);
    }

    public OEngine getEngine(String engineName) {
        this.engineLock.readLock().lock();
        try {
            OEngine oEngine = (OEngine)this.engines.get(engineName);
            return oEngine;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OEngine getEngineIfRunning(String engineName) {
        this.engineLock.readLock().lock();
        try {
            OEngine engine = (OEngine)this.engines.get(engineName);
            OEngine oEngine = engine == null || !engine.isRunning() ? null : engine;
            return oEngine;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OEngine getRunningEngine(String engineName) {
        this.engineLock.readLock().lock();
        try {
            OEngine engine = (OEngine)this.engines.get(engineName);
            if (engine == null) {
                throw new IllegalStateException("Engine '" + engineName + "' is not found.");
            }
            if (!engine.isRunning() && !this.startEngine(engine)) {
                throw new IllegalStateException("Engine '" + engineName + "' is failed to start.");
            }
            OEngine oEngine = engine;
            return oEngine;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public Set<String> getEngines() {
        this.engineLock.readLock().lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.engines.keySet());
            return set;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public Collection<OStorage> getStorages() {
        ArrayList<OStorage> storages = new ArrayList<OStorage>();
        for (OrientDBEmbedded factory : this.factories) {
            storages.addAll(factory.getStorages());
        }
        return storages;
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            this.shutdownHook.cancel();
            this.shutdownHook = null;
        }
    }

    public OSignalHandler getSignalHandler() {
        return this.signalHandler;
    }

    public void removeSignalHandler() {
        if (this.signalHandler != null) {
            this.signalHandler.cancel();
            this.signalHandler = null;
        }
    }

    public boolean isSelfManagedShutdown() {
        return this.shutdownHook != null;
    }

    public Iterator<ODatabaseLifecycleListener> getDbLifecycleListeners() {
        return new LinkedHashSet<ODatabaseLifecycleListener>(this.dbLifecycleListeners.keySet()).iterator();
    }

    public void addDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY> tmp = new LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY>(this.dbLifecycleListeners);
        if (iListener.getPriority() == null) {
            throw new IllegalArgumentException("Priority of DatabaseLifecycleListener '" + iListener + "' cannot be null");
        }
        tmp.put(iListener, iListener.getPriority());
        this.dbLifecycleListeners.clear();
        for (ODatabaseLifecycleListener.PRIORITY p : ODatabaseLifecycleListener.PRIORITY.values()) {
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.dbLifecycleListeners.put((ODatabaseLifecycleListener)e.getKey(), (ODatabaseLifecycleListener.PRIORITY)((Object)e.getValue()));
            }
        }
    }

    public void removeDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.remove(iListener);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ODatabaseThreadLocalFactory getDatabaseThreadFactory() {
        return this.databaseThreadFactory;
    }

    public ORecordFactoryManager getRecordFactoryManager() {
        return this.recordFactoryManager;
    }

    public void setRecordFactoryManager(ORecordFactoryManager iRecordFactoryManager) {
        this.recordFactoryManager = iRecordFactoryManager;
    }

    public OProfiler getProfiler() {
        return this.profiler;
    }

    public void setProfiler(OAbstractProfiler iProfiler) {
        this.profiler = iProfiler;
    }

    public OSecuritySystem getSecurity() {
        return this.security;
    }

    public void setSecurity(OSecuritySystem security) {
        this.security = security;
    }

    public void registerThreadDatabaseFactory(ODatabaseThreadLocalFactory iDatabaseFactory) {
        this.databaseThreadFactory = iDatabaseFactory;
    }

    public OScriptManager getScriptManager() {
        return this.scriptManager;
    }

    @Override
    public void registerListener(OOrientListener listener) {
        if (listener instanceof OOrientStartupListener) {
            this.registerOrientStartupListener((OOrientStartupListener)((Object)listener));
        }
        super.registerListener(listener);
    }

    @Override
    public void unregisterListener(OOrientListener listener) {
        if (listener instanceof OOrientStartupListener) {
            this.unregisterOrientStartupListener((OOrientStartupListener)((Object)listener));
        }
        super.unregisterListener(listener);
    }

    public void registerOrientStartupListener(OOrientStartupListener listener) {
        this.startupListeners.add(listener);
    }

    public void registerWeakOrientStartupListener(OOrientStartupListener listener) {
        this.purgeWeakStartupListeners();
        this.weakStartupListeners.add(new WeakHashSetValueHolder(listener, this.removedStartupListenersQueue));
    }

    public void unregisterOrientStartupListener(OOrientStartupListener listener) {
        this.startupListeners.remove(listener);
    }

    public void unregisterWeakOrientStartupListener(OOrientStartupListener listener) {
        this.purgeWeakStartupListeners();
        this.weakStartupListeners.remove(new WeakHashSetValueHolder(listener, null));
    }

    public void registerWeakOrientShutdownListener(OOrientShutdownListener listener) {
        this.purgeWeakShutdownListeners();
        this.weakShutdownListeners.add(new WeakHashSetValueHolder(listener, this.removedShutdownListenersQueue));
    }

    public void unregisterWeakOrientShutdownListener(OOrientShutdownListener listener) {
        this.purgeWeakShutdownListeners();
        this.weakShutdownListeners.remove(new WeakHashSetValueHolder(listener, null));
    }

    @Override
    public void resetListeners() {
        super.resetListeners();
        this.weakShutdownListeners.clear();
        this.startupListeners.clear();
        this.weakStartupListeners.clear();
    }

    public OLocalRecordCacheFactory getLocalRecordCache() {
        return this.localRecordCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeWeakStartupListeners() {
        ReferenceQueue<OOrientStartupListener> referenceQueue = this.removedStartupListenersQueue;
        synchronized (referenceQueue) {
            WeakHashSetValueHolder ref = (WeakHashSetValueHolder)this.removedStartupListenersQueue.poll();
            while (ref != null) {
                this.weakStartupListeners.remove(ref);
                ref = (WeakHashSetValueHolder)this.removedStartupListenersQueue.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeWeakShutdownListeners() {
        ReferenceQueue<OOrientShutdownListener> referenceQueue = this.removedShutdownListenersQueue;
        synchronized (referenceQueue) {
            WeakHashSetValueHolder ref = (WeakHashSetValueHolder)this.removedShutdownListenersQueue.poll();
            while (ref != null) {
                this.weakShutdownListeners.remove(ref);
                ref = (WeakHashSetValueHolder)this.removedShutdownListenersQueue.poll();
            }
        }
    }

    private boolean startEngine(OEngine engine) {
        String name = engine.getName();
        try {
            engine.startup();
            return true;
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Error during initialization of engine '%s', engine will be removed", e, name);
            try {
                engine.shutdown();
            }
            catch (Exception se) {
                OLogManager.instance().error(this, "Error during engine shutdown", se, new Object[0]);
            }
            this.engines.remove(name);
            return false;
        }
    }

    public boolean isRunningDistributed() {
        return this.runningDistributed;
    }

    public void setRunningDistributed(boolean runningDistributed) {
        this.runningDistributed = runningDistributed;
    }

    public void onEmbeddedFactoryInit(OrientDBEmbedded embeddedFactory) {
        OEngine disc;
        OEngine memory = (OEngine)this.engines.get("memory");
        if (!memory.isRunning()) {
            memory.startup();
        }
        if (!(disc = (OEngine)this.engines.get("plocal")).isRunning()) {
            disc.startup();
        }
        this.factories.add(embeddedFactory);
    }

    public void onEmbeddedFactoryClose(OrientDBEmbedded embeddedFactory) {
        this.factories.remove(embeddedFactory);
        if (this.factories.isEmpty()) {
            OEngine disc;
            OEngine memory = (OEngine)this.engines.get("memory");
            if (memory.isRunning()) {
                memory.shutdown();
            }
            if ((disc = (OEngine)this.engines.get("plocal")).isRunning()) {
                disc.shutdown();
            }
        }
    }

    public void addOrientDB(OrientDBInternal internal) {
        this.engineLock.writeLock().lock();
        try {
            this.runningInstances.add(internal);
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
    }

    public void removeOrientDB(OrientDBInternal internal) {
        this.engineLock.writeLock().lock();
        try {
            this.runningInstances.remove(internal);
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
    }

    static {
        initLock = new ReentrantLock();
        registerDatabaseByPath = false;
        initInProgress = false;
    }

    private class OShutdownCallListenersHandler
    implements OShutdownHandler {
        private OShutdownCallListenersHandler() {
        }

        @Override
        public int getPriority() {
            return 1400;
        }

        @Override
        public void shutdown() throws Exception {
            Orient.this.purgeWeakShutdownListeners();
            for (WeakHashSetValueHolder wl : Orient.this.weakShutdownListeners) {
                try {
                    OOrientShutdownListener l;
                    if (wl == null || (l = (OOrientShutdownListener)wl.get()) == null) continue;
                    l.onShutdown();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error during orient shutdown", e, new Object[0]);
                }
            }
            for (OOrientListener l : Orient.this.browseListeners()) {
                if (l == null) continue;
                try {
                    l.onShutdown();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error during orient shutdown", e, new Object[0]);
                }
            }
            System.gc();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private class OShutdownProfilerHandler
    implements OShutdownHandler {
        private OShutdownProfilerHandler() {
        }

        @Override
        public int getPriority() {
            return 1300;
        }

        @Override
        public void shutdown() throws Exception {
            Orient.this.profiler.shutdown();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private class OShutdownPendingThreadsHandler
    implements OShutdownHandler {
        private OShutdownPendingThreadsHandler() {
        }

        @Override
        public int getPriority() {
            return 1200;
        }

        @Override
        public void shutdown() throws Exception {
            if (Orient.this.threadGroup != null) {
                Orient.this.threadGroup.interrupt();
            }
            if (Orient.this.timer != null) {
                Orient.this.timer.cancel();
                Orient.this.timer = null;
            }
        }

        public String toString() {
            return "OShutdownPendingThreadsHandler";
        }
    }

    public class OShutdownWorkersHandler
    implements OShutdownHandler {
        @Override
        public int getPriority() {
            return 1000;
        }

        @Override
        public void shutdown() throws Exception {
            Orient.this.workers.shutdown();
            try {
                Orient.this.workers.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                OLogManager.instance().error(this, "Shutdown was interrupted", e, new Object[0]);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public class OShutdownOrientDBInstancesHandler
    implements OShutdownHandler {
        @Override
        public int getPriority() {
            return 1100;
        }

        @Override
        public void shutdown() throws Exception {
            for (OrientDBInternal internal : Orient.this.runningInstances) {
                internal.internalClose();
            }
            Orient.this.runningInstances.clear();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class WeakHashSetValueHolder<T>
    extends WeakReference<T> {
        private final int hashCode;

        private WeakHashSetValueHolder(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.hashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeakHashSetValueHolder that = (WeakHashSetValueHolder)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            Object thisObject = this.get();
            Object thatObject = that.get();
            if (thisObject == null && thatObject == null) {
                return super.equals(that);
            }
            if (thisObject != null && thatObject != null) {
                return thisObject.equals(thatObject);
            }
            return false;
        }
    }
}

