/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.orient.core.command.OScriptExecutor;
import com.orientechnologies.orient.core.command.OScriptInterceptor;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import java.util.ArrayList;
import java.util.List;

public abstract class OAbstractScriptExecutor
implements OScriptExecutor {
    protected String language;
    private List<OScriptInterceptor> interceptors = new ArrayList<OScriptInterceptor>();

    public OAbstractScriptExecutor(String language) {
        this.language = language;
    }

    @Override
    public void registerInterceptor(OScriptInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void preExecute(ODatabaseDocumentInternal database, String script, Object params) {
        this.interceptors.forEach(i -> i.preExecute(database, this.language, script, params));
    }

    @Override
    public void unregisterInterceptor(OScriptInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }
}

