/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.storage.OStorage;

public class ODatabaseDocumentEmbeddedPooled
extends ODatabaseDocumentEmbedded {
    private ODatabasePoolInternal pool;

    public ODatabaseDocumentEmbeddedPooled(ODatabasePoolInternal pool, OStorage storage) {
        super(storage);
        this.pool = pool;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.internalClose(true);
        this.pool.release(this);
    }

    @Override
    public void reuse() {
        this.activateOnCurrentThread();
        this.setStatus(ODatabase.STATUS.OPEN);
    }

    @Override
    public ODatabaseDocumentInternal copy() {
        return (ODatabaseDocumentInternal)this.pool.acquire();
    }

    @Override
    public void realClose() {
        ODatabaseDocumentInternal old = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            this.activateOnCurrentThread();
            super.close();
        }
        finally {
            if (old == null) {
                ODatabaseRecordThreadLocal.instance().remove();
            } else {
                ODatabaseRecordThreadLocal.instance().set(old);
            }
        }
    }
}

