/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OHighLevelException;
import com.orientechnologies.common.listener.OListenerManger;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.document.RecordReader;
import com.orientechnologies.orient.core.db.document.SimpleRecordReader;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OTransactionBlockedException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.cluster.OOfflineClusterException;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.OMicroTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;

public abstract class ODatabaseDocumentAbstract
extends OListenerManger<ODatabaseListener>
implements ODatabaseDocumentInternal {
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected Map<ORecordHook, ORecordHook.HOOK_POSITION> unmodifiableHooks;
    protected final Set<OIdentifiable> inHook = new HashSet<OIdentifiable>();
    protected ORecordSerializer serializer;
    protected String url;
    protected ODatabase.STATUS status;
    protected OIntent currentIntent;
    protected ODatabaseInternal<?> databaseOwner;
    protected OMetadataDefault metadata;
    protected OImmutableUser user;
    protected final byte recordType = (byte)100;
    protected final Map<ORecordHook, ORecordHook.HOOK_POSITION> hooks = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>();
    protected boolean retainRecords = true;
    protected OLocalRecordCache localCache;
    protected OCurrentStorageComponentsFactory componentsFactory;
    protected boolean initialized = false;
    protected OTransaction currentTx;
    protected final ORecordHook[][] hooksByScope = new ORecordHook[ORecordHook.SCOPE.values().length][];
    protected OSharedContext sharedContext;
    private boolean prefetchRecords;
    protected OMicroTransaction microTransaction = null;
    protected Map<String, OResultSet> activeQueries = new HashMap<String, OResultSet>();
    private Map<UUID, OBonsaiCollectionPointer> collectionsChanges;

    protected ODatabaseDocumentAbstract() {
        super(false);
    }

    public static ORecordSerializer getDefaultSerializer() {
        return ORecordSerializerFactory.instance().getDefaultRecordSerializer();
    }

    public static void setDefaultSerializer(ORecordSerializer iDefaultSerializer) {
        ORecordSerializerFactory.instance().setDefaultRecordSerializer(iDefaultSerializer);
    }

    @Override
    public void callOnOpenListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onOpen(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.getListenersCopy()) {
            try {
                listener.onOpen(this.getDatabaseOwner());
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during call of database listener", e, new Object[0]);
            }
        }
    }

    protected abstract void loadMetadata();

    @Override
    public void callOnCloseListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onClose(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : this.getListenersCopy()) {
            try {
                listener.onClose(this.getDatabaseOwner());
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during call of database listener", e, new Object[0]);
            }
        }
    }

    @Override
    public void callOnDropListeners() {
        for (ODatabaseListener listener : this.getListenersCopy()) {
            try {
                this.activateOnCurrentThread();
                listener.onDelete(this.getDatabaseOwner());
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during call of database listener", e, new Object[0]);
            }
        }
    }

    @Override
    public <RET extends ORecord> RET getRecord(OIdentifiable iIdentifiable) {
        if (iIdentifiable instanceof ORecord) {
            return (RET)((ORecord)iIdentifiable);
        }
        return (RET)this.load(iIdentifiable.getIdentity());
    }

    @Override
    public void reload() {
        this.checkIfActive();
        if (this.isClosed()) {
            throw new ODatabaseException("Cannot reload a closed db");
        }
        this.metadata.reload();
        this.getStorage().reload();
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecordId, null, -1, iFetchPlan, iIgnoreCache, !iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT, new SimpleRecordReader(this.prefetchRecords));
    }

    @Override
    public ODatabase<ORecord> delete(ORID iRecord, int iVersion) {
        Object record = this.load(iRecord);
        ORecordInternal.setVersion((ORecord)record, iVersion);
        this.delete(record);
        return this;
    }

    @Override
    public ODatabaseDocumentInternal cleanOutRecord(ORID iRecord, int iVersion) {
        this.executeDeleteRecord(iRecord, iVersion, true, ODatabase.OPERATION_MODE.SYNCHRONOUS, true);
        return this;
    }

    @Override
    public String getType() {
        return "document";
    }

    @Deprecated
    public ODatabaseDocument delete(ORID iRecord, ODatabase.OPERATION_MODE iMode) {
        Object record = this.load(iRecord);
        if (record == null) {
            return this;
        }
        this.delete((ORecord)record, iMode);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ODatabaseDocument delete(ORecord iRecord, ODatabase.OPERATION_MODE iMode) {
        this.checkIfActive();
        ODirtyManager dirtyManager = ORecordInternal.getDirtyManager(iRecord);
        if (iRecord instanceof OElement && dirtyManager != null && dirtyManager.getReferences() != null && !dirtyManager.getReferences().isEmpty() && (((OElement)iRecord).isEdge() || ((OElement)iRecord).isVertex() && !this.getTransaction().isActive())) {
            this.begin();
            try {
                this.currentTx.deleteRecord(iRecord, iMode);
                ODatabaseDocumentAbstract oDatabaseDocumentAbstract = this;
                return oDatabaseDocumentAbstract;
            }
            finally {
                this.commit();
            }
        }
        this.currentTx.deleteRecord(iRecord, iMode);
        return this;
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iClass) {
        return this.browseCluster(iClusterName);
    }

    @Override
    @Deprecated
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, clusterId, startClusterPosition, endClusterPosition, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, clusterId, startClusterPosition, endClusterPosition);
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.checkSecurity(ORule.ResourceGeneric.COMMAND, ORole.PERMISSION_READ, new Object[0]);
        this.checkIfActive();
        OCommandRequestInternal command = (OCommandRequestInternal)iCommand;
        try {
            command.reset();
            return command;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Error on command execution"), e);
        }
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<?> iCommand, Object ... iArgs) {
        this.checkIfActive();
        iCommand.reset();
        return (RET)((List)iCommand.execute(iArgs));
    }

    @Override
    public byte getRecordType() {
        return 100;
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        return this.countClusterElements(iClusterIds, false);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        return this.countClusterElements(iClusterId, false);
    }

    @Override
    public void truncateCluster(String clusterName) {
        this.command("truncate cluster " + clusterName, new Object[0]);
    }

    @Override
    public long countClusterElements(int iClusterId, boolean countTombstones) {
        String name = this.getClusterNameById(iClusterId);
        if (name == null) {
            return 0L;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)name);
        this.checkIfActive();
        return this.getStorage().count(iClusterId, countTombstones);
    }

    @Override
    public long countClusterElements(int[] iClusterIds, boolean countTombstones) {
        this.checkIfActive();
        for (int iClusterId : iClusterIds) {
            String name = this.getClusterNameById(iClusterId);
            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)name);
        }
        return this.getStorage().count(iClusterIds, countTombstones);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        if (clusterId < 0) {
            throw new IllegalArgumentException("Cluster '" + iClusterName + "' was not found");
        }
        return this.getStorage().count(clusterId);
    }

    @Override
    public OMetadataDefault getMetadata() {
        this.checkOpenness();
        return this.metadata;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        if (this.user != null) {
            try {
                this.user.allow(resourceGeneric, resourceSpecific, iOperation);
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "User '%s' tried to access the reserved resource '%s.%s', operation '%s'", this.getUser(), resourceGeneric, resourceSpecific, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        if (this.user != null) {
            try {
                if (iResourcesSpecific.length != 0) {
                    for (Object target : iResourcesSpecific) {
                        if (target != null) {
                            this.user.allow(iResourceGeneric, target.toString(), iOperation);
                            continue;
                        }
                        this.user.allow(iResourceGeneric, null, iOperation);
                    }
                } else {
                    this.user.allow(iResourceGeneric, null, iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access the reserved resource '%s', target(s) '%s', operation '%s'", this.getUser(), iResourceGeneric, Arrays.toString(iResourcesSpecific), iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object iResourceSpecific) {
        this.checkOpenness();
        if (this.user != null) {
            try {
                if (iResourceSpecific != null) {
                    this.user.allow(iResourceGeneric, iResourceSpecific.toString(), iOperation);
                } else {
                    this.user.allow(iResourceGeneric, null, iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access the reserved resource '%s', target '%s', operation '%s'", this.getUser(), iResourceGeneric, iResourceSpecific, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    public void checkClusterSecurity(int operation, OIdentifiable record, String cluster) {
        if (cluster == null) {
            cluster = this.getClusterNameById(record.getIdentity().getClusterId());
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, operation, (Object)cluster);
    }

    @Override
    public ODatabaseInternal<?> getDatabaseOwner() {
        ODatabaseInternal<?> current;
        for (current = this.databaseOwner; current != null && current != this && current.getDatabaseOwner() != current; current = current.getDatabaseOwner()) {
        }
        return current;
    }

    @Override
    public ODatabaseInternal<ORecord> setDatabaseOwner(ODatabaseInternal<?> iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public boolean isRetainRecords() {
        return this.retainRecords;
    }

    @Override
    public ODatabaseDocument setRetainRecords(boolean retainRecords) {
        this.retainRecords = retainRecords;
        return this;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        this.checkIfActive();
        this.setStatusInternal(status);
        return (DB)this;
    }

    public void setStatusInternal(ODatabase.STATUS status) {
        this.status = status;
    }

    @Deprecated
    public void setDefaultClusterIdInternal(int iDefClusterId) {
        this.checkIfActive();
        this.getStorage().setDefaultClusterId(iDefClusterId);
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        this.set(iAttribute, iValue);
    }

    @Override
    public OSecurityUser getUser() {
        return this.user;
    }

    @Override
    public void setUser(OSecurityUser user) {
        this.checkIfActive();
        if (user instanceof OUser) {
            OMetadataDefault metadata = this.getMetadata();
            if (metadata != null) {
                OSecurity security = metadata.getSecurity();
                this.user = new OImmutableUser(security.getVersion(), (OUser)user);
            } else {
                this.user = new OImmutableUser(-1L, (OUser)user);
            }
        } else {
            this.user = (OImmutableUser)user;
        }
    }

    @Override
    public void reloadUser() {
        if (this.user != null) {
            this.activateOnCurrentThread();
            if (this.user.checkIfAllowed(ORule.ResourceGeneric.CLASS, "OUser", ORole.PERMISSION_READ) != null) {
                OSecurity security;
                OUser secGetUser;
                OMetadataDefault metadata = this.getMetadata();
                this.user = metadata != null ? ((secGetUser = (security = metadata.getSecurity()).getUser(this.user.getName())) != null ? new OImmutableUser(security.getVersion(), secGetUser) : new OImmutableUser(-1L, new OUser())) : new OImmutableUser(-1L, new OUser());
            }
        }
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public <DB extends ODatabase<?>> DB setMVCC(boolean mvcc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        this.checkOpenness();
        return this.metadata.getIndexManager().getDictionary();
    }

    @Override
    public <DB extends ODatabase<?>> DB registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        this.checkOpenness();
        this.checkIfActive();
        LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION> tmp = new LinkedHashMap<ORecordHook, ORecordHook.HOOK_POSITION>(this.hooks);
        tmp.put(iHookImpl, iPosition);
        this.hooks.clear();
        for (ORecordHook.HOOK_POSITION p : ORecordHook.HOOK_POSITION.values()) {
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.hooks.put((ORecordHook)e.getKey(), (ORecordHook.HOOK_POSITION)((Object)e.getValue()));
            }
        }
        this.compileHooks();
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase<?>> DB registerHook(ORecordHook iHookImpl) {
        return this.registerHook(iHookImpl, ORecordHook.HOOK_POSITION.REGULAR);
    }

    @Override
    public <DB extends ODatabase<?>> DB unregisterHook(ORecordHook iHookImpl) {
        this.checkIfActive();
        if (iHookImpl != null) {
            iHookImpl.onUnregister();
            this.hooks.remove(iHookImpl);
            this.compileHooks();
        }
        return (DB)this;
    }

    @Override
    public OLocalRecordCache getLocalCache() {
        return this.localCache;
    }

    @Override
    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks() {
        return this.unmodifiableHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE type, OIdentifiable id) {
        if (id == null) return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        if (this.hooks.isEmpty()) return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        if (id.getIdentity().getClusterId() == 0) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        ORecordHook.SCOPE scope = ORecordHook.SCOPE.typeToScope(type);
        int scopeOrdinal = scope.ordinal();
        ORID identity = id.getIdentity().copy();
        if (!this.pushInHook(identity)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        try {
            Object rec = id.getRecord();
            if (rec == null) {
                ORecordHook.RESULT rESULT = ORecordHook.RESULT.RECORD_NOT_CHANGED;
                return rESULT;
            }
            OScenarioThreadLocal.RUN_MODE runMode = OScenarioThreadLocal.INSTANCE.getRunMode();
            boolean recordChanged = false;
            block11: for (ORecordHook hook : this.hooksByScope[scopeOrdinal]) {
                switch (runMode) {
                    case DEFAULT: {
                        if (!this.getStorage().isDistributed() || hook.getDistributedExecutionMode() != ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE) break;
                        continue block11;
                    }
                    case RUNNING_DISTRIBUTED: {
                        if (hook.getDistributedExecutionMode() == ORecordHook.DISTRIBUTED_EXECUTION_MODE.SOURCE_NODE) continue block11;
                    }
                }
                ORecordHook.RESULT res = hook.onTrigger(type, (ORecord)rec);
                if (res == ORecordHook.RESULT.RECORD_CHANGED) {
                    recordChanged = true;
                    continue;
                }
                if (res == ORecordHook.RESULT.SKIP_IO) {
                    ORecordHook.RESULT rESULT = res;
                    return rESULT;
                }
                if (res == ORecordHook.RESULT.SKIP) {
                    ORecordHook.RESULT rESULT = res;
                    return rESULT;
                }
                if (res != ORecordHook.RESULT.RECORD_REPLACED) continue;
                ORecordHook.RESULT rESULT = res;
                return rESULT;
            }
            ORecordHook.RESULT rESULT = recordChanged ? ORecordHook.RESULT.RECORD_CHANGED : ORecordHook.RESULT.RECORD_NOT_CHANGED;
            return rESULT;
        }
        finally {
            this.popInHook(identity);
        }
    }

    @Override
    public boolean isValidationEnabled() {
        return (Boolean)this.get(ODatabase.ATTRIBUTES.VALIDATION);
    }

    @Override
    public <DB extends ODatabaseDocument> DB setValidationEnabled(boolean iEnabled) {
        this.set(ODatabase.ATTRIBUTES.VALIDATION, iEnabled);
        return (DB)this;
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        this.checkIfActive();
        return this.getStorage().getClusterRecordConflictStrategy();
    }

    @Override
    public ODatabaseDocumentAbstract setConflictStrategy(String iStrategyName) {
        this.checkIfActive();
        this.getStorage().setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    @Override
    public ODatabaseDocumentAbstract setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.checkIfActive();
        this.getStorage().setConflictStrategy(iResolver);
        return this;
    }

    @Override
    public OContextConfiguration getConfiguration() {
        this.checkIfActive();
        if (this.getStorage() != null) {
            return this.getStorage().getConfiguration().getContextConfiguration();
        }
        return null;
    }

    @Override
    public boolean declareIntent(OIntent iIntent) {
        this.checkIfActive();
        if (this.currentIntent != null) {
            if (iIntent != null && iIntent.getClass().equals(this.currentIntent.getClass())) {
                return false;
            }
            this.currentIntent.end(this);
        }
        this.currentIntent = iIntent;
        if (iIntent != null) {
            iIntent.begin(this);
        }
        return true;
    }

    @Override
    public OIntent getActiveIntent() {
        return this.currentIntent;
    }

    @Override
    public void internalClose(boolean recycle) {
        if (this.status != ODatabase.STATUS.OPEN) {
            return;
        }
        this.checkIfActive();
        try {
            this.closeActiveQueries();
            this.localCache.shutdown();
            if (this.isClosed()) {
                this.status = ODatabase.STATUS.CLOSED;
                return;
            }
            try {
                this.rollback(true);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Exception during commit of active transaction", e, new Object[0]);
            }
            this.callOnCloseListeners();
            if (this.currentIntent != null) {
                this.currentIntent.end(this);
                this.currentIntent = null;
            }
            this.status = ODatabase.STATUS.CLOSED;
            if (!recycle) {
                this.sharedContext = null;
                if (this.getStorage() != null) {
                    this.getStorage().close();
                }
            }
        }
        finally {
            ODatabaseRecordThreadLocal.instance().remove();
        }
    }

    @Override
    public void close() {
        this.internalClose(false);
    }

    @Override
    public ODatabase.STATUS getStatus() {
        return this.status;
    }

    @Override
    public long getSize() {
        this.checkIfActive();
        return this.getStorage().getSize();
    }

    @Override
    public String getName() {
        return this.getStorage() != null ? this.getStorage().getName() : this.url;
    }

    @Override
    public String getURL() {
        return this.url != null ? this.url : this.getStorage().getURL();
    }

    @Override
    public int getDefaultClusterId() {
        this.checkIfActive();
        return this.getStorage().getDefaultClusterId();
    }

    @Override
    public int getClusters() {
        this.checkIfActive();
        return this.getStorage().getClusters();
    }

    @Override
    public boolean existsCluster(String iClusterName) {
        this.checkIfActive();
        return this.getStorage().getClusterNames().contains(iClusterName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Collection<String> getClusterNames() {
        this.checkIfActive();
        return this.getStorage().getClusterNames();
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        if (iClusterName == null) {
            return -1;
        }
        this.checkIfActive();
        return this.getStorage().getClusterIdByName(iClusterName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getClusterNameById(int iClusterId) {
        if (iClusterId < 0) {
            return null;
        }
        this.checkIfActive();
        return this.getStorage().getPhysicalClusterNameById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeByName(String clusterName) {
        this.checkIfActive();
        try {
            return this.getStorage().getClusterRecordsSizeByName(clusterName);
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Error on reading records size for cluster '" + clusterName + "'"), e);
        }
    }

    @Override
    public long getClusterRecordSizeById(int clusterId) {
        this.checkIfActive();
        try {
            return this.getStorage().getClusterRecordsSizeById(clusterId);
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Error on reading records size for cluster with id '" + clusterId + "'"), e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.status == ODatabase.STATUS.CLOSED || this.getStorage().isClosed();
    }

    @Override
    public int addCluster(String iClusterName, Object ... iParameters) {
        this.checkIfActive();
        return this.getStorage().addCluster(iClusterName, iParameters);
    }

    @Override
    public int addCluster(String iClusterName, int iRequestedId, Object ... iParameters) {
        this.checkIfActive();
        return this.getStorage().addCluster(iClusterName, iRequestedId, iParameters);
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.checkIfActive();
        int clusterId = this.getClusterIdByName(iClusterName);
        OSchemaProxy schema = this.metadata.getSchema();
        OClass clazz = schema.getClassByClusterId(clusterId);
        if (clazz != null) {
            clazz.removeClusterId(clusterId);
        }
        if (schema.getBlobClusters().contains(clusterId)) {
            schema.removeBlobCluster(iClusterName);
        }
        this.getLocalCache().freeCluster(clusterId);
        this.checkForClusterPermissions(iClusterName);
        return this.getStorage().dropCluster(iClusterName, iTruncate);
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.checkIfActive();
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(iClusterId));
        OSchemaProxy schema = this.metadata.getSchema();
        OClass clazz = schema.getClassByClusterId(iClusterId);
        if (clazz != null) {
            clazz.removeClusterId(iClusterId);
        }
        this.getLocalCache().freeCluster(iClusterId);
        if (schema.getBlobClusters().contains(iClusterId)) {
            schema.removeBlobCluster(this.getClusterNameById(iClusterId));
        }
        this.checkForClusterPermissions(this.getClusterNameById(iClusterId));
        return this.getStorage().dropCluster(iClusterId, iTruncate);
    }

    @Override
    public void checkForClusterPermissions(String iClusterName) {
        Set<OClass> classes = this.getMetadata().getImmutableSchemaSnapshot().getClassesRelyOnCluster(iClusterName);
        for (OClass c : classes) {
            if (!c.isSubClassOf("ORestricted")) continue;
            throw new OSecurityException("Class '" + c.getName() + "' cannot be truncated because has record level security enabled (extends '" + "ORestricted" + "')");
        }
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        if (iValue == null) {
            return this.properties.remove(iName.toLowerCase(Locale.ENGLISH));
        }
        return this.properties.put(iName.toLowerCase(Locale.ENGLISH), iValue);
    }

    @Override
    public Object getProperty(String iName) {
        return this.properties.get(iName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.properties.entrySet().iterator();
    }

    @Override
    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        this.checkIfActive();
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        OStorage storage = this.getStorage();
        switch (iAttribute) {
            case STATUS: {
                return this.getStatus();
            }
            case DEFAULTCLUSTERID: {
                return this.getDefaultClusterId();
            }
            case TYPE: {
                return this.getMetadata().getImmutableSchemaSnapshot().existsClass("V") ? "graph" : "document";
            }
            case DATEFORMAT: {
                return storage.getConfiguration().getDateFormat();
            }
            case DATETIMEFORMAT: {
                return storage.getConfiguration().getDateTimeFormat();
            }
            case TIMEZONE: {
                return storage.getConfiguration().getTimeZone().getID();
            }
            case LOCALECOUNTRY: {
                return storage.getConfiguration().getLocaleCountry();
            }
            case LOCALELANGUAGE: {
                return storage.getConfiguration().getLocaleLanguage();
            }
            case CHARSET: {
                return storage.getConfiguration().getCharset();
            }
            case CUSTOM: {
                return storage.getConfiguration().getProperties();
            }
            case CLUSTERSELECTION: {
                return storage.getConfiguration().getClusterSelection();
            }
            case MINIMUMCLUSTERS: {
                return storage.getConfiguration().getMinimumClusters();
            }
            case CONFLICTSTRATEGY: {
                return storage.getConfiguration().getConflictStrategy();
            }
            case VALIDATION: {
                return storage.getConfiguration().isValidationEnabled();
            }
        }
        return null;
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        this.checkIfActive();
        return this.getStorage().getRecordMetadata(rid);
    }

    @Override
    public OTransaction getTransaction() {
        this.checkIfActive();
        return this.currentTx;
    }

    @Override
    public OBasicTransaction getMicroOrRegularTransaction() {
        return this.microTransaction != null && this.microTransaction.isActive() ? this.microTransaction : this.getTransaction();
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, !iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, iLockingStrategy);
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, null, false);
    }

    @Override
    public <RET extends ORecord> RET load(ORID recordId) {
        return (RET)this.currentTx.loadRecord(recordId, null, null, false);
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecord> RET loadIfVersionIsNotLatest(ORID rid, int recordVersion, String fetchPlan, boolean ignoreCache) throws ORecordNotFoundException {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecordIfVersionIsNotLatest(rid, recordVersion, fetchPlan, ignoreCache);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkIfActive();
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, iLockingStrategy);
    }

    public <RET extends ORecord> RET reload(ORecord iRecord) {
        return this.reload(iRecord, (String)null, false);
    }

    public <RET extends ORecord> RET reload(ORecord iRecord, String iFetchPlan) {
        return this.reload(iRecord, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecord> RET reload(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.reload(iRecord, iFetchPlan, iIgnoreCache, true);
    }

    @Override
    public <RET extends ORecord> RET reload(ORecord record, String fetchPlan, boolean ignoreCache, boolean force) {
        this.checkIfActive();
        ORecord loadedRecord = this.currentTx.reloadRecord(record.getIdentity(), record, fetchPlan, ignoreCache, force);
        if (loadedRecord != null && record != loadedRecord) {
            record.fromStream(loadedRecord.toStream());
            ORecordInternal.setVersion(record, loadedRecord.getVersion());
        } else if (loadedRecord == null) {
            throw new ORecordNotFoundException(record.getIdentity());
        }
        return (RET)record;
    }

    public ODatabaseDocument delete(ORID iRecord) {
        this.checkOpenness();
        this.checkIfActive();
        Object rec = this.load(iRecord);
        if (rec != null) {
            this.delete(rec);
        }
        return this;
    }

    @Override
    public boolean hide(ORID rid) {
        this.checkOpenness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            throw new ODatabaseException("This operation can be executed only in non transaction mode");
        }
        return this.executeHideRecord(rid, ODatabase.OPERATION_MODE.SYNCHRONOUS);
    }

    @Override
    public OBinarySerializerFactory getSerializerFactory() {
        return this.componentsFactory.binarySerializerFactory;
    }

    @Deprecated
    public ODatabaseDocument begin(OTransaction iTx) {
        this.begin();
        return this;
    }

    @Override
    public OTransaction swapTx(OTransaction newTx) {
        OTransaction old = this.getTransaction();
        this.currentTx = newTx;
        return old;
    }

    @Override
    public void rawBegin(OTransaction iTx) {
        this.checkOpenness();
        this.checkIfActive();
        if (this.currentTx.isActive() && iTx.equals(this.currentTx)) {
            this.currentTx.begin();
        }
        this.currentTx.rollback(true, 0);
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin(this);
            }
            catch (Exception e) {
                String message = "Error before the transaction begin";
                OLogManager.instance().error(this, "Error before the transaction begin", e, new Object[0]);
                throw OException.wrapException(new OTransactionBlockedException("Error before the transaction begin"), e);
            }
        }
        this.currentTx = iTx;
        this.currentTx.begin();
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, -1, iFetchPlan, iIgnoreCache, !iIgnoreCache, false, OStorage.LOCKING_STRATEGY.NONE, new SimpleRecordReader(this.prefetchRecords));
    }

    @Override
    public void setPrefetchRecords(boolean prefetchRecords) {
        this.prefetchRecords = prefetchRecords;
    }

    @Override
    public boolean isPrefetchRecords() {
        return this.prefetchRecords;
    }

    @Override
    public <RET extends ORecord> RET executeReadRecord(ORecordId rid, ORecord iRecord, int recordVersion, String fetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstones, OStorage.LOCKING_STRATEGY lockingStrategy, RecordReader recordReader) {
        this.checkOpenness();
        this.checkIfActive();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        ORecordSerializationContext.pushContext();
        try {
            ORawBuffer recordBuffer;
            this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)this.getClusterNameById(rid.getClusterId()));
            assert (!this.getTransaction().isActive() || this.microTransaction == null || !this.microTransaction.isActive());
            ORecord record = this.getTransaction().getRecord(rid);
            if (record == OBasicTransaction.DELETED_RECORD) {
                RET RET = null;
                return RET;
            }
            if (record == null && this.microTransaction != null && this.microTransaction.isActive() && (record = this.microTransaction.getRecord(rid)) == OBasicTransaction.DELETED_RECORD) {
                RET RET = null;
                return RET;
            }
            if (record == null && !ignoreCache) {
                record = this.getLocalCache().findRecord(rid);
            }
            if (record != null) {
                if (iRecord != null) {
                    iRecord.fromStream(record.toStream());
                    ORecordInternal.setVersion(iRecord, record.getVersion());
                    record = iRecord;
                }
                OFetchHelper.checkFetchPlanValid(fetchPlan);
                if (this.beforeReadOperations(record)) {
                    RET RET = null;
                    return RET;
                }
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                if (lockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_SHARED_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use deprecated record locking strategy: %s it may lead to deadlocks " + (Object)((Object)lockingStrategy), new Object[0]);
                    record.lock(false);
                } else if (lockingStrategy == OStorage.LOCKING_STRATEGY.KEEP_EXCLUSIVE_LOCK) {
                    OLogManager.instance().warn((Object)this, "You use deprecated record locking strategy: %s it may lead to deadlocks " + (Object)((Object)lockingStrategy), new Object[0]);
                    record.lock(true);
                }
                this.afterReadOperations(record);
                if (record instanceof ODocument) {
                    ODocumentInternal.checkClass((ODocument)record, this);
                }
                ORecord oRecord = record;
                return (RET)oRecord;
            }
            if (!rid.isValid()) {
                recordBuffer = null;
            } else {
                OFetchHelper.checkFetchPlanValid(fetchPlan);
                int version = iRecord != null ? iRecord.getVersion() : recordVersion;
                recordBuffer = recordReader.readRecord(this.getStorage(), rid, fetchPlan, ignoreCache, version);
            }
            if (recordBuffer == null) {
                RET RET = null;
                return RET;
            }
            if (iRecord == null || ORecordInternal.getRecordType(iRecord) != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(recordBuffer.recordType, rid.getClusterId(), this);
            }
            ORecordInternal.fill(iRecord, rid, recordBuffer.version, recordBuffer.buffer, false, this);
            if (iRecord instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)iRecord, this);
            }
            if (ORecordVersionHelper.isTombstone(iRecord.getVersion())) {
                ORecord oRecord = iRecord;
                return (RET)oRecord;
            }
            if (this.beforeReadOperations(iRecord)) {
                RET RET = null;
                return RET;
            }
            iRecord.fromStream(recordBuffer.buffer);
            this.afterReadOperations(iRecord);
            if (iUpdateCache) {
                this.getLocalCache().updateRecord(iRecord);
            }
            ORecord oRecord = iRecord;
            return (RET)oRecord;
        }
        catch (OOfflineClusterException t) {
            throw t;
        }
        catch (ORecordNotFoundException t) {
            throw t;
        }
        catch (Exception t) {
            if (rid.isTemporary()) {
                throw OException.wrapException(new ODatabaseException("Error on retrieving record using temporary RID: " + rid), t);
            }
            throw OException.wrapException(new ODatabaseException("Error on retrieving record " + rid + " (cluster: " + this.getStorage().getPhysicalClusterNameById(rid.getClusterId()) + ")"), t);
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int assignAndCheckCluster(ORecord record, String iClusterName) {
        ORecordId rid = (ORecordId)record.getIdentity();
        if ((long)rid.getClusterId() <= -1L && iClusterName != null) {
            rid.setClusterId(this.getClusterIdByName(iClusterName));
            if (rid.getClusterId() == -1) {
                throw new IllegalArgumentException("Cluster name '" + iClusterName + "' is not configured");
            }
        }
        OImmutableClass schemaClass = null;
        if (rid.getClusterId() <= -1 && this.getStorage().isAssigningClusterIds()) {
            if (record instanceof ODocument) {
                schemaClass = ODocumentInternal.getImmutableSchemaClass(this, (ODocument)record);
                if (schemaClass == null) throw new ODatabaseException("Cannot save (1) document " + record + ": no class or cluster defined");
                if (schemaClass.isAbstract()) {
                    throw new OSchemaException("Document belongs to abstract class " + schemaClass.getName() + " and cannot be saved");
                }
                rid.setClusterId(schemaClass.getClusterForNewInstance((ODocument)record));
            } else {
                if (!(record instanceof ORecordBytes)) throw new ODatabaseException("Cannot save (3) document " + record + ": no class or cluster defined");
                Set<Integer> blobs = this.getBlobClusterIds();
                if (blobs.size() == 0) {
                    rid.setClusterId(this.getDefaultClusterId());
                } else {
                    rid.setClusterId(blobs.iterator().next());
                }
            }
        } else if (record instanceof ODocument) {
            schemaClass = ODocumentInternal.getImmutableSchemaClass(this, (ODocument)record);
        }
        if (rid.getClusterId() <= -1 || schemaClass == null) return rid.getClusterId();
        String messageClusterName = this.getClusterNameById(rid.getClusterId());
        this.checkRecordClass(schemaClass, messageClusterName, rid);
        if (schemaClass.hasClusterId(rid.getClusterId())) return rid.getClusterId();
        throw new IllegalArgumentException("Cluster name '" + messageClusterName + "' (id=" + rid.getClusterId() + ") is not configured to store the class '" + schemaClass.getName() + "', valid are " + Arrays.toString(schemaClass.getClusterIds()));
    }

    @Override
    public <RET extends ORecord> RET executeSaveEmptyRecord(ORecord record, String clusterName) {
        ORecordId rid = (ORecordId)record.getIdentity();
        assert (rid.isNew());
        ORecordInternal.onBeforeIdentityChanged(record);
        int id = this.assignAndCheckCluster(record, clusterName);
        clusterName = this.getClusterNameById(id);
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_CREATE, (Object)clusterName);
        byte[] content = this.getSerializer().writeClassOnly(record);
        OStorageOperationResult<OPhysicalPosition> ppos = this.getStorage().createRecord(rid, content, record.getVersion(), (byte)100, ODatabase.OPERATION_MODE.SYNCHRONOUS.ordinal(), null);
        ORecordInternal.setVersion(record, ppos.getResult().recordVersion);
        ((ORecordId)record.getIdentity()).copyFrom(rid);
        ORecordInternal.onAfterIdentityChanged(record);
        return (RET)record;
    }

    @Override
    public abstract <RET extends ORecord> RET executeSaveRecord(ORecord var1, String var2, int var3, ODatabase.OPERATION_MODE var4, boolean var5, ORecordCallback<? extends Number> var6, ORecordCallback<Integer> var7);

    @Override
    public abstract void executeDeleteRecord(OIdentifiable var1, int var2, boolean var3, ODatabase.OPERATION_MODE var4, boolean var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeHideRecord(OIdentifiable record, ODatabase.OPERATION_MODE iMode) {
        this.checkOpenness();
        this.checkIfActive();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot hide record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return false;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.getClusterId()));
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        if (record instanceof ODocument) {
            ODocumentInternal.checkClass((ODocument)record, this);
        }
        ORecordSerializationContext.pushContext();
        try {
            OStorageOperationResult<Boolean> operationResult = this.getStorage().hideRecord(rid, iMode.ordinal(), null);
            if (!operationResult.isMoved()) {
                this.getLocalCache().deleteRecord(rid);
            }
            boolean bl = operationResult.getResult();
            return bl;
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    public ODatabaseDocumentAbstract begin() {
        return this.begin(OTransaction.TXTYPE.OPTIMISTIC);
    }

    public ODatabaseDocumentAbstract begin(OTransaction.TXTYPE iType) {
        this.checkOpenness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        if (!this.inHook.isEmpty()) {
            throw new IllegalStateException("Cannot begin a transaction while a hook is executing");
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin(this);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error before tx begin", e, new Object[0]);
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimistic(this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    @Override
    public void setDefaultTransactionMode() {
        if (!(this.currentTx instanceof OTransactionNoTx)) {
            this.currentTx = new OTransactionNoTx(this);
        }
    }

    @Override
    public void freeze(boolean throwException) {
        this.checkOpenness();
        if (!(this.getStorage() instanceof OFreezableStorageComponent)) {
            OLogManager.instance().error(this, "Only local paginated storage supports freeze. If you are using remote client please use OServerAdmin instead", null, new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        OFreezableStorageComponent storage = this.getFreezableStorage();
        if (storage != null) {
            storage.freeze(throwException);
        }
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".freeze", "Time to freeze the database", startTime, "db.*.freeze");
    }

    @Override
    public void freeze() {
        this.checkOpenness();
        if (!(this.getStorage() instanceof OFreezableStorageComponent)) {
            OLogManager.instance().error(this, "Only local paginated storage supports freeze. If you use remote client please use OServerAdmin instead", null, new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        OFreezableStorageComponent storage = this.getFreezableStorage();
        if (storage != null) {
            storage.freeze(false);
        }
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".freeze", "Time to freeze the database", startTime, "db.*.freeze");
    }

    @Override
    public void release() {
        this.checkOpenness();
        if (!(this.getStorage() instanceof OFreezableStorageComponent)) {
            OLogManager.instance().error(this, "Only local paginated storage supports release. If you are using remote client please use OServerAdmin instead", null, new Object[0]);
            return;
        }
        long startTime = Orient.instance().getProfiler().startChrono();
        OFreezableStorageComponent storage = this.getFreezableStorage();
        if (storage != null) {
            storage.release();
        }
        Orient.instance().getProfiler().stopChrono("db." + this.getName() + ".release", "Time to release the database", startTime, "db.*.release");
    }

    @Override
    public ODocument newInstance() {
        return new ODocument();
    }

    @Override
    public OBlob newBlob(byte[] bytes) {
        return new ORecordBytes(bytes);
    }

    @Override
    public OBlob newBlob() {
        return new ORecordBytes();
    }

    public ODocument newInstance(String iClassName) {
        return new ODocument(iClassName);
    }

    @Override
    public OElement newElement() {
        return this.newInstance();
    }

    @Override
    public OElement newElement(String className) {
        return this.newInstance(className);
    }

    public OElement newElement(OClass clazz) {
        return this.newInstance(clazz.getName());
    }

    @Override
    public OVertex newVertex(String iClassName) {
        OClass cl = this.getClass(iClassName);
        if (cl == null || !cl.isVertexType()) {
            throw new IllegalArgumentException("" + iClassName + " is not a vertex class");
        }
        OVertexDocument doc = new OVertexDocument(cl);
        return doc;
    }

    @Override
    public OVertex newVertex(OClass type) {
        if (type == null) {
            return this.newVertex("V");
        }
        return this.newVertex(type.getName());
    }

    @Override
    public OEdge newEdge(OVertex from, OVertex to, String type) {
        OClass cl = this.getClass(type);
        if (cl == null || !cl.isEdgeType()) {
            throw new IllegalArgumentException("" + type + " is not an edge class");
        }
        return this.addEdgeInternal(from, to, type, false, new Object[0]);
    }

    @Override
    public OEdge newEdge(OVertex from, OVertex to, OClass type) {
        if (type == null) {
            return this.newEdge(from, to, "E");
        }
        return this.newEdge(from, to, type.getName());
    }

    private OEdge addEdgeInternal(OVertex currentVertex, OVertex inVertex, String iClassName, boolean forceRegular, Object ... fields) {
        if (currentVertex == null) {
            throw new IllegalArgumentException("To vertex is null");
        }
        if (inVertex == null) {
            throw new IllegalArgumentException("To vertex is null");
        }
        OEdge edge = null;
        ODocument outDocument = null;
        ODocument inDocument = null;
        boolean outDocumentModified = false;
        if (this.checkDeletedInTx(currentVertex)) {
            throw new ORecordNotFoundException(currentVertex.getIdentity(), "The vertex " + currentVertex.getIdentity() + " has been deleted");
        }
        if (this.checkDeletedInTx(inVertex)) {
            throw new ORecordNotFoundException(inVertex.getIdentity(), "The vertex " + inVertex.getIdentity() + " has been deleted");
        }
        boolean maxRetries = true;
        for (int retry = 0; retry < 1; ++retry) {
            try {
                boolean regularEdgeBasedOnSchema;
                if (outDocument == null && (outDocument = (ODocument)currentVertex.getRecord()) == null) {
                    throw new IllegalArgumentException("source vertex is invalid (rid=" + currentVertex.getIdentity() + ")");
                }
                if (inDocument == null && (inDocument = (ODocument)inVertex.getRecord()) == null) {
                    throw new IllegalArgumentException("source vertex is invalid (rid=" + inVertex.getIdentity() + ")");
                }
                if (!ODocumentInternal.getImmutableSchemaClass(this, outDocument).isVertexType()) {
                    throw new IllegalArgumentException("source record is not a vertex");
                }
                if (!ODocumentInternal.getImmutableSchemaClass(this, outDocument).isVertexType()) {
                    throw new IllegalArgumentException("destination record is not a vertex");
                }
                OVertex to = inVertex;
                OVertex from = currentVertex;
                OSchemaProxy schema = this.getMetadata().getSchema();
                OClass edgeType = schema.getClass(iClassName);
                if (edgeType == null) {
                    schema.createClass(iClassName);
                } else {
                    iClassName = edgeType.getName();
                }
                String outFieldName = ODatabaseDocumentAbstract.getConnectionFieldName(ODirection.OUT, iClassName);
                String inFieldName = ODatabaseDocumentAbstract.getConnectionFieldName(ODirection.IN, iClassName);
                if (iClassName == null) {
                    throw new IllegalArgumentException("Class " + iClassName + " cannot be found");
                }
                boolean bl = regularEdgeBasedOnSchema = this.hasLinkedClass(from, outFieldName, edgeType) || this.hasLinkedClass(to, inFieldName, edgeType);
                if (!(!this.isUseLightweightEdges() || regularEdgeBasedOnSchema || fields != null && fields.length != 0 || forceRegular)) {
                    edge = this.newLightweightEdge(iClassName, from, to);
                    OVertexDelegate.createLink((ODocument)from.getRecord(), to.getRecord(), outFieldName);
                    OVertexDelegate.createLink((ODocument)to.getRecord(), from.getRecord(), inFieldName);
                    break;
                }
                edge = this.newInstance(iClassName).asEdge().get();
                edge.setProperty("out", currentVertex.getRecord());
                edge.setProperty("in", inDocument.getRecord());
                if (fields != null) {
                    for (int i = 0; i < fields.length; i += 2) {
                        String fieldName = "" + fields[i];
                        if (fields.length <= i + 1) break;
                        Object fieldValue = fields[i + 1];
                        edge.setProperty(fieldName, fieldValue);
                    }
                }
                if (!outDocumentModified) {
                    OVertexDelegate.createLink(outDocument, edge.getRecord(), outFieldName);
                }
                OVertexDelegate.createLink(inDocument, edge.getRecord(), inFieldName);
                break;
            }
            catch (ONeedRetryException ignore) {
                if (!outDocumentModified) {
                    outDocument.reload();
                    continue;
                }
                if (inDocument == null) continue;
                inDocument.reload();
                continue;
            }
        }
        return edge;
    }

    private boolean hasLinkedClass(OVertex vertex, String edgeFieldName, OClass linkedClass) {
        Optional<OClass> clazz = vertex.getSchemaType();
        if (!clazz.isPresent()) {
            return false;
        }
        OProperty prop = clazz.get().getProperty(edgeFieldName);
        if (prop == null) {
            return false;
        }
        if (prop.getLinkedClass() == null) {
            return false;
        }
        return linkedClass.isSubClassOf(prop.getLinkedClass());
    }

    private boolean checkDeletedInTx(OVertex currentVertex) {
        if (currentVertex.getRecord() == null) {
            return false;
        }
        ORID id = currentVertex.getRecord().getIdentity();
        ORecordOperation oper = this.getTransaction().getRecordEntry(id);
        if (oper == null) {
            return id.isTemporary();
        }
        return oper.type == 2;
    }

    private static String getConnectionFieldName(ODirection iDirection, String iClassName) {
        String prefix;
        if (iDirection == null || iDirection == ODirection.BOTH) {
            throw new IllegalArgumentException("Direction not valid");
        }
        String string = prefix = iDirection == ODirection.OUT ? "out_" : "in_";
        if (iClassName == null || iClassName.isEmpty() || iClassName.equals("E")) {
            return prefix;
        }
        return prefix + iClassName;
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        if (this.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName) == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in current database");
        }
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iClassName);
        return new ORecordIteratorClass<ODocument>((ODatabaseDocumentInternal)this, iClassName, iPolymorphic, false);
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>((ODatabaseDocumentInternal)this, this.getClusterIdByName(iClusterName));
    }

    @Override
    public Iterable<ODatabaseListener> getListeners() {
        return this.getListenersCopy();
    }

    @Deprecated
    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>(this, this.getClusterIdByName(iClusterName), startClusterPosition, endClusterPosition, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord) {
        return this.save(iRecord, (String)null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<Integer>)null);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        return this.save(iRecord, (String)null, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, String iClusterName) {
        return this.save(iRecord, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<Integer>)null);
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        this.checkOpenness();
        boolean lightweight = false;
        if (iRecord instanceof OVertex) {
            iRecord = iRecord.getRecord();
        }
        if (iRecord instanceof OEdge) {
            if (((OEdge)iRecord).isLightweight()) {
                lightweight = true;
                iRecord = ((OEdge)iRecord).getFrom();
            } else {
                iRecord = iRecord.getRecord();
            }
        }
        ODirtyManager dirtyManager = ORecordInternal.getDirtyManager(iRecord);
        if ((iRecord instanceof OElement && dirtyManager != null && dirtyManager.getReferences() != null && !dirtyManager.getReferences().isEmpty() || lightweight) && (((OElement)iRecord).isVertex() || ((OElement)iRecord).isEdge()) && !this.getTransaction().isActive() && this.inHook.isEmpty()) {
            return this.saveGraph(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        }
        return this.saveInternal(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    private <RET extends ORecord> RET saveInternal(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        if (!(iRecord instanceof ODocument)) {
            this.assignAndCheckCluster(iRecord, iClusterName);
            return (RET)this.currentTx.saveRecord(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        }
        ODocument doc = (ODocument)iRecord;
        ODocumentInternal.checkClass(doc, this);
        try {
            doc.validate();
        }
        catch (OValidationException e) {
            doc.undo();
            throw e;
        }
        ODocumentInternal.convertAllMultiValuesToTrackedVersions(doc);
        if (iForceCreate || !doc.getIdentity().isValid()) {
            if (doc.getClassName() != null) {
                this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)doc.getClassName());
            }
            this.assignAndCheckCluster(doc, iClusterName);
        } else if (doc.getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_UPDATE, (Object)doc.getClassName());
        }
        if (!this.getSerializer().equals(ORecordInternal.getRecordSerializer(doc))) {
            ORecordInternal.setRecordSerializer(doc, this.getSerializer());
        }
        doc = (ODocument)this.currentTx.saveRecord(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        return (RET)doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <RET extends ORecord> RET saveGraph(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        this.begin();
        try {
            RET RET = this.saveInternal(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
            return RET;
        }
        finally {
            this.commit();
        }
    }

    @Override
    public long countClass(String iClassName) {
        return this.countClass(iClassName, true);
    }

    @Override
    public long countClass(String iClassName, boolean iPolymorphic) {
        OClass cls = this.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName);
        if (cls == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in database");
        }
        long totalOnDb = cls.count(iPolymorphic);
        long deletedInTx = 0L;
        long addedInTx = 0L;
        if (this.getTransaction().isActive()) {
            for (ORecordOperation oRecordOperation : this.getTransaction().getRecordOperations()) {
                OClass schemaClass;
                ORecord rec;
                if (oRecordOperation.type == 2 && (rec = oRecordOperation.getRecord()) != null && rec instanceof ODocument) {
                    schemaClass = ((ODocument)rec).getSchemaClass();
                    if (iPolymorphic) {
                        if (schemaClass.isSubClassOf(iClassName)) {
                            ++deletedInTx;
                        }
                    } else if (iClassName.equals(schemaClass.getName()) || iClassName.equals(schemaClass.getShortName())) {
                        ++deletedInTx;
                    }
                }
                if (oRecordOperation.type != 3 || (rec = oRecordOperation.getRecord()) == null || !(rec instanceof ODocument) || (schemaClass = ((ODocument)rec).getSchemaClass()) == null) continue;
                if (iPolymorphic) {
                    if (!schemaClass.isSubClassOf(iClassName)) continue;
                    ++addedInTx;
                    continue;
                }
                if (!iClassName.equals(schemaClass.getName()) && !iClassName.equals(schemaClass.getShortName())) continue;
                ++addedInTx;
            }
        }
        return totalOnDb + addedInTx - deletedInTx;
    }

    @Override
    public ODatabase<ORecord> commit() {
        return this.commit(false);
    }

    public ODatabaseDocument commit(boolean force) throws OTransactionException {
        this.checkOpenness();
        this.checkIfActive();
        if (!this.currentTx.isActive()) {
            return this;
        }
        if (!force && this.currentTx.amountOfNestedTxs() > 1) {
            this.currentTx.commit();
            return this;
        }
        try {
            this.beforeCommitOperations();
        }
        catch (OException e) {
            try {
                this.rollback(force);
            }
            catch (Exception re) {
                OLogManager.instance().error(this, "Exception during rollback `%08X`", re, System.identityHashCode(re));
            }
            throw e;
        }
        try {
            this.currentTx.commit(force);
        }
        catch (RuntimeException e) {
            if (e instanceof OHighLevelException || e instanceof ONeedRetryException) {
                OLogManager.instance().debug((Object)this, "Error on transaction commit `%08X`", e, System.identityHashCode(e));
            } else {
                OLogManager.instance().error(this, "Error on transaction commit `%08X`", e, System.identityHashCode(e));
            }
            this.beforeRollbackOperations();
            try {
                ((OTransactionAbstract)this.currentTx).internalRollback();
            }
            catch (Exception re) {
                OLogManager.instance().error(this, "Error during transaction rollback `%08X`", re, System.identityHashCode(re));
            }
            this.getLocalCache().clear();
            this.afterRollbackOperations();
            throw e;
        }
        this.afterCommitOperations();
        return this;
    }

    protected void beforeCommitOperations() {
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxCommit(this);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Cannot commit the transaction: caught exception on execution of %s.onBeforeTxCommit() `%08X`", e, listener.getClass().getName(), System.identityHashCode(e));
                throw OException.wrapException(new OTransactionException("Cannot commit the transaction: caught exception on execution of " + listener.getClass().getName() + "#onBeforeTxCommit()"), e);
            }
        }
    }

    protected void afterCommitOperations() {
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onAfterTxCommit(this);
            }
            catch (Exception e) {
                String message = "Error after the transaction has been committed. The transaction remains valid. The exception caught was on execution of " + listener.getClass() + ".onAfterTxCommit() `%08X`";
                OLogManager.instance().error(this, message, e, System.identityHashCode(e));
                throw OException.wrapException(new OTransactionBlockedException(message), e);
            }
        }
    }

    protected void beforeRollbackOperations() {
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxRollback(this);
            }
            catch (Exception t) {
                OLogManager.instance().error(this, "Error before transaction rollback `%08X`", t, System.identityHashCode(t));
            }
        }
    }

    protected void afterRollbackOperations() {
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onAfterTxRollback(this);
            }
            catch (Exception t) {
                OLogManager.instance().error(this, "Error after transaction rollback `%08X`", t, System.identityHashCode(t));
            }
        }
    }

    @Override
    public ODatabase<ORecord> rollback() {
        return this.rollback(false);
    }

    public ODatabaseDocument rollback(boolean force) throws OTransactionException {
        this.checkOpenness();
        if (this.currentTx.isActive()) {
            if (!force && this.currentTx.amountOfNestedTxs() > 1) {
                this.currentTx.rollback();
                return this;
            }
            this.beforeRollbackOperations();
            this.currentTx.rollback(force, -1);
            this.afterRollbackOperations();
        }
        this.getLocalCache().clear();
        return this;
    }

    @Override
    public <DB extends ODatabase> DB getUnderlying() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        this.checkOpenness();
        return this.getStorage().backup(out, options, callable, iListener, compressionLevel, bufferSize);
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        this.checkOpenness();
        this.getStorage().restore(in, options, callable, iListener);
        if (!this.isClosed()) {
            this.loadMetadata();
            this.sharedContext = null;
        }
    }

    @Override
    public OSBTreeCollectionManager getSbTreeCollectionManager() {
        return this.getStorage().getSBtreeCollectionManager();
    }

    @Override
    public OCurrentStorageComponentsFactory getStorageVersions() {
        return this.componentsFactory;
    }

    @Override
    public ORecordSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setSerializer(ORecordSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void resetInitialization() {
        for (ORecordHook h : this.hooks.keySet()) {
            h.onUnregister();
        }
        this.hooks.clear();
        this.compileHooks();
        this.close();
        this.initialized = false;
    }

    @Override
    public String incrementalBackup(String path) throws UnsupportedOperationException {
        this.checkOpenness();
        this.checkIfActive();
        return this.getStorage().incrementalBackup(path, null);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResource, int iOperation) {
        String resourceSpecific = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (resourceSpecific == null || resourceSpecific.equals("*")) {
            this.checkSecurity(resourceGeneric, null, iOperation);
        }
        return this.checkSecurity(resourceGeneric, resourceSpecific, iOperation);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResourceGeneric);
        if (iResourceSpecific == null || iResourceSpecific.equals("*")) {
            return this.checkSecurity(resourceGeneric, iOperation, (Object)null);
        }
        return this.checkSecurity(resourceGeneric, iOperation, iResourceSpecific);
    }

    @Override
    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResourceGeneric);
        return this.checkSecurity(resourceGeneric, iOperation, iResourcesSpecific);
    }

    @Override
    public boolean isPooled() {
        return false;
    }

    @Deprecated
    public void setCurrentDatabaseInThreadLocal() {
        this.activateOnCurrentThread();
    }

    @Override
    public ODatabaseDocumentAbstract activateOnCurrentThread() {
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.instance();
        if (tl != null) {
            tl.set(this);
        }
        return this;
    }

    @Override
    public boolean isActiveOnCurrentThread() {
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.instance();
        ODatabaseDocumentInternal db = tl != null ? tl.getIfDefined() : null;
        return db == this;
    }

    protected void checkOpenness() {
        if (this.status == ODatabase.STATUS.CLOSED) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }

    private void popInHook(OIdentifiable id) {
        this.inHook.remove(id);
    }

    private boolean pushInHook(OIdentifiable id) {
        return this.inHook.add(id);
    }

    protected void callbackHookFailure(ORecord record, boolean wasNew, byte[] stream) {
        if (stream != null && stream.length > 0) {
            this.callbackHooks(wasNew ? ORecordHook.TYPE.CREATE_FAILED : ORecordHook.TYPE.UPDATE_FAILED, record);
        }
    }

    protected void callbackHookSuccess(ORecord record, boolean wasNew, byte[] stream, OStorageOperationResult<Integer> operationResult) {
        if (stream != null && stream.length > 0) {
            ORecordHook.TYPE hookType = !operationResult.isMoved() ? (wasNew ? ORecordHook.TYPE.AFTER_CREATE : ORecordHook.TYPE.AFTER_UPDATE) : (wasNew ? ORecordHook.TYPE.CREATE_REPLICATED : ORecordHook.TYPE.UPDATE_REPLICATED);
            this.callbackHooks(hookType, record);
        }
    }

    protected void callbackHookFinalize(ORecord record, boolean wasNew, byte[] stream) {
        if (stream != null && stream.length > 0) {
            ORecordHook.TYPE hookType = wasNew ? ORecordHook.TYPE.FINALIZE_CREATION : ORecordHook.TYPE.FINALIZE_UPDATE;
            this.callbackHooks(hookType, record);
            this.clearDocumentTracking(record);
        }
    }

    protected void clearDocumentTracking(ORecord record) {
        if (record instanceof ODocument && ((ODocument)record).isTrackingChanges()) {
            ODocumentInternal.clearTrackData((ODocument)record);
        }
    }

    protected void checkRecordClass(OClass recordClass, String iClusterName, ORecordId rid) {
        OClass clusterIdClass = this.metadata.getImmutableSchemaSnapshot().getClassByClusterId(rid.getClusterId());
        if (recordClass == null && clusterIdClass != null || clusterIdClass == null && recordClass != null || recordClass != null && !recordClass.equals(clusterIdClass)) {
            throw new IllegalArgumentException("Record saved into cluster '" + iClusterName + "' should be saved with class '" + clusterIdClass + "' but has been created with class '" + recordClass + "'");
        }
    }

    protected void init() {
        this.currentTx = new OTransactionNoTx(this);
    }

    private OFreezableStorageComponent getFreezableStorage() {
        OStorage s = this.getStorage();
        if (s instanceof OFreezableStorageComponent) {
            return (OFreezableStorageComponent)((Object)s);
        }
        OLogManager.instance().error(this, "Storage of type " + s.getType() + " does not support freeze operation", null, new Object[0]);
        return null;
    }

    @Override
    public void checkIfActive() {
        ODatabaseDocumentInternal currentDatabase;
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.instance();
        ODatabaseDocumentInternal oDatabaseDocumentInternal = currentDatabase = tl != null ? tl.get() : null;
        if (currentDatabase instanceof ODatabaseDocumentTx) {
            currentDatabase = ((ODatabaseDocumentTx)currentDatabase).internal;
        }
        if (currentDatabase != this) {
            throw new IllegalStateException("The current database instance (" + this.toString() + ") is not active on the current thread (" + Thread.currentThread() + "). Current active database is: " + currentDatabase);
        }
    }

    @Override
    public Set<Integer> getBlobClusterIds() {
        return this.getMetadata().getSchema().getBlobClusters();
    }

    private void compileHooks() {
        List[] intermediateHooksByScope = new List[ORecordHook.SCOPE.values().length];
        for (ORecordHook.SCOPE scope : ORecordHook.SCOPE.values()) {
            intermediateHooksByScope[scope.ordinal()] = new ArrayList();
        }
        for (ORecordHook hook : this.hooks.keySet()) {
            for (ORecordHook.SCOPE scope : hook.getScopes()) {
                intermediateHooksByScope[scope.ordinal()].add(hook);
            }
        }
        for (ORecordHook.SCOPE scope : ORecordHook.SCOPE.values()) {
            int ordinal = scope.ordinal();
            List scopeHooks = intermediateHooksByScope[ordinal];
            this.hooksByScope[ordinal] = scopeHooks.toArray(new ORecordHook[scopeHooks.size()]);
        }
    }

    @Override
    public OSharedContext getSharedContext() {
        if (this.sharedContext == null) {
            this.sharedContext = this.getStorage().getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

                @Override
                public OSharedContext call() throws Exception {
                    throw new ODatabaseException("Accessing to the database context before the database has bean initialized");
                }
            });
        }
        return this.sharedContext;
    }

    public static Object executeWithRetries(OCallable<Object, Integer> callback, int maxRetry) {
        return ODatabaseDocumentAbstract.executeWithRetries(callback, maxRetry, 0, null);
    }

    public static Object executeWithRetries(OCallable<Object, Integer> callback, int maxRetry, int waitBetweenRetry) {
        return ODatabaseDocumentAbstract.executeWithRetries(callback, maxRetry, waitBetweenRetry, null);
    }

    public static Object executeWithRetries(OCallable<Object, Integer> callback, int maxRetry, int waitBetweenRetry, ORecord[] recordToReloadOnRetry) {
        ONeedRetryException lastException = null;
        for (int retry = 0; retry < maxRetry; ++retry) {
            try {
                return callback.call(retry);
            }
            catch (ONeedRetryException e) {
                lastException = e;
                if (recordToReloadOnRetry != null) {
                    for (ORecord r : recordToReloadOnRetry) {
                        r.reload();
                    }
                }
                if (waitBetweenRetry <= 0) continue;
                try {
                    Thread.sleep(waitBetweenRetry);
                    continue;
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw lastException;
    }

    private void bindPropertiesToContext(OContextConfiguration configuration, Map<String, Object> iProperties) {
        String encryptionKey;
        String encryptionMethod;
        String compressionMethod;
        String connectionStrategy;
        String string = connectionStrategy = iProperties != null ? (String)iProperties.get("connectionStrategy") : null;
        if (connectionStrategy != null) {
            configuration.setValue(OGlobalConfiguration.CLIENT_CONNECTION_STRATEGY, (Object)connectionStrategy);
        }
        String string2 = compressionMethod = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getKey().toLowerCase(Locale.ENGLISH)) : null;
        if (compressionMethod != null) {
            configuration.setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, (Object)compressionMethod);
        }
        String string3 = encryptionMethod = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD.getKey().toLowerCase(Locale.ENGLISH)) : null;
        if (encryptionMethod != null) {
            configuration.setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, (Object)encryptionMethod);
        }
        String string4 = encryptionKey = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getKey().toLowerCase(Locale.ENGLISH)) : null;
        if (encryptionKey != null) {
            configuration.setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, (Object)encryptionKey);
        }
    }

    private void bindPropertiesToContextGlobal(OContextConfiguration configuration, Map<OGlobalConfiguration, Object> iProperties) {
        String encryptionKey;
        String encryptionMethod;
        String compressionMethod;
        String connectionStrategy;
        String string = connectionStrategy = iProperties != null ? (String)iProperties.get("connectionStrategy") : null;
        if (connectionStrategy != null) {
            configuration.setValue(OGlobalConfiguration.CLIENT_CONNECTION_STRATEGY, (Object)connectionStrategy);
        }
        String string2 = compressionMethod = iProperties != null ? (String)iProperties.get((Object)OGlobalConfiguration.STORAGE_COMPRESSION_METHOD) : null;
        if (compressionMethod != null) {
            configuration.setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, (Object)compressionMethod);
        }
        String string3 = encryptionMethod = iProperties != null ? (String)iProperties.get((Object)OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD) : null;
        if (encryptionMethod != null) {
            configuration.setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, (Object)encryptionMethod);
        }
        String string4 = encryptionKey = iProperties != null ? (String)iProperties.get((Object)OGlobalConfiguration.STORAGE_ENCRYPTION_KEY) : null;
        if (encryptionKey != null) {
            configuration.setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, (Object)encryptionKey);
        }
    }

    @Override
    public boolean isUseLightweightEdges() {
        List custom = (List)this.get(ODatabase.ATTRIBUTES.CUSTOM);
        for (OStorageEntryConfiguration c : custom) {
            if (!c.name.equals("useLightweightEdges")) continue;
            return Boolean.parseBoolean(c.value);
        }
        return false;
    }

    @Override
    public void setUseLightweightEdges(boolean b) {
        this.setCustom("useLightweightEdges", b);
    }

    @Override
    public OEdge newLightweightEdge(String iClassName, OVertex from, OVertex to) {
        OClass clazz = this.getMetadata().getSchema().getClass(iClassName);
        OEdgeDelegate result = new OEdgeDelegate(from, to, clazz, iClassName);
        return result;
    }

    @Override
    public OEdge newRegularEdge(String iClassName, OVertex from, OVertex to) {
        OClass cl = this.getClass(iClassName);
        if (cl == null || !cl.isEdgeType()) {
            throw new IllegalArgumentException("" + iClassName + " is not an edge class");
        }
        return this.addEdgeInternal(from, to, iClassName, true, new Object[0]);
    }

    public synchronized void queryStarted(String id, OResultSet rs) {
        if (this.activeQueries.size() > 1 && this.activeQueries.size() % 10 == 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("This database instance has ");
            msg.append(this.activeQueries.size());
            msg.append(" open command/query result sets, please make sure you close them with OResultSet.close()");
            OLogManager.instance().warn((Object)this, msg.toString(), null);
            if (OLogManager.instance().isDebugEnabled()) {
                this.activeQueries.values().stream().map(pendingQuery -> pendingQuery.getExecutionPlan()).filter(plan -> plan != null).forEach(plan -> OLogManager.instance().debug((Object)this, plan.toString(), new Object[0]));
            }
        }
        this.activeQueries.put(id, rs);
        this.getListeners().forEach(l -> l.onCommandStart(this, rs));
    }

    public synchronized void queryClosed(String id) {
        OResultSet rs = this.activeQueries.remove(id);
        this.getListeners().forEach(l -> l.onCommandEnd(this, rs));
    }

    protected synchronized void closeActiveQueries() {
        while (this.activeQueries.size() > 0) {
            this.activeQueries.values().iterator().next().close();
        }
    }

    @Override
    public Map<String, OResultSet> getActiveQueries() {
        return this.activeQueries;
    }

    @Override
    public OResultSet getActiveQuery(String id) {
        return this.activeQueries.get(id);
    }

    @Override
    public void internalCommit(OTransactionInternal transaction) {
        this.getStorage().commit(transaction);
    }

    @Override
    public boolean isClusterEdge(int cluster) {
        OClass clazz = this.getMetadata().getImmutableSchemaSnapshot().getClassByClusterId(cluster);
        return clazz != null && clazz.isEdgeType();
    }

    @Override
    public boolean isClusterVertex(int cluster) {
        OClass clazz = this.getMetadata().getImmutableSchemaSnapshot().getClassByClusterId(cluster);
        return clazz != null && clazz.isVertexType();
    }

    @Override
    public Map<UUID, OBonsaiCollectionPointer> getCollectionsChanges() {
        if (this.collectionsChanges == null) {
            this.collectionsChanges = new HashMap<UUID, OBonsaiCollectionPointer>();
        }
        return this.collectionsChanges;
    }
}

