/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBConfigBuilder;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxInternal;
import com.orientechnologies.orient.core.db.document.RecordReader;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.shutdown.OShutdownHandler;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.util.OURLConnection;
import com.orientechnologies.orient.core.util.OURLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
public class ODatabaseDocumentTx
implements ODatabaseDocumentInternal {
    protected static ConcurrentMap<String, OrientDBInternal> embedded = new ConcurrentHashMap<String, OrientDBInternal>();
    protected static ConcurrentMap<String, OrientDBInternal> remote = new ConcurrentHashMap<String, OrientDBInternal>();
    protected ODatabaseDocumentInternal internal;
    private final String url;
    private OrientDBInternal factory;
    private final String type;
    private final String dbName;
    private final String baseUrl;
    private final Map<String, Object> preopenProperties = new HashMap<String, Object>();
    private final Map<ODatabase.ATTRIBUTES, Object> preopenAttributes = new HashMap<ODatabase.ATTRIBUTES, Object>();
    private final Set<ODatabaseListener> preopenListener = new HashSet<ODatabaseListener>();
    private ODatabaseInternal<?> databaseOwner;
    private OIntent intent;
    private OStorage delegateStorage;
    private ORecordConflictStrategy conflictStrategy;
    private ORecordSerializer serializer;
    protected final AtomicReference<Thread> owner = new AtomicReference();
    private final boolean ownerProtection;
    private static OShutdownHandler shutdownHandler = new OShutdownHandler(){

        @Override
        public void shutdown() throws Exception {
            ODatabaseDocumentTxInternal.closeAllOnShutdown();
        }

        @Override
        public int getPriority() {
            return 1000;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        ConcurrentMap<String, OrientDBInternal> concurrentMap = embedded;
        synchronized (concurrentMap) {
            for (OrientDBInternal factory : embedded.values()) {
                factory.close();
            }
            embedded.clear();
        }
        concurrentMap = remote;
        synchronized (concurrentMap) {
            for (OrientDBInternal factory : remote.values()) {
                factory.close();
            }
            remote.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OrientDBInternal getOrCreateRemoteFactory(String baseUrl) {
        OrientDBInternal factory;
        ConcurrentMap<String, OrientDBInternal> concurrentMap = remote;
        synchronized (concurrentMap) {
            factory = (OrientDBInternal)remote.get(baseUrl);
            if (factory == null || !factory.isOpen()) {
                factory = OrientDBInternal.fromUrl("remote:" + baseUrl, null);
                remote.put(baseUrl, factory);
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OrientDBInternal getOrCreateEmbeddedFactory(String baseUrl, OrientDBConfig config) {
        OrientDBInternal factory;
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        ConcurrentMap<String, OrientDBInternal> concurrentMap = embedded;
        synchronized (concurrentMap) {
            factory = (OrientDBInternal)embedded.get(baseUrl);
            if (factory == null || !factory.isOpen()) {
                try {
                    factory = OrientDBInternal.distributed(baseUrl, config);
                }
                catch (ODatabaseException ignore) {
                    factory = OrientDBInternal.embedded(baseUrl, config);
                }
                embedded.put(baseUrl, factory);
            }
        }
        return factory;
    }

    @Deprecated
    public ODatabaseDocumentTx(String url) {
        this(url, true);
    }

    protected ODatabaseDocumentTx(String url, boolean ownerProtection) {
        OURLConnection connection = OURLHelper.parse(url);
        this.url = connection.getUrl();
        this.type = connection.getType();
        this.baseUrl = connection.getPath();
        this.dbName = connection.getDbName();
        this.ownerProtection = ownerProtection;
    }

    protected ODatabaseDocumentTx(ODatabaseDocumentInternal ref, String baseUrl) {
        this.url = ref.getURL();
        this.type = ref.getType();
        this.baseUrl = baseUrl;
        this.dbName = ref.getName();
        this.internal = ref;
        this.ownerProtection = true;
    }

    public static ORecordSerializer getDefaultSerializer() {
        return ODatabaseDocumentAbstract.getDefaultSerializer();
    }

    public static void setDefaultSerializer(ORecordSerializer defaultSerializer) {
        ODatabaseDocumentAbstract.setDefaultSerializer(defaultSerializer);
    }

    @Override
    public OCurrentStorageComponentsFactory getStorageVersions() {
        if (this.internal == null) {
            return null;
        }
        return this.internal.getStorageVersions();
    }

    @Override
    public OSBTreeCollectionManager getSbTreeCollectionManager() {
        if (this.internal == null) {
            return null;
        }
        return this.internal.getSbTreeCollectionManager();
    }

    @Override
    public OBinarySerializerFactory getSerializerFactory() {
        this.checkOpenness();
        return this.internal.getSerializerFactory();
    }

    @Override
    public ORecordSerializer getSerializer() {
        if (this.internal == null) {
            if (this.serializer != null) {
                return this.serializer;
            }
            return ORecordSerializerFactory.instance().getDefaultRecordSerializer();
        }
        return this.internal.getSerializer();
    }

    @Override
    public int assignAndCheckCluster(ORecord record, String iClusterName) {
        return this.internal.assignAndCheckCluster(record, iClusterName);
    }

    @Override
    public <RET extends ORecord> RET loadIfVersionIsNotLatest(ORID rid, int recordVersion, String fetchPlan, boolean ignoreCache) throws ORecordNotFoundException {
        this.checkOpenness();
        return this.internal.loadIfVersionIsNotLatest(rid, recordVersion, fetchPlan, ignoreCache);
    }

    @Override
    public void reloadUser() {
        this.checkOpenness();
        this.internal.reloadUser();
    }

    @Override
    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE type, OIdentifiable id) {
        this.checkOpenness();
        return this.internal.callbackHooks(type, id);
    }

    @Override
    public <RET extends ORecord> RET executeReadRecord(ORecordId rid, ORecord iRecord, int recordVersion, String fetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstones, OStorage.LOCKING_STRATEGY lockingStrategy, RecordReader recordReader) {
        this.checkOpenness();
        return this.internal.executeReadRecord(rid, iRecord, recordVersion, fetchPlan, ignoreCache, iUpdateCache, loadTombstones, lockingStrategy, recordReader);
    }

    @Override
    public <RET extends ORecord> RET executeSaveRecord(ORecord record, String clusterName, int ver, ODatabase.OPERATION_MODE mode, boolean forceCreate, ORecordCallback<? extends Number> recordCreatedCallback, ORecordCallback<Integer> recordUpdatedCallback) {
        this.checkOpenness();
        return this.internal.executeSaveRecord(record, clusterName, ver, mode, forceCreate, recordCreatedCallback, recordUpdatedCallback);
    }

    @Override
    public void executeDeleteRecord(OIdentifiable record, int iVersion, boolean iRequired, ODatabase.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpenness();
        this.internal.executeDeleteRecord(record, iVersion, iRequired, iMode, prohibitTombstones);
    }

    @Override
    public <RET extends ORecord> RET executeSaveEmptyRecord(ORecord record, String clusterName) {
        this.checkOpenness();
        return this.internal.executeSaveEmptyRecord(record, clusterName);
    }

    @Override
    public void setDefaultTransactionMode() {
        this.checkOpenness();
        this.internal.setDefaultTransactionMode();
    }

    @Override
    public OMetadataInternal getMetadata() {
        this.checkOpenness();
        return this.internal.getMetadata();
    }

    @Override
    public <DB extends ODatabase<?>> DB registerHook(ORecordHook iHookImpl) {
        this.checkOpenness();
        this.internal.registerHook(iHookImpl);
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase<?>> DB registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        this.checkOpenness();
        this.internal.registerHook(iHookImpl, iPosition);
        return (DB)this;
    }

    @Override
    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks() {
        this.checkOpenness();
        return this.internal.getHooks();
    }

    @Override
    public <DB extends ODatabase<?>> DB unregisterHook(ORecordHook iHookImpl) {
        this.checkOpenness();
        this.internal.unregisterHook(iHookImpl);
        return (DB)this;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public Iterable<ODatabaseListener> getListeners() {
        return this.internal.getListeners();
    }

    @Override
    public <DB extends ODatabase<?>> DB setMVCC(boolean iValue) {
        return null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return this.internal.getConflictStrategy();
    }

    @Override
    public <DB extends ODatabase<?>> DB setConflictStrategy(String iStrategyName) {
        if (this.internal != null) {
            this.internal.setConflictStrategy(iStrategyName);
        } else {
            this.conflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName);
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase<?>> DB setConflictStrategy(ORecordConflictStrategy iResolver) {
        if (this.internal != null) {
            this.internal.setConflictStrategy(iResolver);
        } else {
            this.conflictStrategy = iResolver;
        }
        return (DB)this;
    }

    @Override
    public String incrementalBackup(String path) {
        this.checkOpenness();
        return this.internal.incrementalBackup(path);
    }

    @Override
    public ODatabaseDocumentTx copy() {
        this.checkOpenness();
        return new ODatabaseDocumentTx(this.internal.copy(), this.baseUrl);
    }

    @Override
    public void checkIfActive() {
        this.internal.checkIfActive();
    }

    protected void checkOpenness() {
        if (this.internal == null) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }

    @Override
    public void callOnOpenListeners() {
        this.checkOpenness();
        this.internal.callOnOpenListeners();
    }

    @Override
    public void callOnCloseListeners() {
        this.checkOpenness();
        this.internal.callOnCloseListeners();
    }

    @Override
    public OStorage getStorage() {
        if (this.internal == null) {
            return this.delegateStorage;
        }
        return this.internal.getStorage();
    }

    @Override
    public OBasicTransaction getMicroOrRegularTransaction() {
        this.checkOpenness();
        return this.internal.getMicroOrRegularTransaction();
    }

    @Override
    public void setUser(OSecurityUser user) {
        this.internal.setUser(user);
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        this.internal.replaceStorage(iNewStorage);
    }

    @Override
    public void resetInitialization() {
        if (this.internal != null) {
            this.internal.resetInitialization();
        }
    }

    @Override
    public ODatabaseInternal<?> getDatabaseOwner() {
        ODatabaseInternal<?> current;
        for (current = this.databaseOwner; current != null && current != this && current.getDatabaseOwner() != current; current = current.getDatabaseOwner()) {
        }
        if (current == null) {
            return this;
        }
        return current;
    }

    @Override
    public ODatabaseInternal<?> setDatabaseOwner(ODatabaseInternal<?> iOwner) {
        this.databaseOwner = iOwner;
        if (this.internal != null) {
            this.internal.setDatabaseOwner(iOwner);
        }
        return this;
    }

    @Override
    public <DB extends ODatabase> DB getUnderlying() {
        return this.internal.getUnderlying();
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES attribute, Object iValue) {
        this.checkOpenness();
        this.internal.setInternal(attribute, iValue);
    }

    @Override
    public <DB extends ODatabase> DB open(OToken iToken) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OSharedContext getSharedContext() {
        return this.internal.getSharedContext();
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        this.checkOpenness();
        return this.internal.browseClass(iClassName);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        this.checkOpenness();
        return this.internal.browseClass(iClassName, iPolymorphic);
    }

    @Override
    public void freeze() {
        this.checkOpenness();
        this.internal.freeze();
    }

    @Override
    public void release() {
        this.checkOpenness();
        this.internal.release();
    }

    @Override
    public void freeze(boolean throwException) {
        this.checkOpenness();
        this.internal.freeze(throwException);
    }

    @Override
    public OVertex newVertex(String iClassName) {
        this.checkOpenness();
        return this.internal.newVertex(iClassName);
    }

    @Override
    public OVertex newVertex(OClass type) {
        this.checkOpenness();
        return this.internal.newVertex(type);
    }

    @Override
    public OEdge newEdge(OVertex from, OVertex to, String type) {
        this.checkOpenness();
        return this.internal.newEdge(from, to, type);
    }

    @Override
    public OEdge newEdge(OVertex from, OVertex to, OClass type) {
        this.checkOpenness();
        return this.internal.newEdge(from, to, type);
    }

    @Override
    public OElement newElement() {
        this.checkOpenness();
        return (OElement)this.internal.newInstance();
    }

    @Override
    public OElement newElement(String className) {
        this.checkOpenness();
        return this.internal.newElement(className);
    }

    @Override
    public boolean isUseLightweightEdges() {
        return this.internal.isUseLightweightEdges();
    }

    @Override
    public void setUseLightweightEdges(boolean b) {
        this.internal.setUseLightweightEdges(b);
    }

    @Override
    public ODocument newInstance() {
        this.checkOpenness();
        return (ODocument)this.internal.newInstance();
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        this.checkOpenness();
        return this.internal.getDictionary();
    }

    @Override
    public OSecurityUser getUser() {
        if (this.internal != null) {
            return this.internal.getUser();
        }
        return null;
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iObject) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iObject));
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iObject, String iFetchPlan) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iObject, iFetchPlan));
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iObject, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iObject, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy));
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iObject, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iObject, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, iLockingStrategy));
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iObject, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iObject, iFetchPlan, iIgnoreCache));
    }

    @Override
    public <RET extends ORecord> RET reload(ORecord iObject, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.reload(iObject, iFetchPlan, iIgnoreCache));
    }

    @Override
    public <RET extends ORecord> RET reload(ORecord iObject, String iFetchPlan, boolean iIgnoreCache, boolean force) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.reload(iObject, iFetchPlan, iIgnoreCache, force));
    }

    @Override
    public <RET extends ORecord> RET load(ORID recordId) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(recordId));
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iRecordId, iFetchPlan));
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iRecordId, iFetchPlan, iIgnoreCache));
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iRecordId, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy));
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.load(iRecordId, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, iLockingStrategy));
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iObject) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.save(iObject));
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iObject, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.save(iObject, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback));
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iObject, String iClusterName) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.save(iObject, iClusterName));
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iObject, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        this.checkOpenness();
        return (RET)((ORecord)this.internal.save(iObject, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback));
    }

    @Override
    public ODatabase<ORecord> delete(ORecord iObject) {
        this.checkOpenness();
        this.internal.delete(iObject);
        return this;
    }

    @Override
    public ODatabase<ORecord> delete(ORID iRID) {
        this.checkOpenness();
        this.internal.delete(iRID);
        return this;
    }

    @Override
    public ODatabase<ORecord> delete(ORID iRID, int iVersion) {
        this.checkOpenness();
        this.internal.delete(iRID, iVersion);
        return this;
    }

    @Override
    public boolean hide(ORID rid) {
        this.checkOpenness();
        return this.internal.hide(rid);
    }

    @Override
    public ODatabaseDocumentInternal cleanOutRecord(ORID rid, int version) {
        this.checkOpenness();
        this.internal.cleanOutRecord(rid, version);
        return this;
    }

    @Override
    public OTransaction getTransaction() {
        this.checkOpenness();
        return this.internal.getTransaction();
    }

    @Override
    public ODatabase<ORecord> begin() {
        this.checkOpenness();
        this.internal.begin();
        return this;
    }

    @Override
    public ODatabase<ORecord> begin(OTransaction.TXTYPE iStatus) {
        this.checkOpenness();
        this.internal.begin(iStatus);
        return this;
    }

    @Override
    public ODatabase<ORecord> begin(OTransaction iTx) throws OTransactionException {
        this.checkOpenness();
        this.internal.begin(iTx);
        return this;
    }

    @Override
    public void rawBegin(OTransaction transaction) {
        throw new UnsupportedOperationException("private api");
    }

    @Override
    public ODatabase<ORecord> commit() throws OTransactionException {
        this.checkOpenness();
        this.internal.commit();
        return this;
    }

    @Override
    public ODatabase<ORecord> commit(boolean force) throws OTransactionException {
        this.checkOpenness();
        this.internal.commit(force);
        return this;
    }

    @Override
    public ODatabase<ORecord> rollback() throws OTransactionException {
        this.checkOpenness();
        this.internal.rollback();
        return this;
    }

    @Override
    public ODatabase<ORecord> rollback(boolean force) throws OTransactionException {
        this.checkOpenness();
        this.internal.rollback(force);
        return this;
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<?> iCommand, Object ... iArgs) {
        this.checkOpenness();
        return this.internal.query(iCommand, iArgs);
    }

    @Override
    public <RET extends OCommandRequest> RET command(OCommandRequest iCommand) {
        this.checkOpenness();
        return this.internal.command(iCommand);
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        this.checkOpenness();
        return this.internal.browseCluster(iClusterName);
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        this.checkOpenness();
        return this.internal.browseCluster(iClusterName, startClusterPosition, endClusterPosition, loadTombstones);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass) {
        this.checkOpenness();
        return this.internal.browseCluster(iClusterName, iRecordClass);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition) {
        this.checkOpenness();
        return this.internal.browseCluster(iClusterName, iRecordClass, startClusterPosition, endClusterPosition);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        this.checkOpenness();
        return this.internal.browseCluster(iClusterName, iRecordClass, startClusterPosition, endClusterPosition, loadTombstones);
    }

    @Override
    public <RET extends ORecord> RET getRecord(OIdentifiable iIdentifiable) {
        this.checkOpenness();
        return this.internal.getRecord(iIdentifiable);
    }

    @Override
    public byte getRecordType() {
        this.checkOpenness();
        return this.internal.getRecordType();
    }

    @Override
    public boolean isRetainRecords() {
        this.checkOpenness();
        return this.internal.isRetainRecords();
    }

    @Override
    public ODatabaseDocument setRetainRecords(boolean iValue) {
        this.checkOpenness();
        return this.internal.setRetainRecords(iValue);
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        this.checkOpenness();
        this.internal.checkSecurity(resourceGeneric, resourceSpecific, iOperation);
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object iResourceSpecific) {
        this.checkOpenness();
        this.internal.checkSecurity(iResourceGeneric, iOperation, iResourceSpecific);
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        this.checkOpenness();
        this.internal.checkSecurity(iResourceGeneric, iOperation, iResourcesSpecific);
        return (DB)this;
    }

    @Override
    public boolean isValidationEnabled() {
        this.checkOpenness();
        return this.internal.isValidationEnabled();
    }

    @Override
    public <DB extends ODatabaseDocument> DB setValidationEnabled(boolean iEnabled) {
        this.checkOpenness();
        this.internal.setValidationEnabled(iEnabled);
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResource, int iOperation) {
        this.checkOpenness();
        this.internal.checkSecurity(iResource, iOperation);
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        this.checkOpenness();
        this.internal.checkSecurity(iResourceGeneric, iOperation, iResourceSpecific);
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseDocument> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        this.checkOpenness();
        this.internal.checkSecurity(iResourceGeneric, iOperation, iResourcesSpecific);
        return (DB)this;
    }

    @Override
    public boolean isPooled() {
        return false;
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        this.setupThreadOwner();
        try {
            Object config;
            if ("remote".equals(this.type)) {
                this.factory = ODatabaseDocumentTx.getOrCreateRemoteFactory(this.baseUrl);
                config = this.buildConfig(null);
                this.internal = this.factory.open(this.dbName, iUserName, iUserPassword, (OrientDBConfig)config);
            } else {
                this.factory = ODatabaseDocumentTx.getOrCreateEmbeddedFactory(this.baseUrl, null);
                config = this.buildConfig(null);
                this.internal = this.factory.open(this.dbName, iUserName, iUserPassword, (OrientDBConfig)config);
            }
            if (this.databaseOwner != null) {
                this.internal.setDatabaseOwner(this.databaseOwner);
            }
            if (this.intent != null) {
                this.internal.declareIntent(this.intent);
            }
            if (this.conflictStrategy != null) {
                this.internal.setConflictStrategy(this.conflictStrategy);
            }
            if (this.serializer != null) {
                this.internal.setSerializer(this.serializer);
            }
            for (Map.Entry entry : this.preopenProperties.entrySet()) {
                this.internal.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        catch (RuntimeException e) {
            this.clearOwner();
            throw e;
        }
        return (DB)this;
    }

    protected void setupThreadOwner() {
        if (!this.ownerProtection) {
            return;
        }
        Thread current = Thread.currentThread();
        Thread o = this.owner.get();
        if (o != null || !this.owner.compareAndSet(null, current)) {
            throw new IllegalStateException("Current instance is owned by other thread '" + (o != null ? o.getName() : "?") + "'");
        }
    }

    protected void clearOwner() {
        if (!this.ownerProtection) {
            return;
        }
        this.owner.set(null);
    }

    @Override
    public <DB extends ODatabase> DB create() {
        return this.create((Map<OGlobalConfiguration, Object>)null);
    }

    @Override
    @Deprecated
    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        this.setupThreadOwner();
        try {
            OrientDBConfig openConfig;
            OrientDBConfig config = this.buildConfig(iInitialSettings);
            if ("remote".equals(this.type)) {
                throw new UnsupportedOperationException();
            }
            if ("memory".equals(this.type)) {
                this.factory = ODatabaseDocumentTx.getOrCreateEmbeddedFactory(this.baseUrl, null);
                this.factory.create(this.dbName, null, null, ODatabaseType.MEMORY, config);
                openConfig = OrientDBConfig.builder().fromContext(config.getConfigurations()).build();
                this.internal = this.factory.open(this.dbName, "admin", "admin", openConfig);
                for (Map.Entry<ODatabase.ATTRIBUTES, Object> attr : this.preopenAttributes.entrySet()) {
                    this.internal.set(attr.getKey(), attr.getValue());
                }
                for (ODatabaseListener oDatabaseListener : this.preopenListener) {
                    this.internal.registerListener(oDatabaseListener);
                }
            } else {
                this.factory = ODatabaseDocumentTx.getOrCreateEmbeddedFactory(this.baseUrl, null);
                this.factory.create(this.dbName, null, null, ODatabaseType.PLOCAL, config);
                openConfig = OrientDBConfig.builder().fromContext(config.getConfigurations()).build();
                this.internal = this.factory.open(this.dbName, "admin", "admin", openConfig);
                for (Map.Entry<ODatabase.ATTRIBUTES, Object> attr : this.preopenAttributes.entrySet()) {
                    this.internal.set(attr.getKey(), attr.getValue());
                }
                for (ODatabaseListener oDatabaseListener : this.preopenListener) {
                    this.internal.registerListener(oDatabaseListener);
                }
            }
            if (this.databaseOwner != null) {
                this.internal.setDatabaseOwner(this.databaseOwner);
            }
            if (this.intent != null) {
                this.internal.declareIntent(this.intent);
            }
            if (this.conflictStrategy != null) {
                this.internal.setConflictStrategy(this.conflictStrategy);
            }
            if (this.serializer != null) {
                this.internal.setSerializer(this.serializer);
            }
            for (Map.Entry<String, Object> pro : this.preopenProperties.entrySet()) {
                this.internal.setProperty(pro.getKey(), pro.getValue());
            }
        }
        catch (RuntimeException e) {
            this.clearOwner();
            throw e;
        }
        return (DB)this;
    }

    @Override
    public ODatabase activateOnCurrentThread() {
        if (this.internal != null) {
            this.internal.activateOnCurrentThread();
        }
        return this;
    }

    @Override
    public boolean isActiveOnCurrentThread() {
        if (this.internal != null) {
            return this.internal.isActiveOnCurrentThread();
        }
        return false;
    }

    @Override
    public void reload() {
        this.checkOpenness();
        this.internal.reload();
    }

    @Override
    public void drop() {
        this.checkOpenness();
        this.internal.callOnDropListeners();
        ODatabaseRecordThreadLocal.instance().remove();
        this.factory.drop(this.getName(), null, null);
        this.internal = null;
        this.clearOwner();
    }

    @Override
    public OContextConfiguration getConfiguration() {
        this.checkOpenness();
        return this.internal.getConfiguration();
    }

    @Override
    public boolean declareIntent(OIntent iIntent) {
        if (this.internal != null) {
            return this.internal.declareIntent(iIntent);
        }
        this.intent = iIntent;
        return true;
    }

    @Override
    public OIntent getActiveIntent() {
        if (this.internal == null) {
            return this.intent;
        }
        return this.internal.getActiveIntent();
    }

    @Override
    public boolean exists() {
        if (this.internal != null) {
            return true;
        }
        if ("remote".equals(this.type)) {
            throw new UnsupportedOperationException();
        }
        this.factory = ODatabaseDocumentTx.getOrCreateEmbeddedFactory(this.baseUrl, null);
        return this.factory.exists(this.dbName, null, null);
    }

    @Override
    public void close() {
        this.clearOwner();
        if (this.internal != null) {
            this.delegateStorage = this.internal.getStorage();
            this.internal.close();
            this.internal = null;
        }
    }

    @Override
    public ODatabase.STATUS getStatus() {
        return this.internal.getStatus();
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS iStatus) {
        this.checkOpenness();
        this.internal.setStatus(iStatus);
        return (DB)this;
    }

    @Override
    public long getSize() {
        this.checkOpenness();
        return this.internal.getSize();
    }

    @Override
    public String getName() {
        return this.dbName;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public OLocalRecordCache getLocalCache() {
        this.checkOpenness();
        return this.internal.getLocalCache();
    }

    @Override
    public int getDefaultClusterId() {
        this.checkOpenness();
        return this.internal.getDefaultClusterId();
    }

    @Override
    public int getClusters() {
        this.checkOpenness();
        return this.internal.getClusters();
    }

    @Override
    public boolean existsCluster(String iClusterName) {
        this.checkOpenness();
        return this.internal.existsCluster(iClusterName);
    }

    @Override
    public Collection<String> getClusterNames() {
        this.checkOpenness();
        return this.internal.getClusterNames();
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        this.checkOpenness();
        return this.internal.getClusterIdByName(iClusterName);
    }

    @Override
    public String getClusterNameById(int iClusterId) {
        this.checkOpenness();
        return this.internal.getClusterNameById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeByName(String iClusterName) {
        this.checkOpenness();
        return this.internal.getClusterRecordSizeByName(iClusterName);
    }

    @Override
    public long getClusterRecordSizeById(int iClusterId) {
        this.checkOpenness();
        return this.internal.getClusterRecordSizeById(iClusterId);
    }

    @Override
    public boolean isClosed() {
        return this.internal == null || this.internal.isClosed();
    }

    @Override
    public void truncateCluster(String clusterName) {
        this.checkOpenness();
        this.internal.truncateCluster(clusterName);
    }

    @Override
    public long countClusterElements(int iCurrentClusterId) {
        this.checkOpenness();
        return this.internal.countClusterElements(iCurrentClusterId);
    }

    @Override
    public long countClusterElements(int iCurrentClusterId, boolean countTombstones) {
        this.checkOpenness();
        return this.internal.countClusterElements(iCurrentClusterId, countTombstones);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        this.checkOpenness();
        return this.internal.countClusterElements(iClusterIds);
    }

    @Override
    public long countClusterElements(int[] iClusterIds, boolean countTombstones) {
        this.checkOpenness();
        return this.internal.countClusterElements(iClusterIds, countTombstones);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkOpenness();
        return this.internal.countClusterElements(iClusterName);
    }

    @Override
    public int addCluster(String iClusterName, Object ... iParameters) {
        this.checkOpenness();
        return this.internal.addCluster(iClusterName, iParameters);
    }

    @Override
    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        this.checkOpenness();
        return this.internal.addBlobCluster(iClusterName, iParameters);
    }

    @Override
    public Set<Integer> getBlobClusterIds() {
        this.checkOpenness();
        return this.internal.getBlobClusterIds();
    }

    @Override
    public int addCluster(String iClusterName, int iRequestedId, Object ... iParameters) {
        this.checkOpenness();
        return this.internal.addCluster(iClusterName, iRequestedId, iParameters);
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.checkOpenness();
        return this.internal.dropCluster(iClusterName, iTruncate);
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.checkOpenness();
        return this.internal.dropCluster(iClusterId, iTruncate);
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        if (this.internal != null) {
            return this.internal.setProperty(iName, iValue);
        }
        return this.preopenProperties.put(iName, iValue);
    }

    @Override
    public Object getProperty(String iName) {
        if (this.internal != null) {
            return this.internal.getProperty(iName);
        }
        return this.preopenProperties.get(iName);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> getProperties() {
        this.checkOpenness();
        return this.internal.getProperties();
    }

    @Override
    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        if (this.internal != null) {
            return this.internal.get(iAttribute);
        }
        return this.preopenAttributes.get((Object)iAttribute);
    }

    @Override
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (this.internal != null) {
            this.internal.set(iAttribute, iValue);
        } else {
            this.preopenAttributes.put(iAttribute, iValue);
        }
        return (DB)this;
    }

    @Override
    public void registerListener(ODatabaseListener iListener) {
        if (this.internal != null) {
            this.internal.registerListener(iListener);
        } else {
            this.preopenListener.add(iListener);
        }
    }

    @Override
    public void unregisterListener(ODatabaseListener iListener) {
        this.checkOpenness();
        this.internal.unregisterListener(iListener);
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        this.checkOpenness();
        return this.internal.getRecordMetadata(rid);
    }

    public ODocument newInstance(String iClassName) {
        this.checkOpenness();
        return (ODocument)this.internal.newInstance(iClassName);
    }

    @Override
    public OBlob newBlob(byte[] bytes) {
        this.checkOpenness();
        return this.internal.newBlob(bytes);
    }

    @Override
    public OBlob newBlob() {
        return new ORecordBytes();
    }

    @Override
    public OEdge newLightweightEdge(String iClassName, OVertex from, OVertex to) {
        this.checkOpenness();
        return this.internal.newLightweightEdge(iClassName, from, to);
    }

    @Override
    public OEdge newRegularEdge(String iClassName, OVertex from, OVertex to) {
        this.checkOpenness();
        return this.internal.newRegularEdge(iClassName, from, to);
    }

    @Override
    public long countClass(String iClassName) {
        this.checkOpenness();
        return this.internal.countClass(iClassName);
    }

    @Override
    public long countClass(String iClassName, boolean iPolymorphic) {
        this.checkOpenness();
        return this.internal.countClass(iClassName, iPolymorphic);
    }

    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        this.checkOpenness();
        return this.internal.backup(out, options, callable, iListener, compressionLevel, bufferSize);
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        this.checkOpenness();
        this.internal.restore(in, options, callable, iListener);
    }

    @Override
    public void setSerializer(ORecordSerializer serializer) {
        if (this.internal != null) {
            ((ODatabaseDocumentAbstract)this.internal).setSerializer(serializer);
        } else {
            this.serializer = serializer;
        }
    }

    @Override
    public OResultSet query(String query, Object ... args) {
        this.checkOpenness();
        return this.internal.query(query, args);
    }

    @Override
    public OResultSet query(String query, Map args) throws OCommandSQLParsingException, OCommandExecutionException {
        this.checkOpenness();
        return this.internal.query(query, args);
    }

    private OrientDBConfig buildConfig(Map<OGlobalConfiguration, Object> iProperties) {
        String encryptionKey;
        String encryptionMethod;
        String compressionMethod;
        String connectionStrategy;
        HashMap<String, Object> pars = new HashMap<String, Object>(this.preopenProperties);
        if (iProperties != null) {
            for (Map.Entry<OGlobalConfiguration, Object> par : iProperties.entrySet()) {
                pars.put(par.getKey().getKey(), par.getValue());
            }
        }
        OrientDBConfigBuilder builder = OrientDBConfig.builder();
        String string = connectionStrategy = pars != null ? (String)pars.get("connectionStrategy") : null;
        if (connectionStrategy != null) {
            builder.addConfig(OGlobalConfiguration.CLIENT_CONNECTION_STRATEGY, connectionStrategy);
        }
        String string2 = compressionMethod = pars != null ? (String)pars.get(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getKey()) : null;
        if (compressionMethod != null) {
            builder.addConfig(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, compressionMethod);
        }
        String string3 = encryptionMethod = pars != null ? (String)pars.get(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD.getKey()) : null;
        if (encryptionMethod != null) {
            builder.addConfig(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, encryptionMethod);
        }
        String string4 = encryptionKey = pars != null ? (String)pars.get(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getKey()) : null;
        if (encryptionKey != null) {
            builder.addConfig(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, encryptionKey);
        }
        for (Map.Entry<ODatabase.ATTRIBUTES, Object> attr : this.preopenAttributes.entrySet()) {
            builder.addAttribute(attr.getKey(), attr.getValue());
        }
        for (ODatabaseListener oDatabaseListener : this.preopenListener) {
            builder.addListener(oDatabaseListener);
        }
        return builder.build();
    }

    @Override
    public OResultSet command(String query, Object ... args) throws OCommandSQLParsingException, OCommandExecutionException {
        this.checkOpenness();
        return this.internal.command(query, args);
    }

    @Override
    public OResultSet command(String query, Map args) throws OCommandSQLParsingException, OCommandExecutionException {
        this.checkOpenness();
        return this.internal.command(query, args);
    }

    @Override
    public <DB extends ODatabase> DB setCustom(String name, Object iValue) {
        return this.internal.setCustom(name, iValue);
    }

    @Override
    public void callOnDropListeners() {
        this.checkOpenness();
        this.internal.callOnDropListeners();
    }

    @Override
    public boolean isPrefetchRecords() {
        this.checkOpenness();
        return this.internal.isPrefetchRecords();
    }

    @Override
    public void setPrefetchRecords(boolean prefetchRecords) {
        this.checkOpenness();
        this.internal.setPrefetchRecords(prefetchRecords);
    }

    @Override
    public void checkForClusterPermissions(String name) {
        this.checkOpenness();
        this.internal.checkForClusterPermissions(name);
    }

    @Override
    public OResultSet execute(String language, String script, Object ... args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        return this.internal.execute(language, script, args);
    }

    @Override
    public OResultSet execute(String language, String script, Map<String, ?> args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        return this.internal.execute(language, script, args);
    }

    @Override
    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Object ... args) {
        this.checkOpenness();
        return this.internal.live(query, listener, args);
    }

    @Override
    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Map<String, ?> args) {
        this.checkOpenness();
        return this.internal.live(query, listener, args);
    }

    @Override
    public void recycle(ORecord record) {
        this.checkOpenness();
        this.internal.recycle(record);
    }

    @Override
    public void internalCommit(OTransactionInternal transaction) {
        this.internal.internalCommit(transaction);
    }

    @Override
    public boolean isClusterVertex(int cluster) {
        this.checkOpenness();
        return this.internal.isClusterVertex(cluster);
    }

    @Override
    public boolean isClusterEdge(int cluster) {
        this.checkOpenness();
        return this.internal.isClusterEdge(cluster);
    }

    @Override
    public OIdentifiable beforeCreateOperations(OIdentifiable id, String iClusterName) {
        return this.internal.beforeCreateOperations(id, iClusterName);
    }

    @Override
    public OIdentifiable beforeUpdateOperations(OIdentifiable id, String iClusterName) {
        return this.internal.beforeUpdateOperations(id, iClusterName);
    }

    @Override
    public void beforeDeleteOperations(OIdentifiable id, String iClusterName) {
        this.internal.beforeDeleteOperations(id, iClusterName);
    }

    @Override
    public void afterCreateOperations(OIdentifiable id) {
        this.internal.afterCreateOperations(id);
    }

    @Override
    public void afterDeleteOperations(OIdentifiable id) {
        this.internal.afterDeleteOperations(id);
    }

    @Override
    public void afterUpdateOperations(OIdentifiable id) {
        this.internal.afterUpdateOperations(id);
    }

    @Override
    public void afterReadOperations(OIdentifiable identifiable) {
        this.internal.afterReadOperations(identifiable);
    }

    @Override
    public boolean beforeReadOperations(OIdentifiable identifiable) {
        return this.internal.beforeReadOperations(identifiable);
    }

    @Override
    public void internalClose(boolean recycle) {
        this.internal.internalClose(true);
    }

    @Override
    public Map<UUID, OBonsaiCollectionPointer> getCollectionsChanges() {
        return this.internal.getCollectionsChanges();
    }

    static {
        Orient.instance().registerOrientStartupListener(() -> Orient.instance().addShutdownHandler(shutdownHandler));
        Orient.instance().addShutdownHandler(shutdownHandler);
    }
}

