/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.lang.reflect.Method;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class OClassTrigger {
    public static final String CLASSNAME = "OTriggered";
    public static final String METHOD_SEPARATOR = ".";
    public static final String ONBEFORE_CREATED = "onBeforeCreate";
    public static final String PROP_BEFORE_CREATE = "onBeforeCreate";
    public static final String ONAFTER_CREATED = "onAfterCreate";
    public static final String PROP_AFTER_CREATE = "onAfterCreate";
    public static final String ONBEFORE_READ = "onBeforeRead";
    public static final String PROP_BEFORE_READ = "onBeforeRead";
    public static final String ONAFTER_READ = "onAfterRead";
    public static final String PROP_AFTER_READ = "onAfterRead";
    public static final String ONBEFORE_UPDATED = "onBeforeUpdate";
    public static final String PROP_BEFORE_UPDATE = "onBeforeUpdate";
    public static final String ONAFTER_UPDATED = "onAfterUpdate";
    public static final String PROP_AFTER_UPDATE = "onAfterUpdate";
    public static final String ONBEFORE_DELETE = "onBeforeDelete";
    public static final String PROP_BEFORE_DELETE = "onBeforeDelete";
    public static final String ONAFTER_DELETE = "onAfterDelete";
    public static final String PROP_AFTER_DELETE = "onAfterDelete";

    public static ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument, ODatabaseDocumentInternal database) {
        Object func = OClassTrigger.checkClzAttribute(iDocument, "onBeforeCreate", database);
        if (func != null) {
            if (func instanceof OFunction) {
                return OClassTrigger.executeFunction(iDocument, (OFunction)func, database);
            }
            if (func instanceof Object[]) {
                return OClassTrigger.executeMethod(iDocument, (Object[])func);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public static void onRecordAfterCreate(ODocument iDocument, ODatabaseDocumentInternal database) {
        Object func = OClassTrigger.checkClzAttribute(iDocument, "onAfterCreate", database);
        if (func != null) {
            if (func instanceof OFunction) {
                OClassTrigger.executeFunction(iDocument, (OFunction)func, database);
            } else if (func instanceof Object[]) {
                OClassTrigger.executeMethod(iDocument, (Object[])func);
            }
        }
    }

    public static ORecordHook.RESULT onRecordBeforeRead(ODocument iDocument, ODatabaseDocumentInternal database) {
        Object func = OClassTrigger.checkClzAttribute(iDocument, "onBeforeRead", database);
        if (func != null) {
            if (func instanceof OFunction) {
                return OClassTrigger.executeFunction(iDocument, (OFunction)func, database);
            }
            if (func instanceof Object[]) {
                return OClassTrigger.executeMethod(iDocument, (Object[])func);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public static void onRecordAfterRead(ODocument iDocument, ODatabaseDocumentInternal database) {
        Object func = OClassTrigger.checkClzAttribute(iDocument, "onAfterRead", database);
        if (func != null) {
            if (func instanceof OFunction) {
                OClassTrigger.executeFunction(iDocument, (OFunction)func, database);
            } else if (func instanceof Object[]) {
                OClassTrigger.executeMethod(iDocument, (Object[])func);
            }
        }
    }

    public static ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument, ODatabaseDocumentInternal database) {
        Object func = OClassTrigger.checkClzAttribute(iDocument, "onBeforeUpdate", database);
        if (func != null) {
            if (func instanceof OFunction) {
                return OClassTrigger.executeFunction(iDocument, (OFunction)func, database);
            }
            if (func instanceof Object[]) {
                return OClassTrigger.executeMethod(iDocument, (Object[])func);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public static void onRecordAfterUpdate(ODocument iDocument, ODatabaseDocumentInternal database) {
        Object func = OClassTrigger.checkClzAttribute(iDocument, "onAfterUpdate", database);
        if (func != null) {
            if (func instanceof OFunction) {
                OClassTrigger.executeFunction(iDocument, (OFunction)func, database);
            } else if (func instanceof Object[]) {
                OClassTrigger.executeMethod(iDocument, (Object[])func);
            }
        }
    }

    public static ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument, ODatabaseDocumentInternal database) {
        Object func = OClassTrigger.checkClzAttribute(iDocument, "onBeforeDelete", database);
        if (func != null) {
            if (func instanceof OFunction) {
                return OClassTrigger.executeFunction(iDocument, (OFunction)func, database);
            }
            if (func instanceof Object[]) {
                return OClassTrigger.executeMethod(iDocument, (Object[])func);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public static void onRecordAfterDelete(ODocument iDocument, ODatabaseDocumentInternal database) {
        Object func = OClassTrigger.checkClzAttribute(iDocument, "onAfterDelete", database);
        if (func != null) {
            if (func instanceof OFunction) {
                OClassTrigger.executeFunction(iDocument, (OFunction)func, database);
            } else if (func instanceof Object[]) {
                OClassTrigger.executeMethod(iDocument, (Object[])func);
            }
        }
    }

    private static Object checkClzAttribute(ODocument iDocument, String attr, ODatabaseDocumentInternal database) {
        OImmutableClass clz = ODocumentInternal.getImmutableSchemaClass(database, iDocument);
        if (clz != null && clz.isTriggered()) {
            OFunction func = null;
            String fieldName = clz.getCustom(attr);
            for (OClass superClz = clz.getSuperClass(); !(fieldName != null && fieldName.length() != 0 || superClz == null || superClz.getName().equals(CLASSNAME)); superClz = superClz.getSuperClass()) {
                fieldName = superClz.getCustom(attr);
            }
            if (fieldName != null && fieldName.length() > 0) {
                Object[] clzMethod = OClassTrigger.checkMethod(fieldName);
                if (clzMethod != null) {
                    return clzMethod;
                }
                func = database.getMetadata().getFunctionLibrary().getFunction(fieldName);
                if (func == null && OStringSerializerHelper.contains(fieldName, ':')) {
                    try {
                        ODocument funcDoc = (ODocument)database.load(new ORecordId(fieldName));
                        if (funcDoc != null) {
                            func = database.getMetadata().getFunctionLibrary().getFunction((String)funcDoc.field("name"));
                        }
                    }
                    catch (Exception ex) {
                        OLogManager.instance().error(OClassTrigger.class, "illegal record id : ", ex, new Object[0]);
                    }
                }
            } else {
                Object funcProp = iDocument.field(attr);
                if (funcProp != null) {
                    String funcName = funcProp instanceof ODocument ? (String)((ODocument)funcProp).field("name") : funcProp.toString();
                    func = database.getMetadata().getFunctionLibrary().getFunction(funcName);
                }
            }
            return func;
        }
        return null;
    }

    private static Object[] checkMethod(String fieldName) {
        String clzName = null;
        String methodName = null;
        if (fieldName.contains(METHOD_SEPARATOR)) {
            clzName = fieldName.substring(0, fieldName.lastIndexOf(METHOD_SEPARATOR));
            methodName = fieldName.substring(fieldName.lastIndexOf(METHOD_SEPARATOR) + 1);
        }
        if (clzName == null || methodName == null) {
            return null;
        }
        try {
            Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(clzName);
            Method method = clz.getMethod(methodName, ODocument.class);
            return new Object[]{clz, method};
        }
        catch (Exception ex) {
            OLogManager.instance().error(OClassTrigger.class, "illegal class or method : " + clzName + "/" + methodName, ex, new Object[0]);
            return null;
        }
    }

    private static ORecordHook.RESULT executeMethod(ODocument iDocument, Object[] clzMethod) {
        if (clzMethod[0] instanceof Class && clzMethod[1] instanceof Method) {
            Method method = (Method)clzMethod[1];
            Class clz = (Class)clzMethod[0];
            String result = null;
            try {
                result = (String)method.invoke(clz.newInstance(), iDocument);
            }
            catch (Exception ex) {
                throw OException.wrapException(new ODatabaseException("Failed to invoke method " + method.getName()), ex);
            }
            if (result == null) {
                return ORecordHook.RESULT.RECORD_NOT_CHANGED;
            }
            return ORecordHook.RESULT.valueOf(result);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ORecordHook.RESULT executeFunction(ODocument iDocument, OFunction func, ODatabaseDocumentInternal database) {
        if (func == null) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        OScriptManager scriptManager = Orient.instance().getScriptManager();
        OPartitionedObjectPool.PoolEntry<ScriptEngine> entry = scriptManager.acquireDatabaseEngine(database.getName(), func.getLanguage());
        ScriptEngine scriptEngine = (ScriptEngine)entry.object;
        try {
            ORecordHook.RESULT rESULT;
            Bindings binding = scriptEngine.getBindings(100);
            scriptManager.bind(scriptEngine, binding, database, null, null);
            binding.put("doc", (Object)iDocument);
            String result = null;
            try {
                if (func.getLanguage() == null) {
                    throw new OConfigurationException("Database function '" + func.getName() + "' has no language");
                }
                String funcStr = scriptManager.getFunctionDefinition(func);
                if (funcStr != null) {
                    try {
                        scriptEngine.eval(funcStr);
                    }
                    catch (ScriptException e) {
                        scriptManager.throwErrorMessage(e, funcStr);
                    }
                }
                if (scriptEngine instanceof Invocable) {
                    Invocable invocableEngine = (Invocable)((Object)scriptEngine);
                    Object[] EMPTY = OCommonConst.EMPTY_OBJECT_ARRAY;
                    result = (String)invocableEngine.invokeFunction(func.getName(), EMPTY);
                }
            }
            catch (ScriptException e) {
                throw OException.wrapException(new OCommandScriptException("Error on execution of the script", func.getName(), e.getColumnNumber()), e);
            }
            catch (NoSuchMethodException e) {
                throw OException.wrapException(new OCommandScriptException("Error on execution of the script", func.getName(), 0), e);
            }
            catch (OCommandScriptException e) {
                throw e;
            }
            finally {
                scriptManager.unbind(scriptEngine, binding, null, null);
            }
            if (result == null) {
                rESULT = ORecordHook.RESULT.RECORD_NOT_CHANGED;
                return rESULT;
            }
            rESULT = ORecordHook.RESULT.valueOf(result);
            return rESULT;
        }
        finally {
            scriptManager.releaseDatabaseEngine(func.getLanguage(), database.getName(), entry);
        }
    }
}

