/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OLazyIteratorListWrapper;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordMultiValueHelper;
import com.orientechnologies.orient.core.db.record.ORecordTrackedList;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public class ORecordLazyList
extends ORecordTrackedList
implements ORecordLazyMultiValue {
    protected final byte recordType;
    protected ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
    protected boolean autoConvertToRecord = true;
    protected boolean marshalling = false;
    protected boolean ridOnly = false;

    public ORecordLazyList() {
        super((ORecord)null);
        this.recordType = (byte)100;
    }

    public ORecordLazyList(ODocument iSourceRecord) {
        super(iSourceRecord);
        if (iSourceRecord != null) {
            this.recordType = ORecordInternal.getRecordType(iSourceRecord);
            if (!iSourceRecord.isLazyLoad()) {
                this.autoConvertToRecord = false;
            }
        } else {
            this.recordType = (byte)100;
        }
    }

    public ORecordLazyList(ODocument iSourceRecord, Collection<? extends OIdentifiable> iOrigin) {
        this(iSourceRecord);
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll(iOrigin);
        }
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        Iterator<? extends OIdentifiable> it;
        Iterator<? extends OIdentifiable> iterator = it = c instanceof ORecordLazyMultiValue ? ((ORecordLazyMultiValue)((Object)c)).rawIterator() : c.iterator();
        while (it.hasNext()) {
            OIdentifiable o = it.next();
            if (o == null) {
                this.add(null);
                continue;
            }
            if (o instanceof OIdentifiable) {
                this.add(o);
                continue;
            }
            OMultiValue.add(this, o);
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        this.lazyLoad(false);
        OLazyIterator<OIdentifiable> subIterator = new OLazyIterator<OIdentifiable>(){
            private int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos < ORecordLazyList.this.size() - 1;
            }

            @Override
            public OIdentifiable next() {
                return ORecordLazyList.this.rawGet(++this.pos);
            }

            @Override
            public void remove() {
                ORecordLazyList.this.remove(this.pos);
            }

            @Override
            public OIdentifiable update(OIdentifiable iValue) {
                return ORecordLazyList.this.set(this.pos, iValue);
            }
        };
        return new OLazyRecordIterator(this.sourceRecord, (Iterator<? extends OIdentifiable>)subIterator, false);
    }

    public OIdentifiable rawGet(int index) {
        this.lazyLoad(false);
        return (OIdentifiable)super.get(index);
    }

    @Override
    public OLazyIterator<OIdentifiable> iterator() {
        this.lazyLoad(false);
        return new OLazyRecordIterator(this.sourceRecord, new OLazyIteratorListWrapper(super.listIterator()), this.autoConvertToRecord && this.getOwner().getInternalStatus() != ORecordElement.STATUS.MARSHALLING);
    }

    @Override
    public ListIterator<OIdentifiable> listIterator() {
        this.lazyLoad(false);
        return super.listIterator();
    }

    @Override
    public ListIterator<OIdentifiable> listIterator(int index) {
        this.lazyLoad(false);
        return super.listIterator(index);
    }

    @Override
    public boolean contains(Object o) {
        this.lazyLoad(false);
        return super.contains(o);
    }

    @Override
    public boolean add(OIdentifiable e) {
        if (e != null) {
            if ((this.ridOnly || this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS) && e.getIdentity().isPersistent() && e instanceof ODocument && !((ODocument)e).isDirty()) {
                e = e.getIdentity();
            } else {
                this.contentType = ORecordMultiValueHelper.updateContentType(this.contentType, e);
            }
        }
        this.lazyLoad(true);
        return super.add(e);
    }

    @Override
    public void add(int index, OIdentifiable e) {
        if (e != null) {
            ORecordInternal.track(this.sourceRecord, e);
            if ((this.ridOnly || this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS) && e.getIdentity().isPersistent() && e instanceof ODocument && !((ODocument)e).isDirty()) {
                e = e.getIdentity();
            } else {
                this.contentType = ORecordMultiValueHelper.updateContentType(this.contentType, e);
            }
        }
        this.lazyLoad(true);
        super.add(index, e);
    }

    @Override
    public OIdentifiable set(int index, OIdentifiable e) {
        this.lazyLoad(true);
        if (e != null) {
            ORecordInternal.track(this.sourceRecord, e);
            if (e != null) {
                if ((this.ridOnly || this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS) && e.getIdentity().isPersistent() && e instanceof ODocument && !((ODocument)e).isDirty()) {
                    e = e.getIdentity();
                } else {
                    this.contentType = ORecordMultiValueHelper.updateContentType(this.contentType, e);
                }
            }
        }
        return super.set(index, e);
    }

    @Override
    public OIdentifiable get(int index) {
        this.lazyLoad(false);
        if (this.autoConvertToRecord) {
            this.convertLink2Record(index);
        }
        return (OIdentifiable)super.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.lazyLoad(false);
        return super.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.lazyLoad(false);
        return super.lastIndexOf(o);
    }

    @Override
    public OIdentifiable remove(int iIndex) {
        this.lazyLoad(true);
        return (OIdentifiable)super.remove(iIndex);
    }

    @Override
    public boolean remove(Object iElement) {
        if (iElement == null) {
            return this.clearDeletedRecords();
        }
        this.lazyLoad(true);
        boolean result = super.remove(iElement);
        if (this.isEmpty()) {
            this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
        }
        return result;
    }

    @Override
    public void clear() {
        this.lazyLoad(true);
        super.clear();
        this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
    }

    @Override
    public int size() {
        this.lazyLoad(false);
        return super.size();
    }

    @Override
    public <RET> RET setDirty() {
        if (!this.marshalling) {
            return super.setDirty();
        }
        return (RET)this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (!this.marshalling) {
            super.setDirtyNoChanged();
        }
    }

    @Override
    public Object[] toArray() {
        this.convertLinks2Records();
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.lazyLoad(false);
        this.convertLinks2Records();
        return super.toArray(a);
    }

    @Override
    public void convertLinks2Records() {
        this.lazyLoad(false);
        if (this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS || !this.autoConvertToRecord) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            try {
                this.convertLink2Record(i);
                continue;
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {
                // empty catch block
            }
        }
        this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS;
    }

    @Override
    public boolean convertRecords2Links() {
        if (this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS || this.sourceRecord == null) {
            return true;
        }
        boolean allConverted = true;
        for (int i = 0; i < super.size(); ++i) {
            try {
                if (this.convertRecord2Link(i)) continue;
                allConverted = false;
                continue;
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {
                // empty catch block
            }
        }
        if (allConverted) {
            this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS;
        }
        return allConverted;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToDocument) {
        this.autoConvertToRecord = convertToDocument;
    }

    @Override
    public String toString() {
        return ORecordMultiValueHelper.toString(this);
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public ORecordLazyList copy(ODocument iSourceRecord) {
        ORecordLazyList copy = new ORecordLazyList(iSourceRecord);
        copy.contentType = this.contentType;
        copy.autoConvertToRecord = this.autoConvertToRecord;
        int tot = super.size();
        for (int i = 0; i < tot; ++i) {
            copy.add(this.rawGet(i));
        }
        return copy;
    }

    public boolean lazyLoad(boolean iInvalidateStream) {
        return true;
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }

    @Override
    public void fireCollectionChangedEvent(OMultiValueChangeEvent<Integer, OIdentifiable> event) {
        if (!this.marshalling) {
            super.fireCollectionChangedEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertLink2Record(int iIndex) {
        if (this.ridOnly || !this.autoConvertToRecord) {
            return;
        }
        OIdentifiable o = (OIdentifiable)super.get(iIndex);
        if (this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS && !o.getIdentity().isNew()) {
            return;
        }
        if (o != null && o instanceof ORecordId) {
            ORecordId rid = (ORecordId)o;
            this.marshalling = true;
            try {
                Object record = rid.getRecord();
                if (record != null) {
                    ORecordInternal.unTrack(this.sourceRecord, rid);
                    ORecordInternal.track(this.sourceRecord, record);
                }
                super.set(iIndex, record);
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {
            }
            finally {
                this.marshalling = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertRecord2Link(int iIndex) {
        if (this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS) {
            return true;
        }
        Object o = super.get(iIndex);
        if (o != null && o instanceof OIdentifiable && ((OIdentifiable)o).getIdentity().isPersistent()) {
            if (o instanceof ORecord && !((ORecord)o).isDirty()) {
                this.marshalling = true;
                try {
                    super.set(iIndex, ((ORecord)o).getIdentity());
                    boolean bl = true;
                    return bl;
                }
                catch (ORecordNotFoundException oRecordNotFoundException) {
                }
                finally {
                    this.marshalling = false;
                }
            } else if (o instanceof ORID) {
                return true;
            }
        }
        return false;
    }

    public boolean clearDeletedRecords() {
        boolean removed = false;
        Iterator it = super.iterator();
        while (it.hasNext()) {
            OIdentifiable rec = (OIdentifiable)it.next();
            if (rec instanceof ORecord || rec.getRecord() != null) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }
}

