/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ONestedValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class OTrackedList<T>
extends ArrayList<T>
implements ORecordElement,
OTrackedMultiValue<Integer, T>,
Serializable {
    protected final ORecord sourceRecord;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    protected List<OMultiValueChangeListener<Integer, T>> changeListeners = null;
    protected Class<?> genericClass;
    private final boolean embeddedCollection;

    public OTrackedList(ORecord iRecord, Collection<? extends T> iOrigin, Class<?> iGenericClass) {
        this(iRecord);
        this.genericClass = iGenericClass;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll(iOrigin);
        }
    }

    public OTrackedList(ORecord iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        this.embeddedCollection = this.getClass().equals(OTrackedList.class);
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public boolean add(T element) {
        boolean result = super.add(element);
        if (result) {
            this.addOwnerToEmbeddedDoc(element);
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Integer, T>(OMultiValueChangeEvent.OChangeType.ADD, super.size() - 1, element));
        }
        this.addNested(element);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T o : c) {
            this.add(o);
        }
        return true;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.addOwnerToEmbeddedDoc(element);
        this.addNested(element);
        this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Integer, T>(OMultiValueChangeEvent.OChangeType.ADD, index, element));
    }

    @Override
    public T set(int index, T element) {
        T oldValue = super.set(index, element);
        if (oldValue != null && !oldValue.equals(element)) {
            if (oldValue instanceof ODocument) {
                ODocumentInternal.removeOwner((ODocument)oldValue, this);
            }
            this.addOwnerToEmbeddedDoc(element);
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Integer, T>(OMultiValueChangeEvent.OChangeType.UPDATE, index, element, oldValue));
        }
        this.addNested(element);
        return oldValue;
    }

    private void addNested(T element) {
        if (element instanceof OTrackedMultiValue) {
            ((OTrackedMultiValue)element).addChangeListener(new ONestedValueChangeListener((ODocument)this.sourceRecord, this, (OTrackedMultiValue)element));
        }
    }

    private void addOwnerToEmbeddedDoc(T e) {
        if (this.embeddedCollection && e instanceof ODocument && !((ODocument)e).getIdentity().isValid()) {
            ODocumentInternal.addOwner((ODocument)e, this);
        }
        if (e instanceof ODocument) {
            ORecordInternal.track(this.sourceRecord, (ODocument)e);
        }
    }

    @Override
    public T remove(int index) {
        Object oldValue = super.remove(index);
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        this.fireCollectionChangedEvent((OMultiValueChangeEvent<Integer, T>)new OMultiValueChangeEvent<Integer, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, index, null, oldValue));
        this.removeNested(oldValue);
        return (T)oldValue;
    }

    private void removeNested(Object element) {
        if (element instanceof OTrackedMultiValue) {
            // empty if block
        }
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public void clear() {
        ArrayList origValues = this.changeListeners != null && this.changeListeners.isEmpty() ? null : new ArrayList(this);
        if (origValues == null) {
            for (Object item : this) {
                if (!(item instanceof ODocument)) continue;
                ODocumentInternal.removeOwner((ODocument)item, this);
            }
        }
        super.clear();
        if (origValues != null) {
            for (int i = origValues.size() - 1; i >= 0; --i) {
                Object origValue = origValues.get(i);
                if (origValue instanceof ODocument) {
                    ODocumentInternal.removeOwner((ODocument)origValue, this);
                }
                this.fireCollectionChangedEvent((OMultiValueChangeEvent<Integer, T>)new OMultiValueChangeEvent<Integer, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, i, null, origValue));
                this.removeNested(origValue);
            }
        } else {
            this.setDirty();
        }
    }

    public void reset() {
        super.clear();
    }

    @Override
    public <RET> RET setDirty() {
        if (!(this.status == ORecordElement.STATUS.UNMARSHALLING || this.sourceRecord == null || this.sourceRecord.isDirty() && ORecordInternal.isContentChanged(this.sourceRecord))) {
            this.sourceRecord.setDirty();
        }
        return (RET)this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<Integer, T> changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList<OMultiValueChangeListener<Integer, T>>();
        }
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<Integer, T> changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    public List<T> returnOriginalState(List<OMultiValueChangeEvent<Integer, T>> multiValueChangeEvents) {
        ArrayList<T> reverted = new ArrayList<T>(this);
        ListIterator<OMultiValueChangeEvent<Integer, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<Integer, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.add(event.getKey(), event.getOldValue());
                    continue block5;
                }
                case UPDATE: {
                    reverted.set(event.getKey(), event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public void fireCollectionChangedEvent(OMultiValueChangeEvent<Integer, T> event) {
        if (this.status == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        this.setDirty();
        if (this.changeListeners != null) {
            for (OMultiValueChangeListener<Integer, T> changeListener : this.changeListeners) {
                if (changeListener == null) continue;
                changeListener.onAfterRecordChanged(event);
            }
        }
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    private Object writeReplace() {
        return new ArrayList(this);
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
        super.set((Integer)event.getKey(), newValue);
        this.addNested(newValue);
    }
}

