/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.encryption;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.encryption.impl.OAESEncryption;
import com.orientechnologies.orient.core.encryption.impl.OAESGCMEncryption;
import com.orientechnologies.orient.core.encryption.impl.ODESEncryption;
import com.orientechnologies.orient.core.encryption.impl.ONothingEncryption;
import com.orientechnologies.orient.core.exception.OSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OEncryptionFactory {
    public static final OEncryptionFactory INSTANCE = new OEncryptionFactory();
    private final Map<String, OEncryption> instances = new HashMap<String, OEncryption>();
    private final Map<String, Class<? extends OEncryption>> classes = new HashMap<String, Class<? extends OEncryption>>();

    public OEncryptionFactory() {
        this.register(ONothingEncryption.class);
        this.register(ODESEncryption.class);
        this.register(OAESEncryption.class);
        this.register(OAESGCMEncryption.class);
    }

    public OEncryption getEncryption(String name, String iOptions) {
        OEncryption encryption = this.instances.get(name);
        if (encryption == null) {
            Class encryptionClass = name == null ? ONothingEncryption.class : this.classes.get(name);
            if (encryptionClass != null) {
                try {
                    encryption = (OEncryption)encryptionClass.newInstance();
                    encryption.configure(iOptions);
                }
                catch (Exception e) {
                    throw OException.wrapException(new OSecurityException("Cannot instantiate encryption algorithm '" + name + "'"), e);
                }
            } else {
                throw new OSecurityException("Encryption with name '" + name + "' is absent");
            }
        }
        return encryption;
    }

    public void register(OEncryption iEncryption) {
        try {
            String name = iEncryption.name();
            if (this.instances.containsKey(name)) {
                throw new IllegalArgumentException("Encryption with name '" + name + "' was already registered");
            }
            if (this.classes.containsKey(name)) {
                throw new IllegalArgumentException("Encryption with name '" + name + "' was already registered");
            }
            this.instances.put(name, iEncryption);
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Cannot register storage encryption algorithm '%s'", e, iEncryption);
        }
    }

    public void register(Class<? extends OEncryption> iEncryption) {
        try {
            OEncryption tempInstance = iEncryption.newInstance();
            String name = tempInstance.name();
            if (this.instances.containsKey(name)) {
                throw new IllegalArgumentException("Encryption with name '" + name + "' was already registered");
            }
            if (this.classes.containsKey(tempInstance.name())) {
                throw new IllegalArgumentException("Encryption with name '" + name + "' was already registered");
            }
            this.classes.put(name, iEncryption);
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Cannot register storage encryption algorithm '%s'", e, iEncryption);
        }
    }

    public Set<String> getInstances() {
        return this.instances.keySet();
    }
}

