/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OMixedIndexRIDContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class OIndexFullText
extends OIndexMultiValues {
    private static final String CONFIG_STOP_WORDS = "stopWords";
    private static final String CONFIG_SEPARATOR_CHARS = "separatorChars";
    private static final String CONFIG_IGNORE_CHARS = "ignoreChars";
    private static final String CONFIG_INDEX_RADIX = "indexRadix";
    private static final String CONFIG_MIN_WORD_LEN = "minWordLength";
    private static final boolean DEF_INDEX_RADIX = true;
    private static final String DEF_SEPARATOR_CHARS = " \r\n\t:;,.|+*/\\=!?[]()";
    private static final String DEF_IGNORE_CHARS = "'\"";
    private static final String DEF_STOP_WORDS = "the in a at as and or for his her him this that what which while up with be was were is";
    private boolean indexRadix;
    private String separatorChars;
    private String ignoreChars;
    private int minWordLength;
    private Set<String> stopWords;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexFullText(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        this.acquireExclusiveLock();
        try {
            this.config();
            this.configWithMetadata(metadata);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexFullText put(Object key, OIdentifiable singleValue) {
        if (key == null) {
            return this;
        }
        key = this.getCollatingValue(key);
        Set<String> words = this.splitIntoWords(key.toString());
        for (String word : words) {
            this.acquireSharedLock();
            try {
                if (this.apiVersion == 0) {
                    this.doPutV0(singleValue, word);
                    continue;
                }
                if (this.apiVersion == 1) {
                    this.doPutV1(singleValue, word);
                    continue;
                }
                throw new IllegalStateException("Invalid API version, " + this.apiVersion);
            }
            finally {
                this.releaseSharedLock();
            }
        }
        return this;
    }

    private void doPutV0(OIdentifiable singleValue, String word) {
        Set refs;
        while (true) {
            try {
                refs = (Set)this.storage.getIndexValue(this.indexId, word);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        Set refsc = refs;
        while (true) {
            try {
                this.storage.updateIndexEntry(this.indexId, word, (oldValue, bonsayFileId) -> {
                    Set<OIdentifiable> result;
                    if (refsc == null) {
                        if (!"SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) throw new IllegalStateException("MBRBTreeContainer is not supported any more");
                        result = this.binaryFormatVersion >= 13 ? new OMixedIndexRIDContainer(this.getName(), bonsayFileId) : new OIndexRIDContainer(this.getName(), true, bonsayFileId);
                    } else {
                        result = refsc;
                    }
                    result.add(singleValue);
                    return OIndexUpdateAction.changed(result);
                });
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    private void doPutV1(OIdentifiable singleValue, String word) {
        while (true) {
            try {
                this.storage.putRidIndexEntry(this.indexId, word, singleValue.getIdentity());
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isNativeTxSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        if (key == null) {
            return false;
        }
        key = this.getCollatingValue(key);
        Set<String> words = this.splitIntoWords(key.toString());
        OModifiableBoolean removed = new OModifiableBoolean(false);
        for (String word : words) {
            this.acquireSharedLock();
            try {
                if (this.apiVersion == 0) {
                    this.removeV0(value, removed, word);
                    continue;
                }
                if (this.apiVersion == 1) {
                    this.removeV1(value, removed, word);
                    continue;
                }
                throw new IllegalStateException("Invalid API version, " + this.apiVersion);
            }
            finally {
                this.releaseSharedLock();
            }
        }
        return removed.getValue();
    }

    private void removeV0(OIdentifiable value, OModifiableBoolean removed, String word) {
        Set recs;
        while (true) {
            try {
                recs = (Set)this.storage.getIndexValue(this.indexId, word);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
        if (recs != null && !recs.isEmpty()) {
            while (true) {
                try {
                    this.storage.updateIndexEntry(this.indexId, word, new EntityRemover(value, removed));
                }
                catch (OInvalidIndexEngineIdException ignore) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
    }

    private void removeV1(OIdentifiable value, OModifiableBoolean removed, String word) {
        while (true) {
            try {
                boolean rm = this.storage.removeRidIndexEntry(this.indexId, word, value.getIdentity());
                removed.setValue(rm);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    @Override
    public OIndexInternal<?> create(OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener, OBinarySerializer valueSerializer) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(this.type + " indexes cannot be used as composite ones.");
        }
        return super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, valueSerializer);
    }

    @Override
    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(this.type + " indexes cannot be used as composite ones.");
        }
        return super.create(name, indexDefinition, clusterIndexName, (Set)clustersToIndex, rebuild, progressListener);
    }

    @Override
    public ODocument updateConfiguration() {
        super.updateConfiguration();
        return ((FullTextIndexConfiguration)this.configuration).updateFullTextIndexConfiguration(this.separatorChars, this.ignoreChars, this.stopWords, this.minWordLength, this.indexRadix);
    }

    @Override
    protected OIndexAbstract.IndexConfiguration indexConfigurationInstance(ODocument document) {
        return new FullTextIndexConfiguration(document);
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return false;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    private void configWithMetadata(ODocument metadata) {
        if (metadata != null) {
            if (metadata.containsField(CONFIG_IGNORE_CHARS)) {
                this.ignoreChars = (String)metadata.field(CONFIG_IGNORE_CHARS);
            }
            if (metadata.containsField(CONFIG_INDEX_RADIX)) {
                this.indexRadix = (Boolean)metadata.field(CONFIG_INDEX_RADIX);
            }
            if (metadata.containsField(CONFIG_SEPARATOR_CHARS)) {
                this.separatorChars = (String)metadata.field(CONFIG_SEPARATOR_CHARS);
            }
            if (metadata.containsField(CONFIG_MIN_WORD_LEN)) {
                this.minWordLength = (Integer)metadata.field(CONFIG_MIN_WORD_LEN);
            }
            if (metadata.containsField(CONFIG_STOP_WORDS)) {
                this.stopWords = new HashSet<String>((Collection)metadata.field(CONFIG_STOP_WORDS));
            }
        }
    }

    private void config() {
        this.ignoreChars = DEF_IGNORE_CHARS;
        this.indexRadix = true;
        this.separatorChars = DEF_SEPARATOR_CHARS;
        this.minWordLength = 3;
        this.stopWords = new HashSet<String>(OStringSerializerHelper.split(DEF_STOP_WORDS, ' ', new char[0]));
    }

    private Set<String> splitIntoWords(String iKey) {
        HashSet<String> result = new HashSet<String>();
        ArrayList<String> words = new ArrayList<String>();
        OStringSerializerHelper.split(words, iKey, 0, -1, this.separatorChars, new char[0]);
        StringBuilder buffer = new StringBuilder(64);
        block0: for (String word : words) {
            buffer.setLength(0);
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                boolean ignore = false;
                for (int k = 0; k < this.ignoreChars.length(); ++k) {
                    if (c != this.ignoreChars.charAt(k)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                buffer.append(c);
            }
            for (int length = buffer.length(); length >= this.minWordLength; --length) {
                buffer.setLength(length);
                word = buffer.toString();
                if (!this.stopWords.contains(word)) {
                    result.add(word);
                }
                if (!this.indexRadix) continue block0;
            }
        }
        return result;
    }

    private final class FullTextIndexConfiguration
    extends OIndexAbstract.IndexConfiguration {
        FullTextIndexConfiguration(ODocument document) {
            super(document);
        }

        synchronized ODocument updateFullTextIndexConfiguration(String separatorChars, String ignoreChars, Set<String> stopWords, int minWordLength, boolean indexRadix) {
            this.document.field(OIndexFullText.CONFIG_SEPARATOR_CHARS, separatorChars);
            this.document.field(OIndexFullText.CONFIG_IGNORE_CHARS, ignoreChars);
            this.document.field(OIndexFullText.CONFIG_STOP_WORDS, stopWords);
            this.document.field(OIndexFullText.CONFIG_MIN_WORD_LEN, minWordLength);
            this.document.field(OIndexFullText.CONFIG_INDEX_RADIX, indexRadix);
            return this.document;
        }
    }

    private static class EntityRemover
    implements OIndexKeyUpdater<Object> {
        private final OIdentifiable value;
        private final OModifiableBoolean removed;

        private EntityRemover(OIdentifiable value, OModifiableBoolean removed) {
            this.value = value;
            this.removed = removed;
        }

        @Override
        public OIndexUpdateAction<Object> update(Object old, AtomicLong bonsayFileId) {
            Set recs = (Set)old;
            if (recs.remove(this.value)) {
                this.removed.setValue(true);
                if (recs.isEmpty()) {
                    return OIndexUpdateAction.remove();
                }
                return OIndexUpdateAction.changed(recs);
            }
            return OIndexUpdateAction.changed(recs);
        }
    }
}

