/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine.v1;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OSingleValueIndexEngine;
import com.orientechnologies.orient.core.index.engine.v1.OCellBTreeIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.OCellBTreeSingleValue;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class OCellBTreeSingleValueIndexEngine
implements OSingleValueIndexEngine,
OCellBTreeIndexEngine {
    private static final String DATA_FILE_EXTENSION = ".cbt";
    private static final String NULL_BUCKET_FILE_EXTENSION = ".nbt";
    private final OCellBTreeSingleValue<Object> sbTree;
    private final String name;

    public OCellBTreeSingleValueIndexEngine(String name, OAbstractPaginatedStorage storage) {
        this.name = name;
        this.sbTree = new OCellBTreeSingleValue(name, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    @Override
    public void flush() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Set<String> clustersToIndex, Map<String, String> engineProperties, ODocument metadata, OEncryption encryption) {
        this.sbTree.create(atomicOperation, keySerializer, keyTypes, keySize, encryption);
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        this.sbTree.delete(atomicOperation);
    }

    @Override
    public void deleteWithoutLoad(OAtomicOperation atomicOperation, String indexName) {
        this.sbTree.deleteWithoutLoad(atomicOperation);
    }

    @Override
    public void load(String indexName, int keySize, OType[] keyTypes, OBinarySerializer keySerializer, OEncryption encryption) {
        this.sbTree.load(indexName, keySize, keyTypes, keySerializer, encryption);
    }

    @Override
    public boolean contains(Object key) {
        return this.sbTree.get(key) != null;
    }

    @Override
    public boolean remove(OAtomicOperation atomicOperation, Object key) {
        return this.sbTree.remove(atomicOperation, key) != null;
    }

    @Override
    public void clear(OAtomicOperation atomicOperation) {
        this.sbTree.clear(atomicOperation);
    }

    @Override
    public void close() {
        this.sbTree.close();
    }

    @Override
    public ORID get(Object key) {
        return this.sbTree.get(key);
    }

    @Override
    public OIndexCursor cursor(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        Object firstKey = this.sbTree.firstKey();
        if (firstKey == null) {
            return new NullCursor();
        }
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesMajor(firstKey, true, true), valuesTransformer);
    }

    @Override
    public OIndexCursor descCursor(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        Object lastKey = this.sbTree.lastKey();
        if (lastKey == null) {
            return new NullCursor();
        }
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesMinor(lastKey, true, false), valuesTransformer);
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return new OIndexKeyCursor(){
            private final OCellBTreeSingleValue.OSBTreeKeyCursor<Object> sbTreeKeyCursor;
            {
                this.sbTreeKeyCursor = OCellBTreeSingleValueIndexEngine.this.sbTree.keyCursor();
            }

            @Override
            public Object next(int prefetchSize) {
                return this.sbTreeKeyCursor.next(prefetchSize);
            }
        };
    }

    @Override
    public void put(OAtomicOperation atomicOperation, Object key, ORID value) {
        this.sbTree.put(atomicOperation, key, value);
    }

    @Override
    public boolean validatedPut(Object key, OAtomicOperation atomicOperation, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) {
        return this.sbTree.validatedPut(atomicOperation, key, value, validator);
    }

    @Override
    public Object getFirstKey() {
        return this.sbTree.firstKey();
    }

    @Override
    public Object getLastKey() {
        return this.sbTree.lastKey();
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder), transformer);
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder), transformer);
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.sbTree.iterateEntriesMinor(toKey, isInclusive, ascSortOrder), transformer);
    }

    @Override
    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        if (transformer == null) {
            return this.sbTree.size();
        }
        int counter = 0;
        ORID nullValue = this.sbTree.get(null);
        if (nullValue != null) {
            counter += transformer.transformFromValue(nullValue).size();
        }
        Object firstKey = this.sbTree.firstKey();
        Object lastKey = this.sbTree.lastKey();
        if (firstKey != null && lastKey != null) {
            OCellBTreeSingleValue.OSBTreeCursor<Object, ORID> cursor = this.sbTree.iterateEntriesBetween(firstKey, true, lastKey, true, true);
            Map.Entry<Object, ORID> entry = cursor.next(-1);
            while (entry != null) {
                counter += transformer.transformFromValue(entry.getValue()).size();
                entry = cursor.next(-1);
            }
            return counter;
        }
        return counter;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.sbTree.acquireAtomicExclusiveLock();
        return true;
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.name;
    }

    private static class NullCursor
    extends OIndexAbstractCursor {
        private NullCursor() {
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            return null;
        }
    }

    private static final class OSBTreeIndexCursor
    extends OIndexAbstractCursor {
        private final OCellBTreeSingleValue.OSBTreeCursor<Object, ORID> treeCursor;
        private final OBaseIndexEngine.ValuesTransformer valuesTransformer;
        private Iterator<ORID> currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
        private Object currentKey = null;

        private OSBTreeIndexCursor(OCellBTreeSingleValue.OSBTreeCursor<Object, ORID> treeCursor, OBaseIndexEngine.ValuesTransformer valuesTransformer) {
            this.treeCursor = treeCursor;
            this.valuesTransformer = valuesTransformer;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.valuesTransformer == null) {
                Map.Entry<Object, OIdentifiable> entry = this.treeCursor.next(this.getPrefetchSize());
                return entry;
            }
            if (this.currentIterator == null) {
                return null;
            }
            while (!this.currentIterator.hasNext()) {
                Map.Entry<Object, ORID> p = this.treeCursor.next(this.getPrefetchSize());
                Map.Entry<Object, ORID> entry = p;
                if (entry == null) {
                    this.currentIterator = null;
                    return null;
                }
                this.currentKey = entry.getKey();
                this.currentIterator = this.valuesTransformer.transformFromValue(entry.getValue()).iterator();
            }
            final OIdentifiable value = this.currentIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){

                @Override
                public Object getKey() {
                    return currentKey;
                }

                @Override
                public OIdentifiable getValue() {
                    return value;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value2) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }
}

