/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.function;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.script.OCommandExecutorFunction;
import com.orientechnologies.orient.core.command.script.OCommandFunction;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.function.OFunctionDuplicatedException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class OFunctionLibraryImpl {
    public static final String CLASSNAME = "OFunction";
    protected final Map<String, OFunction> functions = new ConcurrentHashMap<String, OFunction>();
    private AtomicBoolean needReload = new AtomicBoolean(false);

    public void create(ODatabaseDocumentInternal db) {
        this.init(db);
    }

    public void load() {
        throw new UnsupportedOperationException();
    }

    public void load(ODatabaseDocumentInternal db) {
        HashMap<String, OCallable<Object, Map<Object, Object>>> callbacks = new HashMap<String, OCallable<Object, Map<Object, Object>>>();
        for (Map.Entry<String, OFunction> entry : this.functions.entrySet()) {
            if (entry.getValue().getCallback() == null) continue;
            callbacks.put(entry.getKey(), entry.getValue().getCallback());
        }
        this.functions.clear();
        if (db.getMetadata().getImmutableSchemaSnapshot().existsClass(CLASSNAME)) {
            try (OResultSet result = db.query("select from OFunction order by name", new Object[0]);){
                while (result.hasNext()) {
                    OResult res = result.next();
                    ODocument d = (ODocument)res.getElement().get();
                    if (d.fields() == 0) continue;
                    OFunction f = new OFunction(d);
                    f.setCallback((OCallable)callbacks.get(f.getName()));
                    this.functions.put(d.field("name").toString().toUpperCase(Locale.ENGLISH), f);
                }
            }
        }
    }

    public void droppedFunction(ODocument function) {
        this.functions.remove(function.field("name").toString());
        this.onFunctionsChanged(ODatabaseRecordThreadLocal.instance().get());
    }

    public void createdFunction(ODocument function) {
        ODocument metadataCopy = function.copy();
        OFunction f = new OFunction(metadataCopy);
        this.functions.put(metadataCopy.field("name").toString().toUpperCase(Locale.ENGLISH), f);
        this.onFunctionsChanged(ODatabaseRecordThreadLocal.instance().get());
    }

    public Set<String> getFunctionNames() {
        return Collections.unmodifiableSet(this.functions.keySet());
    }

    public OFunction getFunction(String iName) {
        this.reloadIfNeeded(ODatabaseRecordThreadLocal.instance().get());
        return this.functions.get(iName.toUpperCase(Locale.ENGLISH));
    }

    public OFunction createFunction(String iName) {
        throw new UnsupportedOperationException("Use Create function with database on internal api");
    }

    public synchronized OFunction createFunction(ODatabaseDocumentInternal database, String iName) {
        this.init(database);
        this.reloadIfNeeded(ODatabaseRecordThreadLocal.instance().get());
        OFunction f = new OFunction().setName(iName);
        try {
            f.save();
        }
        catch (ORecordDuplicatedException ex) {
            OLogManager.instance().error(this, "Exception is suppressed, original exception is ", ex, new Object[0]);
            throw OException.wrapException(new OFunctionDuplicatedException("Function with name '" + iName + "' already exist"), null);
        }
        this.functions.put(iName.toUpperCase(Locale.ENGLISH), f);
        return f;
    }

    public void close() {
        this.functions.clear();
    }

    protected void init(ODatabaseDocument db) {
        if (db.getMetadata().getSchema().existsClass(CLASSNAME)) {
            OClass f = db.getMetadata().getSchema().getClass(CLASSNAME);
            OProperty prop = f.getProperty("name");
            if (prop.getAllIndexes().isEmpty()) {
                prop.createIndex(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX);
            }
            return;
        }
        OClass f = db.getMetadata().getSchema().createClass(CLASSNAME);
        OProperty prop = f.createProperty("name", OType.STRING, (OType)null, true);
        prop.createIndex(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX);
        f.createProperty("code", OType.STRING, (OType)null, true);
        f.createProperty("language", OType.STRING, (OType)null, true);
        f.createProperty("idempotent", OType.BOOLEAN, (OType)null, true);
        f.createProperty("parameters", OType.EMBEDDEDLIST, OType.STRING, true);
    }

    public synchronized void dropFunction(OFunction function) {
        this.reloadIfNeeded(ODatabaseRecordThreadLocal.instance().get());
        String name = function.getName();
        ODocument doc = function.getDocument();
        doc.delete();
        this.functions.remove(name.toUpperCase(Locale.ENGLISH));
    }

    public synchronized void dropFunction(String iName) {
        this.reloadIfNeeded(ODatabaseRecordThreadLocal.instance().get());
        OFunction function = this.getFunction(iName);
        ODocument doc = function.getDocument();
        doc.delete();
        this.functions.remove(iName.toUpperCase(Locale.ENGLISH));
    }

    public void updatedFunction(ODocument function) {
        this.reloadIfNeeded(ODatabaseRecordThreadLocal.instance().get());
        try {
            String oldName = (String)function.getOriginalValue("name");
            if (oldName != null) {
                this.functions.remove(oldName.toUpperCase(Locale.ENGLISH));
            }
        }
        catch (Exception oldName) {
            // empty catch block
        }
        ODocument metadataCopy = function.copy();
        OCallable<Object, Map<Object, Object>> callBack = null;
        OFunction oldFunction = this.functions.get(metadataCopy.field("name").toString());
        if (oldFunction != null) {
            callBack = oldFunction.getCallback();
        }
        OFunction f = new OFunction(metadataCopy);
        if (callBack != null) {
            f.setCallback(callBack);
        }
        this.functions.put(metadataCopy.field("name").toString().toUpperCase(Locale.ENGLISH), f);
    }

    private void reloadIfNeeded(ODatabaseDocumentInternal database) {
        if (this.needReload.get()) {
            this.load(database);
            this.needReload.set(false);
        }
    }

    private void onFunctionsChanged(ODatabaseDocumentInternal database) {
        for (OMetadataUpdateListener listener : database.getSharedContext().browseListeners()) {
            listener.onFunctionLibraryUpdate(database.getName());
        }
    }

    public synchronized void update() {
        this.needReload.set(true);
    }

    public static void validateFunctionRecord(ODocument doc) throws ODatabaseException {
        String name = (String)doc.getProperty("name");
        if (!Pattern.compile("[A-Za-z][A-Za-z0-9_]*").matcher(name).matches()) {
            throw new ODatabaseException("Invalid function name: " + name);
        }
    }

    static {
        OCommandManager.instance().registerExecutor(OCommandFunction.class, OCommandExecutorFunction.class);
    }
}

