/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.concurrent.Callable;

public class OSequenceCached
extends OSequence {
    private static final String FIELD_CACHE = "cache";
    private long cacheStart = 0L;
    private long cacheEnd = 0L;

    public OSequenceCached() {
    }

    public OSequenceCached(ODocument iDocument) {
        super(iDocument);
    }

    public OSequenceCached(ODocument iDocument, OSequence.CreateParams params) {
        super(iDocument, params);
    }

    @Override
    public synchronized boolean updateParams(OSequence.CreateParams params) {
        boolean any = super.updateParams(params);
        if (params.cacheSize != null && this.getCacheSize() != params.cacheSize.intValue()) {
            this.setCacheSize(params.cacheSize);
            any = true;
        }
        return any;
    }

    @Override
    protected void initSequence(OSequence.CreateParams params) {
        super.initSequence(params);
        this.setCacheSize(params.cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() {
        ODatabaseDocumentInternal mainDb = this.getDatabase();
        boolean tx = mainDb.getTransaction().isActive();
        try {
            long l;
            block9: {
                ODatabaseDocumentInternal db = mainDb;
                if (tx) {
                    db = mainDb.copy();
                    db.activateOnCurrentThread();
                }
                try {
                    final ODatabaseDocumentInternal finalDb = db;
                    l = this.callRetry(new Callable<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long call() throws Exception {
                            OSequenceCached oSequenceCached = OSequenceCached.this;
                            synchronized (oSequenceCached) {
                                int increment = OSequenceCached.this.getIncrement();
                                if (OSequenceCached.this.cacheStart + (long)increment >= OSequenceCached.this.cacheEnd) {
                                    OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize(), finalDb);
                                }
                                OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart + (long)increment;
                                return OSequenceCached.this.cacheStart;
                            }
                        }
                    }, "next");
                    if (!tx) break block9;
                }
                catch (Throwable throwable) {
                    if (tx) {
                        db.close();
                    }
                    throw throwable;
                }
                db.close();
            }
            return l;
        }
        finally {
            if (tx) {
                mainDb.activateOnCurrentThread();
            }
        }
    }

    @Override
    public synchronized long current() {
        return this.cacheStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reset() {
        ODatabaseDocumentInternal mainDb = this.getDatabase();
        boolean tx = mainDb.getTransaction().isActive();
        try {
            long l;
            block9: {
                ODatabaseDocumentInternal db = mainDb;
                if (tx) {
                    db = mainDb.copy();
                    db.activateOnCurrentThread();
                }
                try {
                    final ODatabaseDocumentInternal finalDb = db;
                    l = this.callRetry(new Callable<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long call() throws Exception {
                            OSequenceCached oSequenceCached = OSequenceCached.this;
                            synchronized (oSequenceCached) {
                                long newValue = OSequenceCached.this.getStart();
                                OSequenceCached.this.setValue(newValue);
                                OSequenceCached.this.save(finalDb);
                                OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize(), finalDb);
                                return newValue;
                            }
                        }
                    }, "reset");
                    if (!tx) break block9;
                }
                catch (Throwable throwable) {
                    if (tx) {
                        db.close();
                    }
                    throw throwable;
                }
                db.close();
            }
            return l;
        }
        finally {
            if (tx) {
                mainDb.activateOnCurrentThread();
            }
        }
    }

    @Override
    public OSequence.SEQUENCE_TYPE getSequenceType() {
        return OSequence.SEQUENCE_TYPE.CACHED;
    }

    public int getCacheSize() {
        return (Integer)this.getDocument().field(FIELD_CACHE, OType.INTEGER);
    }

    public void setCacheSize(int cacheSize) {
        this.getDocument().field(FIELD_CACHE, cacheSize);
    }

    private void allocateCache(int cacheSize, ODatabaseDocumentInternal db) {
        long value = this.getValue();
        long newValue = value + (long)(this.getIncrement() * cacheSize);
        this.setValue(newValue);
        this.save(db);
        this.cacheStart = value;
        this.cacheEnd = newValue - 1L;
    }
}

