/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.executor.ORidSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OJSONReader {
    public static final char NEW_LINE = '\n';
    public static final char[] DEFAULT_JUMP = new char[]{' ', '\r', '\n', '\t'};
    public static final char[] DEFAULT_SKIP = new char[]{'\r', '\n', '\t'};
    public static final char[] BEGIN_OBJECT = new char[]{'{'};
    public static final char[] END_OBJECT = new char[]{'}'};
    public static final char[] FIELD_ASSIGNMENT = new char[]{':'};
    public static final char[] BEGIN_STRING = new char[]{'\"'};
    public static final char[] COMMA_SEPARATOR = new char[]{','};
    public static final char[] NEXT_IN_OBJECT = new char[]{',', '}'};
    public static final char[] NEXT_IN_ARRAY = new char[]{',', ']'};
    public static final char[] NEXT_OBJ_IN_ARRAY = new char[]{'{', ']'};
    public static final char[] ANY_NUMBER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] BEGIN_COLLECTION = new char[]{'['};
    public static final char[] END_COLLECTION = new char[]{']'};
    private BufferedReader in;
    private int cursor = 0;
    private int lineNumber = 0;
    private int columnNumber = 0;
    private StringBuilder buffer = new StringBuilder(16384);
    private String value;
    private char c;
    private char lastCharacter;
    private Character missedChar;

    public OJSONReader(Reader iIn) {
        this.in = new BufferedReader(iIn);
    }

    public int getCursor() {
        return this.cursor;
    }

    public OJSONReader checkContent(String iExpected) throws ParseException {
        if (!this.value.equals(iExpected)) {
            throw new ParseException("Expected content is " + iExpected + " but found " + this.value, this.cursor);
        }
        return this;
    }

    public boolean isContent(String iExpected) {
        return this.value.equals(iExpected);
    }

    public int readInteger(char[] iUntil) throws IOException, ParseException {
        return this.readNumber(iUntil, false);
    }

    public int readNumber(char[] iUntil, boolean iInclude) throws IOException, ParseException {
        if (this.readNext(iUntil, iInclude) == null) {
            throw new ParseException("Expected integer", this.cursor);
        }
        return Integer.parseInt(this.value.trim());
    }

    public String readString(char[] iUntil) throws IOException, ParseException {
        return this.readString(iUntil, false);
    }

    public String readString(char[] iUntil, boolean iInclude) throws IOException, ParseException {
        return this.readString(iUntil, iInclude, DEFAULT_JUMP, null);
    }

    public String readString(char[] iUntil, boolean iInclude, char[] iJumpChars, char[] iSkipChars) throws IOException, ParseException {
        if (this.readNext(iUntil, iInclude, iJumpChars, iSkipChars) == null) {
            return null;
        }
        if (!iInclude && this.value.startsWith("\"")) {
            return this.value.substring(1, this.value.lastIndexOf("\""));
        }
        return this.value;
    }

    public String readString(char[] iUntil, boolean iInclude, char[] iJumpChars, char[] iSkipChars, boolean preserveQuotes) throws IOException, ParseException {
        if (this.readNext(iUntil, iInclude, iJumpChars, iSkipChars, preserveQuotes) == null) {
            return null;
        }
        if (!iInclude && this.value.startsWith("\"")) {
            return this.value.substring(1, this.value.lastIndexOf("\""));
        }
        return this.value;
    }

    public OPair<String, Map<String, ORidSet>> readRecordString(int maxRidbagSizeLazyImport) throws IOException, ParseException {
        Map<String, ORidSet> ridbags = this.readNextRecord(NEXT_IN_ARRAY, false, DEFAULT_JUMP, null, true, maxRidbagSizeLazyImport);
        if (ridbags == null) {
            return null;
        }
        String resultValue = this.value;
        if (this.value.startsWith("\"")) {
            resultValue = this.value.substring(1, this.value.lastIndexOf("\""));
        }
        return new OPair<String, Map<String, ORidSet>>(resultValue, ridbags);
    }

    public boolean readBoolean(char[] nextInObject) throws IOException, ParseException {
        return Boolean.parseBoolean(this.readString(nextInObject, false, DEFAULT_JUMP, DEFAULT_JUMP));
    }

    public OJSONReader readNext(char[] iUntil) throws IOException, ParseException {
        this.readNext(iUntil, false);
        return this;
    }

    public OJSONReader readNext(char[] iUntil, boolean iInclude) throws IOException, ParseException {
        this.readNext(iUntil, iInclude, DEFAULT_JUMP, null);
        return this;
    }

    public OJSONReader readNext(char[] iUntil, boolean iInclude, char[] iJumpChars, char[] iSkipChars) throws IOException, ParseException {
        this.readNext(iUntil, iInclude, iJumpChars, iSkipChars, true);
        return this;
    }

    public OJSONReader readNext(char[] iUntil, boolean iInclude, char[] iJumpChars, char[] iSkipChars, boolean preserveQuotes) throws IOException, ParseException {
        boolean found;
        if (!this.in.ready()) {
            return this;
        }
        this.jump(iJumpChars);
        if (!this.in.ready()) {
            return this;
        }
        int openBrackets = 0;
        int beginStringChar = 32;
        boolean encodeMode = false;
        do {
            found = false;
            if (beginStringChar == 32) {
                if (openBrackets == 0) {
                    for (char u : iUntil) {
                        if (u != this.c) continue;
                        found = true;
                        break;
                    }
                }
                if (this.c == '\'' || this.c == '\"' && !encodeMode) {
                    beginStringChar = this.c;
                } else if (this.c == '{') {
                    ++openBrackets;
                } else if (this.c == '}' && openBrackets > 0) {
                    --openBrackets;
                }
                if (!found && openBrackets == 0) {
                    for (char u : iUntil) {
                        if (u != this.c) continue;
                        found = true;
                        break;
                    }
                }
            } else if (beginStringChar == this.c && !encodeMode) {
                beginStringChar = 32;
            }
            encodeMode = this.c == '\\' && !encodeMode;
            if (found) continue;
            int read = this.nextChar();
            if (read == -1) break;
            this.c = (char)read;
            boolean skip = false;
            if (iSkipChars != null) {
                for (char j : iSkipChars) {
                    if (j != this.c) continue;
                    skip = true;
                    break;
                }
            }
            if (skip || !preserveQuotes && encodeMode) continue;
            this.lastCharacter = this.c;
            this.buffer.append(this.c);
        } while (!found && this.in.ready());
        if (this.buffer.length() == 0) {
            throw new ParseException("Expected characters '" + Arrays.toString(iUntil) + "' not found", this.cursor);
        }
        if (!iInclude) {
            this.buffer.setLength(this.buffer.length() - 1);
        }
        this.value = this.buffer.toString();
        return this;
    }

    public Map<String, ORidSet> readNextRecord(char[] iUntil, boolean iInclude, char[] iJumpChars, char[] iSkipChars, boolean preserveQuotes, int maxRidbagSizeLazyImport) throws IOException, ParseException {
        boolean found;
        if (!this.in.ready()) {
            return Collections.emptyMap();
        }
        this.jump(iJumpChars);
        if (!this.in.ready()) {
            return Collections.emptyMap();
        }
        HashMap<String, ORidSet> result = new HashMap<String, ORidSet>();
        Pattern ridPattern = Pattern.compile("\"#([0-9]+):([0-9]+)\"");
        ORidSet ridbagSet = null;
        StringBuilder lastString = null;
        String lastFieldName = null;
        StringBuilder lastCollection = null;
        int openBrackets = 0;
        int openSquare = 0;
        int beginStringChar = 32;
        boolean encodeMode = false;
        do {
            found = false;
            if (beginStringChar == 32) {
                if (openBrackets == 0) {
                    for (char u : iUntil) {
                        if (u != this.c) continue;
                        found = true;
                        break;
                    }
                }
                if (this.c == '\'' || this.c == '\"' && !encodeMode) {
                    beginStringChar = this.c;
                    lastString = new StringBuilder();
                } else if (this.c == '{') {
                    ++openBrackets;
                } else if (this.c == '}' && openBrackets > 0) {
                    --openBrackets;
                } else if (this.c == '[') {
                    if (openSquare == 0 && (lastString.toString().startsWith("out_") || lastString.toString().startsWith("in_"))) {
                        lastCollection = new StringBuilder();
                        lastFieldName = lastString.toString();
                        lastFieldName = lastFieldName.substring(0, lastFieldName.length() - 1);
                        ridbagSet = new ORidSet();
                    }
                    ++openSquare;
                } else if (this.c == ']' && openSquare == 1) {
                    if (lastFieldName != null && ridbagSet != null && ridbagSet.size() > 0) {
                        this.stringToRidbag(lastCollection, ridbagSet, ridPattern);
                        result.put(lastFieldName, ridbagSet);
                        lastFieldName = null;
                        ridbagSet = null;
                        this.buffer.append("]");
                    }
                    --openSquare;
                }
                if (!found && openBrackets == 0) {
                    for (char u : iUntil) {
                        if (u != this.c) continue;
                        found = true;
                        break;
                    }
                }
            } else if (beginStringChar == this.c && !encodeMode) {
                beginStringChar = 32;
            }
            encodeMode = this.c == '\\' && !encodeMode;
            if (found) continue;
            int read = this.nextChar();
            if (read == -1) break;
            this.c = (char)read;
            boolean skip = false;
            if (iSkipChars != null) {
                for (char j : iSkipChars) {
                    if (j != this.c) continue;
                    skip = true;
                    break;
                }
            }
            if (skip || !preserveQuotes && encodeMode) continue;
            this.lastCharacter = this.c;
            if (openSquare == 0 && lastCollection != null && lastFieldName != null) {
                this.buffer.append((CharSequence)lastCollection);
                this.buffer.append(this.c);
                lastCollection = null;
            } else if (openSquare > 0 && lastCollection != null) {
                lastCollection.append(this.c);
                if (lastCollection.length() > maxRidbagSizeLazyImport && lastFieldName != null && lastCollection != null && !this.stringToRidbag(lastCollection, ridbagSet, ridPattern)) {
                    lastFieldName = null;
                    openBrackets = 0;
                }
            } else {
                this.buffer.append(this.c);
            }
            if (beginStringChar == 32) continue;
            lastString.append(this.c);
        } while (!found && this.in.ready());
        if (this.buffer.length() == 0) {
            throw new ParseException("Expected characters '" + Arrays.toString(iUntil) + "' not found", this.cursor);
        }
        if (!iInclude) {
            this.buffer.setLength(this.buffer.length() - 1);
        }
        this.value = this.buffer.toString();
        return result;
    }

    private boolean stringToRidbag(StringBuilder lastCollection, ORidSet ridbagSet, Pattern ridPattern) {
        int i;
        String[] split = lastCollection.toString().split(",");
        for (i = 0; i < split.length; ++i) {
            Matcher matcher = ridPattern.matcher(split[i]);
            boolean matches = matcher.matches();
            if (i == 0 && !matches) {
                this.buffer.append((CharSequence)lastCollection);
                return false;
            }
            if (!matches) break;
            ORecordId rid = new ORecordId(split[i].substring(1, split[i].length() - 1));
            ridbagSet.add(rid);
        }
        lastCollection.setLength(0);
        for (int j = i; j < split.length; ++j) {
            if (j != i) {
                lastCollection.append(",");
            }
            lastCollection.append(split[j]);
        }
        return true;
    }

    public int jump(char[] iJumpChars) throws IOException, ParseException {
        this.buffer.setLength(0);
        if (!this.in.ready()) {
            return 0;
        }
        boolean go = true;
        block0: while (go && this.in.ready()) {
            int read = this.nextChar();
            if (read == -1) {
                return -1;
            }
            go = false;
            for (char j : iJumpChars) {
                if (j != this.c) continue;
                go = true;
                continue block0;
            }
        }
        if (!go) {
            this.lastCharacter = this.c;
            this.buffer.append(this.c);
        }
        return this.c;
    }

    public int nextChar() throws IOException {
        if (this.missedChar != null) {
            this.c = this.missedChar.charValue();
            this.missedChar = null;
        } else {
            int read = this.in.read();
            if (read == -1) {
                return -1;
            }
            this.c = (char)read;
            if (this.c == '\\') {
                read = this.in.read();
                if (read == -1) {
                    return -1;
                }
                char c2 = (char)read;
                if (c2 == 'u') {
                    StringBuilder buff = new StringBuilder(8);
                    for (int i = 0; i < 4; ++i) {
                        read = this.in.read();
                        if (read == -1) {
                            return -1;
                        }
                        buff.append((char)read);
                    }
                    this.cursor += 6;
                    return (char)Integer.parseInt(buff.toString(), 16);
                }
                this.missedChar = Character.valueOf(c2);
            }
        }
        ++this.cursor;
        if (this.c == '\n') {
            ++this.lineNumber;
            this.columnNumber = 0;
        } else {
            ++this.columnNumber;
        }
        return this.c;
    }

    public char lastChar() {
        return this.lastCharacter;
    }

    public String getValue() {
        return this.value;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean hasNext() throws IOException {
        return this.in.ready();
    }
}

