/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.ONullSerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class OCompositeKeySerializer
implements OBinarySerializer<OCompositeKey> {
    public static final OCompositeKeySerializer INSTANCE = new OCompositeKeySerializer();
    public static final byte ID = 14;

    @Override
    public int getObjectSize(OCompositeKey compositeKey, Object ... hints) {
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = compositeKey.getKeys();
        int size = 8;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                size += 1 + factory.getObjectSerializer(type).getObjectSize(key, new Object[0]);
                continue;
            }
            size += 1 + ONullSerializer.INSTANCE.getObjectSize((Object)null, new Object[0]);
        }
        return size;
    }

    @Override
    public void serialize(OCompositeKey compositeKey, byte[] stream, int startPosition, Object ... hints) {
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = compositeKey.getKeys();
        int keysSize = keys.size();
        int oldStartPosition = startPosition;
        OIntegerSerializer.INSTANCE.serializeLiteral(keysSize, stream, startPosition += 4);
        startPosition += 4;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            OBinarySerializer<Object> binarySerializer;
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                binarySerializer = factory.getObjectSerializer(type);
            } else {
                binarySerializer = ONullSerializer.INSTANCE;
            }
            stream[startPosition] = binarySerializer.getId();
            binarySerializer.serialize(key, stream, ++startPosition, new Object[0]);
            startPosition += binarySerializer.getObjectSize(key, new Object[0]);
        }
        OIntegerSerializer.INSTANCE.serializeLiteral(startPosition - oldStartPosition, stream, oldStartPosition);
    }

    @Override
    public OCompositeKey deserialize(byte[] stream, int startPosition) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition += 4);
        startPosition += OIntegerSerializer.INSTANCE.getObjectSize(keysSize, new Object[0]);
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = stream[startPosition];
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserialize(stream, ++startPosition);
            compositeKey.addKey(key);
            startPosition += binarySerializer.getObjectSize(key, new Object[0]);
        }
        return compositeKey;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition);
    }

    @Override
    public byte getId() {
        return 14;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
    }

    @Override
    public void serializeNativeObject(OCompositeKey compositeKey, byte[] stream, int startPosition, Object ... hints) {
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = compositeKey.getKeys();
        int keysSize = keys.size();
        int oldStartPosition = startPosition;
        OIntegerSerializer.INSTANCE.serializeNative(keysSize, stream, startPosition += 4, new Object[0]);
        startPosition += 4;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            OBinarySerializer<Object> binarySerializer;
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                binarySerializer = factory.getObjectSerializer(type);
            } else {
                binarySerializer = ONullSerializer.INSTANCE;
            }
            stream[startPosition] = binarySerializer.getId();
            binarySerializer.serializeNativeObject(key, stream, ++startPosition, new Object[0]);
            startPosition += binarySerializer.getObjectSize(key, new Object[0]);
        }
        OIntegerSerializer.INSTANCE.serializeNative(startPosition - oldStartPosition, stream, oldStartPosition, new Object[0]);
    }

    @Override
    public OCompositeKey deserializeNativeObject(byte[] stream, int startPosition) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition += 4);
        startPosition += OIntegerSerializer.INSTANCE.getObjectSize(keysSize, new Object[0]);
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = stream[startPosition];
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserializeNativeObject(stream, ++startPosition);
            compositeKey.addKey(key);
            startPosition += binarySerializer.getObjectSize(key, new Object[0]);
        }
        return compositeKey;
    }

    private OType[] getKeyTypes(Object[] hints) {
        OType[] types = hints != null && hints.length > 0 ? (OType[])hints : OCommonConst.EMPTY_TYPES_ARRAY;
        return types;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public OCompositeKey preprocess(OCompositeKey value, Object ... hints) {
        if (value == null) {
            return null;
        }
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = value.getKeys();
        OCompositeKey compositeKey = new OCompositeKey();
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                OBinarySerializer<Object> keySerializer = factory.getObjectSerializer(type);
                if (key instanceof Map && type != OType.EMBEDDEDMAP && type != OType.LINKMAP && ((Map)key).size() == 1 && ((Map)key).keySet().iterator().next().getClass().isAssignableFrom(type.getDefaultJavaType())) {
                    key = ((Map)key).keySet().iterator().next();
                }
                compositeKey.addKey(keySerializer.preprocess(key, new Object[0]));
                continue;
            }
            compositeKey.addKey(key);
        }
        return compositeKey;
    }

    @Override
    public void serializeInByteBufferObject(OCompositeKey object, ByteBuffer buffer, Object ... hints) {
        OType[] types = this.getKeyTypes(hints);
        List<Object> keys = object.getKeys();
        int keysSize = keys.size();
        int oldStartOffset = buffer.position();
        buffer.position(oldStartOffset + 4);
        buffer.putInt(keysSize);
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keys.size(); ++i) {
            OBinarySerializer<Object> binarySerializer;
            Object key = keys.get(i);
            if (key != null) {
                OType type = types.length > i ? types[i] : OType.getTypeByClass(key.getClass());
                binarySerializer = factory.getObjectSerializer(type);
            } else {
                binarySerializer = ONullSerializer.INSTANCE;
            }
            buffer.put(binarySerializer.getId());
            binarySerializer.serializeInByteBufferObject(key, buffer, new Object[0]);
        }
        int finalPosition = buffer.position();
        int serializedSize = buffer.position() - oldStartOffset;
        buffer.position(oldStartOffset);
        buffer.putInt(serializedSize);
        buffer.position(finalPosition);
    }

    @Override
    public OCompositeKey deserializeFromByteBufferObject(ByteBuffer buffer) {
        OCompositeKey compositeKey = new OCompositeKey();
        buffer.position(buffer.position() + 4);
        int keysSize = buffer.getInt();
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = buffer.get();
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserializeFromByteBufferObject(buffer);
            compositeKey.addKey(key);
        }
        return compositeKey;
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return buffer.getInt();
    }

    @Override
    public OCompositeKey deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = walChanges.getIntValue(buffer, offset += 4);
        offset += 4;
        OBinarySerializerFactory factory = OBinarySerializerFactory.getInstance();
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = walChanges.getByteValue(buffer, offset);
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserializeFromByteBufferObject(buffer, walChanges, ++offset);
            compositeKey.addKey(key);
            offset += binarySerializer.getObjectSize(key, new Object[0]);
        }
        return compositeKey;
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getIntValue(buffer, offset);
    }
}

