/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractUnrollStep
extends AbstractExecutionStep {
    OResultSet lastResult = null;
    Iterator<OResult> nextSubsequence = null;
    OResult nextElement = null;

    public AbstractUnrollStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public void reset() {
        this.lastResult = null;
        this.nextSubsequence = null;
        this.nextElement = null;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (this.prev == null || !this.prev.isPresent()) {
            throw new OCommandExecutionException("Cannot expand without a target");
        }
        return new OResultSet(){
            long localCount = 0L;

            @Override
            public boolean hasNext() {
                if (this.localCount >= (long)nRecords) {
                    return false;
                }
                if (AbstractUnrollStep.this.nextElement == null) {
                    AbstractUnrollStep.this.fetchNext(ctx, nRecords);
                }
                return AbstractUnrollStep.this.nextElement != null;
            }

            @Override
            public OResult next() {
                if (this.localCount >= (long)nRecords) {
                    throw new IllegalStateException();
                }
                if (AbstractUnrollStep.this.nextElement == null) {
                    AbstractUnrollStep.this.fetchNext(ctx, nRecords);
                }
                if (AbstractUnrollStep.this.nextElement == null) {
                    throw new IllegalStateException();
                }
                OResult result = AbstractUnrollStep.this.nextElement;
                ++this.localCount;
                AbstractUnrollStep.this.nextElement = null;
                AbstractUnrollStep.this.fetchNext(ctx, nRecords);
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void fetchNext(OCommandContext ctx, int n) {
        while (true) {
            if (this.nextSubsequence != null && this.nextSubsequence.hasNext()) break;
            if (this.nextSubsequence == null || !this.nextSubsequence.hasNext()) {
                if (this.lastResult == null || !this.lastResult.hasNext()) {
                    this.lastResult = this.getPrev().get().syncPull(ctx, n);
                }
                if (!this.lastResult.hasNext()) {
                    return;
                }
            }
            OResult nextAggregateItem = this.lastResult.next();
            this.nextSubsequence = this.unroll(nextAggregateItem, ctx).iterator();
        }
        this.nextElement = this.nextSubsequence.next();
    }

    protected abstract Collection<OResult> unroll(OResult var1, OCommandContext var2);
}

