/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromClusterExecutionStep;
import com.orientechnologies.orient.core.sql.executor.FetchTemporaryFromTxStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.QueryPlanningInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FetchFromClassExecutionStep
extends AbstractExecutionStep {
    private String className;
    private boolean orderByRidAsc = false;
    private boolean orderByRidDesc = false;
    private List<OExecutionStep> subSteps = new ArrayList<OExecutionStep>();
    OResultSet currentResultSet;
    int currentStep = 0;

    protected FetchFromClassExecutionStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    public FetchFromClassExecutionStep(String className, Set<String> clusters, OCommandContext ctx, Boolean ridOrder, boolean profilingEnabled) {
        this(className, clusters, null, ctx, ridOrder, profilingEnabled);
    }

    public FetchFromClassExecutionStep(String className, Set<String> clusters, QueryPlanningInfo planningInfo, OCommandContext ctx, Boolean ridOrder, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        int i;
        this.className = className;
        if (Boolean.TRUE.equals(ridOrder)) {
            this.orderByRidAsc = true;
        } else if (Boolean.FALSE.equals(ridOrder)) {
            this.orderByRidDesc = true;
        }
        OClass clazz = ctx.getDatabase().getMetadata().getSchema().getClass(className);
        if (clazz == null) {
            throw new OCommandExecutionException("Class " + className + " not found");
        }
        int[] classClusters = clazz.getPolymorphicClusterIds();
        ArrayList<Integer> filteredClassClusters = new ArrayList<Integer>();
        for (int clusterId : classClusters) {
            String clusterName = ctx.getDatabase().getClusterNameById(clusterId);
            if (clusters != null && !clusters.contains(clusterName)) continue;
            filteredClassClusters.add(clusterId);
        }
        int[] clusterIds = new int[filteredClassClusters.size() + 1];
        for (i = 0; i < filteredClassClusters.size(); ++i) {
            clusterIds[i] = (Integer)filteredClassClusters.get(i);
        }
        clusterIds[clusterIds.length - 1] = -1;
        this.sortClusers(clusterIds);
        for (i = 0; i < clusterIds.length; ++i) {
            AbstractExecutionStep step;
            int clusterId = clusterIds[i];
            if (clusterId > 0) {
                step = new FetchFromClusterExecutionStep(clusterId, planningInfo, ctx, profilingEnabled);
                if (this.orderByRidAsc) {
                    ((FetchFromClusterExecutionStep)step).setOrder(FetchFromClusterExecutionStep.ORDER_ASC);
                } else if (this.orderByRidDesc) {
                    ((FetchFromClusterExecutionStep)step).setOrder(FetchFromClusterExecutionStep.ORDER_DESC);
                }
                this.getSubSteps().add(step);
                continue;
            }
            step = new FetchTemporaryFromTxStep(ctx, className, profilingEnabled);
            if (this.orderByRidAsc) {
                ((FetchTemporaryFromTxStep)step).setOrder(FetchFromClusterExecutionStep.ORDER_ASC);
            } else if (this.orderByRidDesc) {
                ((FetchTemporaryFromTxStep)step).setOrder(FetchFromClusterExecutionStep.ORDER_DESC);
            }
            this.getSubSteps().add(step);
        }
    }

    private void sortClusers(int[] clusterIds) {
        if (this.orderByRidAsc) {
            Arrays.sort(clusterIds);
        } else if (this.orderByRidDesc) {
            Arrays.sort(clusterIds);
            for (int i = 0; i < clusterIds.length / 2; ++i) {
                int old = clusterIds[i];
                clusterIds[i] = clusterIds[clusterIds.length - 1 - i];
                clusterIds[clusterIds.length - 1 - i] = old;
            }
        }
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){
            int totDispatched = 0;

            @Override
            public boolean hasNext() {
                while (this.totDispatched < nRecords) {
                    if (FetchFromClassExecutionStep.this.currentResultSet != null && FetchFromClassExecutionStep.this.currentResultSet.hasNext()) {
                        return true;
                    }
                    if (FetchFromClassExecutionStep.this.currentStep >= FetchFromClassExecutionStep.this.getSubSteps().size()) {
                        return false;
                    }
                    FetchFromClassExecutionStep.this.currentResultSet = ((AbstractExecutionStep)FetchFromClassExecutionStep.this.getSubSteps().get(FetchFromClassExecutionStep.this.currentStep)).syncPull(ctx, nRecords);
                    if (FetchFromClassExecutionStep.this.currentResultSet.hasNext()) continue;
                    FetchFromClassExecutionStep.this.currentResultSet = ((AbstractExecutionStep)FetchFromClassExecutionStep.this.getSubSteps().get(FetchFromClassExecutionStep.this.currentStep++)).syncPull(ctx, nRecords);
                }
                return false;
            }

            @Override
            public OResult next() {
                while (true) {
                    if (this.totDispatched >= nRecords) {
                        throw new IllegalStateException();
                    }
                    if (FetchFromClassExecutionStep.this.currentResultSet != null && FetchFromClassExecutionStep.this.currentResultSet.hasNext()) {
                        ++this.totDispatched;
                        OResult result = FetchFromClassExecutionStep.this.currentResultSet.next();
                        ctx.setVariable("$current", result);
                        return result;
                    }
                    if (FetchFromClassExecutionStep.this.currentStep >= FetchFromClassExecutionStep.this.getSubSteps().size()) {
                        throw new IllegalStateException();
                    }
                    FetchFromClassExecutionStep.this.currentResultSet = ((AbstractExecutionStep)FetchFromClassExecutionStep.this.getSubSteps().get(FetchFromClassExecutionStep.this.currentStep)).syncPull(ctx, nRecords);
                    if (FetchFromClassExecutionStep.this.currentResultSet.hasNext()) continue;
                    FetchFromClassExecutionStep.this.currentResultSet = ((AbstractExecutionStep)FetchFromClassExecutionStep.this.getSubSteps().get(FetchFromClassExecutionStep.this.currentStep++)).syncPull(ctx, nRecords);
                }
            }

            @Override
            public void close() {
                for (OExecutionStep step : FetchFromClassExecutionStep.this.getSubSteps()) {
                    ((AbstractExecutionStep)step).close();
                }
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return new HashMap<String, Long>();
            }
        };
    }

    @Override
    public void sendTimeout() {
        for (OExecutionStep step : this.getSubSteps()) {
            ((AbstractExecutionStep)step).sendTimeout();
        }
        this.prev.ifPresent(p -> p.sendTimeout());
    }

    @Override
    public void close() {
        for (OExecutionStep step : this.getSubSteps()) {
            ((AbstractExecutionStep)step).close();
        }
        this.prev.ifPresent(p -> p.close());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder builder = new StringBuilder();
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        builder.append(ind);
        builder.append("+ FETCH FROM CLASS " + this.className);
        if (this.profilingEnabled) {
            builder.append(" (" + this.getCostFormatted() + ")");
        }
        builder.append("\n");
        for (int i = 0; i < this.getSubSteps().size(); ++i) {
            OExecutionStepInternal step = (OExecutionStepInternal)this.getSubSteps().get(i);
            builder.append(step.prettyPrint(depth + 1, indent));
            if (i >= this.getSubSteps().size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public long getCost() {
        return this.getSubSteps().stream().map(x -> x.getCost()).reduce((a, b) -> a + b).orElse(0L);
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        result.setProperty("className", this.className);
        result.setProperty("orderByRidAsc", this.orderByRidAsc);
        result.setProperty("orderByRidDesc", this.orderByRidDesc);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.className = (String)fromResult.getProperty("className");
            this.orderByRidAsc = (Boolean)fromResult.getProperty("orderByRidAsc");
            this.orderByRidDesc = (Boolean)fromResult.getProperty("orderByRidDesc");
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }

    @Override
    public List<OExecutionStep> getSubSteps() {
        return this.subSteps;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        FetchFromClassExecutionStep result = new FetchFromClassExecutionStep(ctx, this.profilingEnabled);
        result.className = this.className;
        result.orderByRidAsc = this.orderByRidAsc;
        result.orderByRidDesc = this.orderByRidDesc;
        result.subSteps = this.subSteps.stream().map(x -> ((OExecutionStepInternal)x).copy(ctx)).collect(Collectors.toList());
        return result;
    }
}

