/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OCommandInterruptedException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class FetchFromIndexedFunctionStep
extends AbstractExecutionStep {
    private OBinaryCondition functionCondition;
    private OFromClause queryTarget;
    private long cost = 0L;
    Iterator<OIdentifiable> fullResult = null;

    public FetchFromIndexedFunctionStep(OBinaryCondition functionCondition, OFromClause queryTarget, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.functionCondition = functionCondition;
        this.queryTarget = queryTarget;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init(ctx);
        return new OResultSet(){
            int localCount = 0;

            @Override
            public boolean hasNext() {
                if (this.localCount >= nRecords) {
                    return false;
                }
                return FetchFromIndexedFunctionStep.this.fullResult.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                if (this.localCount % 100 == 0 && OExecutionThreadLocal.isInterruptCurrentOperation()) {
                    throw new OCommandInterruptedException("The command has been interrupted");
                }
                long begin = FetchFromIndexedFunctionStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (this.localCount >= nRecords) {
                        throw new IllegalStateException();
                    }
                    if (!FetchFromIndexedFunctionStep.this.fullResult.hasNext()) {
                        throw new IllegalStateException();
                    }
                    OResultInternal result = new OResultInternal();
                    result.setElement(FetchFromIndexedFunctionStep.this.fullResult.next());
                    ctx.setVariable("$current", result);
                    ++this.localCount;
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    if (FetchFromIndexedFunctionStep.this.profilingEnabled) {
                        FetchFromIndexedFunctionStep.this.cost = FetchFromIndexedFunctionStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(OCommandContext ctx) {
        if (this.fullResult == null) {
            long begin = this.profilingEnabled ? System.nanoTime() : 0L;
            try {
                this.fullResult = this.functionCondition.executeIndexedFunction(this.queryTarget, ctx).iterator();
            }
            finally {
                if (this.profilingEnabled) {
                    this.cost += System.nanoTime() - begin;
                }
            }
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ FETCH FROM INDEXED FUNCTION " + this.functionCondition.toString();
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public void reset() {
        this.fullResult = null;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        result.setProperty("functionCondition", this.functionCondition.serialize());
        result.setProperty("queryTarget", this.queryTarget.serialize());
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.functionCondition = new OBinaryCondition(-1);
            this.functionCondition.deserialize((OResult)fromResult.getProperty("functionCondition "));
            this.queryTarget = new OFromClause(-1);
            this.queryTarget.deserialize((OResult)fromResult.getProperty("functionCondition "));
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }
}

