/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.EdgeTraversal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class MatchEdgeTraverser {
    protected OResult sourceRecord;
    protected EdgeTraversal edge;
    protected OMatchPathItem item;
    Iterator<OResultInternal> downstream;

    public MatchEdgeTraverser(OResult lastUpstreamRecord, EdgeTraversal edge) {
        this.sourceRecord = lastUpstreamRecord;
        this.edge = edge;
        this.item = edge.edge.item;
    }

    public MatchEdgeTraverser(OResult lastUpstreamRecord, OMatchPathItem item) {
        this.sourceRecord = lastUpstreamRecord;
        this.item = item;
    }

    public boolean hasNext(OCommandContext ctx) {
        this.init(ctx);
        return this.downstream.hasNext();
    }

    public OResult next(OCommandContext ctx) {
        this.init(ctx);
        if (!this.downstream.hasNext()) {
            throw new IllegalStateException();
        }
        String endPointAlias = this.getEndpointAlias();
        OResultInternal nextR = this.downstream.next();
        OIdentifiable nextElement = nextR.getElement().get();
        Object prevValue = this.sourceRecord.getProperty(endPointAlias);
        if (prevValue != null && !this.equals(prevValue, nextElement)) {
            return null;
        }
        OResultInternal result = new OResultInternal();
        for (String prop : this.sourceRecord.getPropertyNames()) {
            result.setProperty(prop, this.sourceRecord.getProperty(prop));
        }
        result.setProperty(endPointAlias, this.toResult(nextElement));
        if (this.edge.edge.item.getFilter().getDepthAlias() != null) {
            result.setProperty(this.edge.edge.item.getFilter().getDepthAlias(), nextR.getMetadata("$depth"));
        }
        if (this.edge.edge.item.getFilter().getPathAlias() != null) {
            result.setProperty(this.edge.edge.item.getFilter().getPathAlias(), nextR.getMetadata("$matchPath"));
        }
        return result;
    }

    protected boolean equals(Object prevValue, OIdentifiable nextElement) {
        if (prevValue instanceof OResult) {
            prevValue = ((OResult)prevValue).getElement().orElse(null);
        }
        if (nextElement instanceof OResult) {
            nextElement = ((OResult)((Object)nextElement)).getElement().orElse(null);
        }
        return prevValue != null && prevValue.equals(nextElement);
    }

    protected Object toResult(OIdentifiable nextElement) {
        OResultInternal result = new OResultInternal();
        result.setElement(nextElement);
        return result;
    }

    protected String getStartingPointAlias() {
        return this.edge.edge.out.alias;
    }

    protected String getEndpointAlias() {
        if (this.item != null) {
            return this.item.getFilter().getAlias();
        }
        return this.edge.edge.in.alias;
    }

    protected void init(OCommandContext ctx) {
        if (this.downstream == null) {
            Object startingElem = this.sourceRecord.getProperty(this.getStartingPointAlias());
            if (startingElem instanceof OResult) {
                startingElem = ((OResult)startingElem).getElement().orElse(null);
            }
            this.downstream = this.executeTraversal(ctx, this.item, (OIdentifiable)startingElem, 0, null).iterator();
        }
    }

    protected Iterable<OResultInternal> executeTraversal(final OCommandContext iCommandContext, OMatchPathItem item, OIdentifiable startingPoint, int depth, List<OIdentifiable> pathToHere) {
        ArrayList<OResultInternal> result;
        OWhereClause filter = null;
        OWhereClause whileCondition = null;
        Integer maxDepth = null;
        String className = null;
        Integer clusterId = null;
        ORid targetRid = null;
        if (item.getFilter() != null) {
            filter = this.getTargetFilter(item);
            whileCondition = item.getFilter().getWhileCondition();
            maxDepth = item.getFilter().getMaxDepth();
            className = this.targetClassName(item, iCommandContext);
            String clusterName = this.targetClusterName(item, iCommandContext);
            if (clusterName != null) {
                clusterId = iCommandContext.getDatabase().getClusterIdByName(clusterName);
            }
            targetRid = this.targetRid(item, iCommandContext);
        }
        if (whileCondition == null && maxDepth == null) {
            Iterable<OResultInternal> queryResult = this.traversePatternEdge(startingPoint, iCommandContext);
            final OWhereClause theFilter = filter;
            final String theClassName = className;
            final Integer theClusterId = clusterId;
            final ORid theTargetRid = targetRid;
            result = () -> {
                final Iterator iter2 = queryResult.iterator();
                return new Iterator(){
                    OResultInternal nextElement = null;

                    @Override
                    public boolean hasNext() {
                        if (this.nextElement == null) {
                            this.fetchNext();
                        }
                        return this.nextElement != null;
                    }

                    public Object next() {
                        if (this.nextElement == null) {
                            this.fetchNext();
                        }
                        if (this.nextElement == null) {
                            throw new IllegalStateException();
                        }
                        OResultInternal res = this.nextElement;
                        this.nextElement = null;
                        return res;
                    }

                    public void fetchNext() {
                        Object previousMatch = iCommandContext.getVariable("$currentMatch");
                        while (iter2.hasNext()) {
                            OResultInternal next = (OResultInternal)iter2.next();
                            OElement elem = next.toElement();
                            iCommandContext.setVariable("$currentMatch", elem);
                            if (!MatchEdgeTraverser.this.matchesFilters(iCommandContext, theFilter, elem) || !MatchEdgeTraverser.this.matchesClass(iCommandContext, theClassName, elem) || !MatchEdgeTraverser.this.matchesCluster(iCommandContext, theClusterId, elem) || !MatchEdgeTraverser.this.matchesRid(iCommandContext, theTargetRid, elem)) continue;
                            this.nextElement = next;
                            break;
                        }
                        iCommandContext.setVariable("$currentMatch", previousMatch);
                    }
                };
            };
        } else {
            result = new ArrayList();
            iCommandContext.setVariable("$depth", depth);
            Object previousMatch = iCommandContext.getVariable("$currentMatch");
            iCommandContext.setVariable("$currentMatch", startingPoint);
            if (this.matchesFilters(iCommandContext, filter, startingPoint) && this.matchesClass(iCommandContext, className, startingPoint) && this.matchesCluster(iCommandContext, clusterId, startingPoint) && this.matchesRid(iCommandContext, targetRid, startingPoint)) {
                OResultInternal rs = new OResultInternal(startingPoint);
                rs.setMetadata("$depth", depth);
                rs.setMetadata("$matchPath", pathToHere == null ? Collections.EMPTY_LIST : pathToHere);
                ((List)result).add(rs);
            }
            if (!(maxDepth != null && depth >= maxDepth || whileCondition != null && !whileCondition.matchesFilters(startingPoint, iCommandContext))) {
                Iterable<OResultInternal> queryResult = this.traversePatternEdge(startingPoint, iCommandContext);
                for (OResultInternal origin : queryResult) {
                    ArrayList<OIdentifiable> newPath = new ArrayList<OIdentifiable>();
                    if (pathToHere != null) {
                        newPath.addAll(pathToHere);
                    }
                    OElement elem = origin.toElement();
                    newPath.add(elem.getIdentity());
                    Iterable<OResultInternal> subResult = this.executeTraversal(iCommandContext, item, elem, depth + 1, newPath);
                    if (subResult instanceof Collection) {
                        ((List)result).addAll((Collection)subResult);
                        continue;
                    }
                    for (OResultInternal i : subResult) {
                        ((List)result).add(i);
                    }
                }
            }
            iCommandContext.setVariable("$currentMatch", previousMatch);
        }
        return result;
    }

    protected OWhereClause getTargetFilter(OMatchPathItem item) {
        return item.getFilter().getFilter();
    }

    protected String targetClassName(OMatchPathItem item, OCommandContext iCommandContext) {
        return item.getFilter().getClassName(iCommandContext);
    }

    protected String targetClusterName(OMatchPathItem item, OCommandContext iCommandContext) {
        return item.getFilter().getClusterName(iCommandContext);
    }

    protected ORid targetRid(OMatchPathItem item, OCommandContext iCommandContext) {
        return item.getFilter().getRid(iCommandContext);
    }

    private boolean matchesClass(OCommandContext iCommandContext, String className, OIdentifiable origin) {
        Object record;
        if (className == null) {
            return true;
        }
        OElement element = null;
        if (origin instanceof OElement) {
            element = (OElement)origin;
        } else if (origin != null && (record = origin.getRecord()) instanceof OElement) {
            element = (OElement)record;
        }
        if (element != null) {
            Optional<OClass> clazz = element.getSchemaType();
            if (!clazz.isPresent()) {
                return false;
            }
            return clazz.get().isSubClassOf(className);
        }
        return false;
    }

    private boolean matchesCluster(OCommandContext iCommandContext, Integer clusterId, OIdentifiable origin) {
        if (clusterId == null) {
            return true;
        }
        if (origin == null) {
            return false;
        }
        if (origin.getIdentity() == null) {
            return false;
        }
        return clusterId.equals(origin.getIdentity().getClusterId());
    }

    private boolean matchesRid(OCommandContext iCommandContext, ORid rid, OIdentifiable origin) {
        if (rid == null) {
            return true;
        }
        if (origin == null) {
            return false;
        }
        if (origin.getIdentity() == null) {
            return false;
        }
        return origin.getIdentity().equals(rid.toRecordId(origin, iCommandContext));
    }

    protected boolean matchesFilters(OCommandContext iCommandContext, OWhereClause filter, OIdentifiable origin) {
        return filter == null || filter.matchesFilters(origin, iCommandContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<OResultInternal> traversePatternEdge(OIdentifiable startingPoint, OCommandContext iCommandContext) {
        Object qR;
        Set<Object> possibleResults = null;
        if (this.item.getFilter() != null) {
            String alias = this.getEndpointAlias();
            Object matchedNodes = iCommandContext.getVariable("$$OrientDB_Prefetched_Alias_Prefix__" + alias);
            if (matchedNodes != null) {
                possibleResults = matchedNodes instanceof Iterable ? (Set<Object>)matchedNodes : Collections.singleton(matchedNodes);
            }
        }
        Object prevCurrent = iCommandContext.getVariable("$current");
        iCommandContext.setVariable("$current", startingPoint);
        try {
            qR = this.item.getMethod().execute(startingPoint, possibleResults, iCommandContext);
        }
        finally {
            iCommandContext.setVariable("$current", prevCurrent);
        }
        if (qR == null) {
            return Collections.EMPTY_LIST;
        }
        if (qR instanceof OIdentifiable) {
            return Collections.singleton(new OResultInternal((OIdentifiable)qR));
        }
        if (qR instanceof Iterable) {
            final Iterator iter2 = ((Iterable)qR).iterator();
            Iterable<OResultInternal> result = () -> new Iterator<OResultInternal>(){
                private OResultInternal nextElement;

                @Override
                public boolean hasNext() {
                    if (this.nextElement == null) {
                        this.fetchNext();
                    }
                    return this.nextElement != null;
                }

                @Override
                public OResultInternal next() {
                    if (this.nextElement == null) {
                        this.fetchNext();
                    }
                    if (this.nextElement == null) {
                        throw new IllegalStateException();
                    }
                    OResultInternal res = this.nextElement;
                    this.nextElement = null;
                    return res;
                }

                public void fetchNext() {
                    while (iter2.hasNext()) {
                        Object o = iter2.next();
                        if (o instanceof OIdentifiable) {
                            this.nextElement = new OResultInternal((OIdentifiable)o);
                            break;
                        }
                        if (o instanceof OResultInternal) {
                            this.nextElement = (OResultInternal)o;
                            break;
                        }
                        if (o == null) continue;
                        throw new UnsupportedOperationException();
                    }
                }
            };
            return result;
        }
        return Collections.EMPTY_LIST;
    }
}

