/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.executor.ORidSet;
import java.util.Iterator;

public class ORidSetIterator
implements Iterator<ORID> {
    private final Iterator<ORID> negativesIterator;
    private ORidSet set;
    int currentCluster = -1;
    long currentId = -1L;

    ORidSetIterator(ORidSet set) {
        this.set = set;
        this.negativesIterator = set.negatives.iterator();
        this.fetchNext();
    }

    @Override
    public boolean hasNext() {
        return this.negativesIterator.hasNext() || this.currentCluster >= 0;
    }

    @Override
    public ORID next() {
        if (this.negativesIterator.hasNext()) {
            return this.negativesIterator.next();
        }
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        ORecordId result = new ORecordId(this.currentCluster, this.currentId);
        ++this.currentId;
        this.fetchNext();
        return result;
    }

    private void fetchNext() {
        if (this.currentCluster < 0) {
            this.currentCluster = 0;
            this.currentId = 0L;
        }
        long currentArrayPos = this.currentId / 63L;
        long currentBit = this.currentId % 63L;
        int block = (int)(currentArrayPos / (long)this.set.maxArraySize);
        int blockPositionByteInt = (int)(currentArrayPos % (long)this.set.maxArraySize);
        while (this.currentCluster < this.set.content.length) {
            while (this.set.content[this.currentCluster] != null && block < this.set.content[this.currentCluster].length) {
                while (this.set.content[this.currentCluster][block] != null && blockPositionByteInt < this.set.content[this.currentCluster][block].length) {
                    if (currentBit == 0L && this.set.content[this.currentCluster][block][blockPositionByteInt] == 0L) {
                        ++blockPositionByteInt;
                        ++currentArrayPos;
                        continue;
                    }
                    if (this.set.contains(new ORecordId(this.currentCluster, currentArrayPos * 63L + currentBit))) {
                        this.currentId = currentArrayPos * 63L + currentBit;
                        return;
                    }
                    if (++currentBit <= 63L) continue;
                    currentBit = 0L;
                    ++blockPositionByteInt;
                    ++currentArrayPos;
                }
                if (this.set.content[this.currentCluster][block] == null && this.set.content[this.currentCluster].length >= block) {
                    currentArrayPos += (long)this.set.maxArraySize;
                }
                ++block;
                blockPositionByteInt = 0;
                currentBit = 0L;
            }
            block = 0;
            currentBit = 0L;
            currentArrayPos = 0L;
            blockPositionByteInt = 0;
            ++this.currentCluster;
        }
        this.currentCluster = -1;
    }
}

