/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryTargetOperator;
import java.util.List;

public class OQueryOperatorContainsText
extends OQueryTargetOperator {
    private boolean ignoreCase = true;

    public OQueryOperatorContainsText(boolean iIgnoreCase) {
        super("CONTAINSTEXT", 5, false);
        this.ignoreCase = iIgnoreCase;
    }

    public OQueryOperatorContainsText() {
        super("CONTAINSTEXT", 5, false);
    }

    @Override
    public String getSyntax() {
        return "<left> CONTAINSTEXT[( noignorecase ] )] <right>";
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext, ODocumentSerializer serializer) {
        if (iLeft == null || iRight == null) {
            return false;
        }
        return iLeft.toString().indexOf(iRight.toString()) > -1;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        return null;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

