/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OAndBlock
extends OBooleanExpression {
    List<OBooleanExpression> subBlocks = new ArrayList<OBooleanExpression>();

    public OAndBlock(int id) {
        super(id);
    }

    public OAndBlock(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        if (this.getSubBlocks() == null) {
            return true;
        }
        for (OBooleanExpression block : this.subBlocks) {
            if (block.evaluate(currentRecord, ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        if (this.getSubBlocks() == null) {
            return true;
        }
        for (OBooleanExpression block : this.subBlocks) {
            if (block.evaluate(currentRecord, ctx)) continue;
            return false;
        }
        return true;
    }

    public List<OBooleanExpression> getSubBlocks() {
        return this.subBlocks;
    }

    public void setSubBlocks(List<OBooleanExpression> subBlocks) {
        this.subBlocks = subBlocks;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.subBlocks == null || this.subBlocks.size() == 0) {
            return;
        }
        boolean first = true;
        for (OBooleanExpression expr : this.subBlocks) {
            if (!first) {
                builder.append(" AND ");
            }
            expr.toString(params, builder);
            first = false;
        }
    }

    @Override
    protected boolean supportsBasicCalculation() {
        for (OBooleanExpression expr : this.subBlocks) {
            if (expr.supportsBasicCalculation()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int result = 0;
        for (OBooleanExpression expr : this.subBlocks) {
            result += expr.getNumberOfExternalCalculations();
        }
        return result;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OBooleanExpression expr : this.subBlocks) {
            result.addAll(expr.getExternalCalculationConditions());
        }
        return result;
    }

    @Override
    public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.subBlocks == null) {
            return null;
        }
        ArrayList<OBinaryCondition> result = new ArrayList<OBinaryCondition>();
        for (OBooleanExpression exp : this.subBlocks) {
            List<OBinaryCondition> sub = exp.getIndexedFunctionConditions(iSchemaClass, database);
            if (sub == null || sub.size() <= 0) continue;
            result.addAll(sub);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public List<OAndBlock> flatten() {
        ArrayList<OAndBlock> result = new ArrayList<OAndBlock>();
        boolean first = true;
        for (OBooleanExpression sub : this.subBlocks) {
            List<OAndBlock> subFlattened = sub.flatten();
            ArrayList<OAndBlock> oldResult = result;
            result = new ArrayList();
            for (OAndBlock subAndItem : subFlattened) {
                if (first) {
                    result.add(subAndItem);
                    continue;
                }
                for (OAndBlock oldResultItem : oldResult) {
                    OAndBlock block = new OAndBlock(-1);
                    block.subBlocks.addAll(oldResultItem.subBlocks);
                    for (OBooleanExpression resultItem : subAndItem.subBlocks) {
                        block.subBlocks.add(resultItem);
                    }
                    result.add(block);
                }
            }
            first = false;
        }
        return result;
    }

    @Override
    protected OAndBlock encapsulateInAndBlock(OBooleanExpression item) {
        if (item instanceof OAndBlock) {
            return (OAndBlock)item;
        }
        OAndBlock result = new OAndBlock(-1);
        result.subBlocks.add(item);
        return result;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        for (OBooleanExpression block : this.subBlocks) {
            if (!block.needsAliases(aliases)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OAndBlock copy() {
        OAndBlock result = new OAndBlock(-1);
        for (OBooleanExpression exp : this.subBlocks) {
            result.subBlocks.add(exp.copy());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAndBlock andBlock = (OAndBlock)o;
        return !(this.subBlocks != null ? !this.subBlocks.equals(andBlock.subBlocks) : andBlock.subBlocks != null);
    }

    public int hashCode() {
        return this.subBlocks != null ? this.subBlocks.hashCode() : 0;
    }

    @Override
    public boolean isEmpty() {
        if (this.subBlocks.isEmpty()) {
            return true;
        }
        for (OBooleanExpression block : this.subBlocks) {
            if (block.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        for (OBooleanExpression exp : this.subBlocks) {
            exp.extractSubQueries(collector);
        }
    }

    @Override
    public boolean refersToParent() {
        for (OBooleanExpression exp : this.subBlocks) {
            if (!exp.refersToParent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        ArrayList<String> result = new ArrayList<String>();
        for (OBooleanExpression exp : this.subBlocks) {
            List<String> x = exp.getMatchPatternInvolvedAliases();
            if (x == null) continue;
            result.addAll(x);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public void translateLuceneOperator() {
        this.subBlocks.forEach(x -> x.translateLuceneOperator());
    }

    @Override
    public boolean isCacheable() {
        for (OBooleanExpression exp : this.subBlocks) {
            if (exp.isCacheable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OBooleanExpression rewriteIndexChainsAsSubqueries(OCommandContext ctx, OClass clazz) {
        for (OBooleanExpression exp : this.subBlocks) {
            exp.rewriteIndexChainsAsSubqueries(ctx, clazz);
        }
        return this;
    }
}

