/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OArraySelector;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OArraySingleValuesSelector
extends SimpleNode {
    protected List<OArraySelector> items = new ArrayList<OArraySelector>();

    public OArraySingleValuesSelector(int id) {
        super(id);
    }

    public OArraySingleValuesSelector(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        boolean first = true;
        for (OArraySelector item : this.items) {
            if (!first) {
                builder.append(",");
            }
            item.toString(params, builder);
            first = false;
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, Object iResult, OCommandContext ctx) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OArraySelector item : this.items) {
            Object index = item.getValue(iCurrentRecord, iResult, ctx);
            if (index == null) {
                return null;
            }
            if (index instanceof Integer) {
                result.add(OMultiValue.getValue(iResult, (Integer)index));
            } else if (iResult instanceof Map) {
                result.add(((Map)iResult).get(index));
            } else if (iResult instanceof OElement && index instanceof String) {
                result.add(((OElement)iResult).getProperty((String)index));
            } else if (OMultiValue.isMultiValue(iResult)) {
                Iterator<Object> iter2 = OMultiValue.getMultiValueIterator(iResult);
                while (iter2.hasNext()) {
                    result.add(this.calculateValue(iter2.next(), index));
                }
            } else {
                result.add(null);
            }
            if (this.items.size() != 1 || result.size() != 1) continue;
            return result.get(0);
        }
        return result;
    }

    public Object execute(OResult iCurrentRecord, Object iResult, OCommandContext ctx) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OArraySelector item : this.items) {
            Object index = item.getValue(iCurrentRecord, iResult, ctx);
            if (index == null) {
                return null;
            }
            if (index instanceof Integer) {
                result.add(OMultiValue.getValue(iResult, (Integer)index));
            } else if (iResult instanceof Map) {
                result.add(((Map)iResult).get(index));
            } else if (iResult instanceof OElement && index instanceof String) {
                result.add(((OElement)iResult).getProperty((String)index));
            } else if (OMultiValue.isMultiValue(iResult)) {
                Iterator<Object> iter2 = OMultiValue.getMultiValueIterator(iResult);
                while (iter2.hasNext()) {
                    result.add(this.calculateValue(iter2.next(), index));
                }
            } else {
                result.add(null);
            }
            if (this.items.size() != 1 || result.size() != 1) continue;
            return result.get(0);
        }
        return result;
    }

    private Object calculateValue(Object item, Object index) {
        if (index instanceof Integer) {
            return OMultiValue.getValue(item, (Integer)index);
        }
        if (item instanceof Map) {
            return ((Map)item).get(index);
        }
        if (item instanceof OElement && index instanceof String) {
            return ((OElement)item).getProperty((String)index);
        }
        if (OMultiValue.isMultiValue(item)) {
            Iterator<Object> iter2 = OMultiValue.getMultiValueIterator(item);
            ArrayList<Object> result = new ArrayList<Object>();
            while (iter2.hasNext()) {
                result.add(this.calculateValue(iter2.next(), index));
            }
            return null;
        }
        return null;
    }

    public boolean needsAliases(Set<String> aliases) {
        for (OArraySelector item : this.items) {
            if (!item.needsAliases(aliases)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OArraySingleValuesSelector copy() {
        OArraySingleValuesSelector result = new OArraySingleValuesSelector(-1);
        result.items = this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OArraySingleValuesSelector that = (OArraySingleValuesSelector)o;
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.items != null) {
            for (OArraySelector item : this.items) {
                item.extractSubQueries(collector);
            }
        }
    }

    public boolean refersToParent() {
        if (this.items != null) {
            for (OArraySelector item : this.items) {
                if (!item.refersToParent()) continue;
                return true;
            }
        }
        return false;
    }

    public void setValue(OResult currentRecord, Object target, Object value, OCommandContext ctx) {
        if (this.items != null) {
            for (OArraySelector item : this.items) {
                item.setValue(currentRecord, target, value, ctx);
            }
        }
    }

    public void applyRemove(Object currentValue, OResultInternal originalRecord, OCommandContext ctx) {
        if (currentValue == null) {
            return;
        }
        List values = this.items.stream().map(x -> x.getValue(originalRecord, null, ctx)).collect(Collectors.toList());
        if (currentValue instanceof List) {
            List list = (List)currentValue;
            Collections.sort(values, this::compareKeysForRemoval);
            for (Object val : values) {
                if (val instanceof Integer) {
                    list.remove((Integer)val);
                    continue;
                }
                list.remove(val);
            }
        } else if (currentValue instanceof Set) {
            Set set = (Set)currentValue;
            Iterator iterator = set.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (!values.contains(count) && !values.contains(item)) continue;
                iterator.remove();
            }
        } else if (currentValue instanceof Map) {
            for (Object val : values) {
                ((Map)currentValue).remove(val);
            }
        } else if (currentValue instanceof OElement) {
            for (Object val : values) {
                ((OElement)currentValue).removeProperty("" + val);
            }
        } else {
            throw new OCommandExecutionException("Trying to remove elements from " + currentValue + " (" + currentValue.getClass().getSimpleName() + ")");
        }
    }

    private int compareKeysForRemoval(Object o1, Object o2) {
        if (o1 instanceof Integer) {
            if (o2 instanceof Integer) {
                return (Integer)o2 - (Integer)o1;
            }
            return -1;
        }
        if (o2 instanceof Integer) {
            return 1;
        }
        return 0;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.items != null) {
            result.setProperty("items", this.items.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("items") != null) {
            List ser = (List)fromResult.getProperty("items");
            this.items = new ArrayList<OArraySelector>();
            for (OResult r : ser) {
                OArraySelector exp = new OArraySelector(-1);
                exp.deserialize(r);
                this.items.add(exp);
            }
        }
    }
}

