/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OFetchPlanItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OFetchPlan
extends SimpleNode {
    protected List<OFetchPlanItem> items = new ArrayList<OFetchPlanItem>();

    public OFetchPlan(int id) {
        super(id);
    }

    public OFetchPlan(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("FETCHPLAN ");
        boolean first = true;
        for (OFetchPlanItem item : this.items) {
            if (!first) {
                builder.append(" ");
            }
            item.toString(params, builder);
            first = false;
        }
    }

    @Override
    public OFetchPlan copy() {
        OFetchPlan result = new OFetchPlan(-1);
        result.items = this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OFetchPlan that = (OFetchPlan)o;
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.items != null) {
            result.setProperty("items", this.items.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("items") != null) {
            List ser = (List)fromResult.getProperty("items");
            this.items = new ArrayList<OFetchPlanItem>();
            for (OResult r : ser) {
                OFetchPlanItem exp = new OFetchPlanItem(-1);
                exp.deserialize(r);
                this.items.add(exp);
            }
        }
    }
}

