/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.chm;

import com.orientechnologies.orient.core.storage.cache.chm.Admittor;
import java.util.concurrent.ThreadLocalRandom;

public final class FrequencySketch
implements Admittor {
    private static final long[] SEED = new long[]{-4348849565147123417L, -5435081209227447693L, -7286425919675154353L, -3750763034362895579L};
    private static final long RESET_MASK = 0x7777777777777777L;
    private static final long ONE_MASK = 0x1111111111111111L;
    private final int randomSeed;
    private int sampleSize;
    private int tableMask;
    private long[] table;
    private int size;

    FrequencySketch() {
        int seed = ThreadLocalRandom.current().nextInt();
        this.randomSeed = (seed & 1) == 0 ? seed + 1 : seed;
    }

    @Override
    public void ensureCapacity(long maximumSize) {
        int maximum = (int)Math.min(maximumSize, 0x3FFFFFFFL);
        if (this.table != null && this.table.length >= maximum) {
            return;
        }
        this.table = new long[maximum == 0 ? 1 : FrequencySketch.ceilingNextPowerOfTwo(maximum)];
        this.tableMask = Math.max(0, this.table.length - 1);
        int n = this.sampleSize = maximumSize == 0L ? 10 : 10 * maximum;
        if (this.sampleSize <= 0) {
            this.sampleSize = Integer.MAX_VALUE;
        }
        this.size = 0;
    }

    @Override
    public int frequency(int hash) {
        hash = this.spread(hash);
        int start = (hash & 3) << 2;
        int frequency = Integer.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            int index = this.indexOf(hash, i);
            int count = (int)(this.table[index] >>> (start + i << 2) & 0xFL);
            frequency = Math.min(frequency, count);
        }
        return frequency;
    }

    @Override
    public void increment(int hash) {
        hash = this.spread(hash);
        int start = (hash & 3) << 2;
        int index0 = this.indexOf(hash, 0);
        int index1 = this.indexOf(hash, 1);
        int index2 = this.indexOf(hash, 2);
        int index3 = this.indexOf(hash, 3);
        boolean added = this.incrementAt(index0, start);
        added |= this.incrementAt(index1, start + 1);
        added |= this.incrementAt(index2, start + 2);
        if ((added |= this.incrementAt(index3, start + 3)) && ++this.size == this.sampleSize) {
            this.reset();
        }
    }

    private boolean incrementAt(int i, int j) {
        int offset = j << 2;
        long mask = 15L << offset;
        if ((this.table[i] & mask) != mask) {
            int n = i;
            this.table[n] = this.table[n] + (1L << offset);
            return true;
        }
        return false;
    }

    private void reset() {
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            count += Long.bitCount(this.table[i] & 0x1111111111111111L);
            this.table[i] = this.table[i] >>> 1 & 0x7777777777777777L;
        }
        this.size = (this.size >>> 1) - (count >>> 2);
    }

    private int indexOf(int item, int i) {
        long hash = SEED[i] * (long)item;
        hash += hash >> 32;
        return (int)hash & this.tableMask;
    }

    private int spread(int x) {
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * this.randomSeed;
        return x >>> 16 ^ x;
    }

    private static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }
}

