/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

public class OBackgroundDelta
implements Runnable,
OSyncSource {
    private TimerTask timer;
    private OAbstractPaginatedStorage storage;
    private PipedOutputStream outputStream;
    private InputStream inputStream;
    private OCommandOutputListener outputListener;
    private SortedSet<ORID> sortedRids;
    private OLogSequenceNumber lsn;
    private OLogSequenceNumber endLsn;
    private CountDownLatch finished = new CountDownLatch(1);
    private volatile long lastRequest;

    public OBackgroundDelta(OAbstractPaginatedStorage storage, OCommandOutputListener outputListener, SortedSet<ORID> sortedRids, OLogSequenceNumber lsn, OLogSequenceNumber endLsn) throws IOException {
        this.storage = storage;
        this.outputListener = outputListener;
        this.sortedRids = sortedRids;
        this.lsn = lsn;
        this.endLsn = endLsn;
        this.outputStream = new PipedOutputStream();
        this.inputStream = new PipedInputStream(this.outputStream);
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
        long time = storage.getConfiguration().getContextConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_CHECK_HEALTH_EVERY) / 3L;
        long maxWait = storage.getConfiguration().getContextConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT) * 3L;
        this.timer = Orient.instance().scheduleTask(() -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRequest > maxWait) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.finished.countDown();
            }
        }, time, time);
    }

    public OBackgroundDelta(OLogSequenceNumber endLsn) {
        this.endLsn = endLsn;
    }

    @Override
    public void run() {
        try {
            this.storage.serializeDeltaContent(this.outputStream, this.outputListener, this.sortedRids, this.lsn);
        }
        finally {
            this.finished.countDown();
            this.timer.cancel();
        }
    }

    @Override
    public boolean getIncremental() {
        return false;
    }

    @Override
    public InputStream getInputStream() {
        this.lastRequest = System.currentTimeMillis();
        return this.inputStream;
    }

    @Override
    public CountDownLatch getFinished() {
        return this.finished;
    }

    public OLogSequenceNumber getEndLsn() {
        return this.endLsn;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public void invalidate() {
    }
}

