/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeRidBag;
import java.io.IOException;

public class ORidBagDeleteSerializationOperation
implements ORecordSerializationOperation {
    private final OBonsaiCollectionPointer collectionPointer;
    private final OSBTreeCollectionManager collectionManager;
    private final OSBTreeRidBag ridBag;

    public ORidBagDeleteSerializationOperation(OBonsaiCollectionPointer collectionPointer, OSBTreeRidBag ridBag) {
        this.collectionPointer = collectionPointer;
        this.ridBag = ridBag;
        this.collectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
    }

    @Override
    public void execute(OAtomicOperation atomicOperation, OAbstractPaginatedStorage paginatedStorage) {
        OSBTreeBonsai<OIdentifiable, Integer> treeBonsai = this.loadTree();
        try {
            treeBonsai.markToDelete(atomicOperation);
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error during ridbag deletion"), e);
        }
        finally {
            this.releaseTree();
        }
        paginatedStorage.tryToDeleteTreeRidBag(this.ridBag);
    }

    private OSBTreeBonsai<OIdentifiable, Integer> loadTree() {
        return this.collectionManager.loadSBTree(this.collectionPointer);
    }

    private void releaseTree() {
        this.collectionManager.releaseSBTree(this.collectionPointer);
    }
}

