/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.lock.OOneEntryPerKeyLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.function.TxConsumer;
import com.orientechnologies.common.function.TxFunction;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OStorageExistsException;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.AtomicOperationIdGen;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.AtomicOperationsTable;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsMangerMXBean;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.operationsfreezer.OperationsFreezer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class OAtomicOperationsManager
implements OAtomicOperationsMangerMXBean {
    private static volatile ThreadLocal<OAtomicOperation> currentOperation = new ThreadLocal();
    private final OperationsFreezer atomicOperationsFreezer = new OperationsFreezer();
    private final OperationsFreezer componentOperationsFreezer = new OperationsFreezer();
    private final Object segmentLock = new Object();
    private final OAbstractPaginatedStorage storage;
    private final OWriteAheadLog writeAheadLog;
    private final OOneEntryPerKeyLockManager<String> lockManager = new OOneEntryPerKeyLockManager(true, -1, OGlobalConfiguration.COMPONENTS_LOCK_CACHE.getValueAsInteger());
    private final OReadCache readCache;
    private final OWriteCache writeCache;
    private final AtomicOperationIdGen idGen;
    private final AtomicOperationsTable atomicOperationsTable;

    public OAtomicOperationsManager(OAbstractPaginatedStorage storage, AtomicOperationsTable atomicOperationsTable) {
        this.storage = storage;
        this.writeAheadLog = storage.getWALInstance();
        this.readCache = storage.getReadCache();
        this.writeCache = storage.getWriteCache();
        this.idGen = storage.getIdGen();
        this.atomicOperationsTable = atomicOperationsTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAtomicOperation startAtomicOperation() throws IOException {
        OLogSequenceNumber lsn;
        long activeSegment;
        long unitId;
        OAtomicOperation operation = currentOperation.get();
        if (operation != null) {
            throw new OStorageExistsException("Atomic operation already started");
        }
        this.atomicOperationsFreezer.startOperation();
        boolean useWal = this.useWal();
        if (useWal) {
            Object object = this.segmentLock;
            synchronized (object) {
                unitId = this.idGen.nextId();
                activeSegment = this.writeAheadLog.activeSegment();
            }
        } else {
            unitId = this.idGen.nextId();
            activeSegment = -1L;
        }
        if (useWal) {
            this.atomicOperationsTable.startOperation(unitId, activeSegment);
            lsn = this.writeAheadLog.logAtomicOperationStartRecord(true, unitId);
        } else {
            lsn = null;
        }
        operation = new OAtomicOperation(lsn, unitId, this.readCache, this.writeCache, this.storage.getId());
        currentOperation.set(operation);
        this.checkReadOnlyConditions(operation);
        return operation;
    }

    public <T> T calculateInsideAtomicOperation(TxFunction<T> function) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        try {
            T t = function.accept(atomicOperation);
            return t;
        }
        catch (Exception e) {
            rollback = true;
            throw OException.wrapException(new OStorageException("Exception during execution of atomic operation inside of storage " + this.storage.getName()), e);
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public void executeInsideAtomicOperation(TxConsumer consumer) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        try {
            consumer.accept(atomicOperation);
        }
        catch (Exception e) {
            rollback = true;
            throw OException.wrapException(new OStorageException("Exception during execution of atomic operation inside of storage " + this.storage.getName()), e);
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public void executeInsideComponentOperation(OAtomicOperation atomicOperation, ODurableComponent component, TxConsumer consumer) {
        this.executeInsideComponentOperation(atomicOperation, component.getLockName(), consumer);
    }

    public void executeInsideComponentOperation(OAtomicOperation atomicOperation, String lockName, TxConsumer consumer) {
        Objects.requireNonNull(atomicOperation);
        this.startComponentOperation(atomicOperation, lockName);
        try {
            consumer.accept(atomicOperation);
        }
        catch (Exception e) {
            throw OException.wrapException(new OStorageException("Exception during execution of component operation inside of storage " + this.storage.getName()), e);
        }
        finally {
            this.endComponentOperation();
        }
    }

    public boolean tryExecuteInsideComponentOperation(OAtomicOperation atomicOperation, ODurableComponent component, TxConsumer consumer) {
        return this.tryExecuteInsideComponentOperation(atomicOperation, component.getLockName(), consumer);
    }

    private boolean tryExecuteInsideComponentOperation(OAtomicOperation atomicOperation, String lockName, TxConsumer consumer) {
        Objects.requireNonNull(atomicOperation);
        boolean result = this.tryStartComponentOperation(atomicOperation, lockName);
        if (!result) {
            return false;
        }
        try {
            consumer.accept(atomicOperation);
        }
        catch (Exception e) {
            throw OException.wrapException(new OStorageException("Exception during execution of component operation inside of storage " + this.storage.getName()), e);
        }
        finally {
            this.endComponentOperation();
        }
        return true;
    }

    public <T> T calculateInsideComponentOperation(OAtomicOperation atomicOperation, ODurableComponent component, TxFunction<T> function) {
        return this.calculateInsideComponentOperation(atomicOperation, component.getLockName(), function);
    }

    public <T> T calculateInsideComponentOperation(OAtomicOperation atomicOperation, String lockName, TxFunction<T> function) {
        Objects.requireNonNull(atomicOperation);
        this.startComponentOperation(atomicOperation, lockName);
        try {
            T t = function.accept(atomicOperation);
            return t;
        }
        catch (Exception e) {
            throw OException.wrapException(new OStorageException("Exception during execution of component operation inside of storage " + this.storage.getName()), e);
        }
        finally {
            this.endComponentOperation();
        }
    }

    private void checkReadOnlyConditions(OAtomicOperation operation) {
        try {
            this.storage.checkReadOnlyConditions();
        }
        catch (Error | RuntimeException e) {
            Iterator<String> lockedObjectIterator = operation.lockedObjects().iterator();
            while (lockedObjectIterator.hasNext()) {
                String lockName = lockedObjectIterator.next();
                lockedObjectIterator.remove();
                this.lockManager.releaseLock(this, lockName, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
            }
            throw e;
        }
    }

    public static void alarmClearOfAtomicOperation() {
        OAtomicOperation current = currentOperation.get();
        if (current != null) {
            currentOperation.set(null);
        }
    }

    public long freezeAtomicOperations(Class<? extends OException> exceptionClass, String message) {
        return this.atomicOperationsFreezer.freezeOperations(exceptionClass, message);
    }

    public void releaseAtomicOperations(long id) {
        this.atomicOperationsFreezer.releaseOperations(id);
    }

    public static OAtomicOperation getCurrentOperation() {
        return currentOperation.get();
    }

    private void startComponentOperation(OAtomicOperation atomicOperation, String lockName) {
        this.checkReadOnlyConditions(atomicOperation);
        this.acquireExclusiveLockTillOperationComplete(atomicOperation, lockName);
        this.componentOperationsFreezer.startOperation();
    }

    private void endComponentOperation() {
        this.componentOperationsFreezer.endOperation();
    }

    public long freezeComponentOperations() {
        return this.componentOperationsFreezer.freezeOperations(null, null);
    }

    public void releaseComponentOperations(long freezeId) {
        this.componentOperationsFreezer.releaseOperations(freezeId);
    }

    private boolean tryStartComponentOperation(OAtomicOperation atomicOperation, String lockName) {
        this.checkReadOnlyConditions(atomicOperation);
        boolean result = this.tryAcquireExclusiveLockTillOperationComplete(atomicOperation, lockName);
        if (!result) {
            return false;
        }
        this.componentOperationsFreezer.startOperation();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAtomicOperation(boolean rollback) throws IOException {
        OAtomicOperation operation = currentOperation.get();
        if (operation == null) {
            OLogManager.instance().error(this, "There is no atomic operation active", null, new Object[0]);
            throw new ODatabaseException("There is no atomic operation active");
        }
        try {
            if (rollback) {
                operation.rollback();
            }
            try {
                boolean useWal = this.useWal();
                if (!operation.isRollback()) {
                    if (useWal) {
                        OLogSequenceNumber endLSN = operation.commitChanges(this.writeAheadLog);
                        long operationId = operation.getOperationUnitId();
                        this.atomicOperationsTable.commitOperation(operationId);
                        this.writeAheadLog.addEventAt(endLSN, () -> this.atomicOperationsTable.persistOperation(operationId));
                    } else {
                        operation.commitChanges(null);
                    }
                } else if (useWal) {
                    this.atomicOperationsTable.rollbackOperation(operation.getOperationUnitId());
                }
            }
            finally {
                Iterator<String> lockedObjectIterator = operation.lockedObjects().iterator();
                while (lockedObjectIterator.hasNext()) {
                    String lockedObject = lockedObjectIterator.next();
                    lockedObjectIterator.remove();
                    this.lockManager.releaseLock(this, lockedObject, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
                }
                currentOperation.set(null);
            }
        }
        catch (Error e) {
            OAbstractPaginatedStorage st = this.storage;
            if (st != null) {
                st.handleJVMError(e);
            }
            throw e;
        }
        finally {
            this.atomicOperationsFreezer.endOperation();
        }
    }

    public void ensureThatComponentsUnlocked() {
        OAtomicOperation operation = currentOperation.get();
        if (operation != null) {
            Iterator<String> lockedObjectIterator = operation.lockedObjects().iterator();
            while (lockedObjectIterator.hasNext()) {
                String lockedObject = lockedObjectIterator.next();
                lockedObjectIterator.remove();
                this.lockManager.releaseLock(this, lockedObject, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
            }
        }
    }

    public void acquireExclusiveLockTillOperationComplete(OAtomicOperation operation, String lockName) {
        if (operation.containsInLockedObjects(lockName)) {
            return;
        }
        this.lockManager.acquireLock(lockName, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
        operation.addLockedObject(lockName);
    }

    private boolean tryAcquireExclusiveLockTillOperationComplete(OAtomicOperation operation, String lockName) {
        if (operation.containsInLockedObjects(lockName)) {
            return true;
        }
        try {
            this.lockManager.acquireLock(lockName, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE, 1L);
        }
        catch (OLockException e) {
            return false;
        }
        operation.addLockedObject(lockName);
        return true;
    }

    public void acquireExclusiveLockTillOperationComplete(ODurableComponent durableComponent) {
        OAtomicOperation operation = currentOperation.get();
        assert (operation != null);
        this.acquireExclusiveLockTillOperationComplete(operation, durableComponent.getLockName());
    }

    public void acquireReadLock(ODurableComponent durableComponent) {
        this.lockManager.acquireLock(durableComponent.getLockName(), OOneEntryPerKeyLockManager.LOCK.SHARED);
    }

    public void releaseReadLock(ODurableComponent durableComponent) {
        assert (durableComponent.getName() != null);
        this.lockManager.releaseLock(this, durableComponent.getLockName(), OOneEntryPerKeyLockManager.LOCK.SHARED);
    }

    @Override
    public void trackAtomicOperations() {
    }

    @Override
    public void doNotTrackAtomicOperations() {
    }

    @Override
    public String dumpActiveAtomicOperations() {
        return "";
    }

    private boolean useWal() {
        if (this.writeAheadLog == null) {
            return false;
        }
        OStorageTransaction storageTransaction = this.storage.getStorageTransaction();
        if (storageTransaction == null) {
            return true;
        }
        OTransactionInternal clientTx = storageTransaction.getClientTx();
        return clientTx == null || clientTx.isUsingLog();
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (currentOperation == null) {
                    currentOperation = new ThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                currentOperation = null;
            }
        });
    }
}

