/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

public abstract class OAbstractCheckPointStartRecord
extends OAbstractWALRecord {
    private OLogSequenceNumber previousCheckpoint;

    protected OAbstractCheckPointStartRecord() {
    }

    protected OAbstractCheckPointStartRecord(OLogSequenceNumber previousCheckpoint) {
        this.previousCheckpoint = previousCheckpoint;
    }

    public OLogSequenceNumber getPreviousCheckpoint() {
        return this.previousCheckpoint;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        if (this.previousCheckpoint == null) {
            content[offset] = 0;
            return ++offset;
        }
        content[offset] = 1;
        OLongSerializer.INSTANCE.serializeNative(this.previousCheckpoint.getSegment(), content, ++offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(this.previousCheckpoint.getPosition(), content, offset += 8, new Object[0]);
        return offset += 8;
    }

    @Override
    public void toStream(ByteBuffer buffer) {
        if (this.previousCheckpoint == null) {
            buffer.put((byte)0);
            return;
        }
        buffer.put((byte)1);
        buffer.putLong(this.previousCheckpoint.getSegment());
        buffer.putLong(this.previousCheckpoint.getPosition());
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        if (content[offset] == 0) {
            return ++offset;
        }
        long segment = OLongSerializer.INSTANCE.deserializeNative(content, ++offset);
        long position = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.previousCheckpoint = new OLogSequenceNumber(segment, position);
        return offset += 8;
    }

    @Override
    public int serializedSize() {
        if (this.previousCheckpoint == null) {
            return 1;
        }
        return 17;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAbstractCheckPointStartRecord that = (OAbstractCheckPointStartRecord)o;
        return Objects.equals(this.previousCheckpoint, that.previousCheckpoint);
    }

    @Override
    public int hashCode() {
        return Optional.ofNullable(this.previousCheckpoint).map(OLogSequenceNumber::hashCode).orElse(0);
    }

    @Override
    public String toString() {
        return this.toString("previousCheckpoint=" + this.previousCheckpoint);
    }
}

