/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class OAbstractWriteAheadLog
implements OWriteAheadLog {
    private boolean closed;
    private final Lock syncObject = new ReentrantLock();
    private OLogSequenceNumber lastCheckpoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber logFuzzyCheckPointStart(OLogSequenceNumber flushedLsn) throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            OFuzzyCheckpointStartRecord record = new OFuzzyCheckpointStartRecord(this.lastCheckpoint, flushedLsn);
            this.log(record);
            OLogSequenceNumber oLogSequenceNumber = record.getLsn();
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public OLogSequenceNumber logFuzzyCheckPointEnd() throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            OFuzzyCheckpointEndRecord record = new OFuzzyCheckpointEndRecord();
            this.log(record);
            OLogSequenceNumber oLogSequenceNumber = record.getLsn();
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public OLogSequenceNumber logFullCheckpointStart() throws IOException {
        return this.log(new OFullCheckpointStartRecord(this.lastCheckpoint));
    }

    @Override
    public OLogSequenceNumber logFullCheckpointEnd() throws IOException {
        this.syncObject.lock();
        try {
            this.checkForClose();
            OLogSequenceNumber oLogSequenceNumber = this.log(new OCheckpointEndRecord());
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    @Override
    public OLogSequenceNumber getLastCheckpoint() {
        this.syncObject.lock();
        try {
            this.checkForClose();
            OLogSequenceNumber oLogSequenceNumber = this.lastCheckpoint;
            return oLogSequenceNumber;
        }
        finally {
            this.syncObject.unlock();
        }
    }

    private void checkForClose() {
        if (this.closed) {
            throw new OStorageException("WAL has been closed");
        }
    }
}

