/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.LongOperationId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OperationUnitOperationId;
import java.nio.ByteBuffer;

public abstract class OOperationUnitRecord<T>
extends OAbstractWALRecord {
    private T operationUnitId;

    protected OOperationUnitRecord() {
    }

    protected OOperationUnitRecord(T operationUnitId) {
        this.operationUnitId = operationUnitId;
    }

    public T getOperationUnitId() {
        return this.operationUnitId;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        if (this instanceof OperationUnitOperationId) {
            return ((OOperationUnitId)this.operationUnitId).toStream(content, offset);
        }
        if (this instanceof LongOperationId) {
            OLongSerializer.INSTANCE.serializeNative((Long)this.operationUnitId, content, offset, new Object[0]);
            return offset + 8;
        }
        throw new IllegalStateException("Invalid type of operation unit id");
    }

    @Override
    public void toStream(ByteBuffer buffer) {
        if (this instanceof OperationUnitOperationId) {
            ((OOperationUnitId)this.operationUnitId).toStream(buffer);
        } else if (this instanceof LongOperationId) {
            buffer.putLong((Long)this.operationUnitId);
        } else {
            throw new IllegalStateException("Invalid type of operation unit id");
        }
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        if (this instanceof OperationUnitOperationId) {
            OOperationUnitId operationUnitId = new OOperationUnitId();
            int position = operationUnitId.fromStream(content, offset);
            this.operationUnitId = operationUnitId;
            return position;
        }
        if (this instanceof LongOperationId) {
            this.operationUnitId = OLongSerializer.INSTANCE.deserializeNativeObject(content, offset);
            return offset + 8;
        }
        throw new IllegalStateException("Invalid type of operation id");
    }

    @Override
    public int serializedSize() {
        if (this instanceof OperationUnitOperationId) {
            return 16;
        }
        if (this instanceof LongOperationId) {
            return 8;
        }
        throw new IllegalStateException("Invalid type of operation id");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OOperationUnitRecord that = (OOperationUnitRecord)o;
        return this.operationUnitId.equals(that.operationUnitId);
    }

    @Override
    public int hashCode() {
        return this.operationUnitId.hashCode();
    }

    @Override
    public String toString() {
        return this.toString("operationUnitId=" + this.operationUnitId);
    }
}

