/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.statistic;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OOperation;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;

public class OClusterCountersHolder
extends OSessionStoragePerformanceStatistic.PerformanceCountersHolder {
    long createdRecords;
    long timeRecordCreation;
    private long createRecordPages;
    private long createRecordFilePages;
    private long createRecordPageReadTime;
    private long createRecordFilePageReadTime;
    long deletedRecords;
    long timeRecordDeletion;
    private long deleteRecordPages;
    private long deleteRecordFilePages;
    private long deleteRecordPageReadTime = 0L;
    private long deleteRecordFilePageReadTime = 0L;
    long updatedRecords;
    long timeRecordUpdate;
    private long updateRecordPages;
    private long updateRecordFilePages;
    private long updateRecordPageReadTime;
    private long updateRecordFilePageReadTime;
    long readRecords;
    long timeRecordRead;
    private long readRecordPages;
    private long readRecordFilePages;
    private long readRecordPageReadTime;
    private long readRecordFilePageReadTime;

    @Override
    public OClusterCountersHolder newInstance() {
        return new OClusterCountersHolder();
    }

    @Override
    public void clean() {
        super.clean();
        this.createdRecords = 0L;
        this.timeRecordCreation = 0L;
        this.createRecordPages = 0L;
        this.createRecordFilePages = 0L;
        this.createRecordPageReadTime = 0L;
        this.createRecordFilePageReadTime = 0L;
        this.deletedRecords = 0L;
        this.timeRecordDeletion = 0L;
        this.deleteRecordPages = 0L;
        this.deleteRecordFilePages = 0L;
        this.deleteRecordPageReadTime = 0L;
        this.deleteRecordFilePageReadTime = 0L;
        this.updatedRecords = 0L;
        this.timeRecordUpdate = 0L;
        this.updateRecordPages = 0L;
        this.updateRecordFilePages = 0L;
        this.updateRecordPageReadTime = 0L;
        this.updateRecordFilePageReadTime = 0L;
        this.readRecords = 0L;
        this.timeRecordRead = 0L;
        this.readRecordPages = 0L;
        this.readRecordFilePages = 0L;
        this.readRecordPageReadTime = 0L;
        this.readRecordFilePageReadTime = 0L;
    }

    public long getRecordCreationTime() {
        if (this.createdRecords == 0L) {
            return -1L;
        }
        return this.timeRecordCreation / this.createdRecords;
    }

    public long getRecordCreationPages() {
        if (this.createdRecords == 0L) {
            return -1L;
        }
        return this.createRecordPages / this.createdRecords;
    }

    public int getRecordCreationHitRate() {
        if (this.createRecordPages == 0L) {
            return -1;
        }
        return (int)(100L * (this.createRecordPages - this.createRecordFilePages) / this.createRecordPages);
    }

    public long getRecordCreationPageTime() {
        if (this.createRecordPages == 0L) {
            return -1L;
        }
        return this.createRecordPageReadTime / this.createRecordPages;
    }

    public long getRecordCreationFilePageTime() {
        if (this.createRecordFilePages == 0L) {
            return -1L;
        }
        return this.createRecordFilePageReadTime / this.createRecordFilePages;
    }

    public long getRecordDeletionTime() {
        if (this.deletedRecords == 0L) {
            return -1L;
        }
        return this.timeRecordDeletion / this.deletedRecords;
    }

    public long getRecordDeletionPages() {
        if (this.deletedRecords == 0L) {
            return -1L;
        }
        return this.deleteRecordPages / this.deletedRecords;
    }

    public long getRecordDeletionHitRate() {
        if (this.deleteRecordPages == 0L) {
            return -1L;
        }
        return (int)(100L * (this.deleteRecordPages - this.deleteRecordFilePages) / this.deleteRecordPages);
    }

    public long getRecordDeletionPageTime() {
        if (this.deleteRecordPages == 0L) {
            return -1L;
        }
        return this.deleteRecordPageReadTime / this.deleteRecordPages;
    }

    public long getRecordDeletionFilePageTime() {
        if (this.deleteRecordFilePages == 0L) {
            return -1L;
        }
        return this.deleteRecordFilePageReadTime / this.deleteRecordFilePages;
    }

    public long getRecordUpdateTime() {
        if (this.updatedRecords == 0L) {
            return -1L;
        }
        return this.timeRecordUpdate / this.updatedRecords;
    }

    public long getRecordUpdatePages() {
        if (this.updatedRecords == 0L) {
            return -1L;
        }
        return this.updateRecordPages / this.updatedRecords;
    }

    public long getRecordUpdateHitRate() {
        if (this.updateRecordPages == 0L) {
            return -1L;
        }
        return (int)(100L * (this.updateRecordPages - this.updateRecordFilePages) / this.updateRecordPages);
    }

    public long getRecordUpdatePageTime() {
        if (this.updateRecordPages == 0L) {
            return -1L;
        }
        return this.updateRecordPageReadTime / this.updateRecordPages;
    }

    public long getRecordUpdateFilePageTime() {
        if (this.updateRecordFilePages == 0L) {
            return -1L;
        }
        return this.updateRecordFilePageReadTime / this.updateRecordFilePages;
    }

    public long getRecordReadTime() {
        if (this.readRecords == 0L) {
            return -1L;
        }
        return this.timeRecordRead / this.readRecords;
    }

    public long getRecordReadPages() {
        if (this.readRecords == 0L) {
            return -1L;
        }
        return this.readRecordPages / this.readRecords;
    }

    public long getRecordReadHitRate() {
        if (this.readRecordPages == 0L) {
            return -1L;
        }
        return (int)(100L * (this.readRecordPages - this.readRecordFilePages) / this.readRecordPages);
    }

    public long getRecordReadPageTime() {
        if (this.readRecordPages == 0L) {
            return -1L;
        }
        return this.readRecordPageReadTime / this.readRecordPages;
    }

    public long getRecordReadFilePageTime() {
        if (this.readRecordFilePages == 0L) {
            return -1L;
        }
        return this.readRecordFilePageReadTime / this.readRecordFilePages;
    }

    @Override
    public ODocument toDocument() {
        ODocument document = super.toDocument();
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordCreationTime", this.getRecordCreationTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordCreationPages", this.getRecordCreationPages());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordCreationHitRate", this.getRecordCreationHitRate());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordCreationPageTime", this.getRecordCreationPageTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordCreationFilePageTime", this.getRecordCreationFilePageTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordDeletionTime", this.getRecordDeletionTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordDeletionPages", this.getRecordDeletionPages());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordDeletionHitRate", this.getRecordDeletionHitRate());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordDeletionPageTime", this.getRecordDeletionPageTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordDeletionFilePageTime", this.getRecordDeletionFilePageTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordUpdateTime", this.getRecordUpdateTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordUpdatePages", this.getRecordUpdatePages());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordUpdateHitRate", this.getRecordUpdateHitRate());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordUpdatePageTime", this.getRecordUpdatePageTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordUpdateFilePageTime", this.getRecordUpdateFilePageTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordReadTime", this.getRecordReadTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordReadPages", this.getRecordReadPages());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordReadHitRate", this.getRecordReadHitRate());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordReadPageTime", this.getRecordReadPageTime());
        OSessionStoragePerformanceStatistic.writeMetric(document, "recordReadFilePageTime", this.getRecordReadFilePageTime());
        return document;
    }

    public class ReadRecordPages
    extends OOperation {
        @Override
        void incrementOperationsCounter(int pages, int filePages) {
            OClusterCountersHolder oClusterCountersHolder = OClusterCountersHolder.this;
            oClusterCountersHolder.readRecordPages = oClusterCountersHolder.readRecordPages + (long)pages;
            oClusterCountersHolder = OClusterCountersHolder.this;
            oClusterCountersHolder.readRecordFilePages = oClusterCountersHolder.readRecordFilePages + (long)filePages;
        }
    }

    public class DeleteRecordPages
    extends OOperation {
        @Override
        void incrementOperationsCounter(int pages, int filePages) {
            OClusterCountersHolder oClusterCountersHolder = OClusterCountersHolder.this;
            oClusterCountersHolder.deleteRecordPages = oClusterCountersHolder.deleteRecordPages + (long)pages;
            oClusterCountersHolder = OClusterCountersHolder.this;
            oClusterCountersHolder.deleteRecordFilePages = oClusterCountersHolder.deleteRecordFilePages + (long)filePages;
        }
    }

    public class UpdateRecordOperation
    extends OOperation {
        @Override
        void incrementOperationsCounter(int pages, int filePages) {
            OClusterCountersHolder oClusterCountersHolder = OClusterCountersHolder.this;
            oClusterCountersHolder.updateRecordPages = oClusterCountersHolder.updateRecordPages + (long)pages;
            oClusterCountersHolder = OClusterCountersHolder.this;
            oClusterCountersHolder.updateRecordFilePages = oClusterCountersHolder.updateRecordFilePages + (long)filePages;
        }
    }

    public class CreateRecordOperation
    extends OOperation {
        @Override
        void incrementOperationsCounter(int pages, int filePages) {
            OClusterCountersHolder.this.createRecordPages = OClusterCountersHolder.this.createRecordPages + (long)pages;
            OClusterCountersHolder.this.createRecordFilePages = OClusterCountersHolder.this.createRecordFilePages + (long)filePages;
        }
    }
}

