/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.statistic;

import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OWOWCache;
import com.orientechnologies.orient.core.storage.cache.local.twoq.O2QCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManagerMBean;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OPerformanceStatisticManager {
    private static final String MBEAN_PREFIX = "com.orientechnologies.orient.core.storage.impl.local.statistic:type=OPerformanceStatisticManagerMXBean";
    private final long intervalBetweenSnapshots;
    private final long cleanUpInterval;
    private final OReadersWriterSpinLock switchLock = new OReadersWriterSpinLock();
    private volatile boolean enabled = false;
    private final ThreadLocal<Boolean> enabledForCurrentThread = ThreadLocal.withInitial(() -> false);
    private final ConcurrentHashMap<Thread, OSessionStoragePerformanceStatistic> statistics = new ConcurrentHashMap();
    private volatile ImmutableStatistic deadThreadsStatistic;
    private volatile ImmutableStatistic postMeasurementStatistic;
    private final Lock deadThreadsUpdateLock = new ReentrantLock();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();
    private final List<String> componentNames = new CopyOnWriteArrayList<String>();
    private long fullCheckpointCount = -1L;
    private long walSize = -1L;
    private long walCacheOverflowCount = -1L;
    private long readCacheSize = -1L;
    private long writeCacheSize = -1L;
    private long exclusiveWriteCacheSize = 1L;
    private long writeCacheOverflowCount = -1L;
    private final OAbstractPaginatedStorage storage;
    private volatile boolean wowCacheInitialized;
    private volatile OWOWCache wowCache;
    private volatile boolean readCacheInitialized;
    private volatile O2QCache readCache;
    private volatile boolean writeAheadLogInitialized;

    public OPerformanceStatisticManager(OAbstractPaginatedStorage storage, long intervalBetweenSnapshots, long cleanUpInterval) {
        this.intervalBetweenSnapshots = intervalBetweenSnapshots;
        this.cleanUpInterval = cleanUpInterval;
        this.storage = storage;
    }

    private OWOWCache getWowCache() {
        if (this.wowCacheInitialized) {
            return this.wowCache;
        }
        OWriteCache writeCache = this.storage.getWriteCache();
        this.wowCache = writeCache instanceof OWOWCache ? (OWOWCache)writeCache : null;
        this.wowCacheInitialized = true;
        return this.wowCache;
    }

    private O2QCache gerReadCache() {
        if (this.readCacheInitialized) {
            return this.readCache;
        }
        OReadCache cache = this.storage.getReadCache();
        this.readCache = cache instanceof O2QCache ? (O2QCache)cache : null;
        this.readCacheInitialized = true;
        return this.readCache;
    }

    public void startThreadMonitoring() {
        this.switchLock.acquireWriteLock();
        try {
            if (this.enabled) {
                throw new IllegalStateException("Monitoring is already started on system level and can not be started on thread level");
            }
            this.enabledForCurrentThread.set(true);
            this.statistics.put(Thread.currentThread(), new OSessionStoragePerformanceStatistic(this.intervalBetweenSnapshots, Long.MAX_VALUE));
        }
        finally {
            this.switchLock.releaseWriteLock();
        }
    }

    public OSessionStoragePerformanceStatistic stopThreadMonitoring() {
        this.switchLock.acquireWriteLock();
        try {
            this.enabledForCurrentThread.set(false);
            Thread currentThread = Thread.currentThread();
            OSessionStoragePerformanceStatistic oSessionStoragePerformanceStatistic = (OSessionStoragePerformanceStatistic)this.statistics.remove(currentThread);
            return oSessionStoragePerformanceStatistic;
        }
        finally {
            this.switchLock.releaseWriteLock();
        }
    }

    public void startMonitoring() {
        this.switchLock.acquireWriteLock();
        try {
            if (!this.statistics.isEmpty() && !this.enabled) {
                throw new IllegalStateException("Monitoring is already started on thread level and can not be started on system level");
            }
            this.deadThreadsStatistic = null;
            this.postMeasurementStatistic = null;
            this.enabled = true;
        }
        finally {
            this.switchLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring() {
        this.switchLock.acquireWriteLock();
        try {
            this.enabled = false;
            OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
            HashMap<String, OSessionStoragePerformanceStatistic.PerformanceCountersHolder> componentCountersHolder = new HashMap<String, OSessionStoragePerformanceStatistic.PerformanceCountersHolder>();
            OSessionStoragePerformanceStatistic.WritCacheCountersHolder writCacheCountersHolder = this.deadThreadsStatistic.writCacheCountersHolder;
            OSessionStoragePerformanceStatistic.StorageCountersHolder storageCountersHolder = this.deadThreadsStatistic.storageCountersHolder;
            OSessionStoragePerformanceStatistic.WALCountersHolder walCountersHolder = this.deadThreadsStatistic.walCountersHolder;
            this.deadThreadsStatistic.countersHolder.pushData(countersHolder);
            componentCountersHolder.putAll(this.deadThreadsStatistic.countersByComponents);
            this.deadThreadsStatistic = null;
            for (OSessionStoragePerformanceStatistic statistic : this.statistics.values()) {
                statistic.pushSystemCounters(countersHolder);
                statistic.pushComponentCounters(componentCountersHolder);
                writCacheCountersHolder = statistic.pushWriteCacheCounters(writCacheCountersHolder);
                storageCountersHolder = statistic.pushStorageCounters(storageCountersHolder);
                walCountersHolder = statistic.pushWALCounters(walCountersHolder);
            }
            this.statistics.clear();
            this.postMeasurementStatistic = new ImmutableStatistic(countersHolder, componentCountersHolder, writCacheCountersHolder, storageCountersHolder, walCountersHolder);
        }
        finally {
            this.switchLock.releaseWriteLock();
        }
    }

    public void registerMBean(String storageName, int storageId) {
        if (this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanName(storageName, storageId));
                if (!server.isRegistered(mbeanName)) {
                    server.registerMBean(new OPerformanceStatisticManagerMBean(this), mbeanName);
                } else {
                    this.mbeanIsRegistered.set(false);
                    OLogManager.instance().warn((Object)this, "MBean with name %s has already registered. Probably your system was not shutdown correctly or you have several running applications which use OrientDB engine inside", mbeanName.getCanonicalName());
                }
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                throw OException.wrapException(new OStorageException("Error during registration of profiler MBean"), e);
            }
        }
    }

    private String getMBeanName(String storageName, int storageId) {
        return "com.orientechnologies.orient.core.storage.impl.local.statistic:type=OPerformanceStatisticManagerMXBean,name=" + ObjectName.quote(storageName) + ",id=" + storageId;
    }

    public void unregisterMBean(String storageName, int storageId) {
        if (storageName == null) {
            OLogManager.instance().warnNoDb(this, "Can not unregister MBean for performance statistics, storage name is null", new Object[0]);
        }
        if (this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanName(storageName, storageId));
                server.unregisterMBean(mbeanName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
                throw OException.wrapException(new OStorageException("Error during unregistration of profiler MBean"), e);
            }
        }
    }

    public void registerComponent(String component) {
        this.componentNames.add(component);
    }

    public Set<String> getComponentNames() {
        return new HashSet<String>(this.componentNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSessionStoragePerformanceStatistic getSessionPerformanceStatistic() {
        if (!this.enabled && !this.enabledForCurrentThread.get().booleanValue()) {
            return null;
        }
        this.switchLock.acquireReadLock();
        try {
            if (!this.enabled && !this.enabledForCurrentThread.get().booleanValue()) {
                OSessionStoragePerformanceStatistic oSessionStoragePerformanceStatistic = null;
                return oSessionStoragePerformanceStatistic;
            }
            Thread currentThread = Thread.currentThread();
            OSessionStoragePerformanceStatistic performanceStatistic = (OSessionStoragePerformanceStatistic)this.statistics.get(currentThread);
            if (performanceStatistic != null) {
                OSessionStoragePerformanceStatistic oSessionStoragePerformanceStatistic = performanceStatistic;
                return oSessionStoragePerformanceStatistic;
            }
            performanceStatistic = new OSessionStoragePerformanceStatistic(this.intervalBetweenSnapshots, this.enabled ? this.cleanUpInterval : -1L);
            this.statistics.put(currentThread, performanceStatistic);
            OSessionStoragePerformanceStatistic oSessionStoragePerformanceStatistic = performanceStatistic;
            return oSessionStoragePerformanceStatistic;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAmountOfPagesPerOperation(String componentName) {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder componentCountersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchComponentCounters(componentName, componentCountersHolder);
                long l = componentCountersHolder.getAmountOfPagesPerOperation();
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.PerformanceCountersHolder holder = post.countersByComponents.get(componentName);
            if (holder == null) {
                long l = -1L;
                return l;
            }
            long l = holder.getAmountOfPagesPerOperation();
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    public int getCacheHits() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchSystemCounters(countersHolder);
                int n = countersHolder.getCacheHits();
                return n;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                int n = -1;
                return n;
            }
            int n = post.countersHolder.getCacheHits();
            return n;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheHits(String componentName) {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchComponentCounters(componentName, countersHolder);
                int n = countersHolder.getCacheHits();
                return n;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                int n = -1;
                return n;
            }
            OSessionStoragePerformanceStatistic.PerformanceCountersHolder holder = post.countersByComponents.get(componentName);
            if (holder != null) {
                int n = holder.getCacheHits();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCommitTime() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchSystemCounters(countersHolder);
                long l = countersHolder.getCommitTime();
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            long l = post.countersHolder.getCommitTime();
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReadSpeedFromCacheInPages() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchSystemCounters(countersHolder);
                long l = countersHolder.getReadSpeedFromCacheInPages();
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            long l = post.countersHolder.getReadSpeedFromCacheInPages();
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReadSpeedFromCacheInPages(String componentName) {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchComponentCounters(componentName, countersHolder);
                long l = countersHolder.getReadSpeedFromCacheInPages();
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.PerformanceCountersHolder holder = post.countersByComponents.get(componentName);
            if (holder == null) {
                long l = -1L;
                return l;
            }
            long l = holder.getReadSpeedFromCacheInPages();
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReadSpeedFromFileInPages() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchSystemCounters(countersHolder);
                long l = countersHolder.getReadSpeedFromFileInPages();
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            long l = post.countersHolder.getReadSpeedFromFileInPages();
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReadSpeedFromFileInPages(String componentName) {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchComponentCounters(componentName, countersHolder);
                long l = countersHolder.getReadSpeedFromFileInPages();
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.PerformanceCountersHolder holder = post.countersByComponents.get(componentName);
            if (holder == null) {
                long l = -1L;
                return l;
            }
            long l = holder.getReadSpeedFromFileInPages();
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteSpeedInCacheInPages() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchSystemCounters(countersHolder);
                long l = countersHolder.getWriteSpeedInCacheInPages();
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            long l = post.countersHolder.getWriteSpeedInCacheInPages();
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteSpeedInCacheInPages(String componentName) {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
                this.fetchComponentCounters(componentName, countersHolder);
                long l = countersHolder.getWriteSpeedInCacheInPages();
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.PerformanceCountersHolder holder = post.countersByComponents.get(componentName);
            if (holder == null) {
                long l = -1L;
                return l;
            }
            long l = holder.getWriteSpeedInCacheInPages();
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteCachePagesPerFlush() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.WritCacheCountersHolder holder = this.fetchWriteCacheCounters();
                if (holder != null) {
                    long l = holder.getPagesPerFlush();
                    return l;
                }
                long l = -1L;
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.WritCacheCountersHolder holder = post.writCacheCountersHolder;
            if (holder != null) {
                long l = holder.getPagesPerFlush();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteCacheFlushOperationsTime() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.WritCacheCountersHolder holder = this.fetchWriteCacheCounters();
                if (holder != null) {
                    long l = holder.getFlushOperationsTime();
                    return l;
                }
                long l = -1L;
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.WritCacheCountersHolder holder = post.writCacheCountersHolder;
            if (holder != null) {
                long l = holder.getFlushOperationsTime();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteCacheFuzzyCheckpointTime() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.WritCacheCountersHolder holder = this.fetchWriteCacheCounters();
                if (holder != null) {
                    long l = holder.getFuzzyCheckpointTime();
                    return l;
                }
                long l = -1L;
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.WritCacheCountersHolder holder = post.writCacheCountersHolder;
            if (holder != null) {
                long l = holder.getFuzzyCheckpointTime();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFullCheckpointTime() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.StorageCountersHolder holder = this.fetchStorageCounters();
                if (holder != null) {
                    long l = holder.getFullCheckpointTime();
                    return l;
                }
                long l = -1L;
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.StorageCountersHolder holder = post.storageCountersHolder;
            if (holder != null) {
                long l = holder.getFullCheckpointTime();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    public long getFullCheckpointCount() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                long l = this.fullCheckpointCount = this.storage.getFullCheckpointCount();
                return l;
            }
            long l = this.fullCheckpointCount;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReadCacheSize() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                O2QCache cache = this.gerReadCache();
                if (cache != null) {
                    this.readCacheSize = cache.getUsedMemory();
                }
                long l = this.readCacheSize;
                return l;
            }
            long l = this.readCacheSize;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteCacheSize() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OWOWCache cache = this.getWowCache();
                if (cache != null) {
                    this.writeCacheSize = cache.getWriteCacheSize();
                }
                long l = this.writeCacheSize;
                return l;
            }
            long l = this.writeCacheSize;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExclusiveWriteCacheSize() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OWOWCache cache = this.getWowCache();
                if (cache != null) {
                    this.exclusiveWriteCacheSize = cache.getExclusiveWriteCacheSize();
                }
                long l = this.exclusiveWriteCacheSize;
                return l;
            }
            long l = this.exclusiveWriteCacheSize;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWriteCacheOverflowCount() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OWOWCache cache = this.getWowCache();
                if (cache != null) {
                    this.writeCacheOverflowCount = cache.getCacheOverflowCount();
                }
                long l = this.writeCacheOverflowCount;
                return l;
            }
            long l = this.writeCacheOverflowCount;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWALLogRecordTime() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.WALCountersHolder holder = this.fetchWALCounters();
                if (holder != null) {
                    long l = holder.getLogTime();
                    return l;
                }
                long l = -1L;
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.WALCountersHolder holder = post.walCountersHolder;
            if (holder != null) {
                long l = holder.getLogTime();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWALStartAOLogRecordTime() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.WALCountersHolder holder = this.fetchWALCounters();
                if (holder != null) {
                    long l = holder.getStartAOTime();
                    return l;
                }
                long l = -1L;
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.WALCountersHolder holder = post.walCountersHolder;
            if (holder != null) {
                long l = holder.getStartAOTime();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWALStopAOLogRecordTime() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.WALCountersHolder holder = this.fetchWALCounters();
                if (holder != null) {
                    long l = holder.getStopAOTime();
                    return l;
                }
                long l = -1L;
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.WALCountersHolder holder = post.walCountersHolder;
            if (holder != null) {
                long l = holder.getStopAOTime();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWALFlushTime() {
        this.switchLock.acquireReadLock();
        try {
            if (this.enabled) {
                OSessionStoragePerformanceStatistic.WALCountersHolder holder = this.fetchWALCounters();
                if (holder != null) {
                    long l = holder.getFlushTime();
                    return l;
                }
                long l = -1L;
                return l;
            }
            ImmutableStatistic post = this.postMeasurementStatistic;
            if (post == null) {
                long l = -1L;
                return l;
            }
            OSessionStoragePerformanceStatistic.WALCountersHolder holder = post.walCountersHolder;
            if (holder != null) {
                long l = holder.getFlushTime();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.switchLock.releaseReadLock();
        }
    }

    private OSessionStoragePerformanceStatistic.WritCacheCountersHolder fetchWriteCacheCounters() {
        OSessionStoragePerformanceStatistic.WritCacheCountersHolder writCacheCountersHolder;
        ImmutableStatistic immutableStatistic;
        ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>> snapshots = new ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>>(this.statistics.size());
        ArrayList<Thread> threadsToRemove = new ArrayList<Thread>();
        for (Map.Entry entry : this.statistics.entrySet()) {
            Thread thread = (Thread)entry.getKey();
            OSessionStoragePerformanceStatistic statistic = (OSessionStoragePerformanceStatistic)entry.getValue();
            snapshots.add(new ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>(thread, statistic.getSnapshot()));
        }
        OSessionStoragePerformanceStatistic.WritCacheCountersHolder holder = null;
        for (ORawPair oRawPair : snapshots) {
            Thread thread = (Thread)oRawPair.getFirst();
            if (thread.isAlive()) {
                OSessionStoragePerformanceStatistic.PerformanceSnapshot snapshot = (OSessionStoragePerformanceStatistic.PerformanceSnapshot)oRawPair.getSecond();
                if (snapshot.writCacheCountersHolder == null) continue;
                if (holder == null) {
                    holder = new OSessionStoragePerformanceStatistic.WritCacheCountersHolder();
                }
                snapshot.writCacheCountersHolder.pushData(holder);
                continue;
            }
            threadsToRemove.add(thread);
        }
        if (!threadsToRemove.isEmpty()) {
            this.updateDeadThreadsStatistic(threadsToRemove);
        }
        if ((immutableStatistic = this.deadThreadsStatistic) != null && (writCacheCountersHolder = immutableStatistic.writCacheCountersHolder) != null) {
            if (holder == null) {
                holder = new OSessionStoragePerformanceStatistic.WritCacheCountersHolder();
            }
            writCacheCountersHolder.pushData(holder);
        }
        return holder;
    }

    private OSessionStoragePerformanceStatistic.StorageCountersHolder fetchStorageCounters() {
        OSessionStoragePerformanceStatistic.StorageCountersHolder storageCountersHolder;
        ImmutableStatistic immutableStatistic;
        ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>> snapshots = new ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>>(this.statistics.size());
        ArrayList<Thread> threadsToRemove = new ArrayList<Thread>();
        for (Map.Entry entry : this.statistics.entrySet()) {
            Thread thread = (Thread)entry.getKey();
            OSessionStoragePerformanceStatistic statistic = (OSessionStoragePerformanceStatistic)entry.getValue();
            snapshots.add(new ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>(thread, statistic.getSnapshot()));
        }
        OSessionStoragePerformanceStatistic.StorageCountersHolder holder = null;
        for (ORawPair oRawPair : snapshots) {
            Thread thread = (Thread)oRawPair.getFirst();
            if (thread.isAlive()) {
                OSessionStoragePerformanceStatistic.PerformanceSnapshot snapshot = (OSessionStoragePerformanceStatistic.PerformanceSnapshot)oRawPair.getSecond();
                if (snapshot.storageCountersHolder == null) continue;
                if (holder == null) {
                    holder = new OSessionStoragePerformanceStatistic.StorageCountersHolder();
                }
                snapshot.storageCountersHolder.pushData(holder);
                continue;
            }
            threadsToRemove.add(thread);
        }
        if (!threadsToRemove.isEmpty()) {
            this.updateDeadThreadsStatistic(threadsToRemove);
        }
        if ((immutableStatistic = this.deadThreadsStatistic) != null && (storageCountersHolder = immutableStatistic.storageCountersHolder) != null) {
            if (holder == null) {
                holder = new OSessionStoragePerformanceStatistic.StorageCountersHolder();
            }
            storageCountersHolder.pushData(holder);
        }
        return holder;
    }

    private OSessionStoragePerformanceStatistic.WALCountersHolder fetchWALCounters() {
        OSessionStoragePerformanceStatistic.WALCountersHolder wALCountersHolder;
        ImmutableStatistic immutableStatistic;
        ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>> snapshots = new ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>>(this.statistics.size());
        ArrayList<Thread> threadsToRemove = new ArrayList<Thread>();
        for (Map.Entry entry : this.statistics.entrySet()) {
            Thread thread = (Thread)entry.getKey();
            OSessionStoragePerformanceStatistic statistic = (OSessionStoragePerformanceStatistic)entry.getValue();
            snapshots.add(new ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>(thread, statistic.getSnapshot()));
        }
        OSessionStoragePerformanceStatistic.WALCountersHolder holder = null;
        for (ORawPair oRawPair : snapshots) {
            Thread thread = (Thread)oRawPair.getFirst();
            if (thread.isAlive()) {
                OSessionStoragePerformanceStatistic.PerformanceSnapshot snapshot = (OSessionStoragePerformanceStatistic.PerformanceSnapshot)oRawPair.getSecond();
                if (snapshot.walCountersHolder == null) continue;
                if (holder == null) {
                    holder = new OSessionStoragePerformanceStatistic.WALCountersHolder();
                }
                snapshot.walCountersHolder.pushData(holder);
                continue;
            }
            threadsToRemove.add(thread);
        }
        if (!threadsToRemove.isEmpty()) {
            this.updateDeadThreadsStatistic(threadsToRemove);
        }
        if ((immutableStatistic = this.deadThreadsStatistic) != null && (wALCountersHolder = immutableStatistic.walCountersHolder) != null) {
            if (holder == null) {
                holder = new OSessionStoragePerformanceStatistic.WALCountersHolder();
            }
            wALCountersHolder.pushData(holder);
        }
        return holder;
    }

    private void fetchSystemCounters(OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder) {
        ImmutableStatistic ds;
        Thread thread;
        ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>> snapshots = new ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>>(this.statistics.size());
        ArrayList<Thread> threadsToRemove = new ArrayList<Thread>();
        for (Map.Entry entry : this.statistics.entrySet()) {
            thread = (Thread)entry.getKey();
            OSessionStoragePerformanceStatistic statistic = (OSessionStoragePerformanceStatistic)entry.getValue();
            snapshots.add(new ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>(thread, statistic.getSnapshot()));
        }
        for (ORawPair oRawPair : snapshots) {
            thread = (Thread)oRawPair.getFirst();
            if (thread.isAlive()) {
                OSessionStoragePerformanceStatistic.PerformanceSnapshot snapshot = (OSessionStoragePerformanceStatistic.PerformanceSnapshot)oRawPair.getSecond();
                snapshot.performanceCountersHolder.pushData(countersHolder);
                continue;
            }
            threadsToRemove.add(thread);
        }
        if (!threadsToRemove.isEmpty()) {
            this.updateDeadThreadsStatistic(threadsToRemove);
        }
        if ((ds = this.deadThreadsStatistic) != null) {
            OSessionStoragePerformanceStatistic.PerformanceCountersHolder performanceCountersHolder = ds.countersHolder;
            performanceCountersHolder.pushData(countersHolder);
        }
    }

    private void fetchComponentCounters(String componentName, OSessionStoragePerformanceStatistic.PerformanceCountersHolder componentCountersHolder) {
        OSessionStoragePerformanceStatistic.PerformanceCountersHolder performanceCountersHolder;
        ImmutableStatistic ds;
        Thread thread;
        ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>> snapshots = new ArrayList<ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>>(this.statistics.size());
        ArrayList<Thread> threadsToRemove = new ArrayList<Thread>();
        for (Map.Entry entry : this.statistics.entrySet()) {
            thread = (Thread)entry.getKey();
            OSessionStoragePerformanceStatistic statistic = (OSessionStoragePerformanceStatistic)entry.getValue();
            snapshots.add(new ORawPair<Thread, OSessionStoragePerformanceStatistic.PerformanceSnapshot>(thread, statistic.getSnapshot()));
        }
        for (ORawPair oRawPair : snapshots) {
            thread = (Thread)oRawPair.getFirst();
            if (thread.isAlive()) {
                OSessionStoragePerformanceStatistic.PerformanceSnapshot snapshot = (OSessionStoragePerformanceStatistic.PerformanceSnapshot)oRawPair.getSecond();
                OSessionStoragePerformanceStatistic.PerformanceCountersHolder holder = snapshot.countersByComponent.get(componentName);
                if (holder == null) continue;
                holder.pushData(componentCountersHolder);
                continue;
            }
            threadsToRemove.add(thread);
        }
        if (!threadsToRemove.isEmpty()) {
            this.updateDeadThreadsStatistic(threadsToRemove);
        }
        if ((ds = this.deadThreadsStatistic) != null && (performanceCountersHolder = ds.countersByComponents.get(componentName)) != null) {
            performanceCountersHolder.pushData(componentCountersHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeadThreadsStatistic(Collection<Thread> threadsToRemove) {
        this.deadThreadsUpdateLock.lock();
        try {
            ImmutableStatistic oldDS = this.deadThreadsStatistic;
            OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder = OSessionStoragePerformanceStatistic.ComponentType.GENERAL.newCountersHolder();
            HashMap<String, OSessionStoragePerformanceStatistic.PerformanceCountersHolder> countersByComponents = new HashMap<String, OSessionStoragePerformanceStatistic.PerformanceCountersHolder>();
            OSessionStoragePerformanceStatistic.WritCacheCountersHolder writeCacheCountersHolder = null;
            OSessionStoragePerformanceStatistic.StorageCountersHolder storageCountersHolder = null;
            OSessionStoragePerformanceStatistic.WALCountersHolder walCountersHolder = null;
            if (oldDS != null) {
                oldDS.countersHolder.pushData(countersHolder);
                for (Map.Entry entry : oldDS.countersByComponents.entrySet()) {
                    OSessionStoragePerformanceStatistic.PerformanceCountersHolder holder = ((OSessionStoragePerformanceStatistic.PerformanceCountersHolder)entry.getValue()).newInstance();
                    ((OSessionStoragePerformanceStatistic.PerformanceCountersHolder)entry.getValue()).pushData(holder);
                    countersByComponents.put((String)entry.getKey(), holder);
                }
                if (oldDS.writCacheCountersHolder != null) {
                    writeCacheCountersHolder = new OSessionStoragePerformanceStatistic.WritCacheCountersHolder();
                    oldDS.writCacheCountersHolder.pushData(writeCacheCountersHolder);
                }
                if (oldDS.storageCountersHolder != null) {
                    storageCountersHolder = new OSessionStoragePerformanceStatistic.StorageCountersHolder();
                    oldDS.storageCountersHolder.pushData(storageCountersHolder);
                }
                if (oldDS.walCountersHolder != null) {
                    walCountersHolder = new OSessionStoragePerformanceStatistic.WALCountersHolder();
                    oldDS.walCountersHolder.pushData(walCountersHolder);
                }
            }
            for (Thread thread : threadsToRemove) {
                OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = (OSessionStoragePerformanceStatistic)this.statistics.remove(thread);
                if (sessionStoragePerformanceStatistic == null) continue;
                sessionStoragePerformanceStatistic.pushSystemCounters(countersHolder);
                sessionStoragePerformanceStatistic.pushComponentCounters(countersByComponents);
                writeCacheCountersHolder = sessionStoragePerformanceStatistic.pushWriteCacheCounters(writeCacheCountersHolder);
                storageCountersHolder = sessionStoragePerformanceStatistic.pushStorageCounters(storageCountersHolder);
                walCountersHolder = sessionStoragePerformanceStatistic.pushWALCounters(walCountersHolder);
            }
            this.deadThreadsStatistic = new ImmutableStatistic(countersHolder, countersByComponents, writeCacheCountersHolder, storageCountersHolder, walCountersHolder);
        }
        finally {
            this.deadThreadsUpdateLock.unlock();
        }
    }

    private final class ImmutableStatistic {
        final OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder;
        final Map<String, OSessionStoragePerformanceStatistic.PerformanceCountersHolder> countersByComponents;
        final OSessionStoragePerformanceStatistic.WritCacheCountersHolder writCacheCountersHolder;
        final OSessionStoragePerformanceStatistic.StorageCountersHolder storageCountersHolder;
        final OSessionStoragePerformanceStatistic.WALCountersHolder walCountersHolder;

        public ImmutableStatistic(OSessionStoragePerformanceStatistic.PerformanceCountersHolder countersHolder, Map<String, OSessionStoragePerformanceStatistic.PerformanceCountersHolder> countersByComponents, OSessionStoragePerformanceStatistic.WritCacheCountersHolder writCacheCountersHolder, OSessionStoragePerformanceStatistic.StorageCountersHolder storageCountersHolder, OSessionStoragePerformanceStatistic.WALCountersHolder walCountersHolder) {
            this.countersHolder = countersHolder;
            this.countersByComponents = countersByComponents;
            this.writCacheCountersHolder = writCacheCountersHolder;
            this.storageCountersHolder = storageCountersHolder;
            this.walCountersHolder = walCountersHolder;
        }
    }
}

