/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.types.OModifiableLong;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OTooBigIndexKeyException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTree;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.OCellBTreeMultiValue;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueException;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2Bucket;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2EntryPoint;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.CellBTreeMultiValueV2NullBucket;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.MapEntry;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.MultiValueEntry;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.MultiValueEntrySerializer;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.OEntryPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class CellBTreeMultiValueV2<K>
extends ODurableComponent
implements OCellBTreeMultiValue<K> {
    private static final int M_ID_BATCH_SIZE = 131072;
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final int ENTRY_POINT_INDEX = 0;
    private static final long ROOT_INDEX = 1L;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private final String containerExtension;
    private long fileId;
    private long nullBucketFileId;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;
    private OEncryption encryption;
    private OSBTree<MultiValueEntry, Byte> multiContainer;
    private final OModifiableLong mIdCounter = new OModifiableLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellBTreeMultiValueV2(String name, String dataFileExtension, String nullFileExtension, String containerExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
            this.containerExtension = containerExtension;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer<K> keySerializer, OType[] keyTypes, int keySize, OEncryption encryption) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                this.keySize = keySize;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.encryption = encryption;
                this.keySerializer = keySerializer;
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullFileExtension);
                OCacheEntry entryPointCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    CellBTreeMultiValueV2EntryPoint entryPoint = new CellBTreeMultiValueV2EntryPoint(entryPointCacheEntry);
                    entryPoint.init();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
                }
                OCacheEntry rootCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    CellBTreeMultiValueV2Bucket rootBucket = new CellBTreeMultiValueV2Bucket(rootCacheEntry);
                    rootBucket.init(true);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rootCacheEntry);
                }
                OCacheEntry nullBucketEntry = this.addPage(atomicOperation, this.nullBucketFileId);
                try {
                    CellBTreeMultiValueV2NullBucket nullBucket = new CellBTreeMultiValueV2NullBucket(nullBucketEntry);
                    nullBucket.init(this.incrementMId(atomicOperation));
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, nullBucketEntry);
                }
                this.multiContainer = new OSBTree(this.getName(), this.containerExtension, null, this.storage);
                this.multiContainer.create(atomicOperation, MultiValueEntrySerializer.INSTANCE, OByteSerializer.INSTANCE, null, 1, false, null);
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<ORID> get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 38[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fetchValues(int itemIndex, List<ORID> result, CellBTreeMultiValueV2Bucket<K> bucket) {
        CellBTreeMultiValueV2Bucket.LeafEntry entry = bucket.getLeafEntry(itemIndex, this.keySerializer, this.encryption != null);
        result.addAll(entry.values);
        if (entry.values.size() < entry.entriesCount) {
            OSBTree.OSBTreeCursor<MultiValueEntry, Byte> cursor = this.multiContainer.iterateEntriesBetween(new MultiValueEntry(entry.mId, 0, 0L), true, new MultiValueEntry(entry.mId, Integer.MAX_VALUE, Long.MAX_VALUE), true, true);
            Map.Entry<MultiValueEntry, Byte> cursorEntry = cursor.next(-1);
            while (cursorEntry != null) {
                MultiValueEntry multiValueEntry = cursorEntry.getKey();
                result.add(new ORecordId(multiValueEntry.clusterId, multiValueEntry.clusterPosition));
                cursorEntry = cursor.next(-1);
            }
        }
    }

    private void fetchMapEntries(int itemIndex, K key, List<Map.Entry<K, ORID>> result, CellBTreeMultiValueV2Bucket<K> bucket) {
        CellBTreeMultiValueV2Bucket.LeafEntry entry = bucket.getLeafEntry(itemIndex, this.keySerializer, this.encryption != null);
        this.fetchMapEntriesFromLeafEntry(key, result, entry);
    }

    private void fetchMapEntriesFromLeafEntry(K key, List<Map.Entry<K, ORID>> result, CellBTreeMultiValueV2Bucket.LeafEntry entry) {
        for (ORID rid : entry.values) {
            result.add(new MapEntry<K>(key, rid));
        }
        if (entry.values.size() < entry.entriesCount) {
            OSBTree.OSBTreeCursor<MultiValueEntry, Byte> cursor = this.multiContainer.iterateEntriesBetween(new MultiValueEntry(entry.mId, 0, 0L), true, new MultiValueEntry(entry.mId, Integer.MAX_VALUE, Long.MAX_VALUE), true, true);
            Map.Entry<MultiValueEntry, Byte> cursorEntry = cursor.next(-1);
            while (cursorEntry != null) {
                MultiValueEntry multiValueEntry = cursorEntry.getKey();
                result.add(new MapEntry<K>(key, new ORecordId(multiValueEntry.clusterId, multiValueEntry.clusterPosition)));
                cursorEntry = cursor.next(-1);
            }
        }
    }

    @Override
    public void put(OAtomicOperation atomicOperation, K key, ORID value) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            block13: {
                this.acquireExclusiveLock();
                try {
                    if (key != null) {
                        boolean isNew;
                        int insertionIndex;
                        Object preProcessedKey = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                        byte[] serializedKey = this.keySerializer.serializeNativeAsWhole(preProcessedKey, (Object[])this.keyTypes);
                        if (this.keySize > MAX_KEY_SIZE) {
                            throw new OTooBigIndexKeyException("Key size is more than allowed, operation was canceled. Current key size " + this.keySize + ", allowed  " + MAX_KEY_SIZE, this.getName());
                        }
                        UpdateBucketSearchResult bucketSearchResult = this.findBucketForUpdate(preProcessedKey, atomicOperation);
                        OCacheEntry keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
                        CellBTreeMultiValueV2Bucket keyBucket = new CellBTreeMultiValueV2Bucket(keyBucketCacheEntry);
                        byte[] keyToInsert = this.serializeKey(serializedKey);
                        if (bucketSearchResult.itemIndex >= 0) {
                            insertionIndex = bucketSearchResult.itemIndex;
                            isNew = false;
                        } else {
                            insertionIndex = -bucketSearchResult.itemIndex - 1;
                            isNew = true;
                        }
                        while (!this.addEntry(keyBucket, insertionIndex, isNew, keyToInsert, value, atomicOperation)) {
                            bucketSearchResult = this.splitBucket(keyBucket, keyBucketCacheEntry, bucketSearchResult.path, bucketSearchResult.insertionIndexes, insertionIndex, preProcessedKey, atomicOperation);
                            insertionIndex = bucketSearchResult.itemIndex;
                            long pageIndex = bucketSearchResult.getLastPathItem();
                            if (pageIndex != keyBucketCacheEntry.getPageIndex()) {
                                this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                                keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                            }
                            keyBucket = new CellBTreeMultiValueV2Bucket(keyBucketCacheEntry);
                        }
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                        this.updateSize(1L, atomicOperation);
                        break block13;
                    }
                    OCacheEntry nullCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                    try {
                        CellBTreeMultiValueV2NullBucket nullBucket = new CellBTreeMultiValueV2NullBucket(nullCacheEntry);
                        long result = nullBucket.addValue(value);
                        if (result >= 0L) {
                            this.multiContainer.validatedPut(atomicOperation, new MultiValueEntry(result, value.getClusterId(), value.getClusterPosition()), (byte)1, (k, ov, v) -> {
                                if (ov != null) {
                                    return OBaseIndexEngine.Validator.IGNORE;
                                }
                                nullBucket.incrementSize();
                                return v;
                            });
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, nullCacheEntry);
                    }
                    this.updateSize(1L, atomicOperation);
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
        });
    }

    private boolean addEntry(CellBTreeMultiValueV2Bucket<K> bucketMultiValue, int index, boolean isNew, byte[] key, ORID value, OAtomicOperation atomicOperation) throws IOException {
        if (isNew) {
            long mId = this.incrementMId(atomicOperation);
            return bucketMultiValue.createMainLeafEntry(index, key, value, mId);
        }
        long result = bucketMultiValue.appendNewLeafEntry(index, value);
        if (result >= 0L) {
            this.multiContainer.validatedPut(atomicOperation, new MultiValueEntry(result, value.getClusterId(), value.getClusterPosition()), (byte)1, (k, ov, v) -> {
                if (ov != null) {
                    return OBaseIndexEngine.Validator.IGNORE;
                }
                bucketMultiValue.incrementEntriesCount(index);
                return v;
            });
            return true;
        }
        return result == -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementMId(OAtomicOperation atomicOperation) throws IOException {
        long idCounter = this.mIdCounter.getValue();
        if ((idCounter & 0x1FFFFL) == 0L) {
            OCacheEntry cacheEntryPoint = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
            try {
                CellBTreeMultiValueV2EntryPoint entryPoint = new CellBTreeMultiValueV2EntryPoint(cacheEntryPoint);
                entryPoint.setEntryId(idCounter + 131072L);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntryPoint);
            }
        }
        this.mIdCounter.setValue(idCounter + 1L);
        return idCounter + 1L;
    }

    @Override
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.readCache.closeFile(this.fileId, true, this.writeCache);
            this.readCache.closeFile(this.nullBucketFileId, true, this.writeCache);
            this.multiContainer.close();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void clear(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
                try {
                    OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
                    entryPoint.init();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
                }
                OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 1L, false, true);
                try {
                    CellBTreeMultiValueV2Bucket rootBucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
                    rootBucket.init(true);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
                OCacheEntry nullBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                try {
                    CellBTreeMultiValueV2NullBucket nullBucket = new CellBTreeMultiValueV2NullBucket(nullBucketCacheEntry);
                    nullBucket.init(nullBucket.getMid());
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, nullBucketCacheEntry);
                }
                this.multiContainer.clear(atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                this.deleteFile(atomicOperation, this.nullBucketFileId);
                this.multiContainer.delete(atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public void deleteWithoutLoad(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    long fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, fileId);
                }
                if (this.isFileExists(atomicOperation, this.getName() + this.nullFileExtension)) {
                    long nullFileId = this.openFile(atomicOperation, this.getName() + this.nullFileExtension);
                    this.deleteFile(atomicOperation, nullFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String name, int keySize, OType[] keyTypes, OBinarySerializer<K> keySerializer, OEncryption encryption) {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullFileExtension);
            this.keySize = keySize;
            this.keyTypes = keyTypes;
            this.encryption = encryption;
            this.keySerializer = keySerializer;
            this.multiContainer = new OSBTree(this.getName(), this.containerExtension, null, this.storage);
            this.multiContainer.load(this.getName(), MultiValueEntrySerializer.INSTANCE, OByteSerializer.INSTANCE, null, 1, false, null);
            OCacheEntry entryPointCacheEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
            try {
                CellBTreeMultiValueV2EntryPoint entryPoint = new CellBTreeMultiValueV2EntryPoint(entryPointCacheEntry);
                this.mIdCounter.setValue(entryPoint.getEntryId());
            }
            finally {
                this.releasePageFromRead(atomicOperation, entryPointCacheEntry);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new CellBTreeMultiValueException("Exception during loading of sbtree " + name, this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(OAtomicOperation atomicOperation, K key) {
        boolean removed = false;
        this.acquireExclusiveLock();
        try {
            OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> cursor = this.iterateEntriesBetween(key, true, key, true, true);
            Map.Entry<K, ORID> cursorEntry = cursor.next(-1);
            while (cursorEntry != null) {
                boolean entryRemoved = this.remove(atomicOperation, cursorEntry.getKey(), cursorEntry.getValue());
                removed = removed || entryRemoved;
                cursorEntry = cursor.next(-1);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        return removed;
    }

    @Override
    public boolean remove(OAtomicOperation atomicOperation, K key, ORID value) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            boolean removed;
            block33: {
                this.acquireExclusiveLock();
                try {
                    if (key != null) {
                        int size;
                        CellBTreeMultiValueV2Bucket bucket;
                        Object preProcessedKey = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                        int serializeKeySize = this.keySerializer.getObjectSize(preProcessedKey, new Object[0]) + (this.encryption == null ? 0 : 4);
                        BucketSearchResult bucketSearchResult = this.findBucket(preProcessedKey, atomicOperation);
                        if (bucketSearchResult.itemIndex < 0) {
                            Boolean bl = false;
                            return bl;
                        }
                        long pageIndex = bucketSearchResult.pageIndex;
                        int itemIndex = bucketSearchResult.itemIndex;
                        long leftSibling = -1L;
                        long rightSibling = -1L;
                        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                        try {
                            bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
                            removed = this.removeEntry(atomicOperation, itemIndex, serializeKeySize, value, bucket);
                            if (!removed) {
                                if (itemIndex == 0) {
                                    leftSibling = bucket.getLeftSibling();
                                }
                                if (itemIndex == bucket.size() - 1) {
                                    rightSibling = bucket.getRightSibling();
                                }
                            }
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, cacheEntry);
                        }
                        while (!removed && leftSibling >= 0L) {
                            cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, leftSibling, false, true);
                            try {
                                bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
                                size = bucket.size();
                                if (size > 0) {
                                    removed = this.removeEntry(atomicOperation, size - 1, this.keySize, value, bucket);
                                    if (removed) continue;
                                    if (size <= 1) {
                                        leftSibling = bucket.getLeftSibling();
                                        continue;
                                    }
                                    leftSibling = -1L;
                                    continue;
                                }
                                leftSibling = bucket.getLeftSibling();
                            }
                            finally {
                                this.releasePageFromWrite(atomicOperation, cacheEntry);
                            }
                        }
                        while (!removed && rightSibling >= 0L) {
                            cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, rightSibling, false, true);
                            try {
                                bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
                                size = bucket.size();
                                if (size > 0) {
                                    removed = this.removeEntry(atomicOperation, 0, serializeKeySize, value, bucket);
                                    if (removed) continue;
                                    if (size <= 1) {
                                        rightSibling = bucket.getRightSibling();
                                        continue;
                                    }
                                    rightSibling = -1L;
                                    continue;
                                }
                                rightSibling = bucket.getRightSibling();
                            }
                            finally {
                                this.releasePageFromWrite(atomicOperation, cacheEntry);
                            }
                        }
                        if (removed) {
                            this.updateSize(-1L, atomicOperation);
                        }
                        break block33;
                    }
                    OCacheEntry nullBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                    try {
                        CellBTreeMultiValueV2NullBucket nullBucket = new CellBTreeMultiValueV2NullBucket(nullBucketCacheEntry);
                        int result = nullBucket.removeValue(value);
                        if (result == 0) {
                            boolean bl = removed = this.multiContainer.remove(atomicOperation, new MultiValueEntry(nullBucket.getMid(), value.getClusterId(), value.getClusterPosition())) != null;
                            if (removed) {
                                nullBucket.decrementSize();
                            }
                        } else {
                            removed = result == 1;
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, nullBucketCacheEntry);
                    }
                    if (removed) {
                        this.updateSize(-1L, atomicOperation);
                    }
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
            return removed;
        });
    }

    private boolean removeEntry(OAtomicOperation atomicOperation, int itemIndex, int keySize, ORID value, CellBTreeMultiValueV2Bucket<K> bucket) {
        boolean removed;
        int entriesCount = bucket.removeLeafEntry(itemIndex, value);
        if (entriesCount == 0) {
            bucket.removeMainLeafEntry(itemIndex, keySize);
        }
        boolean bl = removed = entriesCount >= 0;
        if (!removed && bucket.hasExternalEntries(itemIndex)) {
            long mId = bucket.getMid(itemIndex);
            boolean bl2 = removed = this.multiContainer.remove(atomicOperation, new MultiValueEntry(mId, value.getClusterId(), value.getClusterPosition())) != null;
            if (removed && bucket.decrementEntriesCount(itemIndex)) {
                bucket.removeMainLeafEntry(itemIndex, keySize);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (ascSortOrder) break block8;
                    oCellBTreeCursor = this.iterateEntriesMinorDesc(key, inclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oCellBTreeCursor;
            }
            OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor = this.iterateEntriesMinorAsc(key, inclusive);
            this.releaseSharedLock();
            return oCellBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    oCellBTreeCursor = this.iterateEntriesMajorAsc(key, inclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oCellBTreeCursor;
            }
            OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor = this.iterateEntriesMajorDesc(key, inclusive);
            this.releaseSharedLock();
            return oCellBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCellBTreeMultiValue.OCellBTreeKeyCursor<K> keyCursor() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            BucketSearchResult searchResult;
            block10: {
                OCellBTreeMultiValue.OCellBTreeKeyCursor<Object> oCellBTreeKeyCursor;
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    searchResult = this.firstItem(atomicOperation);
                    if (searchResult != null) break block10;
                    oCellBTreeKeyCursor = prefetchSize -> null;
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw OException.wrapException(new CellBTreeMultiValueException("Error during finding first key in sbtree [" + this.getName() + "]", this), e);
                    }
                }
                this.releaseSharedLock();
                return oCellBTreeKeyCursor;
            }
            OCellBTreeFullKeyCursor oCellBTreeFullKeyCursor = new OCellBTreeFullKeyCursor(searchResult.pageIndex);
            this.releaseSharedLock();
            return oCellBTreeFullKeyCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    oCellBTreeCursor = this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oCellBTreeCursor;
            }
            OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> oCellBTreeCursor = this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive);
            this.releaseSharedLock();
            return oCellBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSize(long diffSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            CellBTreeMultiValueV2EntryPoint entryPoint = new CellBTreeMultiValueV2EntryPoint(entryPointCacheEntry);
            entryPoint.setTreeSize(entryPoint.getTreeSize() + diffSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMinorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        return new OCellBTreeCursorBackward(null, key, false, inclusive);
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMinorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
        return new OCellBTreeCursorForward(null, key, false, inclusive);
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMajorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        return new OCellBTreeCursorForward(key, null, inclusive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesMajorDesc(K key, boolean inclusive) {
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
            OCellBTreeCursorBackward oCellBTreeCursorBackward = new OCellBTreeCursorBackward(key, null, inclusive, false);
            return oCellBTreeCursorBackward;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        int itemIndex = 0;
        try {
            CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex + 1;
                    } else {
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        bucketIndex = itemIndex < bucket.size() ? (long)bucket.getLeft(itemIndex) : (long)bucket.getRight(itemIndex - 1);
                        itemIndex = 0;
                    }
                } else {
                    BucketSearchResult bucketSearchResult;
                    if (!bucket.isEmpty()) {
                        bucketSearchResult = new BucketSearchResult(0, bucketIndex);
                        return bucketSearchResult;
                    }
                    if (path.isEmpty()) {
                        bucketSearchResult = null;
                        return bucketSearchResult;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex + 1;
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex - 1;
                    } else {
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        bucketIndex = itemIndex > -1 ? (long)bucket.getRight(itemIndex) : (long)bucket.getLeft(0);
                        itemIndex = CellBTreeMultiValueV2Bucket.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else {
                    BucketSearchResult bucketSearchResult;
                    if (!bucket.isEmpty()) {
                        bucketSearchResult = new BucketSearchResult(bucket.size() - 1, bucketIndex);
                        return bucketSearchResult;
                    }
                    if (path.isEmpty()) {
                        bucketSearchResult = null;
                        return bucketSearchResult;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex - 1;
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
                if (itemIndex != CellBTreeMultiValueV2Bucket.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        return new OCellBTreeCursorForward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        return new OCellBTreeCursorBackward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private UpdateBucketSearchResult splitBucket(CellBTreeMultiValueV2Bucket<K> bucketToSplit, OCacheEntry entryToSplit, List<Long> path, List<Integer> insertionIndexes, int keyIndex, K keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        int startRightIndex;
        boolean splitLeaf = bucketToSplit.isLeaf();
        int bucketSize = bucketToSplit.size();
        int indexToSplit = bucketSize >>> 1;
        byte[] serializedSeparationKey = bucketToSplit.getRawKey(indexToSplit, this.keySerializer, this.encryption);
        ArrayList<CellBTreeMultiValueV2Bucket.Entry> rightEntries = new ArrayList<CellBTreeMultiValueV2Bucket.Entry>(indexToSplit);
        int n = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1;
        if (splitLeaf) {
            for (int i = startRightIndex; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getLeafEntry(i, this.keySerializer, this.encryption != null));
            }
        } else {
            for (int i = startRightIndex; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getNonLeafEntry(i, this.keySerializer, this.encryption != null));
            }
        }
        if (entryToSplit.getPageIndex() != 1L) {
            return this.splitNonRootBucket(path, insertionIndexes, keyIndex, keyToInsert, entryToSplit.getPageIndex(), bucketToSplit, splitLeaf, indexToSplit, serializedSeparationKey, rightEntries, atomicOperation);
        }
        return this.splitRootBucket(keyIndex, keyToInsert, entryToSplit, bucketToSplit, splitLeaf, indexToSplit, serializedSeparationKey, rightEntries, atomicOperation);
    }

    private byte[] serializeKey(byte[] serializedKey) {
        byte[] keyToInsert;
        if (this.encryption == null) {
            keyToInsert = serializedKey;
        } else {
            byte[] encryptedKey = this.encryption.encrypt(serializedKey);
            keyToInsert = new byte[4 + encryptedKey.length];
            OIntegerSerializer.INSTANCE.serializeNative(encryptedKey.length, keyToInsert, 0, new Object[0]);
            System.arraycopy(encryptedKey, 0, keyToInsert, 4, encryptedKey.length);
        }
        return keyToInsert;
    }

    private K deserializeKey(byte[] serializedKey) {
        if (this.encryption == null) {
            return this.keySerializer.deserializeNativeObject(serializedKey, 0);
        }
        byte[] decrypted = this.encryption.decrypt(serializedKey, 4, serializedKey.length - 4);
        return this.keySerializer.deserializeNativeObject(decrypted, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult splitNonRootBucket(List<Long> path, List<Integer> insertionIndexes, int keyIndex, K keyToInsert, long pageIndex, CellBTreeMultiValueV2Bucket<K> bucketToSplit, boolean splitLeaf, int indexToSplit, byte[] serializedSeparationKey, List<CellBTreeMultiValueV2Bucket.Entry> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry;
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            CellBTreeMultiValueV2EntryPoint entryPoint = new CellBTreeMultiValueV2EntryPoint(entryPointCacheEntry);
            int pageSize = entryPoint.getPagesSize();
            if ((long)pageSize < this.getFilledUpTo(atomicOperation, this.fileId) - 1L) {
                rightBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageSize + 1, false, false);
                entryPoint.setPagesSize(pageSize + 1);
            } else {
                assert ((long)pageSize == this.getFilledUpTo(atomicOperation, this.fileId) - 1L);
                rightBucketEntry = this.addPage(atomicOperation, this.fileId);
                entryPoint.setPagesSize((int)rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
        Object separationKey = null;
        try {
            CellBTreeMultiValueV2Bucket<K> newRightBucket = new CellBTreeMultiValueV2Bucket<K>(rightBucketEntry);
            newRightBucket.init(splitLeaf);
            newRightBucket.addAll(rightEntries, this.keySerializer, this.encryption != null);
            assert (bucketToSplit.size() > 1);
            bucketToSplit.shrink(indexToSplit, this.keySerializer, this.encryption != null);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, rightSiblingPageIndex, false, true);
                    CellBTreeMultiValueV2Bucket rightSiblingBucket = new CellBTreeMultiValueV2Bucket(rightSiblingBucketEntry);
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, rightSiblingBucketEntry);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
            try {
                CellBTreeMultiValueV2Bucket parentBucket = new CellBTreeMultiValueV2Bucket(parentCacheEntry);
                int insertionIndex = insertionIndexes.get(insertionIndexes.size() - 2);
                while (!parentBucket.addNonLeafEntry(insertionIndex, serializedSeparationKey, (int)pageIndex, (int)rightBucketEntry.getPageIndex(), true)) {
                    if (separationKey == null) {
                        separationKey = this.deserializeKey(serializedSeparationKey);
                    }
                    UpdateBucketSearchResult bucketSearchResult = this.splitBucket(parentBucket, parentCacheEntry, path.subList(0, path.size() - 1), insertionIndexes.subList(0, insertionIndexes.size() - 1), insertionIndex, separationKey, atomicOperation);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    insertionIndex = bucketSearchResult.itemIndex;
                    if (parentIndex != parentCacheEntry.getPageIndex()) {
                        this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                        parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
                    }
                    parentBucket = new CellBTreeMultiValueV2Bucket(parentCacheEntry);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, parentCacheEntry);
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        ArrayList<Integer> resultInsertionIndexes = new ArrayList<Integer>(insertionIndexes.subList(0, insertionIndexes.size() - 1));
        if (keyIndex < indexToSplit) {
            return CellBTreeMultiValueV2.addToTheLeftNonRootBucket(keyIndex, pageIndex, resultPath, resultInsertionIndexes);
        }
        if (keyIndex > indexToSplit) {
            return CellBTreeMultiValueV2.addToTheRightNonRootBucket(keyIndex, splitLeaf, indexToSplit, rightBucketEntry.getPageIndex(), resultPath, resultInsertionIndexes);
        }
        if (splitLeaf && keyToInsert.equals(Optional.ofNullable(separationKey).orElseGet(() -> this.deserializeKey(serializedSeparationKey)))) {
            return CellBTreeMultiValueV2.addToTheRightNonRootBucket(keyIndex, true, indexToSplit, rightBucketEntry.getPageIndex(), resultPath, resultInsertionIndexes);
        }
        return CellBTreeMultiValueV2.addToTheLeftNonRootBucket(keyIndex, pageIndex, resultPath, resultInsertionIndexes);
    }

    private static UpdateBucketSearchResult addToTheRightNonRootBucket(int keyIndex, boolean splitLeaf, int indexToSplit, long rightPageIndex, ArrayList<Long> resultPath, ArrayList<Integer> resultItemPointers) {
        int parentIndex = resultItemPointers.size() - 1;
        resultItemPointers.set(parentIndex, resultItemPointers.get(parentIndex) + 1);
        resultPath.add(rightPageIndex);
        if (splitLeaf) {
            resultItemPointers.add(keyIndex - indexToSplit);
            return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex - indexToSplit);
        }
        int insertionIndex = keyIndex - indexToSplit - 1;
        resultItemPointers.add(insertionIndex);
        return new UpdateBucketSearchResult(resultItemPointers, resultPath, insertionIndex);
    }

    private static UpdateBucketSearchResult addToTheLeftNonRootBucket(int keyIndex, long pageIndex, ArrayList<Long> resultPath, ArrayList<Integer> resultItemPointers) {
        resultPath.add(pageIndex);
        resultItemPointers.add(keyIndex);
        return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private UpdateBucketSearchResult splitRootBucket(int keyIndex, K keyToInsert, OCacheEntry bucketEntry, CellBTreeMultiValueV2Bucket<K> bucketToSplit, boolean splitLeaf, int indexToSplit, byte[] serializedSeparationKey, List<CellBTreeMultiValueV2Bucket.Entry> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry;
        OCacheEntry leftBucketEntry;
        int i;
        ArrayList<CellBTreeMultiValueV2Bucket.Entry> leftEntries = new ArrayList<CellBTreeMultiValueV2Bucket.Entry>(indexToSplit);
        if (splitLeaf) {
            if (bucketToSplit.size() <= 1) throw new IllegalStateException("Bucket should have at least two entries to be able to split");
            for (i = 0; i < indexToSplit; ++i) {
                leftEntries.add(bucketToSplit.getLeafEntry(i, this.keySerializer, this.encryption != null));
            }
        } else {
            for (i = 0; i < indexToSplit; ++i) {
                leftEntries.add(bucketToSplit.getNonLeafEntry(i, this.keySerializer, this.encryption != null));
            }
        }
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            CellBTreeMultiValueV2EntryPoint entryPoint = new CellBTreeMultiValueV2EntryPoint(entryPointCacheEntry);
            int pageSize = entryPoint.getPagesSize();
            int filledUpTo = (int)this.getFilledUpTo(atomicOperation, this.fileId);
            if (pageSize < filledUpTo - 1) {
                leftBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, ++pageSize, false, false);
            } else {
                assert (pageSize == filledUpTo - 1);
                leftBucketEntry = this.addPage(atomicOperation, this.fileId);
                pageSize = (int)leftBucketEntry.getPageIndex();
            }
            if (pageSize < filledUpTo) {
                rightBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, ++pageSize, false, false);
            } else {
                assert (pageSize == filledUpTo);
                rightBucketEntry = this.addPage(atomicOperation, this.fileId);
                pageSize = (int)rightBucketEntry.getPageIndex();
            }
            entryPoint.setPagesSize(pageSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
        try {
            CellBTreeMultiValueV2Bucket<K> newLeftBucket = new CellBTreeMultiValueV2Bucket<K>(leftBucketEntry);
            newLeftBucket.init(splitLeaf);
            newLeftBucket.addAll(leftEntries, this.keySerializer, this.encryption != null);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, leftBucketEntry);
        }
        try {
            CellBTreeMultiValueV2Bucket<K> newRightBucket = new CellBTreeMultiValueV2Bucket<K>(rightBucketEntry);
            newRightBucket.init(splitLeaf);
            newRightBucket.addAll(rightEntries, this.keySerializer, this.encryption != null);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        bucketToSplit = new CellBTreeMultiValueV2Bucket(bucketEntry);
        bucketToSplit.shrink(0, this.keySerializer, this.encryption != null);
        if (splitLeaf) {
            bucketToSplit.switchBucketType();
        }
        bucketToSplit.addNonLeafEntry(0, serializedSeparationKey, (int)leftBucketEntry.getPageIndex(), (int)rightBucketEntry.getPageIndex(), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(8);
        resultPath.add(1L);
        ArrayList<Integer> itemPointers = new ArrayList<Integer>(8);
        if (keyIndex < indexToSplit) {
            return CellBTreeMultiValueV2.addToTheLeftRootBucket(keyIndex, leftBucketEntry, resultPath, itemPointers);
        }
        if (keyIndex > indexToSplit) {
            return CellBTreeMultiValueV2.addToTheRightRootBucket(keyIndex, splitLeaf, indexToSplit, rightBucketEntry, resultPath, itemPointers);
        }
        if (!splitLeaf || !keyToInsert.equals(this.deserializeKey(serializedSeparationKey))) return CellBTreeMultiValueV2.addToTheLeftRootBucket(keyIndex, leftBucketEntry, resultPath, itemPointers);
        return CellBTreeMultiValueV2.addToTheRightRootBucket(keyIndex, true, indexToSplit, rightBucketEntry, resultPath, itemPointers);
    }

    private static UpdateBucketSearchResult addToTheRightRootBucket(int keyIndex, boolean splitLeaf, int indexToSplit, OCacheEntry rightBucketEntry, ArrayList<Long> resultPath, ArrayList<Integer> itemPointers) {
        resultPath.add(rightBucketEntry.getPageIndex());
        itemPointers.add(0);
        if (splitLeaf) {
            itemPointers.add(keyIndex - indexToSplit);
            return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex - indexToSplit);
        }
        int itemPointer = keyIndex - indexToSplit - 1;
        itemPointers.add(itemPointer);
        return new UpdateBucketSearchResult(itemPointers, resultPath, itemPointer);
    }

    private static UpdateBucketSearchResult addToTheLeftRootBucket(int keyIndex, OCacheEntry leftBucketEntry, ArrayList<Long> resultPath, ArrayList<Integer> itemPointers) {
        itemPointers.add(-1);
        itemPointers.add(keyIndex);
        resultPath.add(leftBucketEntry.getPageIndex());
        return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 1L;
        int depth = 0;
        while (true) {
            if (++depth > MAX_PATH_LENGTH) {
                throw new CellBTreeMultiValueException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                CellBTreeMultiValueV2Bucket<K> keyBucket = new CellBTreeMultiValueV2Bucket<K>(bucketEntry);
                int index = keyBucket.find(key, this.keySerializer, this.encryption);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, pageIndex);
                    return bucketSearchResult;
                }
                if (index >= 0) {
                    pageIndex = keyBucket.getRight(index);
                    continue;
                }
                int insertionIndex = -index - 1;
                if (insertionIndex >= keyBucket.size()) {
                    pageIndex = keyBucket.getRight(insertionIndex - 1);
                    continue;
                }
                pageIndex = keyBucket.getLeft(insertionIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult findBucketForUpdate(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 1L;
        ArrayList<Long> path = new ArrayList<Long>(8);
        ArrayList<Integer> insertionIndexes = new ArrayList<Integer>(8);
        while (true) {
            if (path.size() > MAX_PATH_LENGTH) {
                throw new CellBTreeMultiValueException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                CellBTreeMultiValueV2Bucket<K> keyBucket = new CellBTreeMultiValueV2Bucket<K>(bucketEntry);
                int index = keyBucket.find(key, this.keySerializer, this.encryption);
                if (keyBucket.isLeaf()) {
                    insertionIndexes.add(index);
                    UpdateBucketSearchResult updateBucketSearchResult = new UpdateBucketSearchResult(insertionIndexes, path, index);
                    return updateBucketSearchResult;
                }
                if (index >= 0) {
                    pageIndex = keyBucket.getRight(index);
                    insertionIndexes.add(index + 1);
                    continue;
                }
                int insertionIndex = -index - 1;
                pageIndex = insertionIndex >= keyBucket.size() ? (long)keyBucket.getRight(insertionIndex - 1) : (long)keyBucket.getLeft(insertionIndex);
                insertionIndexes.add(insertionIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    private final class OCellBTreeCursorBackward
    implements OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> {
        private final K fromKey;
        private K toKey;
        private final boolean fromKeyInclusive;
        private boolean toKeyInclusive;
        private final List<Map.Entry<K, ORID>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, ORID>> dataCacheIterator = Collections.emptyIterator();

        private OCellBTreeCursorBackward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (toKey == null) {
                this.toKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, ORID> next(int prefetchSize) {
            block36: {
                if (this.dataCacheIterator == null) {
                    return null;
                }
                if (this.dataCacheIterator.hasNext()) {
                    Map.Entry entry = this.dataCacheIterator.next();
                    this.toKey = entry.getKey();
                    this.toKeyInclusive = false;
                    return entry;
                }
                this.dataCache.clear();
                if (prefetchSize <= 0) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                CellBTreeMultiValueV2.this.atomicOperationsManager.acquireReadLock(CellBTreeMultiValueV2.this);
                try {
                    CellBTreeMultiValueV2.this.acquireSharedLock();
                    try {
                        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        BucketSearchResult bucketSearchResult = this.toKey != null ? CellBTreeMultiValueV2.this.findBucket(this.toKey, atomicOperation) : CellBTreeMultiValueV2.this.lastItem(atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            Map.Entry entry = null;
                            return entry;
                        }
                        long pageIndex = bucketSearchResult.pageIndex;
                        int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.toKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
                        boolean firstTry = true;
                        Object lastKey = null;
                        block17: while (pageIndex != -1L) {
                            OCacheEntry cacheEntry = CellBTreeMultiValueV2.this.loadPageForRead(atomicOperation, CellBTreeMultiValueV2.this.fileId, pageIndex, false);
                            try {
                                CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
                                if (firstTry && this.toKey != null && this.toKeyInclusive && bucketSearchResult.itemIndex == 0) {
                                    int rightSibling = (int)bucket.getRightSibling();
                                    while (rightSibling > 0) {
                                        Object key;
                                        OCacheEntry siblingCacheEntry = CellBTreeMultiValueV2.this.loadPageForRead(atomicOperation, CellBTreeMultiValueV2.this.fileId, rightSibling, false);
                                        CellBTreeMultiValueV2Bucket siblingBucket = new CellBTreeMultiValueV2Bucket(siblingCacheEntry);
                                        int bucketSize = siblingBucket.size();
                                        if (bucketSize == 0) {
                                            rightSibling = (int)siblingBucket.getRightSibling();
                                            continue;
                                        }
                                        if (bucketSize == 1) {
                                            key = siblingBucket.getKey(0, CellBTreeMultiValueV2.this.keySerializer, CellBTreeMultiValueV2.this.encryption);
                                            if (key.equals(this.fromKey)) {
                                                lastKey = key;
                                                CellBTreeMultiValueV2.this.fetchMapEntries(0, key, this.dataCache, siblingBucket);
                                                rightSibling = (int)siblingBucket.getRightSibling();
                                                continue;
                                            }
                                            rightSibling = -1;
                                            continue;
                                        }
                                        key = siblingBucket.getKey(0, CellBTreeMultiValueV2.this.keySerializer, CellBTreeMultiValueV2.this.encryption);
                                        if (key.equals(this.fromKey)) {
                                            lastKey = key;
                                            CellBTreeMultiValueV2.this.fetchMapEntries(0, key, this.dataCache, siblingBucket);
                                        } else {
                                            rightSibling = -1;
                                        }
                                        CellBTreeMultiValueV2.this.releasePageFromRead(atomicOperation, siblingCacheEntry);
                                    }
                                }
                                firstTry = false;
                                while (true) {
                                    if (itemIndex >= bucket.size()) {
                                        itemIndex = bucket.size() - 1;
                                    }
                                    if (itemIndex < 0) {
                                        pageIndex = bucket.getLeftSibling();
                                        itemIndex = Integer.MAX_VALUE;
                                        continue block17;
                                    }
                                    CellBTreeMultiValueV2Bucket.LeafEntry leafEntry = bucket.getLeafEntry(itemIndex, CellBTreeMultiValueV2.this.keySerializer, CellBTreeMultiValueV2.this.encryption != null);
                                    --itemIndex;
                                    Object key = CellBTreeMultiValueV2.this.deserializeKey(leafEntry.key);
                                    if (this.dataCache.size() < prefetchSize || lastKey != null && lastKey.equals(key)) {
                                        if (!this.toKeyInclusive ? this.toKey != null && CellBTreeMultiValueV2.this.comparator.compare(key, this.toKey) >= 0 : this.toKey != null && CellBTreeMultiValueV2.this.comparator.compare(key, this.toKey) > 0) continue;
                                        if (!(this.fromKeyInclusive ? this.fromKey != null && CellBTreeMultiValueV2.this.comparator.compare(key, this.fromKey) < 0 : this.fromKey != null && CellBTreeMultiValueV2.this.comparator.compare(key, this.fromKey) <= 0)) {
                                            lastKey = key;
                                            CellBTreeMultiValueV2.this.fetchMapEntriesFromLeafEntry(key, this.dataCache, leafEntry);
                                            continue;
                                        }
                                    }
                                    break block36;
                                    break;
                                }
                            }
                            finally {
                                CellBTreeMultiValueV2.this.releasePageFromRead(atomicOperation, cacheEntry);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        CellBTreeMultiValueV2.this.releaseSharedLock();
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new CellBTreeMultiValueException("Error during element iteration", CellBTreeMultiValueV2.this), e);
                }
                finally {
                    CellBTreeMultiValueV2.this.atomicOperationsManager.releaseReadLock(CellBTreeMultiValueV2.this);
                }
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            Map.Entry entry = this.dataCacheIterator.next();
            this.toKey = entry.getKey();
            this.toKeyInclusive = false;
            return entry;
        }
    }

    private final class OCellBTreeCursorForward
    implements OCellBTreeMultiValue.OCellBTreeCursor<K, ORID> {
        private K fromKey;
        private final K toKey;
        private boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private final List<Map.Entry<K, ORID>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, ORID>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OCellBTreeCursorForward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (fromKey == null) {
                this.fromKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, ORID> next(int prefetchSize) {
            block38: {
                if (this.dataCacheIterator == null) {
                    return null;
                }
                if (this.dataCacheIterator.hasNext()) {
                    Map.Entry entry = this.dataCacheIterator.next();
                    this.fromKey = entry.getKey();
                    this.fromKeyInclusive = false;
                    return entry;
                }
                this.dataCache.clear();
                if (prefetchSize <= 0) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                CellBTreeMultiValueV2.this.atomicOperationsManager.acquireReadLock(CellBTreeMultiValueV2.this);
                try {
                    CellBTreeMultiValueV2.this.acquireSharedLock();
                    try {
                        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        BucketSearchResult bucketSearchResult = this.fromKey != null ? CellBTreeMultiValueV2.this.findBucket(this.fromKey, atomicOperation) : CellBTreeMultiValueV2.this.firstItem(atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            Map.Entry entry = null;
                            return entry;
                        }
                        long pageIndex = bucketSearchResult.pageIndex;
                        int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.fromKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
                        Object lastKey = null;
                        boolean firstTry = true;
                        block17: while (pageIndex != -1L) {
                            OCacheEntry cacheEntry = CellBTreeMultiValueV2.this.loadPageForRead(atomicOperation, CellBTreeMultiValueV2.this.fileId, pageIndex, false);
                            try {
                                CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
                                if (firstTry && this.fromKey != null && this.fromKeyInclusive && bucketSearchResult.itemIndex == 0) {
                                    int leftSibling = (int)bucket.getLeftSibling();
                                    while (leftSibling > 0) {
                                        Object key;
                                        OCacheEntry siblingCacheEntry = CellBTreeMultiValueV2.this.loadPageForRead(atomicOperation, CellBTreeMultiValueV2.this.fileId, leftSibling, false);
                                        CellBTreeMultiValueV2Bucket siblingBucket = new CellBTreeMultiValueV2Bucket(siblingCacheEntry);
                                        int bucketSize = siblingBucket.size();
                                        if (bucketSize == 0) {
                                            leftSibling = (int)siblingBucket.getLeftSibling();
                                        } else if (bucketSize == 1) {
                                            key = siblingBucket.getKey(0, CellBTreeMultiValueV2.this.keySerializer, CellBTreeMultiValueV2.this.encryption);
                                            if (key.equals(this.fromKey)) {
                                                lastKey = key;
                                                CellBTreeMultiValueV2.this.fetchMapEntries(0, key, this.dataCache, siblingBucket);
                                                leftSibling = (int)siblingBucket.getLeftSibling();
                                            } else {
                                                leftSibling = -1;
                                            }
                                        } else {
                                            key = siblingBucket.getKey(bucketSize - 1, CellBTreeMultiValueV2.this.keySerializer, CellBTreeMultiValueV2.this.encryption);
                                            if (key.equals(this.fromKey)) {
                                                lastKey = key;
                                                CellBTreeMultiValueV2.this.fetchMapEntries(0, key, this.dataCache, siblingBucket);
                                                leftSibling = -1;
                                            } else {
                                                leftSibling = -1;
                                            }
                                        }
                                        CellBTreeMultiValueV2.this.releasePageFromRead(atomicOperation, siblingCacheEntry);
                                    }
                                }
                                firstTry = false;
                                while (true) {
                                    if (itemIndex >= bucket.size()) {
                                        pageIndex = bucket.getRightSibling();
                                        itemIndex = 0;
                                        continue block17;
                                    }
                                    CellBTreeMultiValueV2Bucket.LeafEntry leafEntry = bucket.getLeafEntry(itemIndex, CellBTreeMultiValueV2.this.keySerializer, CellBTreeMultiValueV2.this.encryption != null);
                                    ++itemIndex;
                                    Object key = CellBTreeMultiValueV2.this.deserializeKey(leafEntry.key);
                                    if (this.dataCache.size() < prefetchSize || lastKey != null && lastKey.equals(key)) {
                                        if (!this.fromKeyInclusive ? this.fromKey != null && CellBTreeMultiValueV2.this.comparator.compare(key, this.fromKey) <= 0 : this.fromKey != null && CellBTreeMultiValueV2.this.comparator.compare(key, this.fromKey) < 0) continue;
                                        if (!(this.toKeyInclusive ? this.toKey != null && CellBTreeMultiValueV2.this.comparator.compare(key, this.toKey) > 0 : this.toKey != null && CellBTreeMultiValueV2.this.comparator.compare(key, this.toKey) >= 0)) {
                                            lastKey = key;
                                            CellBTreeMultiValueV2.this.fetchMapEntriesFromLeafEntry(key, this.dataCache, leafEntry);
                                            continue;
                                        }
                                    }
                                    break block38;
                                    break;
                                }
                            }
                            finally {
                                CellBTreeMultiValueV2.this.releasePageFromRead(atomicOperation, cacheEntry);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        CellBTreeMultiValueV2.this.releaseSharedLock();
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new CellBTreeMultiValueException("Error during element iteration", CellBTreeMultiValueV2.this), e);
                }
                finally {
                    CellBTreeMultiValueV2.this.atomicOperationsManager.releaseReadLock(CellBTreeMultiValueV2.this);
                }
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            Map.Entry entry = this.dataCacheIterator.next();
            this.fromKey = entry.getKey();
            this.fromKeyInclusive = false;
            return entry;
        }
    }

    public final class OCellBTreeFullKeyCursor
    implements OCellBTreeMultiValue.OCellBTreeKeyCursor<K> {
        private long pageIndex;
        private int itemIndex;
        private List<K> keysCache = new ArrayList();
        private Iterator<K> keysIterator = new OEmptyIterator();

        private OCellBTreeFullKeyCursor(long startPageIndex) {
            this.pageIndex = startPageIndex;
            this.itemIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next(int prefetchSize) {
            if (this.keysIterator == null) {
                return null;
            }
            if (this.keysIterator.hasNext()) {
                return this.keysIterator.next();
            }
            this.keysCache.clear();
            if (prefetchSize <= 0) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            CellBTreeMultiValueV2.this.atomicOperationsManager.acquireReadLock(CellBTreeMultiValueV2.this);
            try {
                CellBTreeMultiValueV2.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    while (this.keysCache.size() < prefetchSize) {
                        block24: {
                            if (this.pageIndex == -1L) {
                                break;
                            }
                            OCacheEntry entryPointCacheEntry = CellBTreeMultiValueV2.this.loadPageForRead(atomicOperation, CellBTreeMultiValueV2.this.fileId, 0L, false);
                            try {
                                CellBTreeMultiValueV2EntryPoint entryPoint = new CellBTreeMultiValueV2EntryPoint(entryPointCacheEntry);
                                if (this.pageIndex < (long)(entryPoint.getPagesSize() + 1)) break block24;
                                this.pageIndex = -1L;
                                break;
                            }
                            finally {
                                CellBTreeMultiValueV2.this.releasePageFromRead(atomicOperation, entryPointCacheEntry);
                            }
                        }
                        OCacheEntry cacheEntry = CellBTreeMultiValueV2.this.loadPageForRead(atomicOperation, CellBTreeMultiValueV2.this.fileId, this.pageIndex, false);
                        try {
                            CellBTreeMultiValueV2Bucket bucket = new CellBTreeMultiValueV2Bucket(cacheEntry);
                            int bucketSize = bucket.size();
                            if (this.itemIndex >= bucketSize) {
                                this.pageIndex = bucket.getRightSibling();
                                this.itemIndex = 0;
                                continue;
                            }
                            while (this.itemIndex < bucketSize && this.keysCache.size() < prefetchSize) {
                                this.keysCache.add(CellBTreeMultiValueV2.this.deserializeKey(bucket.getRawKey(this.itemIndex, CellBTreeMultiValueV2.this.keySerializer, CellBTreeMultiValueV2.this.encryption)));
                                ++this.itemIndex;
                            }
                        }
                        finally {
                            CellBTreeMultiValueV2.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    CellBTreeMultiValueV2.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new CellBTreeMultiValueException("Error during element iteration", CellBTreeMultiValueV2.this), e);
            }
            finally {
                CellBTreeMultiValueV2.this.atomicOperationsManager.releaseReadLock(CellBTreeMultiValueV2.this);
            }
            if (this.keysCache.isEmpty()) {
                this.keysCache = null;
                return null;
            }
            this.keysIterator = this.keysCache.iterator();
            return this.keysIterator.next();
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static final class UpdateBucketSearchResult {
        private final List<Integer> insertionIndexes;
        private final ArrayList<Long> path;
        private final int itemIndex;

        private UpdateBucketSearchResult(List<Integer> insertionIndexes, ArrayList<Long> path, int itemIndex) {
            this.insertionIndexes = insertionIndexes;
            this.path = path;
            this.itemIndex = itemIndex;
        }

        private long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    private static final class BucketSearchResult {
        private final int itemIndex;
        private final long pageIndex;

        private BucketSearchResult(int itemIndex, long pageIndex) {
            this.itemIndex = itemIndex;
            this.pageIndex = pageIndex;
        }
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

