/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class CellBTreeMultiValueV2Bucket<K>
extends ODurablePage {
    private static final int NEXT_ITEM_POINTER_OFFSET = 0;
    private static final int EMBEDDED_ENTRIES_COUNT_OFFSET = 4;
    private static final int ENTRIES_COUNT_OFFSET = 5;
    private static final int M_ID_OFFSET = 9;
    private static final int CLUSTER_ID_OFFSET = 17;
    private static final int CLUSTER_POSITION_OFFSET = 19;
    private static final int KEY_OFFSET = 27;
    private static final int EMBEDDED_ITEMS_THRESHOLD = 64;
    private static final int RID_SIZE = 10;
    private static final int SINGLE_ELEMENT_LINKED_ITEM_SIZE = 15;
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int IS_LEAF_OFFSET = 36;
    private static final int LEFT_SIBLING_OFFSET = 37;
    private static final int RIGHT_SIBLING_OFFSET = 45;
    private static final int POSITIONS_ARRAY_OFFSET = 53;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;

    public CellBTreeMultiValueV2Bucket(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init(boolean isLeaf) {
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(32, 0);
        this.setByteValue(36, (byte)(isLeaf ? 1 : 0));
        this.setLongValue(37, -1L);
        this.setLongValue(45, -1L);
    }

    public void switchBucketType() {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Type of bucket can be changed only bucket if bucket is empty");
        }
        boolean isLeaf = this.isLeaf();
        if (isLeaf) {
            this.setByteValue(36, (byte)0);
        } else {
            this.setByteValue(36, (byte)1);
        }
    }

    boolean isEmpty() {
        return this.size() == 0;
    }

    int find(K key, OBinarySerializer<K> keySerializer, OEncryption encryption) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid, keySerializer, encryption);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void removeMainLeafEntry(int entryIndex, int entryPosition, int keySize) {
        int size = this.getIntValue(32);
        if (entryIndex < size - 1) {
            this.moveData(53 + (entryIndex + 1) * 4, 53 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        int entrySize = 27 + keySize;
        boolean moved = false;
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
            moved = true;
        }
        this.setIntValue(28, freePointer + entrySize);
        if (moved) {
            int currentPositionOffset = 53;
            for (int i = 0; i < size; ++i) {
                int updatedEntryPosition;
                int currentEntryPosition = this.getIntValue(currentPositionOffset);
                if (currentEntryPosition < entryPosition) {
                    updatedEntryPosition = currentEntryPosition + entrySize;
                    this.setIntValue(currentPositionOffset, updatedEntryPosition);
                } else {
                    updatedEntryPosition = currentEntryPosition;
                }
                int nextItem = this.getIntValue(updatedEntryPosition);
                if (nextItem > 0 && nextItem < entryPosition) {
                    this.setIntValue(updatedEntryPosition, nextItem + entrySize);
                    this.updateAllLinkedListReferences(nextItem, entryPosition, entrySize);
                }
                currentPositionOffset += 4;
            }
        }
    }

    public int removeLeafEntry(int entryIndex, ORID value) {
        int entryPosition;
        assert (this.isLeaf());
        int position = entryPosition = this.getIntValue(53 + entryIndex * 4);
        int nextItem = this.getIntValue(position);
        int embeddedEntriesCountPosition = position += 4;
        byte embeddedEntriesCount = this.getByteValue(position);
        int entriesCountPosition = ++position;
        int entriesCount = this.getIntValue(entriesCountPosition);
        position += 4;
        position += 8;
        if (nextItem == -1) {
            int clusterIdPosition = position;
            short clusterId = this.getShortValue(clusterIdPosition);
            long clusterPosition = this.getLongValue(position += 2);
            if (clusterId != value.getClusterId()) {
                return -1;
            }
            if (clusterPosition == value.getClusterPosition()) {
                this.setShortValue(clusterIdPosition, (short)-1);
                assert (embeddedEntriesCount == 1);
                this.setByteValue(embeddedEntriesCountPosition, (byte)(embeddedEntriesCount - 1));
                this.setIntValue(entriesCountPosition, entriesCount - 1);
                return entriesCount - 1;
            }
        } else {
            short clusterId = this.getShortValue(position);
            long clusterPosition = this.getLongValue(position += 2);
            if (clusterId == value.getClusterId() && clusterPosition == value.getClusterPosition()) {
                int nextNextItem = this.getIntValue(nextItem);
                int nextItemSize = 0xFF & this.getByteValue(nextItem + 4);
                byte[] nextValue = this.getBinaryValue(nextItem + 4 + 1, 10);
                assert (nextItemSize > 0);
                int freePointer = this.getIntValue(28);
                if (nextItemSize == 1) {
                    this.setIntValue(entryPosition, nextNextItem);
                    this.setIntValue(28, freePointer + 4 + 10 + 1);
                } else {
                    this.setByteValue(nextItem + 4, (byte)(nextItemSize - 1));
                    this.setIntValue(28, freePointer + 10);
                }
                this.setBinaryValue(entryPosition + 8 + 1 + 8, nextValue);
                if (nextItem > freePointer || nextItemSize > 1) {
                    if (nextItemSize == 1) {
                        this.moveData(freePointer, freePointer + 15, nextItem - freePointer);
                    } else {
                        this.moveData(freePointer, freePointer + 10, nextItem + 4 + 1 - freePointer);
                    }
                    int diff = nextItemSize > 1 ? 10 : 15;
                    int size = this.getIntValue(32);
                    int currentPositionOffset = 53;
                    for (int i = 0; i < size; ++i) {
                        int updatedEntryPosition;
                        int currentEntryPosition = this.getIntValue(currentPositionOffset);
                        if (currentEntryPosition < nextItem) {
                            updatedEntryPosition = currentEntryPosition + diff;
                            this.setIntValue(currentPositionOffset, updatedEntryPosition);
                        } else {
                            updatedEntryPosition = currentEntryPosition;
                        }
                        int currentNextItem = this.getIntValue(updatedEntryPosition);
                        if (currentNextItem > 0 && currentNextItem < nextItem + diff) {
                            this.setIntValue(updatedEntryPosition, currentNextItem + diff);
                            this.updateAllLinkedListReferences(currentNextItem, nextItem + diff, diff);
                        }
                        currentPositionOffset += 4;
                    }
                }
                this.setByteValue(embeddedEntriesCountPosition, (byte)(embeddedEntriesCount - 1));
                this.setIntValue(entriesCountPosition, entriesCount - 1);
                return entriesCount - 1;
            }
            int prevItem = entryPosition;
            while (nextItem > 0) {
                int nextNextItem = this.getIntValue(nextItem);
                int nextItemSize = 0xFF & this.getByteValue(nextItem + 4);
                if (nextItemSize == 1) {
                    clusterId = this.getShortValue(nextItem + 4 + 1);
                    clusterPosition = this.getLongValue(nextItem + 4 + 1 + 2);
                    if (clusterId == value.getClusterId() && clusterPosition == value.getClusterPosition()) {
                        this.setIntValue(prevItem, nextNextItem);
                        int freePointer = this.getIntValue(28);
                        this.setIntValue(28, freePointer + 15);
                        if (nextItem > freePointer) {
                            this.moveData(freePointer, freePointer + 15, nextItem - freePointer);
                            int size = this.getIntValue(32);
                            int currentPositionOffset = 53;
                            for (int i = 0; i < size; ++i) {
                                int updatedEntryPosition;
                                int currentEntryPosition = this.getIntValue(currentPositionOffset);
                                if (currentEntryPosition < nextItem) {
                                    updatedEntryPosition = currentEntryPosition + 15;
                                    this.setIntValue(currentPositionOffset, updatedEntryPosition);
                                } else {
                                    updatedEntryPosition = currentEntryPosition;
                                }
                                int currentNextItem = this.getIntValue(updatedEntryPosition);
                                if (currentNextItem > 0 && currentNextItem < nextItem) {
                                    this.setIntValue(updatedEntryPosition, currentNextItem + 15);
                                    this.updateAllLinkedListReferences(currentNextItem, nextItem, 15);
                                }
                                currentPositionOffset += 4;
                            }
                        }
                        this.setByteValue(embeddedEntriesCountPosition, (byte)(embeddedEntriesCount - 1));
                        this.setIntValue(entriesCountPosition, entriesCount - 1);
                        return entriesCount - 1;
                    }
                } else {
                    for (int i = 0; i < nextItemSize; ++i) {
                        clusterId = this.getShortValue(nextItem + 4 + 1 + i * 10);
                        clusterPosition = this.getLongValue(nextItem + 4 + 2 + 1 + i * 10);
                        if (clusterId != value.getClusterId() || clusterPosition != value.getClusterPosition()) continue;
                        int freePointer = this.getIntValue(28);
                        this.setIntValue(28, freePointer + 10);
                        this.setByteValue(nextItem + 4, (byte)(nextItemSize - 1));
                        this.moveData(freePointer, freePointer + 10, nextItem + 4 + 1 + i * 10 - freePointer);
                        int size = this.getIntValue(32);
                        int currentPositionOffset = 53;
                        for (int n = 0; n < size; ++n) {
                            int updatedEntryPosition;
                            int currentEntryPosition = this.getIntValue(currentPositionOffset);
                            if (currentEntryPosition < nextItem) {
                                updatedEntryPosition = currentEntryPosition + 10;
                                this.setIntValue(currentPositionOffset, updatedEntryPosition);
                            } else {
                                updatedEntryPosition = currentEntryPosition;
                            }
                            int currentNextItem = this.getIntValue(updatedEntryPosition);
                            if (currentNextItem > 0 && currentNextItem < nextItem + 10) {
                                this.setIntValue(updatedEntryPosition, currentNextItem + 10);
                                this.updateAllLinkedListReferences(currentNextItem, nextItem + 10, 10);
                            }
                            currentPositionOffset += 4;
                        }
                        this.setByteValue(embeddedEntriesCountPosition, (byte)(embeddedEntriesCount - 1));
                        this.setIntValue(entriesCountPosition, entriesCount - 1);
                        return entriesCount - 1;
                    }
                }
                prevItem = nextItem;
                nextItem = nextNextItem;
            }
        }
        return -1;
    }

    boolean hasExternalEntries(int entryIndex) {
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        byte embeddedEntriesCount = this.getByteValue(entryPosition + 4);
        int entriesCount = this.getIntValue(entryPosition + 4 + 1);
        assert (entriesCount >= embeddedEntriesCount);
        return entriesCount > embeddedEntriesCount;
    }

    long getMid(int entryIndex) {
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        return this.getLongValue(entryPosition + 8 + 1);
    }

    public boolean decrementEntriesCount(int entryIndex) {
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        int entriesCount = this.getIntValue(entryPosition + 4 + 1);
        this.setIntValue(entryPosition + 4 + 1, entriesCount - 1);
        return entriesCount == 1;
    }

    public void removeMainLeafEntry(int entryIndex, int keySize) {
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        int entriesCount = this.getIntValue(entryPosition + 5);
        long mId = this.getLongValue(entryPosition + 9);
        if (entriesCount == 0) {
            Object value = null;
        } else {
            short clusterId = this.getShortValue(entryPosition + 17);
            long clusterPosition = this.getLongValue(entryPosition + 19);
            ORecordId value = new ORecordId(clusterId, clusterPosition);
        }
        byte[] key = this.getBinaryValue(entryPosition + 27, keySize);
        this.removeMainLeafEntry(entryIndex, entryPosition, keySize);
    }

    public void incrementEntriesCount(int entryIndex) {
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        int entriesCount = this.getIntValue(entryPosition + 4 + 1);
        this.setIntValue(entryPosition + 4 + 1, entriesCount + 1);
    }

    private void updateAllLinkedListReferences(int firstItem, int boundary, int diffSize) {
        int nextItem;
        int currentItem = firstItem + diffSize;
        while ((nextItem = this.getIntValue(currentItem)) > 0 && nextItem < boundary) {
            this.setIntValue(currentItem, nextItem + diffSize);
            currentItem = nextItem + diffSize;
        }
    }

    public int size() {
        return this.getIntValue(32);
    }

    public LeafEntry getLeafEntry(int entryIndex, OBinarySerializer<K> keySerializer, boolean isEncrypted) {
        byte[] key;
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        int nextItem = this.getIntValue(entryPosition);
        byte embeddedEntriesCount = this.getByteValue(entryPosition += 4);
        int entriesCount = this.getIntValue(++entryPosition);
        long mId = this.getLongValue(entryPosition += 4);
        ArrayList<ORID> values = new ArrayList<ORID>(entriesCount);
        short clusterId = this.getShortValue(entryPosition += 8);
        entryPosition += 2;
        if (clusterId >= 0) {
            long clusterPosition = this.getLongValue(entryPosition);
            entryPosition += 8;
            values.add(new ORecordId(clusterId, clusterPosition));
        } else {
            entryPosition += 8;
        }
        if (!isEncrypted) {
            int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            key = this.getBinaryValue(entryPosition, keySize);
        } else {
            int encryptionSize = this.getIntValue(entryPosition);
            key = this.getBinaryValue(entryPosition, encryptionSize + 4);
        }
        while (nextItem > 0) {
            int nextNextItem = this.getIntValue(nextItem);
            int nextItemSize = 0xFF & this.getByteValue(nextItem + 4);
            for (int i = 0; i < nextItemSize; ++i) {
                clusterId = this.getShortValue(nextItem + 4 + 1 + i * 10);
                long clusterPosition = this.getLongValue(nextItem + 2 + 4 + 1 + i * 10);
                values.add(new ORecordId(clusterId, clusterPosition));
            }
            nextItem = nextNextItem;
        }
        assert (values.size() == embeddedEntriesCount);
        return new LeafEntry(key, mId, values, entriesCount);
    }

    public NonLeafEntry getNonLeafEntry(int entryIndex, OBinarySerializer<K> keySerializer, boolean isEncrypted) {
        byte[] key;
        assert (!this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        int leftChild = this.getIntValue(entryPosition);
        int rightChild = this.getIntValue(entryPosition += 4);
        entryPosition += 4;
        if (!isEncrypted) {
            int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            key = this.getBinaryValue(entryPosition, keySize);
        } else {
            int encryptionSize = this.getIntValue(entryPosition);
            key = this.getBinaryValue(entryPosition, encryptionSize + 4);
        }
        return new NonLeafEntry(key, leftChild, rightChild);
    }

    int getLeft(int entryIndex) {
        assert (!this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        return this.getIntValue(entryPosition);
    }

    int getRight(int entryIndex) {
        assert (!this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        return this.getIntValue(entryPosition + 4);
    }

    public K getKey(int index, OBinarySerializer<K> keySerializer, OEncryption encryption) {
        int entryPosition = this.getIntValue(index * 4 + 53);
        entryPosition = !this.isLeaf() ? (entryPosition += 8) : (entryPosition += 27);
        if (encryption == null) {
            return this.deserializeFromDirectMemory(keySerializer, entryPosition);
        }
        int encryptedSize = this.getIntValue(entryPosition);
        byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptedSize);
        byte[] serializedKey = encryption.decrypt(encryptedKey);
        return keySerializer.deserializeNativeObject(serializedKey, 0);
    }

    byte[] getRawKey(int index, OBinarySerializer<K> keySerializer, OEncryption encryption) {
        int entryPosition = this.getIntValue(index * 4 + 53);
        entryPosition = !this.isLeaf() ? (entryPosition += 8) : (entryPosition += 27);
        if (encryption == null) {
            int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            return this.getBinaryValue(entryPosition, keySize);
        }
        int encryptedSize = this.getIntValue(entryPosition);
        return this.getBinaryValue(entryPosition, encryptedSize + 4);
    }

    public boolean isLeaf() {
        return this.getByteValue(36) > 0;
    }

    public void addAll(List<? extends Entry> entries, OBinarySerializer<K> keySerializer, boolean isEncrypted) {
        int currentSize = this.size();
        boolean isLeaf = this.isLeaf();
        if (!isLeaf) {
            for (int i = 0; i < entries.size(); ++i) {
                NonLeafEntry entry = (NonLeafEntry)entries.get(i);
                this.doAddNonLeafEntry(i + currentSize, entry.key, entry.leftChild, entry.rightChild, false);
            }
        } else {
            for (int i = 0; i < entries.size(); ++i) {
                LeafEntry entry = (LeafEntry)entries.get(i);
                byte[] key = entry.key;
                List<ORID> values = entry.values;
                if (!values.isEmpty()) {
                    this.doCreateMainLeafEntry(i + currentSize, key, values.get(0), entry.mId);
                } else {
                    this.doCreateMainLeafEntry(i + currentSize, key, null, entry.mId);
                }
                if (values.size() <= 1) continue;
                this.appendNewLeafEntries(i + currentSize, values.subList(1, values.size()), entry.entriesCount);
            }
        }
        this.setIntValue(32, currentSize + entries.size());
    }

    public void shrink(int newSize, OBinarySerializer<K> keySerializer, boolean isEncrypted) {
        boolean isLeaf = this.isLeaf();
        int currentSize = this.size();
        if (isLeaf) {
            ArrayList<LeafEntry> entriesToAdd = new ArrayList<LeafEntry>(newSize);
            for (int i = 0; i < newSize; ++i) {
                entriesToAdd.add(this.getLeafEntry(i, keySerializer, isEncrypted));
            }
            ArrayList<LeafEntry> entriesToRemove = new ArrayList<LeafEntry>(currentSize - newSize);
            for (int i = newSize; i < currentSize; ++i) {
                entriesToRemove.add(this.getLeafEntry(i, keySerializer, isEncrypted));
            }
            this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
            this.setIntValue(32, 0);
            int index = 0;
            for (LeafEntry entry : entriesToAdd) {
                byte[] key = entry.key;
                List<ORID> values = entry.values;
                if (!values.isEmpty()) {
                    this.doCreateMainLeafEntry(index, key, values.get(0), entry.mId);
                } else {
                    this.doCreateMainLeafEntry(index, key, null, entry.mId);
                }
                if (values.size() > 1) {
                    this.appendNewLeafEntries(index, values.subList(1, values.size()), entry.entriesCount);
                }
                ++index;
            }
        } else {
            ArrayList<NonLeafEntry> entries = new ArrayList<NonLeafEntry>(newSize);
            for (int i = 0; i < newSize; ++i) {
                entries.add(this.getNonLeafEntry(i, keySerializer, isEncrypted));
            }
            ArrayList<NonLeafEntry> entriesToRemove = new ArrayList<NonLeafEntry>(currentSize - newSize);
            for (int i = newSize; i < currentSize; ++i) {
                entriesToRemove.add(this.getNonLeafEntry(i, keySerializer, isEncrypted));
            }
            this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
            this.setIntValue(32, 0);
            int index = 0;
            for (NonLeafEntry entry : entries) {
                this.doAddNonLeafEntry(index, entry.key, entry.leftChild, entry.rightChild, false);
                ++index;
            }
        }
    }

    public boolean createMainLeafEntry(int index, byte[] serializedKey, ORID value, long mId) {
        return !this.doCreateMainLeafEntry(index, serializedKey, value, mId);
    }

    private boolean doCreateMainLeafEntry(int index, byte[] serializedKey, ORID value, long mId) {
        assert (this.isLeaf());
        int entrySize = 27 + serializedKey.length;
        int size = this.getIntValue(32);
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 53) {
            return true;
        }
        if (index <= size - 1) {
            this.moveData(53 + index * 4, 53 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(53 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        freePointer += this.setIntValue(freePointer, -1);
        if (value != null) {
            freePointer += this.setByteValue(freePointer, (byte)1);
            freePointer += this.setIntValue(freePointer, 1);
        } else {
            freePointer += this.setByteValue(freePointer, (byte)0);
            freePointer += this.setIntValue(freePointer, 0);
        }
        freePointer += this.setLongValue(freePointer, mId);
        if (value != null) {
            freePointer += this.setShortValue(freePointer, (short)value.getClusterId());
            freePointer += this.setLongValue(freePointer, value.getClusterPosition());
        } else {
            freePointer += this.setShortValue(freePointer, (short)-1);
            freePointer += this.setLongValue(freePointer, -1L);
        }
        this.setBinaryValue(freePointer, serializedKey);
        return false;
    }

    public long appendNewLeafEntry(int index, ORID value) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(index * 4 + 53);
        int nextItem = this.getIntValue(entryPosition);
        byte embeddedEntriesCount = this.getByteValue(entryPosition + 4);
        int entriesCount = this.getIntValue(entryPosition + 1 + 4);
        long mId = this.getLongValue(entryPosition + 1 + 8);
        if (embeddedEntriesCount < 64) {
            if (embeddedEntriesCount > 0) {
                int size;
                int itemSize = 15;
                int freePointer = this.getIntValue(28);
                if (freePointer - 15 < (size = this.getIntValue(32)) * 4 + 53) {
                    return -2L;
                }
                this.setIntValue(entryPosition, freePointer -= 15);
                freePointer += this.setIntValue(freePointer, nextItem);
                freePointer += this.setByteValue(freePointer, (byte)1);
                freePointer += this.setShortValue(freePointer, (short)value.getClusterId());
                freePointer += this.setLongValue(freePointer, value.getClusterPosition());
                this.setIntValue(28, freePointer -= 15);
            } else {
                this.setShortValue(entryPosition + 17, (short)value.getClusterId());
                this.setLongValue(entryPosition + 19, value.getClusterPosition());
            }
        } else {
            return mId;
        }
        this.setByteValue(entryPosition + 4, (byte)(embeddedEntriesCount + 1));
        this.setIntValue(entryPosition + 1 + 4, entriesCount + 1);
        return -1L;
    }

    private void appendNewLeafEntries(int index, List<ORID> values, int entriesCount) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(index * 4 + 53);
        byte embeddedEntriesCount = this.getByteValue(entryPosition + 4);
        if (values.size() > 64 - embeddedEntriesCount) {
            throw new IllegalStateException("Can not insert " + values.size() + " embedded entries, limit is " + (64 - embeddedEntriesCount));
        }
        int startIndex = 0;
        if (embeddedEntriesCount == 0) {
            ORID rid = values.get(0);
            this.setShortValue(entryPosition + 8 + 1, (short)rid.getClusterId());
            this.setLongValue(entryPosition + 8 + 1 + 2, rid.getClusterPosition());
            startIndex = 1;
        }
        if (values.size() > startIndex) {
            int itemSize = 4 + 10 * values.size() + 1;
            int freePointer = this.getIntValue(28);
            this.setIntValue(28, freePointer -= itemSize);
            int nextItem = this.getIntValue(entryPosition);
            this.setIntValue(entryPosition, freePointer);
            freePointer += this.setIntValue(freePointer, nextItem);
            freePointer += this.setByteValue(freePointer, (byte)values.size());
            for (int i = startIndex; i < values.size(); ++i) {
                ORID rid = values.get(i);
                freePointer += this.setShortValue(freePointer, (short)rid.getClusterId());
                freePointer += this.setLongValue(freePointer, rid.getClusterPosition());
            }
        }
        this.setByteValue(entryPosition + 4, (byte)(embeddedEntriesCount + values.size()));
        this.setIntValue(entryPosition + 1 + 4, entriesCount);
    }

    public boolean addNonLeafEntry(int index, byte[] serializedKey, int leftChild, int rightChild, boolean updateNeighbors) {
        int prevChild = this.doAddNonLeafEntry(index, serializedKey, leftChild, rightChild, updateNeighbors);
        return prevChild >= -1;
    }

    private int doAddNonLeafEntry(int index, byte[] serializedKey, int leftChild, int rightChild, boolean updateNeighbors) {
        assert (!this.isLeaf());
        int entrySize = serializedKey.length + 8;
        int size = this.size();
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 53) {
            return -2;
        }
        if (index <= size - 1) {
            this.moveData(53 + index * 4, 53 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(53 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        freePointer += this.setIntValue(freePointer, leftChild);
        freePointer += this.setIntValue(freePointer, rightChild);
        this.setBinaryValue(freePointer, serializedKey);
        int prevChild = -1;
        if (updateNeighbors && ++size > 1) {
            if (index < size - 1) {
                int nextEntryPosition = this.getIntValue(53 + (index + 1) * 4);
                prevChild = this.getIntValue(nextEntryPosition);
                this.setIntValue(nextEntryPosition, rightChild);
            }
            if (index > 0) {
                int prevEntryPosition = this.getIntValue(53 + (index - 1) * 4);
                prevChild = this.getIntValue(prevEntryPosition + 4);
                this.setIntValue(prevEntryPosition + 4, leftChild);
            }
        }
        return prevChild;
    }

    public void removeNonLeafEntry(int entryIndex, byte[] key, int prevChild) {
        if (this.isLeaf()) {
            throw new IllegalStateException("Remove is applied to non-leaf buckets only");
        }
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        int entrySize = key.length + 8;
        int size = this.getIntValue(32);
        int leftChild = this.getIntValue(entryPosition);
        int rightChild = this.getIntValue(entryPosition + 4);
        if (entryIndex < size - 1) {
            this.moveData(53 + (entryIndex + 1) * 4, 53 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 53;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        if (prevChild >= 0) {
            if (entryIndex > 0) {
                int prevEntryPosition = this.getIntValue(53 + (entryIndex - 1) * 4);
                this.setIntValue(prevEntryPosition + 4, prevChild);
            }
            if (entryIndex < size) {
                int nextEntryPosition = this.getIntValue(53 + entryIndex * 4);
                this.setIntValue(nextEntryPosition, prevChild);
            }
        }
    }

    public void setLeftSibling(long pageIndex) {
        long prevSibling = this.getLongValue(37);
        this.setLongValue(37, pageIndex);
    }

    public long getLeftSibling() {
        return this.getLongValue(37);
    }

    public void setRightSibling(long pageIndex) {
        long prevSibling = this.getLongValue(45);
        this.setLongValue(45, pageIndex);
    }

    public long getRightSibling() {
        return this.getLongValue(45);
    }

    public static final class NonLeafEntry
    extends Entry {
        public final int leftChild;
        public final int rightChild;

        public NonLeafEntry(byte[] key, int leftChild, int rightChild) {
            super(key);
            this.leftChild = leftChild;
            this.rightChild = rightChild;
        }
    }

    public static final class LeafEntry
    extends Entry {
        public final long mId;
        public final List<ORID> values;
        public final int entriesCount;

        public LeafEntry(byte[] key, long mId, List<ORID> values, int entriesCount) {
            super(key);
            this.mId = mId;
            this.values = values;
            this.entriesCount = entriesCount;
        }
    }

    protected static class Entry {
        public final byte[] key;

        Entry(byte[] key) {
            this.key = key;
        }
    }
}

