/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.singlevalue;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OTooBigIndexKeyException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.OCellBTreeSingleValueException;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.OEntryPoint;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.ONullBucket;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.OSBTreeBucketSingleValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class OCellBTreeSingleValue<K>
extends ODurableComponent {
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final int ENTRY_POINT_INDEX = 0;
    private static final long ROOT_INDEX = 1L;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private long fileId;
    private long nullBucketFileId = -1L;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;
    private OEncryption encryption;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCellBTreeSingleValue(String name, String dataFileExtension, String nullFileExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void create(OAtomicOperation atomicOperation, OBinarySerializer<K> keySerializer, OType[] keyTypes, int keySize, OEncryption encryption) {
        assert (keySerializer != null);
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                this.keySize = keySize;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.encryption = encryption;
                this.keySerializer = keySerializer;
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullFileExtension);
                OCacheEntry entryPointCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
                    entryPoint.init();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
                }
                OCacheEntry rootCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    OSBTreeBucketSingleValue oSBTreeBucketSingleValue = new OSBTreeBucketSingleValue(rootCacheEntry, true, keySerializer, keyTypes, encryption);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rootCacheEntry);
                }
                OCacheEntry nullCacheEntry = this.addPage(atomicOperation, this.nullBucketFileId);
                try {
                    ONullBucket oNullBucket = new ONullBucket(nullCacheEntry, true);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, nullCacheEntry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ORID get(K key) {
        ORID oRID;
        OCacheEntry keyBucketCacheEntry;
        this.atomicOperationsManager.acquireReadLock(this);
        this.acquireSharedLock();
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        if (key != null) {
            BucketSearchResult bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, (Object[])this.keyTypes), atomicOperation);
            if (bucketSearchResult.itemIndex < 0) {
                ORID oRID2 = null;
                return oRID2;
            }
            long pageIndex = bucketSearchResult.pageIndex;
            keyBucketCacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            OSBTreeBucketSingleValue<K> keyBucket = new OSBTreeBucketSingleValue<K>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.encryption);
            ORID oRID3 = keyBucket.getValue(bucketSearchResult.itemIndex);
            return oRID3;
        }
        OCacheEntry nullBucketCacheEntry = this.loadPageForRead(atomicOperation, this.nullBucketFileId, 0L, false);
        try {
            ONullBucket nullBucket = new ONullBucket(nullBucketCacheEntry, false);
            oRID = nullBucket.getValue();
        }
        catch (Throwable throwable) {
            try {
                this.releasePageFromRead(atomicOperation, nullBucketCacheEntry);
                throw throwable;
            }
            catch (IOException e) {}
            throw OException.wrapException(new OCellBTreeSingleValueException("Error during retrieving  of sbtree with name " + this.getName(), this), e);
            finally {
                this.releasePageFromRead(atomicOperation, keyBucketCacheEntry);
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
        this.releasePageFromRead(atomicOperation, nullBucketCacheEntry);
        return oRID;
    }

    public void put(OAtomicOperation atomicOperation, K key, ORID value) {
        this.update(atomicOperation, key, value, null);
    }

    public boolean validatedPut(OAtomicOperation atomicOperation, K key, ORID value, OBaseIndexEngine.Validator<K, ORID> validator) {
        return this.update(atomicOperation, key, value, validator);
    }

    private boolean update(OAtomicOperation atomicOperation, K key, ORID value, OBaseIndexEngine.Validator<K, ORID> validator) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                if (key != null) {
                    int sizeDiff;
                    int insertionIndex;
                    byte[] rawKey;
                    ORecordId oldValue;
                    byte[] oldRawValue;
                    Object preProcessedKey = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                    byte[] serializedKey = this.keySerializer.serializeNativeAsWhole(preProcessedKey, (Object[])this.keyTypes);
                    if (this.keySize > MAX_KEY_SIZE) {
                        throw new OTooBigIndexKeyException("Key size is more than allowed, operation was canceled. Current key size " + this.keySize + ", allowed  " + MAX_KEY_SIZE, this.getName());
                    }
                    UpdateBucketSearchResult bucketSearchResult = this.findBucketForUpdate(preProcessedKey, atomicOperation);
                    OCacheEntry keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
                    OSBTreeBucketSingleValue<K> keyBucket = new OSBTreeBucketSingleValue<K>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.encryption);
                    byte[] byArray = oldRawValue = bucketSearchResult.itemIndex > -1 ? keyBucket.getRawValue(bucketSearchResult.itemIndex) : null;
                    if (oldRawValue == null) {
                        oldValue = null;
                    } else {
                        short clusterId = OShortSerializer.INSTANCE.deserializeNative(oldRawValue, 0);
                        long clusterPosition = OLongSerializer.INSTANCE.deserializeNative(oldRawValue, 2);
                        oldValue = new ORecordId(clusterId, clusterPosition);
                    }
                    ORID updatedValue = value;
                    if (validator != null) {
                        boolean failure = true;
                        boolean ignored = false;
                        try {
                            Object result = validator.validate(preProcessedKey, oldValue, updatedValue);
                            if (result == OBaseIndexEngine.Validator.IGNORE) {
                                ignored = true;
                                failure = false;
                                Boolean bl = false;
                                return bl;
                            }
                            updatedValue = (ORID)result;
                            failure = false;
                        }
                        finally {
                            if (failure || ignored) {
                                this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                            }
                        }
                    }
                    byte[] serializedValue = new byte[10];
                    OShortSerializer.INSTANCE.serializeNative((short)updatedValue.getClusterId(), serializedValue, 0, new Object[0]);
                    OLongSerializer.INSTANCE.serializeNative(updatedValue.getClusterPosition(), serializedValue, 2, new Object[0]);
                    if (this.encryption == null) {
                        rawKey = serializedKey;
                    } else {
                        byte[] encryptedKey = this.encryption.encrypt(serializedKey);
                        rawKey = new byte[4 + encryptedKey.length];
                        OIntegerSerializer.INSTANCE.serializeNative(encryptedKey.length, rawKey, 0, new Object[0]);
                        System.arraycopy(encryptedKey, 0, rawKey, 4, encryptedKey.length);
                    }
                    if (bucketSearchResult.itemIndex >= 0) {
                        assert (oldRawValue != null);
                        if (oldRawValue.length == serializedValue.length) {
                            keyBucket.updateValue(bucketSearchResult.itemIndex, serializedValue);
                            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                            Boolean bl = true;
                            return bl;
                        }
                        keyBucket.remove(bucketSearchResult.itemIndex, rawKey);
                        insertionIndex = bucketSearchResult.itemIndex;
                        sizeDiff = 0;
                    } else {
                        insertionIndex = -bucketSearchResult.itemIndex - 1;
                        sizeDiff = 1;
                    }
                    while (!keyBucket.addLeafEntry(insertionIndex, rawKey, serializedValue)) {
                        bucketSearchResult = this.splitBucket(keyBucket, keyBucketCacheEntry, bucketSearchResult.path, bucketSearchResult.insertionIndexes, insertionIndex, atomicOperation);
                        insertionIndex = bucketSearchResult.itemIndex;
                        long pageIndex = bucketSearchResult.getLastPathItem();
                        if (pageIndex != keyBucketCacheEntry.getPageIndex()) {
                            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                            keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
                        }
                        keyBucket = new OSBTreeBucketSingleValue<K>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.encryption);
                    }
                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                    if (sizeDiff != 0) {
                        this.updateSize(sizeDiff, atomicOperation);
                    }
                } else {
                    OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                    int sizeDiff = 0;
                    try {
                        Object result;
                        ONullBucket nullBucket = new ONullBucket(cacheEntry, false);
                        ORID oldValue = nullBucket.getValue();
                        if (validator != null && (result = validator.validate(null, oldValue, value)) == OBaseIndexEngine.Validator.IGNORE) {
                            Boolean bl = false;
                            return bl;
                        }
                        if (oldValue != null) {
                            sizeDiff = -1;
                        }
                        nullBucket.setValue(value);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateSize(++sizeDiff, atomicOperation);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    public void close() {
        this.acquireExclusiveLock();
        try {
            this.readCache.closeFile(this.fileId, true, this.writeCache);
            this.readCache.closeFile(this.nullBucketFileId, true, this.writeCache);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void clear(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                OCacheEntry nullCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                try {
                    ONullBucket nullBucket = new ONullBucket(nullCacheEntry, false);
                    nullBucket.removeValue();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, nullCacheEntry);
                }
                OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
                try {
                    OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
                    entryPoint.init();
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
                }
                OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 1L, false, true);
                try {
                    OSBTreeBucketSingleValue<K> oSBTreeBucketSingleValue = new OSBTreeBucketSingleValue<K>(cacheEntry, true, this.keySerializer, this.keyTypes, this.encryption);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    public void delete(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                this.deleteFile(atomicOperation, this.nullBucketFileId);
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    public void deleteWithoutLoad(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    long fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, fileId);
                }
                if (this.isFileExists(atomicOperation, this.getName() + this.nullFileExtension)) {
                    long nullFileId = this.openFile(atomicOperation, this.getName() + this.nullFileExtension);
                    this.deleteFile(atomicOperation, nullFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    public void load(String name, int keySize, OType[] keyTypes, OBinarySerializer<K> keySerializer, OEncryption encryption) {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullFileExtension);
            this.keySize = keySize;
            this.keyTypes = keyTypes;
            this.keySerializer = keySerializer;
            this.encryption = encryption;
        }
        catch (IOException e) {
            throw OException.wrapException(new OCellBTreeSingleValueException("Exception during loading of sbtree " + name, this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ORID remove(OAtomicOperation atomicOperation, K key) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                ORID removedValue;
                if (key != null) {
                    Object preProcessedKey = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                    BucketSearchResult bucketSearchResult = this.findBucket(preProcessedKey, atomicOperation);
                    if (bucketSearchResult.itemIndex < 0) {
                        ORID oRID = null;
                        return oRID;
                    }
                    removedValue = this.removeKey(atomicOperation, bucketSearchResult);
                } else {
                    if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) == 0L) {
                        ORID oRID = null;
                        return oRID;
                    }
                    removedValue = this.removeNullBucket(atomicOperation);
                }
                ORID oRID = removedValue;
                return oRID;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORID removeNullBucket(OAtomicOperation atomicOperation) throws IOException {
        ORID removedValue;
        OCacheEntry nullCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
        try {
            ONullBucket nullBucket = new ONullBucket(nullCacheEntry, false);
            removedValue = nullBucket.getValue();
            if (removedValue != null) {
                nullBucket.removeValue();
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, nullCacheEntry);
        }
        if (removedValue != null) {
            this.updateSize(-1L, atomicOperation);
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORID removeKey(OAtomicOperation atomicOperation, BucketSearchResult bucketSearchResult) throws IOException {
        ORID removedValue;
        OCacheEntry keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.pageIndex, false, true);
        try {
            OSBTreeBucketSingleValue<K> keyBucket = new OSBTreeBucketSingleValue<K>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.encryption);
            removedValue = keyBucket.getValue(bucketSearchResult.itemIndex);
            keyBucket.remove(bucketSearchResult.itemIndex, null);
            this.updateSize(-1L, atomicOperation);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<K, ORID> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OSBTreeCursor<K, ORID> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (ascSortOrder) break block8;
                    oSBTreeCursor = this.iterateEntriesMinorDesc(key, inclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, ORID> oSBTreeCursor = this.iterateEntriesMinorAsc(key, inclusive);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<K, ORID> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OSBTreeCursor<K, ORID> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    oSBTreeCursor = this.iterateEntriesMajorAsc(key, inclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, ORID> oSBTreeCursor = this.iterateEntriesMajorDesc(key, inclusive);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeKeyCursor<K> keyCursor() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            BucketSearchResult searchResult;
            block10: {
                OSBTreeKeyCursor<Object> oSBTreeKeyCursor;
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    searchResult = this.firstItem(atomicOperation);
                    if (searchResult != null) break block10;
                    oSBTreeKeyCursor = prefetchSize -> null;
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw OException.wrapException(new OCellBTreeSingleValueException("Error during finding first key in sbtree [" + this.getName() + "]", this), e);
                    }
                }
                this.releaseSharedLock();
                return oSBTreeKeyCursor;
            }
            OSBTreeFullKeyCursor oSBTreeFullKeyCursor = new OSBTreeFullKeyCursor(searchResult.pageIndex);
            this.releaseSharedLock();
            return oSBTreeFullKeyCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<K, ORID> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OSBTreeCursor<K, ORID> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    oSBTreeCursor = this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, ORID> oSBTreeCursor = this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSize(long diffSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
            entryPoint.setTreeSize(entryPoint.getTreeSize() + diffSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
    }

    private OSBTreeCursor<K, ORID> iterateEntriesMinorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        return new OSBTreeCursorBackward(null, key, false, inclusive);
    }

    private OSBTreeCursor<K, ORID> iterateEntriesMinorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
        return new OSBTreeCursorForward(null, key, false, inclusive);
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private OSBTreeCursor<K, ORID> iterateEntriesMajorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        return new OSBTreeCursorForward(key, null, inclusive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSBTreeCursor<K, ORID> iterateEntriesMajorDesc(K key, boolean inclusive) {
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
            OSBTreeCursorBackward oSBTreeCursorBackward = new OSBTreeCursorBackward(key, null, inclusive, false);
            return oSBTreeCursorBackward;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        int itemIndex = 0;
        try {
            OSBTreeBucketSingleValue<K> bucket = new OSBTreeBucketSingleValue<K>(cacheEntry, this.keySerializer, this.keyTypes, this.encryption);
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex + 1;
                    } else {
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        bucketIndex = itemIndex < bucket.size() ? (long)bucket.getLeft(itemIndex) : (long)bucket.getRight(itemIndex - 1);
                        itemIndex = 0;
                    }
                } else {
                    BucketSearchResult bucketSearchResult;
                    if (!bucket.isEmpty()) {
                        bucketSearchResult = new BucketSearchResult(0, bucketIndex);
                        return bucketSearchResult;
                    }
                    if (path.isEmpty()) {
                        bucketSearchResult = null;
                        return bucketSearchResult;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex + 1;
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new OSBTreeBucketSingleValue<K>(cacheEntry, this.keySerializer, this.keyTypes, this.encryption);
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 1L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        OSBTreeBucketSingleValue<K> bucket = new OSBTreeBucketSingleValue<K>(cacheEntry, this.keySerializer, this.keyTypes, this.encryption);
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex - 1;
                    } else {
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        bucketIndex = itemIndex > -1 ? (long)bucket.getRight(itemIndex) : (long)bucket.getLeft(0);
                        itemIndex = OSBTreeBucketSingleValue.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else {
                    BucketSearchResult bucketSearchResult;
                    if (!bucket.isEmpty()) {
                        bucketSearchResult = new BucketSearchResult(bucket.size() - 1, bucketIndex);
                        return bucketSearchResult;
                    }
                    if (path.isEmpty()) {
                        bucketSearchResult = null;
                        return bucketSearchResult;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex - 1;
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new OSBTreeBucketSingleValue<K>(cacheEntry, this.keySerializer, this.keyTypes, this.encryption);
                if (itemIndex != OSBTreeBucketSingleValue.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private OSBTreeCursor<K, ORID> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        return new OSBTreeCursorForward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private OSBTreeCursor<K, ORID> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        return new OSBTreeCursorBackward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private UpdateBucketSearchResult splitBucket(OSBTreeBucketSingleValue<K> bucketToSplit, OCacheEntry entryToSplit, List<Long> path, List<Integer> itemPointers, int keyIndex, OAtomicOperation atomicOperation) throws IOException {
        int startRightIndex;
        boolean splitLeaf = bucketToSplit.isLeaf();
        int bucketSize = bucketToSplit.size();
        int indexToSplit = bucketSize >>> 1;
        K separationKey = bucketToSplit.getKey(indexToSplit);
        ArrayList<byte[]> rightEntries = new ArrayList<byte[]>(indexToSplit);
        for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
            rightEntries.add(bucketToSplit.getRawEntry(i));
        }
        if (entryToSplit.getPageIndex() != 1L) {
            return this.splitNonRootBucket(path, itemPointers, keyIndex, entryToSplit.getPageIndex(), bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
        }
        return this.splitRootBucket(keyIndex, entryToSplit, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult splitNonRootBucket(List<Long> path, List<Integer> itemPointers, int keyIndex, long pageIndex, OSBTreeBucketSingleValue<K> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry;
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
            int pageSize = entryPoint.getPagesSize();
            if ((long)pageSize < this.getFilledUpTo(atomicOperation, this.fileId) - 1L) {
                rightBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, ++pageSize, false, false);
                entryPoint.setPagesSize(pageSize);
            } else {
                assert ((long)pageSize == this.getFilledUpTo(atomicOperation, this.fileId) - 1L);
                rightBucketEntry = this.addPage(atomicOperation, this.fileId);
                entryPoint.setPagesSize((int)rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
        try {
            OSBTreeBucketSingleValue<K> newRightBucket = new OSBTreeBucketSingleValue<K>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.encryption);
            newRightBucket.addAll(rightEntries);
            bucketToSplit.shrink(indexToSplit);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, rightSiblingPageIndex, false, true);
                    OSBTreeBucketSingleValue<K> rightSiblingBucket = new OSBTreeBucketSingleValue<K>(rightSiblingBucketEntry, this.keySerializer, this.keyTypes, this.encryption);
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, rightSiblingBucketEntry);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
            try {
                OSBTreeBucketSingleValue<K> parentBucket = new OSBTreeBucketSingleValue<K>(parentCacheEntry, this.keySerializer, this.keyTypes, this.encryption);
                OSBTreeBucketSingleValue.SBTreeEntry<K> parentEntry = new OSBTreeBucketSingleValue.SBTreeEntry<K>((int)pageIndex, (int)rightBucketEntry.getPageIndex(), separationKey, null);
                int insertionIndex = itemPointers.get(itemPointers.size() - 2);
                while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                    UpdateBucketSearchResult bucketSearchResult = this.splitBucket(parentBucket, parentCacheEntry, path.subList(0, path.size() - 1), itemPointers.subList(0, itemPointers.size() - 1), insertionIndex, atomicOperation);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    insertionIndex = bucketSearchResult.itemIndex;
                    if (parentIndex != parentCacheEntry.getPageIndex()) {
                        this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                        parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
                    }
                    parentBucket = new OSBTreeBucketSingleValue<K>(parentCacheEntry, this.keySerializer, this.keyTypes, this.encryption);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, parentCacheEntry);
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        ArrayList<Integer> resultItemPointers = new ArrayList<Integer>(itemPointers.subList(0, itemPointers.size() - 1));
        if (keyIndex <= indexToSplit) {
            resultPath.add(pageIndex);
            resultItemPointers.add(keyIndex);
            return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex);
        }
        int parentIndex = resultItemPointers.size() - 1;
        resultItemPointers.set(parentIndex, resultItemPointers.get(parentIndex) + 1);
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            resultItemPointers.add(keyIndex - indexToSplit);
            return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex - indexToSplit);
        }
        resultItemPointers.add(keyIndex - indexToSplit - 1);
        return new UpdateBucketSearchResult(resultItemPointers, resultPath, keyIndex - indexToSplit - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult splitRootBucket(int keyIndex, OCacheEntry bucketEntry, OSBTreeBucketSingleValue<K> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry;
        OCacheEntry leftBucketEntry;
        ArrayList<byte[]> leftEntries = new ArrayList<byte[]>(indexToSplit);
        for (int i = 0; i < indexToSplit; ++i) {
            leftEntries.add(bucketToSplit.getRawEntry(i));
        }
        OCacheEntry entryPointCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
            int pagesSize = entryPoint.getPagesSize();
            int filledUpTo = (int)this.getFilledUpTo(atomicOperation, this.fileId);
            if (pagesSize < filledUpTo - 1) {
                leftBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, ++pagesSize, false, false);
            } else {
                assert (pagesSize == filledUpTo - 1);
                leftBucketEntry = this.addPage(atomicOperation, this.fileId);
                pagesSize = (int)leftBucketEntry.getPageIndex();
            }
            if (pagesSize < filledUpTo) {
                rightBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, ++pagesSize, false, false);
            } else {
                assert (pagesSize == filledUpTo);
                rightBucketEntry = this.addPage(atomicOperation, this.fileId);
                pagesSize = (int)rightBucketEntry.getPageIndex();
            }
            entryPoint.setPagesSize(pagesSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointCacheEntry);
        }
        try {
            OSBTreeBucketSingleValue<K> newLeftBucket = new OSBTreeBucketSingleValue<K>(leftBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.encryption);
            newLeftBucket.addAll(leftEntries);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, leftBucketEntry);
        }
        try {
            OSBTreeBucketSingleValue<K> newRightBucket = new OSBTreeBucketSingleValue<K>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.encryption);
            newRightBucket.addAll(rightEntries);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        bucketToSplit = new OSBTreeBucketSingleValue<K>(bucketEntry, false, this.keySerializer, this.keyTypes, this.encryption);
        bucketToSplit.addEntry(0, new OSBTreeBucketSingleValue.SBTreeEntry<K>((int)leftBucketEntry.getPageIndex(), (int)rightBucketEntry.getPageIndex(), separationKey, null), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(8);
        resultPath.add(1L);
        ArrayList<Integer> itemPointers = new ArrayList<Integer>(8);
        if (keyIndex <= indexToSplit) {
            itemPointers.add(-1);
            itemPointers.add(keyIndex);
            resultPath.add(leftBucketEntry.getPageIndex());
            return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        itemPointers.add(0);
        if (splitLeaf) {
            itemPointers.add(keyIndex - indexToSplit);
            return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex - indexToSplit);
        }
        itemPointers.add(keyIndex - indexToSplit - 1);
        return new UpdateBucketSearchResult(itemPointers, resultPath, keyIndex - indexToSplit - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 1L;
        int depth = 0;
        while (true) {
            if (++depth > MAX_PATH_LENGTH) {
                throw new OCellBTreeSingleValueException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                OSBTreeBucketSingleValue<K> keyBucket = new OSBTreeBucketSingleValue<K>(bucketEntry, this.keySerializer, this.keyTypes, this.encryption);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, pageIndex);
                    return bucketSearchResult;
                }
                if (index >= 0) {
                    pageIndex = keyBucket.getRight(index);
                    continue;
                }
                int insertionIndex = -index - 1;
                if (insertionIndex >= keyBucket.size()) {
                    pageIndex = keyBucket.getRight(insertionIndex - 1);
                    continue;
                }
                pageIndex = keyBucket.getLeft(insertionIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateBucketSearchResult findBucketForUpdate(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 1L;
        ArrayList<Long> path = new ArrayList<Long>(8);
        ArrayList<Integer> itemIndexes = new ArrayList<Integer>(8);
        while (true) {
            if (path.size() > MAX_PATH_LENGTH) {
                throw new OCellBTreeSingleValueException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                OSBTreeBucketSingleValue<K> keyBucket = new OSBTreeBucketSingleValue<K>(bucketEntry, this.keySerializer, this.keyTypes, this.encryption);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    itemIndexes.add(index);
                    UpdateBucketSearchResult updateBucketSearchResult = new UpdateBucketSearchResult(itemIndexes, path, index);
                    return updateBucketSearchResult;
                }
                if (index >= 0) {
                    pageIndex = keyBucket.getRight(index);
                    itemIndexes.add(index + 1);
                    continue;
                }
                int insertionIndex = -index - 1;
                pageIndex = insertionIndex >= keyBucket.size() ? (long)keyBucket.getRight(insertionIndex - 1) : (long)keyBucket.getLeft(insertionIndex);
                itemIndexes.add(insertionIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    private Map.Entry<K, ORID> convertToMapEntry(OSBTreeBucketSingleValue.SBTreeEntry<K> treeEntry) {
        final Object key = treeEntry.key;
        final ORID value = treeEntry.value;
        return new Map.Entry<K, ORID>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public ORID getValue() {
                return value;
            }

            @Override
            public ORID setValue(ORID value2) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    private final class OSBTreeCursorBackward
    implements OSBTreeCursor<K, ORID> {
        private final K fromKey;
        private K toKey;
        private final boolean fromKeyInclusive;
        private boolean toKeyInclusive;
        private final List<Map.Entry<K, ORID>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, ORID>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorBackward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (toKey == null) {
                this.toKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, ORID> next(int prefetchSize) {
            block26: {
                if (this.dataCacheIterator == null) {
                    return null;
                }
                if (this.dataCacheIterator.hasNext()) {
                    Map.Entry entry = this.dataCacheIterator.next();
                    this.toKey = entry.getKey();
                    this.toKeyInclusive = false;
                    return entry;
                }
                this.dataCache.clear();
                if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                OCellBTreeSingleValue.this.atomicOperationsManager.acquireReadLock(OCellBTreeSingleValue.this);
                try {
                    OCellBTreeSingleValue.this.acquireSharedLock();
                    try {
                        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        BucketSearchResult bucketSearchResult = this.toKey != null ? OCellBTreeSingleValue.this.findBucket(this.toKey, atomicOperation) : OCellBTreeSingleValue.this.lastItem(atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            Map.Entry entry = null;
                            return entry;
                        }
                        long pageIndex = bucketSearchResult.pageIndex;
                        int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.toKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
                        while (this.dataCache.size() < prefetchSize) {
                            if (pageIndex == -1L) {
                                break;
                            }
                            OCacheEntry cacheEntry = OCellBTreeSingleValue.this.loadPageForRead(atomicOperation, OCellBTreeSingleValue.this.fileId, pageIndex, false);
                            try {
                                OSBTreeBucketSingleValue bucket = new OSBTreeBucketSingleValue(cacheEntry, OCellBTreeSingleValue.this.keySerializer, OCellBTreeSingleValue.this.keyTypes, OCellBTreeSingleValue.this.encryption);
                                if (itemIndex >= bucket.size()) {
                                    itemIndex = bucket.size() - 1;
                                }
                                if (itemIndex < 0) {
                                    pageIndex = bucket.getLeftSibling();
                                    itemIndex = Integer.MAX_VALUE;
                                    continue;
                                }
                                while (itemIndex >= 0 && this.dataCache.size() < prefetchSize) {
                                    Map.Entry entry = OCellBTreeSingleValue.this.convertToMapEntry(bucket.getEntry(itemIndex));
                                    --itemIndex;
                                    if (this.toKey != null && (!this.toKeyInclusive ? OCellBTreeSingleValue.this.comparator.compare(entry.getKey(), this.toKey) >= 0 : OCellBTreeSingleValue.this.comparator.compare(entry.getKey(), this.toKey) > 0)) continue;
                                    if (this.fromKey == null || !(this.fromKeyInclusive ? OCellBTreeSingleValue.this.comparator.compare(entry.getKey(), this.fromKey) < 0 : OCellBTreeSingleValue.this.comparator.compare(entry.getKey(), this.fromKey) <= 0)) {
                                        this.dataCache.add(entry);
                                        continue;
                                    }
                                    break block26;
                                }
                            }
                            finally {
                                OCellBTreeSingleValue.this.releasePageFromRead(atomicOperation, cacheEntry);
                            }
                        }
                    }
                    finally {
                        OCellBTreeSingleValue.this.releaseSharedLock();
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new OCellBTreeSingleValueException("Error during element iteration", OCellBTreeSingleValue.this), e);
                }
                finally {
                    OCellBTreeSingleValue.this.atomicOperationsManager.releaseReadLock(OCellBTreeSingleValue.this);
                }
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            Map.Entry entry = this.dataCacheIterator.next();
            this.toKey = entry.getKey();
            this.toKeyInclusive = false;
            return entry;
        }
    }

    private final class OSBTreeCursorForward
    implements OSBTreeCursor<K, ORID> {
        private K fromKey;
        private final K toKey;
        private boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private final List<Map.Entry<K, ORID>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, ORID>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorForward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (fromKey == null) {
                this.fromKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, ORID> next(int prefetchSize) {
            block26: {
                if (this.dataCacheIterator == null) {
                    return null;
                }
                if (this.dataCacheIterator.hasNext()) {
                    Map.Entry entry = this.dataCacheIterator.next();
                    this.fromKey = entry.getKey();
                    this.fromKeyInclusive = false;
                    return entry;
                }
                this.dataCache.clear();
                if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                if (prefetchSize == 0) {
                    prefetchSize = 1;
                }
                OCellBTreeSingleValue.this.atomicOperationsManager.acquireReadLock(OCellBTreeSingleValue.this);
                try {
                    OCellBTreeSingleValue.this.acquireSharedLock();
                    try {
                        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        BucketSearchResult bucketSearchResult = this.fromKey != null ? OCellBTreeSingleValue.this.findBucket(this.fromKey, atomicOperation) : OCellBTreeSingleValue.this.firstItem(atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            Map.Entry entry = null;
                            return entry;
                        }
                        long pageIndex = bucketSearchResult.pageIndex;
                        int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.fromKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
                        while (this.dataCache.size() < prefetchSize) {
                            if (pageIndex == -1L) {
                                break;
                            }
                            OCacheEntry cacheEntry = OCellBTreeSingleValue.this.loadPageForRead(atomicOperation, OCellBTreeSingleValue.this.fileId, pageIndex, false);
                            try {
                                OSBTreeBucketSingleValue bucket = new OSBTreeBucketSingleValue(cacheEntry, OCellBTreeSingleValue.this.keySerializer, OCellBTreeSingleValue.this.keyTypes, OCellBTreeSingleValue.this.encryption);
                                int bucketSize = bucket.size();
                                if (itemIndex >= bucketSize) {
                                    pageIndex = bucket.getRightSibling();
                                    itemIndex = 0;
                                    continue;
                                }
                                while (itemIndex < bucketSize && this.dataCache.size() < prefetchSize) {
                                    Map.Entry entry = OCellBTreeSingleValue.this.convertToMapEntry(bucket.getEntry(itemIndex));
                                    ++itemIndex;
                                    if (this.fromKey != null && (!this.fromKeyInclusive ? OCellBTreeSingleValue.this.comparator.compare(entry.getKey(), this.fromKey) <= 0 : OCellBTreeSingleValue.this.comparator.compare(entry.getKey(), this.fromKey) < 0)) continue;
                                    if (this.toKey == null || !(this.toKeyInclusive ? OCellBTreeSingleValue.this.comparator.compare(entry.getKey(), this.toKey) > 0 : OCellBTreeSingleValue.this.comparator.compare(entry.getKey(), this.toKey) >= 0)) {
                                        this.dataCache.add(entry);
                                        continue;
                                    }
                                    break block26;
                                }
                            }
                            finally {
                                OCellBTreeSingleValue.this.releasePageFromRead(atomicOperation, cacheEntry);
                            }
                        }
                    }
                    finally {
                        OCellBTreeSingleValue.this.releaseSharedLock();
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new OCellBTreeSingleValueException("Error during element iteration", OCellBTreeSingleValue.this), e);
                }
                finally {
                    OCellBTreeSingleValue.this.atomicOperationsManager.releaseReadLock(OCellBTreeSingleValue.this);
                }
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            Map.Entry entry = this.dataCacheIterator.next();
            this.fromKey = entry.getKey();
            this.fromKeyInclusive = false;
            return entry;
        }
    }

    public final class OSBTreeFullKeyCursor
    implements OSBTreeKeyCursor<K> {
        private long pageIndex;
        private int itemIndex;
        private List<K> keysCache = new ArrayList();
        private Iterator<K> keysIterator = new OEmptyIterator();

        private OSBTreeFullKeyCursor(long startPageIndex) {
            this.pageIndex = startPageIndex;
            this.itemIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next(int prefetchSize) {
            if (this.keysIterator == null) {
                return null;
            }
            if (this.keysIterator.hasNext()) {
                return this.keysIterator.next();
            }
            this.keysCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OCellBTreeSingleValue.this.atomicOperationsManager.acquireReadLock(OCellBTreeSingleValue.this);
            try {
                OCellBTreeSingleValue.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    while (this.keysCache.size() < prefetchSize) {
                        block25: {
                            if (this.pageIndex == -1L) {
                                break;
                            }
                            OCacheEntry entryPointCacheEntry = OCellBTreeSingleValue.this.loadPageForRead(atomicOperation, OCellBTreeSingleValue.this.fileId, 0L, false);
                            try {
                                OEntryPoint entryPoint = new OEntryPoint(entryPointCacheEntry);
                                if (this.pageIndex < (long)(entryPoint.getPagesSize() + 1)) break block25;
                                this.pageIndex = -1L;
                                break;
                            }
                            finally {
                                OCellBTreeSingleValue.this.releasePageFromRead(atomicOperation, entryPointCacheEntry);
                            }
                        }
                        OCacheEntry cacheEntry = OCellBTreeSingleValue.this.loadPageForRead(atomicOperation, OCellBTreeSingleValue.this.fileId, this.pageIndex, false);
                        try {
                            OSBTreeBucketSingleValue bucket = new OSBTreeBucketSingleValue(cacheEntry, OCellBTreeSingleValue.this.keySerializer, OCellBTreeSingleValue.this.keyTypes, OCellBTreeSingleValue.this.encryption);
                            int bucketSize = bucket.size();
                            if (this.itemIndex >= bucketSize) {
                                this.pageIndex = bucket.getRightSibling();
                                this.itemIndex = 0;
                                continue;
                            }
                            while (this.itemIndex < bucketSize && this.keysCache.size() < prefetchSize) {
                                Map.Entry entry = OCellBTreeSingleValue.this.convertToMapEntry(bucket.getEntry(this.itemIndex));
                                ++this.itemIndex;
                                this.keysCache.add(entry.getKey());
                            }
                        }
                        finally {
                            OCellBTreeSingleValue.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    OCellBTreeSingleValue.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OCellBTreeSingleValueException("Error during element iteration", OCellBTreeSingleValue.this), e);
            }
            finally {
                OCellBTreeSingleValue.this.atomicOperationsManager.releaseReadLock(OCellBTreeSingleValue.this);
            }
            if (this.keysCache.isEmpty()) {
                this.keysCache = null;
                return null;
            }
            this.keysIterator = this.keysCache.iterator();
            return this.keysIterator.next();
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static final class UpdateBucketSearchResult {
        private final List<Integer> insertionIndexes;
        private final ArrayList<Long> path;
        private final int itemIndex;

        private UpdateBucketSearchResult(List<Integer> insertionIndexes, ArrayList<Long> path, int itemIndex) {
            this.insertionIndexes = insertionIndexes;
            this.path = path;
            this.itemIndex = itemIndex;
        }

        private long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    private static final class BucketSearchResult {
        private final int itemIndex;
        private final long pageIndex;

        private BucketSearchResult(int itemIndex, long pageIndex) {
            this.itemIndex = itemIndex;
            this.pageIndex = pageIndex;
        }
    }

    public static interface OSBTreeKeyCursor<K> {
        public K next(int var1);
    }

    public static interface OSBTreeCursor<K, V> {
        public Map.Entry<K, V> next(int var1);
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

