/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.ridbag.sbtree;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OIndexRIDContainerSBTree;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class OMixedIndexRIDContainer
implements Set<OIdentifiable> {
    private static final String INDEX_FILE_EXTENSION = ".irs";
    private final long fileId;
    private final Set<ORID> embeddedSet;
    private OIndexRIDContainerSBTree tree = null;
    private final int topThreshold = OGlobalConfiguration.INDEX_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.getValueAsInteger();

    public OMixedIndexRIDContainer(String name, AtomicLong bonsayFileId) {
        long gotFileId = bonsayFileId.get();
        if (gotFileId == 0L) {
            gotFileId = OMixedIndexRIDContainer.resolveFileIdByName(name + INDEX_FILE_EXTENSION);
            bonsayFileId.set(gotFileId);
        }
        this.fileId = gotFileId;
        this.embeddedSet = new HashSet<ORID>();
    }

    public OMixedIndexRIDContainer(long fileId, Set<ORID> embeddedSet, OIndexRIDContainerSBTree tree) {
        this.fileId = fileId;
        this.embeddedSet = embeddedSet;
        this.tree = tree;
    }

    private static long resolveFileIdByName(String fileName) {
        OAbstractPaginatedStorage storage = (OAbstractPaginatedStorage)ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying();
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        Objects.requireNonNull(atomicOperation);
        OAtomicOperationsManager atomicOperationsManager = storage.getAtomicOperationsManager();
        return atomicOperationsManager.calculateInsideComponentOperation(atomicOperation, fileName, operation -> {
            long fileId = atomicOperation.isFileExists(fileName) ? atomicOperation.loadFile(fileName) : atomicOperation.addFile(fileName);
            return fileId;
        });
    }

    public long getFileId() {
        return this.fileId;
    }

    @Override
    public int size() {
        if (this.tree == null) {
            return this.embeddedSet.size();
        }
        return this.embeddedSet.size() + this.tree.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.tree == null) {
            return this.embeddedSet.isEmpty();
        }
        return this.embeddedSet.isEmpty() && this.tree.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.tree == null) {
            return this.embeddedSet.contains(o);
        }
        return this.embeddedSet.contains(o) || this.tree.contains(o);
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        if (this.tree == null) {
            return new Iterator<OIdentifiable>(){
                final Iterator<ORID> embeddedIterator;
                {
                    this.embeddedIterator = OMixedIndexRIDContainer.this.embeddedSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.embeddedIterator.hasNext();
                }

                @Override
                public OIdentifiable next() {
                    return this.embeddedIterator.next();
                }
            };
        }
        return new Iterator<OIdentifiable>(){
            private final Iterator<ORID> embeddedIterator;
            private final Iterator<OIdentifiable> treeIterator;
            {
                this.embeddedIterator = OMixedIndexRIDContainer.this.embeddedSet.iterator();
                this.treeIterator = OMixedIndexRIDContainer.this.tree.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.embeddedIterator.hasNext()) {
                    return true;
                }
                return this.treeIterator.hasNext();
            }

            @Override
            public OIdentifiable next() {
                if (this.embeddedIterator.hasNext()) {
                    return this.embeddedIterator.next();
                }
                return this.treeIterator.next();
            }
        };
    }

    @Override
    public Object[] toArray() {
        if (this.tree == null) {
            return this.embeddedSet.toArray();
        }
        Object[] embeddedArray = this.embeddedSet.toArray();
        Object[] treeArray = this.tree.toArray();
        Object[] result = new Object[embeddedArray.length + treeArray.length];
        System.arraycopy(embeddedArray, 0, result, 0, embeddedArray.length);
        System.arraycopy(treeArray, 0, result, embeddedArray.length, treeArray.length);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.tree == null) {
            return this.embeddedSet.toArray(a);
        }
        T[] embeddedArray = this.embeddedSet.toArray(a);
        T[] treeArray = this.tree.toArray(a);
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), embeddedArray.length + treeArray.length);
        System.arraycopy(embeddedArray, 0, result, 0, embeddedArray.length);
        System.arraycopy(treeArray, 0, result, embeddedArray.length, treeArray.length);
        return result;
    }

    @Override
    public boolean add(OIdentifiable oIdentifiable) {
        if (this.embeddedSet.contains(oIdentifiable.getIdentity())) {
            return false;
        }
        if (this.embeddedSet.size() < this.topThreshold) {
            return this.embeddedSet.add(oIdentifiable.getIdentity());
        }
        if (this.tree == null) {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
            this.tree = new OIndexRIDContainerSBTree(this.fileId, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        }
        return this.tree.add(oIdentifiable);
    }

    public boolean addEntry(OIdentifiable identifiable) {
        if (this.embeddedSet.contains(identifiable.getIdentity())) {
            return false;
        }
        if (this.embeddedSet.size() < this.topThreshold) {
            return this.embeddedSet.add(identifiable.getIdentity());
        }
        boolean treeWasCreated = false;
        if (this.tree == null) {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
            this.tree = new OIndexRIDContainerSBTree(this.fileId, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
            treeWasCreated = true;
        }
        this.tree.add(identifiable);
        return treeWasCreated;
    }

    @Override
    public boolean remove(Object o) {
        boolean res = this.embeddedSet.remove(o);
        if (res) {
            return true;
        }
        if (this.tree == null) {
            return false;
        }
        return this.tree.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.embeddedSet.containsAll(c)) {
            return true;
        }
        if (this.tree == null) {
            return false;
        }
        ArrayList<ORID> copy = new ArrayList<ORID>(c);
        copy.removeAll(this.embeddedSet);
        return this.tree.containsAll(copy);
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        int sizeDiff = this.topThreshold - this.embeddedSet.size();
        boolean changed = false;
        Iterator<? extends OIdentifiable> iterator = c.iterator();
        for (int i = 0; i < sizeDiff; ++i) {
            if (iterator.hasNext()) {
                OIdentifiable identifiable = iterator.next();
                changed |= this.embeddedSet.add(identifiable.getIdentity());
                continue;
            }
            return changed;
        }
        if (c.size() > sizeDiff) {
            if (this.tree == null) {
                ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
                this.tree = new OIndexRIDContainerSBTree(this.fileId, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
            }
            while (iterator.hasNext()) {
                OIdentifiable identifiable = iterator.next();
                changed |= this.tree.add(identifiable);
            }
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.embeddedSet.retainAll(c);
        if (this.tree != null) {
            changed |= this.tree.retainAll(c);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.embeddedSet.removeAll(c);
        if (this.tree != null) {
            changed |= this.tree.removeAll(c);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.embeddedSet.clear();
        if (this.tree != null) {
            this.tree.delete();
            this.tree = null;
        }
    }

    public Set<ORID> getEmbeddedSet() {
        return this.embeddedSet;
    }

    public OIndexRIDContainerSBTree getTree() {
        return this.tree;
    }
}

