/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.task.OGossipTask;
import com.orientechnologies.orient.server.distributed.impl.task.ORequestDatabaseConfigurationTask;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateDatabaseStatusTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OClusterHealthChecker
implements Runnable {
    private final ODistributedServerManager manager;
    private final long healthCheckerEveryMs;
    private long lastExecution = 0L;
    private Map<String, OLogSequenceNumber> sentLsn = new ConcurrentHashMap<String, OLogSequenceNumber>();

    public OClusterHealthChecker(ODistributedServerManager manager, long healthCheckerEveryMs) {
        this.manager = manager;
        this.healthCheckerEveryMs = healthCheckerEveryMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        OLogManager.instance().debug((Object)this, "Checking cluster health...", new Object[0]);
        long now = System.currentTimeMillis();
        if (now - this.lastExecution > this.healthCheckerEveryMs / 3L) {
            try {
                this.checkServerConfig();
                this.checkServerStatus();
                this.checkServerInStall();
                this.checkServerList();
                this.notifyCommittedLsn();
            }
            catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            }
            catch (Exception t) {
                if (this.manager.getServerInstance().isActive()) {
                    OLogManager.instance().error(this, "Error on checking cluster health", t, new Object[0]);
                }
                OLogManager.instance().debug((Object)this, "Error on checking cluster health", t, new Object[0]);
            }
            finally {
                OLogManager.instance().debug((Object)this, "Cluster health checking completed", new Object[0]);
            }
        } else {
            OLogManager.instance().debug((Object)this, "Cluster health finished recently (%dms ago), skip this execution", now - this.lastExecution);
        }
        this.lastExecution = now;
    }

    private void checkServerConfig() {
        for (String databaseName : this.manager.getMessageService().getDatabases()) {
            ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(databaseName);
            Set<String> confServers = cfg.getServers(null);
            for (String s : this.manager.getActiveServers()) {
                if (!this.manager.isNodeAvailable(s, databaseName) || confServers.contains(s)) continue;
                ArrayList<String> nodes = new ArrayList<String>();
                for (String n : this.manager.getActiveServers()) {
                    if (!this.manager.isNodeAvailable(n, databaseName)) continue;
                    nodes.add(n);
                }
                try {
                    ODistributedResponse response = this.manager.sendRequest(databaseName, null, nodes, new ORequestDatabaseConfigurationTask(databaseName), this.manager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                    Object payload = response != null ? response.getPayload() : null;
                    if (!(payload instanceof Map)) continue;
                    String mostUpdatedServer = null;
                    int mostUpdatedServerVersion = -1;
                    Map responses = (Map)payload;
                    for (Map.Entry r : responses.entrySet()) {
                        ODocument doc;
                        int v;
                        if (!(r.getValue() instanceof ODocument) || (v = ((Integer)(doc = (ODocument)r.getValue()).field("version")).intValue()) <= mostUpdatedServerVersion) continue;
                        mostUpdatedServerVersion = v;
                        mostUpdatedServer = (String)r.getKey();
                    }
                    if (cfg.getVersion() >= mostUpdatedServerVersion) continue;
                    ((ODistributedStorage)this.manager.getStorage(databaseName)).setDistributedConfiguration(new OModifiableDistributedConfiguration((ODocument)responses.get(mostUpdatedServer)));
                }
                catch (ODistributedOperationException oDistributedOperationException) {}
            }
        }
    }

    private void checkServerList() {
        Set<String> activeServers = this.manager.getActiveServers();
        for (String server : activeServers) {
            int id = this.manager.getNodeIdByName(server);
            if (id != -1) continue;
            ODistributedServerLog.info((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Server '%s' was not found in the list of registered servers. Reloading configuration from cluster...", server);
            ((OHazelcastPlugin)this.manager).reloadRegisteredNodes(null);
            id = this.manager.getNodeIdByName(server);
            if (id != -1) break;
            if (server.equals(this.manager.getLocalNodeName())) {
                ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Local server was not found in the list of registered servers after the update", server);
                break;
            }
            ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Server '%s' was not found in the list of registered servers after the update, restarting the server...", server);
            try {
                ((OHazelcastPlugin)this.manager).restartNode(server);
            }
            catch (IOException e) {
                ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on restarting server '%s' (error=%s)", server, e);
            }
            break;
        }
    }

    private void checkServerStatus() {
        if (this.manager.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE) {
            return;
        }
        if (!this.manager.getServerInstance().isActive()) {
            return;
        }
        for (String dbName : this.manager.getMessageService().getDatabases()) {
            ODistributedServerManager.DB_STATUS localNodeStatus = this.manager.getDatabaseStatus(this.manager.getLocalNodeName(), dbName);
            if (localNodeStatus != ODistributedServerManager.DB_STATUS.NOT_AVAILABLE || "OSystem".equalsIgnoreCase(dbName)) continue;
            Set<String> servers = this.manager.getAvailableNodeNames(dbName);
            servers.remove(this.manager.getLocalNodeName());
            if (servers.isEmpty()) {
                ODistributedServerLog.info((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "No server are ONLINE for database '%s'. Considering local copy of database as the good one. Setting status=ONLINE...", dbName);
                this.manager.getMessageService().getDatabase(dbName).setOnline();
                continue;
            }
            ODistributedServerLog.info((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Trying to recover current server for database '%s'...", dbName);
            if (this.manager.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE) {
                return;
            }
            ODistributedConfiguration dCfg = ((ODistributedStorage)this.manager.getStorage(dbName)).getDistributedConfiguration();
            if (dCfg == null) continue;
            boolean result = this.manager.installDatabase(true, dbName, false, OGlobalConfiguration.DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST.getValueAsBoolean());
            if (result) {
                ODistributedServerLog.info((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Recover complete for database '%s'", dbName);
                continue;
            }
            ODistributedServerLog.info((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Recover cannot be completed for database '%s'", dbName);
        }
    }

    private void checkServerInStall() {
        if (this.manager.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE) {
            return;
        }
        for (String dbName : this.manager.getMessageService().getDatabases()) {
            ODistributedServerManager.DB_STATUS localNodeStatus = this.manager.getDatabaseStatus(this.manager.getLocalNodeName(), dbName);
            if (localNodeStatus != ODistributedServerManager.DB_STATUS.ONLINE) continue;
            Set<String> servers = this.manager.getAvailableNodeNames(dbName);
            servers.remove(this.manager.getLocalNodeName());
            if (servers.isEmpty()) continue;
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), servers.toString(), ODistributedServerLog.DIRECTION.OUT, "Sending gossip message to servers (db=%s)", dbName);
            }
            try {
                Object payload;
                ODistributedResponse response = this.manager.sendRequest(dbName, null, servers, new OGossipTask(this.manager.getLockManagerServer()), this.manager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                Object object = payload = response != null ? response.getPayload() : null;
                if (payload instanceof Map) {
                    Map responses = (Map)payload;
                    String lockManagerServer = this.manager.getLockManagerServer();
                    if (lockManagerServer != null) {
                        for (Map.Entry r : responses.entrySet()) {
                            if (lockManagerServer.equals(String.valueOf(r.getValue()))) continue;
                            ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Server '%s' is using server '%s' as lockManager, while current server is using '%s'", r.getKey(), r.getValue(), lockManagerServer);
                        }
                    }
                    servers.removeAll(responses.keySet());
                }
            }
            catch (ODistributedException e) {
                ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on sending request for cluster health check", e, new Object[0]);
            }
            catch (ODistributedOperationException e) {
                ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on sending request for cluster health check", e, new Object[0]);
            }
            for (String server : servers) {
                this.setDatabaseOffline(dbName, server);
            }
        }
    }

    private void notifyCommittedLsn() {
        if (this.manager.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE) {
            return;
        }
        if (!this.manager.getServerInstance().isActive()) {
            return;
        }
        for (String dbName : this.manager.getMessageService().getDatabases()) {
            ODistributedServerManager.DB_STATUS localNodeStatus = this.manager.getDatabaseStatus(this.manager.getLocalNodeName(), dbName);
            if (localNodeStatus != ODistributedServerManager.DB_STATUS.ONLINE || "OSystem".equalsIgnoreCase(dbName)) continue;
            List<String> servers = this.manager.getOnlineNodes(dbName);
            servers.remove(this.manager.getLocalNodeName());
            if (servers.isEmpty()) continue;
            try {
                ODistributedDatabase sharedDb = this.manager.getMessageService().getDatabase(dbName);
                OLogSequenceNumber updatedLsn = null;
                updatedLsn = sharedDb.getSyncConfiguration().getLastLSN(this.manager.getLocalNodeName());
                if (updatedLsn == null) {
                    return;
                }
                OLogSequenceNumber sent = this.sentLsn.get(dbName);
                if (sent != null && updatedLsn.equals(this.sentLsn)) {
                    return;
                }
                this.sentLsn.put(dbName, updatedLsn);
                OUpdateDatabaseStatusTask task = new OUpdateDatabaseStatusTask(dbName, "", updatedLsn);
                ODistributedResponse oDistributedResponse = this.manager.sendRequest(dbName, null, servers, task, this.manager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
            }
            catch (ODistributedException e) {
                ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on sending request for cluster health check", e, new Object[0]);
            }
            catch (ODistributedOperationException e) {
                ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error on sending request for cluster health check", e, new Object[0]);
            }
        }
    }

    private void setDatabaseOffline(String dbName, String server) {
        if (this.manager.getDatabaseStatus(server, dbName) != ODistributedServerManager.DB_STATUS.ONLINE) {
            return;
        }
        if (OGlobalConfiguration.DISTRIBUTED_CHECK_HEALTH_CAN_OFFLINE_SERVER.getValueAsBoolean()) {
            ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), server, ODistributedServerLog.DIRECTION.OUT, "Server '%s' did not respond to the gossip message (db=%s, timeout=%dms). Setting the database as NOT_AVAILABLE", server, dbName, OGlobalConfiguration.DISTRIBUTED_HEARTBEAT_TIMEOUT.getValueAsLong());
            this.manager.setDatabaseStatus(server, dbName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
        } else {
            ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), server, ODistributedServerLog.DIRECTION.OUT, "Server '%s' did not respond to the gossip message (db=%s, timeout=%dms), but cannot be set OFFLINE by configuration", server, dbName, OGlobalConfiguration.DISTRIBUTED_HEARTBEAT_TIMEOUT.getValueAsLong());
        }
    }
}

