/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.conflict.OAbstractDistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTransactionManager;
import com.orientechnologies.orient.server.distributed.impl.task.OClusterRepairInfoTask;
import com.orientechnologies.orient.server.distributed.impl.task.OCompleted2pcTask;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.ORepairClusterTask;
import com.orientechnologies.orient.server.distributed.impl.task.ORepairRecordsTask;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTaskResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class OConflictResolverDatabaseRepairer
implements ODistributedDatabaseRepairer {
    private final ODistributedServerManager dManager;
    private final String databaseName;
    private final AtomicLong recordProcessed = new AtomicLong(0L);
    private final AtomicLong recordCanceled = new AtomicLong(0L);
    private final AtomicLong totalTimeProcessing = new AtomicLong(0L);
    private final boolean active;
    private ConcurrentMap<ORecordId, Boolean> records = new ConcurrentHashMap<ORecordId, Boolean>();
    private ConcurrentMap<Integer, Boolean> clusters = new ConcurrentHashMap<Integer, Boolean>();
    private final TimerTask checkTask;
    private List<ODistributedConflictResolver> conflictResolvers = new ArrayList<ODistributedConflictResolver>();

    public OConflictResolverDatabaseRepairer(ODistributedServerManager manager, String databaseName) {
        String[] items;
        this.dManager = manager;
        this.databaseName = databaseName;
        String chain = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHAIN.getValueAsString();
        for (String item : items = chain.split(",")) {
            ODocument config;
            String name;
            if (item.endsWith("}")) {
                int pos = item.indexOf(123);
                if (pos < 0) {
                    throw new OConfigurationException("Invalid configuration for conflict resolver: " + item);
                }
                name = item.substring(0, pos);
                config = new ODocument().fromJSON(item.substring(pos));
            } else {
                name = item;
                config = null;
            }
            ODistributedConflictResolver cr = (ODistributedConflictResolver)manager.getConflictResolverFactory().getImplementation(name);
            if (cr == null) {
                throw new OConfigurationException("Cannot find '" + name + "' conflict resolver implementation. Available are: " + manager.getConflictResolverFactory().getRegisteredImplementationNames());
            }
            if (config != null) {
                cr.configure(config);
            }
            this.conflictResolvers.add(cr);
        }
        long time = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHECK_EVERY.getValueAsLong();
        if (time > 0L) {
            this.checkTask = Orient.instance().scheduleTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    try {
                        OConflictResolverDatabaseRepairer.this.check();
                    }
                    catch (Exception t) {
                        OLogManager.instance().error(this, "Error on repairing distributed database", t, new Object[0]);
                    }
                    finally {
                        OConflictResolverDatabaseRepairer.this.totalTimeProcessing.addAndGet(System.currentTimeMillis() - start);
                    }
                }
            }, time, time);
            this.active = true;
        } else {
            this.checkTask = null;
            this.active = false;
        }
    }

    @Override
    public void enqueueRepairRecords(Collection<ORecordId> rids) {
        for (ORecordId rid : rids) {
            this.enqueueRepairRecord(rid);
        }
    }

    @Override
    public void enqueueRepairRecord(ORecordId rid) {
        if (!this.active) {
            return;
        }
        if (rid == null || !rid.isPersistent()) {
            return;
        }
        if (rid.getClusterPosition() < -1L) {
            return;
        }
        this.recordProcessed.incrementAndGet();
        this.records.put(rid, Boolean.TRUE);
    }

    @Override
    public void cancelRepairRecord(ORecordId rid) {
        if (!this.active) {
            return;
        }
        if (rid.getClusterPosition() < -1L) {
            return;
        }
        if (this.records.remove(rid) != null) {
            this.recordCanceled.incrementAndGet();
        }
    }

    @Override
    public void enqueueRepairCluster(int clusterId) {
        if (!this.active) {
            return;
        }
        if (clusterId < -1) {
            return;
        }
        this.recordProcessed.incrementAndGet();
        this.clusters.put(clusterId, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() throws Exception {
        ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
        ODatabase db = null;
        try {
            int batchMax = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH.getValueAsInteger();
            ArrayList<ORecordId> rids = new ArrayList<ORecordId>(batchMax);
            for (Integer n : this.clusters.keySet()) {
            }
            this.clusters.clear();
            for (ORecordId rid : this.records.keySet()) {
                rids.add(rid);
                if (rids.size() < batchMax) continue;
                break;
            }
            if (!rids.isEmpty() && this.repairRecords((ODatabaseDocumentInternal)(db = this.getDatabase()), rids)) {
                for (ORecordId rid : rids) {
                    this.records.remove(rid);
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairCluster(ODatabaseDocumentInternal db, Integer clusterId) throws Exception {
        block16: {
            String clusterName;
            String serverOwner;
            if (clusterId < 0) {
                return;
            }
            ODistributedConfiguration dCfg = this.dManager.getDatabaseConfiguration(this.databaseName);
            ODistributedRequestId requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
            ODistributedDatabase localDistributedDatabase = this.dManager.getMessageService().getDatabase(this.databaseName);
            if (db == null) {
                db = this.getDatabase();
            }
            if ((serverOwner = dCfg.getClusterOwner(clusterName = db.getClusterNameById(clusterId))) == null || !serverOwner.equals(this.dManager.getLocalNodeName())) {
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Cannot auto repair cluster '%s' (%d) because current server (%s) is not the owner (owner=%s reqId=%s)", clusterName, clusterId, this.dManager.getLocalNodeName(), serverOwner, requestId);
                return;
            }
            ODistributedTxContext ctx = localDistributedDatabase.registerTxContext(requestId);
            try {
                int repaired;
                Set<String> involvedServers;
                block15: {
                    ArrayList<ORecordId> rids = new ArrayList<ORecordId>(1);
                    rids.add(new ORecordId(clusterId, -1L));
                    ODistributedTransactionManager.acquireMultipleRecordLocks(this, this.dManager, rids, null, ctx, -1L);
                    ArrayList<String> clusterNames = new ArrayList<String>();
                    clusterNames.add(clusterName);
                    involvedServers = dCfg.getServers(clusterNames);
                    HashSet<String> nonLocalServers = new HashSet<String>(involvedServers);
                    nonLocalServers.remove(this.dManager.getLocalNodeName());
                    if (nonLocalServers.isEmpty()) {
                        return;
                    }
                    ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing cluster '%s' (%d) on servers %s (reqId=%s)...", clusterName, clusterId, involvedServers, requestId);
                    OClusterRepairInfoTask task = new OClusterRepairInfoTask(clusterId);
                    ODistributedResponse response = this.dManager.sendRequest(this.databaseName, clusterNames, nonLocalServers, task, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                    repaired = 0;
                    try {
                        Object payload;
                        if (response != null && (payload = response.getPayload()) instanceof Map) {
                            repaired = this.repairClusterAtBlocks(db, clusterNames, clusterId, (Map)payload);
                        }
                        if (repaired != 0) break block15;
                    }
                    catch (Throwable throwable) {
                        if (repaired == 0) {
                            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing of cluster '%s' completed. No fix is needed (reqId=%s)", clusterName, repaired, requestId);
                        } else {
                            ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing of cluster '%s' completed. Repaired %d records (reqId=%s)", clusterName, repaired, requestId);
                        }
                        throw throwable;
                    }
                    ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing of cluster '%s' completed. No fix is needed (reqId=%s)", clusterName, repaired, requestId);
                    break block16;
                }
                ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing of cluster '%s' completed. Repaired %d records (reqId=%s)", clusterName, repaired, requestId);
            }
            catch (Exception e) {
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error executing auto repairing on cluster '%s' (error=%s, reqId=%s)", clusterName, e.toString(), requestId);
                return;
            }
            finally {
                localDistributedDatabase.popTxContext(requestId);
                ctx.destroy();
            }
        }
    }

    private int repairClusterAtBlocks(ODatabaseDocumentInternal db, List<String> clusterNames, int clusterId, Map<String, Object> repairInfoResult) throws IOException {
        OStorage storage = db.getStorage().getUnderlying();
        long localEnd = storage.getClusterNextPosition(clusterId) - 1L;
        int batchMax = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH.getValueAsInteger();
        int recordRepaired = 0;
        for (Map.Entry<String, Object> entry : repairInfoResult.entrySet()) {
            String server = entry.getKey();
            ODistributedServerManager.DB_STATUS status = this.dManager.getDatabaseStatus(server, this.databaseName);
            if (status != ODistributedServerManager.DB_STATUS.ONLINE) {
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Cannot align missing records of cluster '%s' on server %s, because is not ONLINE (status=%s)", new Object[]{clusterNames.get(0), server, status});
                return 0;
            }
            Object result = entry.getValue();
            ArrayList<String> servers = new ArrayList<String>(1);
            servers.add(server);
            if (!(result instanceof Long)) continue;
            long remoteEnd = (Long)result;
            ORepairClusterTask task = new ORepairClusterTask().init(clusterId);
            for (long pos = remoteEnd + 1L; pos <= localEnd; ++pos) {
                ORecordId rid = new ORecordId(clusterId, pos);
                ORawBuffer rawRecord = storage.readRecord(rid, null, true, false, null).getResult();
                if (rawRecord == null) continue;
                task.add(((OCreateRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(servers).createTask(0)).init(rid, rawRecord.buffer, rawRecord.version, rawRecord.recordType));
                ++recordRepaired;
                if (task.getTasks().size() <= batchMax) continue;
                ODistributedResponse response = this.dManager.sendRequest(this.databaseName, clusterNames, servers, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                task = new ORepairClusterTask().init(clusterId);
            }
            if (!task.getTasks().isEmpty()) {
                ODistributedResponse oDistributedResponse = this.dManager.sendRequest(this.databaseName, clusterNames, servers, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
            }
            if (task.getTasks().size() == 0) {
                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Auto repair aligned %d records of cluster '%s'", task.getTasks().size(), clusterNames.get(0));
                continue;
            }
            ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Auto repair aligned %d records of cluster '%s'", task.getTasks().size(), clusterNames.get(0));
        }
        return recordRepaired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repairRecords(Collection<ORecordId> rids) {
        ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
        ODatabaseDocumentInternal db = this.getDatabase();
        try {
            this.repairRecords(db, rids);
        }
        finally {
            db.close();
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repairRecord(ORecordId rid) {
        ArrayList<ORecordId> rids = new ArrayList<ORecordId>();
        rids.add(rid);
        ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
        ODatabaseDocumentInternal db = this.getDatabase();
        try {
            this.repairRecords(db, rids);
        }
        finally {
            db.close();
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean repairRecords(ODatabaseDocumentInternal db, Collection<ORecordId> ridSet) {
        rids = new ArrayList<ORecordId>(ridSet);
        dCfg = this.dManager.getDatabaseConfiguration(this.databaseName);
        requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
        localDistributedDatabase = this.dManager.getMessageService().getDatabase(this.databaseName);
        ctx = localDistributedDatabase.registerTxContext(requestId);
        try {
            ODistributedTransactionManager.acquireMultipleRecordLocks(this, this.dManager, rids, null, ctx, -1L);
            clusterNames = new HashSet<String>();
            for (ORecordId rid : rids) {
                clusterNames.add(db.getClusterNameById(rid.getClusterId()));
            }
            involvedServers = dCfg.getServers(clusterNames);
            nonLocalServers = new HashSet<String>(involvedServers);
            nonLocalServers.remove(this.dManager.getLocalNodeName());
            if (nonLocalServers.isEmpty()) {
                var11_13 = true;
                return var11_13;
            }
            localResult = new OTxTaskResult();
            for (ORecordId var13_16 : rids) {
                res = var13_16.getClusterPosition() > -1L ? db.getStorage().readRecord(var13_16, null, true, false, null) : null;
                if (res != null) {
                    localResult.results.add(res.getResult());
                    continue;
                }
                localResult.results.add(null);
            }
            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing records %s on servers %s (reqId=%s)...", new Object[]{rids, involvedServers, requestId});
            tx = (ORepairRecordsTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nonLocalServers).createTask(17);
            for (ORecordId rid : rids) {
                tx.add(new OReadRecordTask().init(rid));
            }
            var13_18 = this.dManager.sendRequest(this.databaseName, clusterNames, nonLocalServers, tx, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, localResult, null, null);
            repairMap = new HashMap<String, OCompleted2pcTask>(rids.size());
            for (String server : involvedServers) {
                completedTask = (OCompleted2pcTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(involvedServers).createTask(8);
                completedTask.init(requestId, false, tx.getPartitionKey());
                repairMap.put(server, completedTask);
            }
            skipTheRest = false;
            if (var13_18 == null || !((payload = var13_18.getPayload()) instanceof Map)) ** GOTO lbl186
            map = (Map)payload;
            for (i = 0; i < localResult.results.size(); ++i) {
                groupedResult = new HashMap<Object, List<String>>();
                rid = (ORecordId)rids.get(i);
lbl51:
                // 2 sources

                for (Map.Entry<K, V> entry : map.entrySet()) {
                    serverName = (String)entry.getKey();
                    serverResult = entry.getValue();
                    if (!(serverResult instanceof Throwable)) break block44;
                    if (serverResult instanceof ONeedRetryException) {
                        ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), serverName, ODistributedServerLog.DIRECTION.IN, "Cannot auto repair record %s on servers %s because some of them are locked (error=%s), trying it again later", new Object[]{rid, serverName, serverResult});
                    } else {
                        ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), serverName, ODistributedServerLog.DIRECTION.IN, "Cannot auto repair record %s on servers %s (error=%s), trying it again later", new Object[]{rid, serverName, serverResult});
                    }
                    var25_43 = false;
                    var26_45 = false;
                    var27_50 = repairMap.entrySet().iterator();
                    ** break block45
                }
                ** GOTO lbl112
            }
            ** GOTO lbl186
lbl-1000:
            // 1 sources

            {
                block44: {
                    while (var27_50.hasNext()) {
                        var28_53 = var27_50.next();
                        server = (String)var28_53.getKey();
                        task = (OCompleted2pcTask)var28_53.getValue();
                        var26_46 += task.getFixTasks().size();
                        if (this.dManager.getLocalNodeName().equals(server)) {
                            this.dManager.executeOnLocalNode(requestId, task, db);
                            continue;
                        }
                        servers = new ArrayList<String>();
                        servers.add(server);
                        this.dManager.getAvailableNodes(servers, this.databaseName);
                        if (servers.isEmpty() || (var13_20 = this.dManager.sendRequest(this.databaseName, clusterNames, servers, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null)) != null && !(var13_20.getPayload() instanceof Throwable)) continue;
                        ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Auto repair cannot execute the fix, retrying it later (error=%s)", new Object[]{var13_20 != null ? var13_20.getPayload() : "no response"});
                        skipTheRest = true;
                        break;
                    }
                    if (skipTheRest != false) return var25_43;
                    if (var26_46 == false) {
                        ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing completed. No fix is needed (reqId=%s)", new Object[]{(int)var26_46, requestId});
                        return var25_43;
                    }
                    ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing completed. Sent %d fix messages for %d records (reqId=%s)", new Object[]{(int)var26_46, rids.size(), requestId});
                    return var25_43;
                }
                try {
                    serverTxResult = (OTxTaskResult)serverResult;
                    var26_47 = serverTxResult.results.get(i);
                    group /* !! */  = (ArrayList<Object>)groupedResult.get(var26_47);
                    if (group /* !! */  == null) {
                        if (var26_47 instanceof ORawBuffer && ((ORawBuffer)var26_47).recordType == 100) {
                            for (Map.Entry<K, V> resultEntry : groupedResult.entrySet()) {
                                if (!(resultEntry.getKey() instanceof ORawBuffer) || !OAbstractDistributedConflictResolver.compareRecords((ORawBuffer)var26_47, (ORawBuffer)resultEntry.getKey())) continue;
                                group /* !! */  = (List)resultEntry.getValue();
                                break;
                            }
                        }
                        if (group /* !! */  == null) {
                            group /* !! */  = new ArrayList<Object>();
                            groupedResult.put(var26_47, group /* !! */ );
                        }
                    }
                    group /* !! */ .add(serverName);
                    ** GOTO lbl51
                }
                catch (Throwable var32_60) {
                    block47: {
                        repaired = 0;
                        var34_62 = repairMap.entrySet().iterator();
                        break block47;
lbl112:
                        // 1 sources

                        if (groupedResult.size() == 1) continue;
                        ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Auto repair found %d groups of contents, analyzing the winner...", new Object[]{groupedResult.size()});
                        winner = null;
                        candidates /* !! */  = groupedResult;
                        for (ODistributedConflictResolver conflictResolver : this.conflictResolvers) {
                            conflictResult = conflictResolver.onConflict(this.databaseName, db.getClusterNameById(rid.getClusterId()), rid, this.dManager, candidates /* !! */ );
                            winner = conflictResult.winner;
                            if (winner != ODistributedConflictResolver.NOT_FOUND) break;
                            candidates /* !! */  = conflictResult.candidates;
                        }
                        if (winner == ODistributedConflictResolver.NOT_FOUND) {
                            buffer = new StringBuilder();
                            resultIndex = 0;
                            for (Map.Entry var26_48 : groupedResult.entrySet()) {
                                buffer.append("\n- ");
                                buffer.append(resultIndex++);
                                buffer.append(": ");
                                if (var26_48.getKey() instanceof ORawBuffer) {
                                    r = (ORawBuffer)var26_48.getKey();
                                    if (r.buffer != null) {
                                        buffer.append("bytes=");
                                        buffer.append(Arrays.toString(r.buffer));
                                        var28_55 = Orient.instance().getRecordFactoryManager().newInstance(r.recordType, -1, db);
                                        var28_55.fromStream(r.buffer);
                                        buffer.append(var28_55);
                                        buffer.append(" (size=");
                                        buffer.append(r.buffer.length);
                                        buffer.append(" v=");
                                        buffer.append(r.version);
                                        buffer.append(")");
                                    } else {
                                        buffer.append("(empty)");
                                    }
                                } else {
                                    buffer.append(var26_48.getKey());
                                }
                                buffer.append(" in servers ");
                                buffer.append(var26_48.getValue());
                            }
                            ODistributedServerLog.warn((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Auto repair cannot find a winner for record %s and the following groups of contents: %s", new Object[]{rid, buffer});
                            continue;
                        }
                        for (Map.Entry<K, V> entry : groupedResult.entrySet()) {
                            value = entry.getKey();
                            var26_49 = (List)entry.getValue();
                            for (String var28_56 : var26_49) {
                                if ((winner != null || value == null) && (winner == null || winner.equals(value))) continue;
                                ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), var28_56, ODistributedServerLog.DIRECTION.OUT, "Preparing fix for record %s on servers %s, winner=%s remoteValue=%s...", new Object[]{rid, var28_56, winner, value});
                                completedTask = (OCompleted2pcTask)repairMap.get(var28_56);
                                if (winner instanceof ORawBuffer && (value == null || value instanceof ORawBuffer)) {
                                    winnerRecord = (ORawBuffer)winner;
                                    completedTask.addFixTask(((OFixUpdateRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(involvedServers).createTask(21)).init(rid, winnerRecord.buffer, ORecordVersionHelper.setRollbackMode(winnerRecord.version), winnerRecord.recordType));
                                    continue;
                                }
                                if ((winner == null || winner instanceof ORecordNotFoundException) && value instanceof ORawBuffer) {
                                    completedTask.addFixTask(((OFixCreateRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames(involvedServers).createTask(20)).init(rid, -1));
                                    continue;
                                }
                                if (value instanceof Throwable) continue;
                            }
                        }
                        continue;
lbl186:
                        // 2 sources

                        repaired = 0;
                        for (Map.Entry<K, V> entry : repairMap.entrySet()) {
                            server = (String)entry.getKey();
                            task = (OCompleted2pcTask)entry.getValue();
                            repaired += task.getFixTasks().size();
                            if (this.dManager.getLocalNodeName().equals(server)) {
                                this.dManager.executeOnLocalNode(requestId, task, db);
                                continue;
                            }
                            servers = new ArrayList<String>();
                            servers.add(server);
                            this.dManager.getAvailableNodes(servers, this.databaseName);
                            if (servers.isEmpty() || (var13_22 = this.dManager.sendRequest(this.databaseName, clusterNames, servers, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null)) != null && !(var13_22.getPayload() instanceof Throwable)) continue;
                            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Auto repair cannot execute the fix, retrying it later (error=%s)", new Object[]{var13_22 != null ? var13_22.getPayload() : "no response"});
                            skipTheRest = true;
                            break;
                        }
                        if (skipTheRest) break;
                        if (repaired == 0) {
                            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing completed. No fix is needed (reqId=%s)", new Object[]{repaired, requestId});
                            break;
                        }
                        ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing completed. Sent %d fix messages for %d records (reqId=%s)", new Object[]{repaired, rids.size(), requestId});
                        break;
                    }
                    while (var34_62.hasNext()) {
                        entry = var34_62.next();
                        server = (String)entry.getKey();
                        task = (OCompleted2pcTask)entry.getValue();
                        repaired += task.getFixTasks().size();
                        if (this.dManager.getLocalNodeName().equals(server)) {
                            this.dManager.executeOnLocalNode(requestId, task, db);
                            continue;
                        }
                        servers = new ArrayList<String>();
                        servers.add(server);
                        this.dManager.getAvailableNodes(servers, this.databaseName);
                        if (servers.isEmpty() || (var13_24 = this.dManager.sendRequest(this.databaseName, clusterNames, servers, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null)) != null && !(var13_24.getPayload() instanceof Throwable)) continue;
                        ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Auto repair cannot execute the fix, retrying it later (error=%s)", new Object[]{var13_24 != null ? var13_24.getPayload() : "no response"});
                        skipTheRest = true;
                        break;
                    }
                    if (skipTheRest != false) throw var32_60;
                    if (repaired == 0) {
                        ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing completed. No fix is needed (reqId=%s)", new Object[]{repaired, requestId});
                        throw var32_60;
                    }
                    ODistributedServerLog.info((Object)this, this.dManager.getLocalNodeName(), involvedServers.toString(), ODistributedServerLog.DIRECTION.OUT, "Auto repairing completed. Sent %d fix messages for %d records (reqId=%s)", new Object[]{repaired, rids.size(), requestId});
                    throw var32_60;
                    break;
                }
            }
            if (skipTheRest == false) return true;
            var16_29 = false;
            return var16_29;
        }
        catch (Exception e) {
            ODistributedServerLog.debug((Object)this, this.dManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Error executing auto repairing (error=%s, reqId=%s)", new Object[]{e.toString(), requestId});
            var9_11 = false;
            return var9_11;
        }
        finally {
            localDistributedDatabase.popTxContext(requestId);
            ctx.destroy();
        }
    }

    @Override
    public long getRecordProcessed() {
        return this.recordProcessed.get();
    }

    @Override
    public long getTotalTimeProcessing() {
        return this.totalTimeProcessing.get();
    }

    private ODatabaseDocumentInternal getDatabase() {
        return this.dManager.getMessageService().getDatabase(this.databaseName).getDatabaseInstance();
    }

    @Override
    public void shutdown() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
        this.records.clear();
    }
}

