/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.enterprise.OEnterpriseEndpoint;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OLowDiskSpaceException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.ONewDistributedTransactionManager;
import com.orientechnologies.orient.server.distributed.impl.ONewDistributedTxContextImpl;
import com.orientechnologies.orient.server.distributed.impl.OTransactionOptimisticDistributed;
import com.orientechnologies.orient.server.distributed.impl.metadata.OClassDistributed;
import com.orientechnologies.orient.server.distributed.impl.metadata.OSharedContextDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.ORunQueryExecutionPlanTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedKeyLockedException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;

public class ODatabaseDocumentDistributed
extends ODatabaseDocumentEmbedded {
    private final OHazelcastPlugin hazelcastPlugin;

    public ODatabaseDocumentDistributed(OStorage storage, OHazelcastPlugin hazelcastPlugin) {
        super(storage);
        this.hazelcastPlugin = hazelcastPlugin;
    }

    public ODistributedStorage getStorageDistributed() {
        return (ODistributedStorage)super.getStorage();
    }

    @Override
    public String getLocalNodeName() {
        return this.getStorageDistributed().getNodeId();
    }

    @Override
    public Map<String, Set<String>> getActiveClusterMap() {
        ODistributedServerManager distributedManager = this.getStorageDistributed().getDistributedManager();
        if (distributedManager.isOffline() || !distributedManager.isNodeOnline(distributedManager.getLocalNodeName(), this.getName()) || OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            return super.getActiveClusterMap();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ODistributedConfiguration cfg = this.getStorageDistributed().getDistributedConfiguration();
        for (String server : distributedManager.getActiveServers()) {
            if (this.getClustersOnServer(cfg, server).contains("*")) {
                result.put(server, this.getStorage().getClusterNames());
                continue;
            }
            result.put(server, this.getClustersOnServer(cfg, server));
        }
        return result;
    }

    public Set<String> getClustersOnServer(ODistributedConfiguration cfg, String server) {
        Set<String> result = cfg.getClustersOnServer(server);
        if (result.contains("*")) {
            result.remove("*");
            HashSet<String> more = new HashSet<String>();
            more.addAll(this.getStorage().getClusterNames());
            for (String s : cfg.getClusterNames()) {
                if (cfg.getServers(s, null).contains(s)) continue;
                more.remove(s);
            }
            result.addAll(more);
        }
        return result;
    }

    @Override
    protected void loadMetadata() {
        this.metadata = new OMetadataDefault(this);
        this.sharedContext = this.getStorage().getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextDistributed shared = new OSharedContextDistributed(ODatabaseDocumentDistributed.this.getStorage());
                return shared;
            }
        });
        this.metadata.init(this.sharedContext);
        this.sharedContext.load(this);
    }

    @Override
    public Map<String, Set<String>> getActiveDataCenterMap() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ODistributedConfiguration cfg = this.getStorageDistributed().getDistributedConfiguration();
        Set<String> servers = cfg.getRegisteredServers();
        for (String server : servers) {
            String dc = cfg.getDataCenterOfServer(server);
            HashSet<String> dcConfig = (HashSet<String>)result.get(dc);
            if (dcConfig == null) {
                dcConfig = new HashSet<String>();
                result.put(dc, dcConfig);
            }
            dcConfig.add(server);
        }
        return result;
    }

    @Override
    public boolean isSharded() {
        Map<String, Set<String>> clusterMap = this.getActiveClusterMap();
        Iterator<Set<String>> iter2 = clusterMap.values().iterator();
        Set<String> firstClusterSet = null;
        if (iter2.hasNext()) {
            firstClusterSet = iter2.next();
        }
        while (iter2.hasNext()) {
            if (firstClusterSet.equals(iter2.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentDistributed database = new ODatabaseDocumentDistributed(this.getStorage(), this.hazelcastPlugin);
        database.init(this.getConfig());
        database.internalOpen(this.getUser().getName(), null, false);
        database.callOnOpenListeners();
        this.activateOnCurrentThread();
        return database;
    }

    @Override
    public Map<String, Object> getHaStatus(boolean servers, boolean db, boolean latency, boolean messages) {
        this.checkSecurity(ORule.ResourceGeneric.SERVER, "status", ORole.PERMISSION_READ);
        OHazelcastPlugin dManager = (OHazelcastPlugin)this.getStorageDistributed().getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        ODistributedConfiguration cfg = dManager.getDatabaseConfiguration(databaseName);
        HashMap<String, Object> row = new HashMap<String, Object>();
        StringBuilder output = new StringBuilder();
        if (servers) {
            row.put("servers", dManager.getClusterConfiguration());
        }
        if (db) {
            row.put("database", cfg.getDocument());
        }
        if (latency) {
            row.put("latency", ODistributedOutput.formatLatency(dManager, dManager.getClusterConfiguration()));
        }
        if (messages) {
            row.put("messages", ODistributedOutput.formatMessages(dManager, dManager.getClusterConfiguration()));
        }
        return row;
    }

    @Override
    public boolean removeHaServer(String serverName) {
        this.checkSecurity(ORule.ResourceGeneric.SERVER, "remove", ORole.PERMISSION_EXECUTE);
        OHazelcastPlugin dManager = (OHazelcastPlugin)this.getStorageDistributed().getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        return dManager.removeNodeFromConfiguration(serverName, databaseName, false, true);
    }

    @Override
    public OResultSet queryOnNode(String nodeName, OExecutionPlan executionPlan, Map<Object, Object> inputParameters) {
        ORunQueryExecutionPlanTask task = new ORunQueryExecutionPlanTask(executionPlan, inputParameters, nodeName);
        ODistributedResponse result = this.executeTaskOnNode(task, nodeName);
        return task.getResult(result, this);
    }

    public ODistributedResponse executeTaskOnNode(ORemoteTask task, String nodeName) {
        ODistributedServerManager dManager = this.getStorageDistributed().getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new ODistributedException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        return dManager.sendRequest(databaseName, null, Collections.singletonList(nodeName), task, dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
    }

    @Override
    public void init(OrientDBConfig config) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            super.init(config);
            return null;
        });
    }

    @Override
    protected void createMetadata() {
        OSharedContext shared = this.getStorage().getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextDistributed shared = new OSharedContextDistributed(ODatabaseDocumentDistributed.this.getStorage());
                return shared;
            }
        });
        this.metadata.init(shared);
        ((OSharedContextDistributed)shared).create(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int assignAndCheckCluster(ORecord record, String iClusterName) {
        if (!this.hazelcastPlugin.isEnabled()) return super.assignAndCheckCluster(record, iClusterName);
        ORecordId rid = (ORecordId)record.getIdentity();
        if ((long)rid.getClusterId() <= -1L && iClusterName != null) {
            rid.setClusterId(this.getClusterIdByName(iClusterName));
            if (rid.getClusterId() == -1) {
                throw new IllegalArgumentException("Cluster name '" + iClusterName + "' is not configured");
            }
        }
        OClass schemaClass = null;
        if (rid.getClusterId() <= -1 && this.getStorage().isAssigningClusterIds()) {
            if (!(record instanceof ODocument)) throw new ODatabaseException("Cannot save (5) document " + record + ": no class or cluster defined");
            schemaClass = ((ODocument)record).getSchemaClass();
            if (schemaClass == null) throw new ODatabaseException("Cannot save (4) document " + record + ": no class or cluster defined");
            if (schemaClass.isAbstract()) {
                throw new OSchemaException("Document belongs to abstract class " + schemaClass.getName() + " and cannot be saved");
            }
            rid.setClusterId(((OClassDistributed)schemaClass).getClusterForNewInstance(this, (ODocument)record));
        } else if (record instanceof ODocument) {
            schemaClass = ((ODocument)record).getSchemaClass();
        }
        if (rid.getClusterId() <= -1 || schemaClass == null) return rid.getClusterId();
        String messageClusterName = this.getClusterNameById(rid.getClusterId());
        this.checkRecordClass(schemaClass, messageClusterName, rid);
        if (schemaClass.hasClusterId(rid.getClusterId())) return rid.getClusterId();
        throw new IllegalArgumentException("Cluster name '" + messageClusterName + "' (id=" + rid.getClusterId() + ") is not configured to store the class '" + schemaClass.getName() + "', valid are " + Arrays.toString(schemaClass.getClusterIds()));
    }

    @Override
    public void internalCommit(OTransactionInternal iTx) {
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            super.internalCommit(iTx);
        } else {
            try {
                for (ORecordOperation txEntry : iTx.getRecordOperations()) {
                    ORecord record;
                    if (txEntry.type != 3 && txEntry.type != 1 || !((record = txEntry.getRecord()) instanceof ODocument)) continue;
                    ((ODocument)record).validate();
                }
                ODistributedConfiguration dbCfg = this.getStorageDistributed().getDistributedConfiguration();
                ODistributedServerManager dManager = this.getStorageDistributed().getDistributedManager();
                String localNodeName = dManager.getLocalNodeName();
                this.getStorageDistributed().checkNodeIsMaster(localNodeName, dbCfg, "Transaction Commit");
                ONewDistributedTransactionManager txManager = new ONewDistributedTransactionManager(this.getStorageDistributed(), dManager, this.getStorageDistributed().getLocalDistributedDatabase());
                int quorum = 0;
                for (String clusterName : txManager.getInvolvedClusters(iTx.getRecordOperations())) {
                    List<String> clusterServers = dbCfg.getServers(clusterName, null);
                    int writeQuorum = dbCfg.getWriteQuorum(clusterName, clusterServers.size(), localNodeName);
                    quorum = Math.max(quorum, writeQuorum);
                }
                int availableNodes = dManager.getAvailableNodes(this.getName());
                if (quorum > availableNodes) {
                    Set<String> online = dManager.getAvailableNodeNames(this.getName());
                    throw new ODistributedException("No enough nodes online to execute the operation, available nodes: " + online);
                }
                txManager.commit(this, iTx, this.getStorageDistributed().getEventListener());
                return;
            }
            catch (OValidationException e) {
                throw e;
            }
            catch (HazelcastInstanceNotActiveException e) {
                throw new OOfflineNodeException("Hazelcast instance is not available");
            }
            catch (HazelcastException e) {
                throw new OOfflineNodeException("Hazelcast instance is not available");
            }
            catch (Exception e) {
                this.getStorageDistributed().handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
            }
        }
    }

    public void acquireLocksForTx(OTransactionInternal tx, ODistributedTxContext txContext) {
        TreeSet<ORID> rids = new TreeSet<ORID>();
        for (ORecordOperation entry : tx.getRecordOperations()) {
            if (entry.getType() != 3) {
                rids.add(entry.getRID().copy());
                continue;
            }
            rids.add(new ORecordId(entry.getRID().getClusterId(), -1L));
        }
        for (ORID rid : rids) {
            txContext.lock(rid);
        }
        TreeSet<String> keys = new TreeSet<String>();
        for (Map.Entry<String, OTransactionIndexChanges> change : tx.getIndexOperations().entrySet()) {
            OIndex<?> index = this.getMetadata().getIndexManager().getIndex(change.getKey());
            if (!OClass.INDEX_TYPE.UNIQUE.name().equals(index.getType()) && !OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.name().equals(index.getType()) && !OClass.INDEX_TYPE.DICTIONARY.name().equals(index.getType()) && !OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.name().equals(index.getType())) continue;
            String name = index.getName();
            for (OTransactionIndexChangesPerKey changesPerKey : change.getValue().changesPerKey.values()) {
                keys.add(name + "#" + changesPerKey.key);
            }
            if (change.getValue().nullKeyChanges.entries.isEmpty()) continue;
            keys.add(name + "#null");
        }
        for (String key : keys) {
            txContext.lockIndexKey(key);
        }
    }

    public boolean beginDistributedTx(ODistributedRequestId requestId, OTransactionInternal tx, boolean local, int retryCount) {
        ODistributedDatabase localDistributedDatabase = this.getStorageDistributed().getLocalDistributedDatabase();
        ONewDistributedTxContextImpl txContext = new ONewDistributedTxContextImpl((ODistributedDatabaseImpl)localDistributedDatabase, requestId, tx);
        try {
            this.internalBegin2pc(txContext, local);
            txContext.setStatus(ONewDistributedTxContextImpl.Status.SUCCESS);
            this.getStorageDistributed().getLocalDistributedDatabase().registerTxContext(requestId, txContext);
        }
        catch (OConcurrentCreateException ex) {
            if (retryCount >= 0 && retryCount < this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY) && ex.getExpectedRid().getClusterPosition() > ex.getActualRid().getClusterPosition()) {
                OLogManager.instance().debug((Object)this, "Allocation of rid not match, expected:%s actual:%s waiting for re-enqueue request", ex.getExpectedRid(), ex.getActualRid());
                txContext.unlock();
                return false;
            }
            txContext.setStatus(ONewDistributedTxContextImpl.Status.FAILED);
            this.getStorageDistributed().getLocalDistributedDatabase().registerTxContext(requestId, txContext);
            throw ex;
        }
        catch (OConcurrentModificationException ex) {
            if (retryCount >= 0 && retryCount < this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY) && ex.getEnhancedRecordVersion() > ex.getEnhancedDatabaseVersion()) {
                OLogManager.instance().debug((Object)this, "Persistent version not match, record:%s expected:%s actual:%s waiting for re-enqueue request", ex.getRid(), ex.getEnhancedRecordVersion(), ex.getEnhancedDatabaseVersion());
                txContext.unlock();
                return false;
            }
            txContext.setStatus(ONewDistributedTxContextImpl.Status.FAILED);
            this.getStorageDistributed().getLocalDistributedDatabase().registerTxContext(requestId, txContext);
            throw ex;
        }
        catch (ORecordNotFoundException e) {
            if (retryCount >= 0 && retryCount < this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY)) {
                return false;
            }
            txContext.setStatus(ONewDistributedTxContextImpl.Status.FAILED);
            this.getStorageDistributed().getLocalDistributedDatabase().registerTxContext(requestId, txContext);
            throw e;
        }
        catch (ODistributedKeyLockedException | ODistributedRecordLockedException ex) {
            txContext.setStatus(ONewDistributedTxContextImpl.Status.TIMEDOUT);
            this.getStorageDistributed().getLocalDistributedDatabase().registerTxContext(requestId, txContext);
            throw ex;
        }
        catch (ORecordDuplicatedException ex) {
            txContext.setStatus(ONewDistributedTxContextImpl.Status.FAILED);
            this.getStorageDistributed().getLocalDistributedDatabase().registerTxContext(requestId, txContext);
            throw ex;
        }
        catch (OLowDiskSpaceException ex) {
            this.getStorageDistributed().getDistributedManager().setDatabaseStatus(this.getLocalNodeName(), this.getName(), ODistributedServerManager.DB_STATUS.OFFLINE);
            throw ex;
        }
        return true;
    }

    public void commit2pcLocal(ODistributedRequestId transactionId) {
        this.commit2pc(transactionId, true, transactionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit2pc(ODistributedRequestId transactionId, boolean local, ODistributedRequestId requestId) {
        this.getStorageDistributed().resetLastValidBackup();
        ODistributedDatabase localDistributedDatabase = this.getStorageDistributed().getLocalDistributedDatabase();
        ODistributedServerManager manager = this.getStorageDistributed().getDistributedManager();
        ONewDistributedTxContextImpl txContext = (ONewDistributedTxContextImpl)localDistributedDatabase.getTxContext(transactionId);
        if (txContext != null) {
            if (ONewDistributedTxContextImpl.Status.SUCCESS.equals((Object)txContext.getStatus())) {
                try {
                    if (manager != null) {
                        manager.messageCurrentPayload(requestId, txContext);
                        manager.messageBeforeOp("commit", requestId);
                    }
                    txContext.commit(this);
                    if (manager != null) {
                        manager.messageAfterOp("commit", requestId);
                    }
                    localDistributedDatabase.popTxContext(transactionId);
                    OLiveQueryHook.notifyForTxChanges(this);
                    OLiveQueryHookV2.notifyForTxChanges(this);
                }
                finally {
                    OLiveQueryHook.removePendingDatabaseOps(this);
                    OLiveQueryHookV2.removePendingDatabaseOps(this);
                }
                return true;
            }
            if (ONewDistributedTxContextImpl.Status.TIMEDOUT.equals((Object)txContext.getStatus())) {
                int nretry = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY);
                int delay = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY);
                for (int i = 0; i < nretry; ++i) {
                    try {
                        if (i > 0) {
                            try {
                                Thread.sleep(new Random().nextInt(delay));
                            }
                            catch (InterruptedException e) {
                                OException.wrapException(new OInterruptedException(e.getMessage()), e);
                            }
                        }
                        this.internalBegin2pc(txContext, local);
                        txContext.setStatus(ONewDistributedTxContextImpl.Status.SUCCESS);
                        break;
                    }
                    catch (ODistributedKeyLockedException | ODistributedRecordLockedException e) {
                        continue;
                    }
                    catch (Exception ex) {
                        OLogManager.instance().warn((Object)this, "Error beginning timed out transaction: %s ", ex, transactionId);
                        break;
                    }
                }
                if (!ONewDistributedTxContextImpl.Status.SUCCESS.equals((Object)txContext.getStatus())) {
                    txContext.destroy();
                    localDistributedDatabase.popTxContext(transactionId);
                    Orient.instance().submit(() -> {
                        OLogManager.instance().warn((Object)this, "Reached limit of retry for commit tx:%s forcing database re-install", transactionId);
                        manager.installDatabase(false, this.getName(), true, true);
                    });
                    return true;
                }
                try {
                    txContext.commit(this);
                    localDistributedDatabase.popTxContext(transactionId);
                    OLiveQueryHook.notifyForTxChanges(this);
                    OLiveQueryHookV2.notifyForTxChanges(this);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    OLiveQueryHook.removePendingDatabaseOps(this);
                    OLiveQueryHookV2.removePendingDatabaseOps(this);
                }
            }
            txContext.destroy();
            localDistributedDatabase.popTxContext(transactionId);
            Orient.instance().submit(() -> {
                OLogManager.instance().warn((Object)this, "Reached limit of retry for commit tx:%s forcing database re-install", transactionId);
                manager.installDatabase(false, this.getName(), true, true);
            });
            return true;
        }
        return false;
    }

    public boolean rollback2pc(ODistributedRequestId transactionId) {
        ODistributedDatabase localDistributedDatabase = this.getStorageDistributed().getLocalDistributedDatabase();
        ODistributedTxContext txContext = localDistributedDatabase.popTxContext(transactionId);
        if (txContext != null) {
            txContext.destroy();
            OLiveQueryHook.removePendingDatabaseOps(this);
            OLiveQueryHookV2.removePendingDatabaseOps(this);
            return true;
        }
        return false;
    }

    public void internalCommit2pc(ONewDistributedTxContextImpl txContext) {
        try {
            OTransactionInternal tx = txContext.getTransaction();
            ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).commitPreAllocated(tx);
        }
        catch (OLowDiskSpaceException ex) {
            this.getStorageDistributed().getDistributedManager().setDatabaseStatus(this.getLocalNodeName(), this.getName(), ODistributedServerManager.DB_STATUS.OFFLINE);
            throw ex;
        }
        finally {
            txContext.destroy();
        }
    }

    public void internalBegin2pc(ONewDistributedTxContextImpl txContext, boolean local) {
        this.getStorageDistributed().resetLastValidBackup();
        OTransactionInternal transaction = txContext.getTransaction();
        if (!local) {
            ((OTransactionOptimisticDistributed)transaction).setDatabase(this);
            ((OTransactionOptimistic)transaction).begin();
        }
        this.getStorageDistributed().getLocalDistributedDatabase().getManager().messageBeforeOp("locks", txContext.getReqId());
        this.acquireLocksForTx(transaction, txContext);
        this.getStorageDistributed().getLocalDistributedDatabase().getManager().messageAfterOp("locks", txContext.getReqId());
        this.getStorageDistributed().getLocalDistributedDatabase().getManager().messageBeforeOp("allocate", txContext.getReqId());
        ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).preallocateRids(transaction);
        this.getStorageDistributed().getLocalDistributedDatabase().getManager().messageAfterOp("allocate", txContext.getReqId());
        this.getStorageDistributed().getLocalDistributedDatabase().getManager().messageBeforeOp("indexCheck", txContext.getReqId());
        for (Map.Entry<String, OTransactionIndexChanges> change : transaction.getIndexOperations().entrySet()) {
            OIndex<?> index = this.getSharedContext().getIndexManager().getRawIndex(change.getKey());
            if (!OClass.INDEX_TYPE.UNIQUE.name().equals(index.getType()) && !OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.name().equals(index.getType())) continue;
            OTransactionIndexChangesPerKey nullKeyChanges = change.getValue().nullKeyChanges;
            if (!nullKeyChanges.entries.isEmpty()) {
                OIdentifiable old = (OIdentifiable)index.get(null);
                OIdentifiable newValue = nullKeyChanges.entries.get((int)(nullKeyChanges.entries.size() - 1)).value;
                if (old != null && !old.equals(newValue)) {
                    boolean oldValueRemoved = false;
                    for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : nullKeyChanges.entries) {
                        if (entry.value == null || !entry.value.equals(old) || entry.operation != OTransactionIndexChanges.OPERATION.REMOVE) continue;
                        oldValueRemoved = true;
                        break;
                    }
                    if (!oldValueRemoved) {
                        throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", newValue, null, this.getName(), old.getIdentity()), this.getName(), old.getIdentity(), null);
                    }
                }
            }
            for (OTransactionIndexChangesPerKey changesPerKey : change.getValue().changesPerKey.values()) {
                OIdentifiable old = (OIdentifiable)index.get(changesPerKey.key);
                if (changesPerKey.entries.isEmpty()) continue;
                OIdentifiable newValue = changesPerKey.entries.get((int)(changesPerKey.entries.size() - 1)).value;
                if (old == null || old.equals(newValue)) continue;
                boolean oldValueRemoved = false;
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : changesPerKey.entries) {
                    if (entry.value == null || !entry.value.equals(old) || entry.operation != OTransactionIndexChanges.OPERATION.REMOVE) continue;
                    oldValueRemoved = true;
                    break;
                }
                if (oldValueRemoved) continue;
                throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", newValue, changesPerKey.key, this.getName(), old.getIdentity()), this.getName(), old.getIdentity(), changesPerKey.key);
            }
        }
        this.getStorageDistributed().getLocalDistributedDatabase().getManager().messageAfterOp("indexCheck", txContext.getReqId());
        this.getStorageDistributed().getLocalDistributedDatabase().getManager().messageBeforeOp("mvccCheck", txContext.getReqId());
        for (ORecordOperation entry : transaction.getRecordOperations()) {
            if (entry.getType() == 3) continue;
            int changeVersion = entry.getRecord().getVersion();
            ORecordMetadata metadata = this.getStorage().getRecordMetadata(entry.getRID());
            if (metadata == null) {
                if (((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).isDeleted(entry.getRID())) {
                    throw new OConcurrentModificationException(entry.getRID(), changeVersion, changeVersion, entry.getType());
                }
                throw new OConcurrentCreateException(new ORecordId(-1, -1L), entry.getRID());
            }
            int persistentVersion = metadata.getVersion();
            if (changeVersion == persistentVersion) continue;
            throw new OConcurrentModificationException(entry.getRID(), persistentVersion, changeVersion, entry.getType());
        }
        this.getStorageDistributed().getLocalDistributedDatabase().getManager().messageAfterOp("mvccCheck", txContext.getReqId());
    }

    @Override
    public OEnterpriseEndpoint getEnterpriseEndpoint() {
        OServer server = ((ODistributedStorage)this.getStorage()).getDistributedManager().getServerInstance();
        return server.getPlugins().stream().map(x -> x.getInstance()).filter(OEnterpriseEndpoint.class::isInstance).findFirst().map(OEnterpriseEndpoint.class::cast).orElse(null);
    }
}

