/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OSimpleLockManager;
import com.orientechnologies.common.concur.lock.OSimpleLockManagerImpl;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManagerImpl;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedSyncConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.impl.OConflictResolverDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedMessageServiceImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedResponseManagerFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTxContextImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedWorker;
import com.orientechnologies.orient.server.distributed.impl.OExecuteOnce;
import com.orientechnologies.orient.server.distributed.impl.OWaitPartitionsReadyTask;
import com.orientechnologies.orient.server.distributed.impl.task.ODistributedLockTask;
import com.orientechnologies.orient.server.distributed.impl.task.OUnreachableServerLocalTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class ODistributedDatabaseImpl
implements ODistributedDatabase {
    public static final String DISTRIBUTED_SYNC_JSON_FILENAME = "distributed-sync.json";
    private static final HashSet<Integer> ALL_QUEUES = new HashSet();
    protected final ODistributedAbstractPlugin manager;
    protected final ODistributedMessageServiceImpl msgService;
    protected final String databaseName;
    protected ODistributedDatabaseRepairer repairer;
    protected ODistributedSyncConfiguration syncConfiguration;
    protected ConcurrentHashMap<ORID, ODistributedLock> lockManager = new ConcurrentHashMap(256);
    protected ConcurrentHashMap<ODistributedRequestId, ODistributedTxContext> activeTxContexts = new ConcurrentHashMap(64);
    protected final List<ODistributedWorker> workerThreads = new ArrayList<ODistributedWorker>();
    protected ODistributedWorker lockThread;
    protected ODistributedWorker nowaitThread;
    private AtomicLong totalSentRequests = new AtomicLong();
    private AtomicLong totalReceivedRequests = new AtomicLong();
    private TimerTask txTimeoutTask = null;
    private CountDownLatch waitForOnline = new CountDownLatch(1);
    private volatile boolean running = true;
    private AtomicBoolean parsing = new AtomicBoolean(true);
    private final AtomicReference<ODistributedMomentum> filterByMomentum = new AtomicReference();
    private String localNodeName;
    private OSimpleLockManager<ORID> recordLockManager;
    private OSimpleLockManager<Object> indexKeyLockManager;
    private AtomicLong operationsRunnig = new AtomicLong(0L);

    public OSimpleLockManager<ORID> getRecordLockManager() {
        return this.recordLockManager;
    }

    public OSimpleLockManager<Object> getIndexKeyLockManager() {
        return this.indexKeyLockManager;
    }

    public void startOperation() {
        this.waitDistributedIsReady();
        this.operationsRunnig.incrementAndGet();
    }

    public void endOperation() {
        this.operationsRunnig.decrementAndGet();
    }

    public ODistributedDatabaseImpl(OHazelcastPlugin manager, ODistributedMessageServiceImpl msgService, String iDatabaseName, ODistributedConfiguration cfg) {
        this.manager = manager;
        this.msgService = msgService;
        this.databaseName = iDatabaseName;
        this.localNodeName = manager.getLocalNodeName();
        ODistributedDatabaseImpl prev = msgService.databases.put(iDatabaseName, this);
        if (prev != null) {
            prev.shutdown();
        }
        this.startAcceptingRequests();
        if (iDatabaseName.equals("OSystem")) {
            return;
        }
        this.startTxTimeoutTimerTask();
        this.repairer = new OConflictResolverDatabaseRepairer(manager, this.databaseName);
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".msgSent", "Number of replication messages sent from current node", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return ODistributedDatabaseImpl.this.totalSentRequests.get();
            }
        }, "distributed.db.*.msgSent");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".msgReceived", "Number of replication messages received from external nodes", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return ODistributedDatabaseImpl.this.totalReceivedRequests.get();
            }
        }, "distributed.db.*.msgReceived");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".activeContexts", "Number of active distributed transactions", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.activeTxContexts.size();
            }
        }, "distributed.db.*.activeContexts");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".workerThreads", "Number of worker threads", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.workerThreads.size();
            }
        }, "distributed.db.*.workerThreads");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".recordLocks", "Number of record locked", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.lockManager.size();
            }
        }, "distributed.db.*.recordLocks");
        long timeout = manager.getServerInstance().getContextConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT);
        this.recordLockManager = new OSimpleLockManagerImpl<ORID>(timeout);
        this.indexKeyLockManager = new OSimpleLockManagerImpl<Object>(timeout);
    }

    public OLogSequenceNumber getLastLSN(String server) {
        if (server == null) {
            return null;
        }
        return this.getSyncConfiguration().getLastLSN(server);
    }

    @Override
    public void waitForOnline() {
        try {
            if (!this.databaseName.equalsIgnoreCase("OSystem")) {
                this.waitForOnline.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void reEnqueue(int senderNodeId, long msgSequence, String databaseName, ORemoteTask payload, int retryCount) {
        Orient.instance().scheduleTask(() -> this.processRequest(new ODistributedRequest(this.getManager(), senderNodeId, msgSequence, databaseName, payload), false), 10 * retryCount, 0L);
    }

    @Override
    public synchronized void processRequest(ODistributedRequest request, boolean waitForAcceptingRequests) {
        if (!this.running) {
            throw new ODistributedException("Server is going down or is removing the database:'" + this.getDatabaseName() + "' discarding");
        }
        ORemoteTask task = request.getTask();
        task.received(request, this);
        this.manager.messageReceived(request);
        if (waitForAcceptingRequests) {
            this.waitIsReady(task);
            if (!this.running) {
                throw new ODistributedException("Server is going down or is removing the database:'" + this.getDatabaseName() + "' discarding");
            }
        }
        this.totalReceivedRequests.incrementAndGet();
        int[] partitionKeys = task.getPartitionKey();
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, this.localNodeName, task.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Request %s on database '%s' partitionKeys=%s task=%s", request, this.databaseName, Arrays.toString(partitionKeys), task);
        }
        if (partitionKeys.length > 1 || partitionKeys[0] == -1) {
            Set<Integer> involvedWorkerQueues = partitionKeys.length > 1 ? this.getInvolvedQueuesByPartitionKeys(partitionKeys) : ALL_QUEUES;
            this.manager.messagePartitionCalculate(request, involvedWorkerQueues);
            ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Request %s on database '%s' involvedQueues=%s", request, this.databaseName, involvedWorkerQueues);
            if (involvedWorkerQueues.size() == 1) {
                this.processRequest(involvedWorkerQueues.iterator().next(), request);
            } else {
                ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Request %s on database '%s' waiting for all the previous requests to be completed", request, this.databaseName);
                CountDownLatch started = new CountDownLatch(involvedWorkerQueues.size());
                OExecuteOnce once = new OExecuteOnce(started, task);
                for (int queue : involvedWorkerQueues) {
                    ODistributedWorker worker = this.workerThreads.get(queue);
                    OWaitPartitionsReadyTask waitRequest = new OWaitPartitionsReadyTask(once);
                    ODistributedRequest syncRequest = new ODistributedRequest(null, request.getId().getNodeId(), request.getId().getMessageId(), this.databaseName, waitRequest);
                    worker.processRequest(syncRequest);
                }
            }
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -2) {
            boolean found = false;
            for (ODistributedWorker q : this.workerThreads) {
                if (!q.isWaitingForNextRequest() || !q.localQueue.isEmpty()) continue;
                q.processRequest(request);
                found = true;
                break;
            }
            if (!found) {
                for (ODistributedWorker q : this.workerThreads) {
                    if (!q.localQueue.isEmpty()) continue;
                    q.processRequest(request);
                    found = true;
                    break;
                }
            }
            if (!found) {
                this.workerThreads.get(0).processRequest(request);
            }
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -3) {
            ODistributedServerLog.debug((Object)this, this.localNodeName, request.getTask().getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Request %s on database '%s' dispatched to the lock worker", request, this.databaseName);
            this.lockThread.processRequest(request);
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -4) {
            ODistributedServerLog.debug((Object)this, this.localNodeName, request.getTask().getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Request %s on database '%s' dispatched to the nowait worker", request, this.databaseName);
            this.nowaitThread.processRequest(request);
        } else {
            this.processRequest(partitionKeys[0], request);
        }
    }

    public void waitIsReady(ORemoteTask task) {
        if (task.isNodeOnlineRequired()) {
            this.waitDistributedIsReady();
        }
    }

    public void waitDistributedIsReady() {
        if (!this.parsing.get()) {
            while (!this.parsing.get()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    protected Set<Integer> getInvolvedQueuesByPartitionKeys(int[] partitionKeys) {
        HashSet<Integer> involvedWorkerQueues = new HashSet<Integer>(partitionKeys.length);
        for (int pk : partitionKeys) {
            if (pk < 0) continue;
            involvedWorkerQueues.add(pk % this.workerThreads.size());
        }
        return involvedWorkerQueues;
    }

    protected void processRequest(int partitionKey, ODistributedRequest request) {
        if (this.workerThreads.isEmpty()) {
            throw new ODistributedException("There are no worker threads to process request " + request);
        }
        int partition = partitionKey % this.workerThreads.size();
        HashSet<Integer> partitions = new HashSet<Integer>();
        partitions.add(partition);
        this.manager.messagePartitionCalculate(request, partitions);
        ODistributedServerLog.debug((Object)this, this.localNodeName, request.getTask().getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Request %s on database '%s' dispatched to the worker %d", request, this.databaseName, partition);
        this.workerThreads.get(partition).processRequest(request);
    }

    @Override
    public ODistributedResponse send2Nodes(ODistributedRequest iRequest, Collection<String> iClusterNames, Collection<String> iNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, OCallable<Void, ODistributedRequestId> iAfterSentCallback, OCallable<Void, ODistributedResponseManager> endCallback) {
        return this.send2Nodes(iRequest, iClusterNames, iNodes, iExecutionMode, localResult, iAfterSentCallback, endCallback, (iRequest1, iNodes1, endCallback1, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode) -> new ODistributedResponseManagerImpl(this.manager, iRequest, iNodes, nodesConcurToTheQuorum, expectedResponses, quorum, waitLocalNode, this.adjustTimeoutWithLatency(iNodes, task.getSynchronousTimeout(expectedResponses), iRequest.getId()), this.adjustTimeoutWithLatency(iNodes, task.getTotalTimeout(availableNodes), iRequest.getId()), groupByResponse, endCallback));
    }

    public ODistributedResponse send2Nodes(ODistributedRequest iRequest, Collection<String> iClusterNames, Collection<String> iNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, OCallable<Void, ODistributedRequestId> iAfterSentCallback, OCallable<Void, ODistributedResponseManager> endCallback, ODistributedResponseManagerFactory responseManagerFactory) {
        boolean afterSendCallBackCalled = false;
        try {
            Object object;
            this.checkForServerOnline(iRequest);
            String databaseName = iRequest.getDatabaseName();
            if (iNodes.isEmpty()) {
                ODistributedServerLog.error((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.OUT, "No nodes configured for database '%s' request: %s", databaseName, iRequest);
                throw new ODistributedException("No nodes configured for partition '" + databaseName + "' request: " + iRequest);
            }
            ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(databaseName);
            ORemoteTask task = iRequest.getTask();
            boolean checkNodesAreOnline = task.isNodeOnlineRequired();
            Set<String> nodesConcurToTheQuorum = this.manager.getDistributedStrategy().getNodesConcurInQuorum(this.manager, cfg, iRequest, iNodes, databaseName, localResult);
            int availableNodes = checkNodesAreOnline ? this.manager.getNodesWithStatus(iNodes, databaseName, ODistributedServerManager.DB_STATUS.ONLINE, ODistributedServerManager.DB_STATUS.BACKUP, ODistributedServerManager.DB_STATUS.SYNCHRONIZING) : iNodes.size();
            int expectedResponses = localResult != null ? availableNodes + 1 : availableNodes;
            int onlineMasters = this.manager.getOnlineNodes(databaseName).stream().filter(f -> cfg.getServerRole((String)f) == ODistributedConfiguration.ROLES.MASTER).collect(Collectors.toSet()).size();
            int quorum = this.calculateQuorum(task.getQuorumType(), iClusterNames, cfg, expectedResponses, nodesConcurToTheQuorum.size(), onlineMasters, checkNodesAreOnline, this.localNodeName);
            boolean groupByResponse = task.getResultStrategy() != ORemoteTask.RESULT_STRATEGY.UNION;
            boolean waitLocalNode = this.waitForLocalNode(cfg, iClusterNames, iNodes);
            ODistributedResponseManager currentResponseMgr = responseManagerFactory.newResponseManager(iRequest, iNodes, endCallback, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode);
            if (localResult != null && currentResponseMgr.setLocalResult(this.localNodeName, localResult)) {
                ODistributedResponse oDistributedResponse = currentResponseMgr.getFinalResponse();
                return oDistributedResponse;
            }
            if (!(iNodes instanceof List)) {
                iNodes = new ArrayList<String>(iNodes);
            }
            if (iNodes.size() > 1) {
                Collections.sort((List)iNodes);
            }
            this.msgService.registerRequest(iRequest.getId().getMessageId(), currentResponseMgr);
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, iNodes.toString(), ODistributedServerLog.DIRECTION.OUT, "Sending request %s...", iRequest);
            }
            for (String node : iNodes) {
                try {
                    ORemoteServerController remoteServer = this.manager.getRemoteServer(node);
                    remoteServer.sendRequest(iRequest);
                }
                catch (Exception e) {
                    currentResponseMgr.removeServerBecauseUnreachable(node);
                    String reason = e.getMessage();
                    if (e instanceof ODistributedException && e.getCause() instanceof IOException) {
                        reason = e.getCause().getMessage();
                        this.manager.closeRemoteServer(node);
                    } else if (e instanceof OSecurityAccessException) {
                        this.manager.closeRemoteServer(node);
                        try {
                            ORemoteServerController remoteServer = this.manager.getRemoteServer(node);
                            remoteServer.sendRequest(iRequest);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.manager.isNodeAvailable(node)) {
                        ODistributedServerLog.debug((Object)this, this.localNodeName, node, ODistributedServerLog.DIRECTION.OUT, "Error on sending distributed request %s. The target node is not available. Active nodes: %s", e, iRequest, this.manager.getAvailableNodeNames(databaseName));
                        continue;
                    }
                    ODistributedServerLog.error((Object)this, this.localNodeName, node, ODistributedServerLog.DIRECTION.OUT, "Error on sending distributed request %s (err=%s). Active nodes: %s", iRequest, reason, this.manager.getAvailableNodeNames(databaseName));
                }
            }
            if (currentResponseMgr.getExpectedNodes().isEmpty()) {
                throw new ODistributedException("No server active for distributed request (" + iRequest + ") against database '" + databaseName + (iClusterNames != null ? "." + iClusterNames : "") + "' to nodes " + iNodes);
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, iNodes.toString(), ODistributedServerLog.DIRECTION.OUT, "Sent request %s", iRequest);
            }
            this.totalSentRequests.incrementAndGet();
            afterSendCallBackCalled = true;
            if (iAfterSentCallback != null) {
                iAfterSentCallback.call(iRequest.getId());
            }
            if (iExecutionMode == ODistributedRequest.EXECUTION_MODE.RESPONSE) {
                object = this.waitForResponse(iRequest, currentResponseMgr);
                return object;
            }
            object = null;
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODistributedException("Error on executing distributed request (" + iRequest + ") against database '" + this.databaseName + (iClusterNames != null ? "." + iClusterNames : "") + "' to nodes " + iNodes), e);
        }
        finally {
            if (iAfterSentCallback != null && !afterSendCallBackCalled) {
                iAfterSentCallback.call(iRequest.getId());
            }
        }
    }

    public ODistributedResponseManager newResponseManager(ODistributedRequest iRequest, Collection<String> iNodes, OCallable<Void, ODistributedResponseManager> endCallback, ORemoteTask task, Set<String> nodesConcurToTheQuorum, int availableNodes, int expectedResponses, int quorum, boolean groupByResponse, boolean waitLocalNode) {
        return new ODistributedResponseManagerImpl(this.manager, iRequest, iNodes, nodesConcurToTheQuorum, expectedResponses, quorum, waitLocalNode, this.adjustTimeoutWithLatency(iNodes, task.getSynchronousTimeout(expectedResponses), iRequest.getId()), this.adjustTimeoutWithLatency(iNodes, task.getTotalTimeout(availableNodes), iRequest.getId()), groupByResponse, endCallback);
    }

    private long adjustTimeoutWithLatency(Collection<String> iNodes, long timeout, ODistributedRequestId requestId) {
        long delta = 0L;
        if (iNodes != null) {
            for (String n : iNodes) {
                long l = this.msgService.getCurrentLatency(n);
                delta = Math.max(delta, l);
            }
        }
        if (delta > 500L) {
            ODistributedServerLog.debug((Object)this, this.localNodeName, iNodes.toString(), ODistributedServerLog.DIRECTION.OUT, "Adjusted timeouts by adding +%dms because this is the maximum latency recorded against servers %s (reqId=%s)", delta, iNodes, requestId);
        }
        return timeout + delta;
    }

    @Override
    public void setOnline() {
        ODistributedServerLog.info((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Publishing ONLINE status for database %s.%s...", this.localNodeName, this.databaseName);
        this.manager.setDatabaseStatus(this.localNodeName, this.databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
        this.waitForOnline.countDown();
    }

    @Override
    public ORawBuffer getRecordIfLocked(ORID rid) {
        ODistributedLock currentLock = (ODistributedLock)this.lockManager.get(rid);
        if (currentLock != null) {
            return currentLock.record;
        }
        return null;
    }

    @Override
    public void replaceRecordContentIfLocked(ORID rid, byte[] bytes) {
        ODistributedLock currentLock = (ODistributedLock)this.lockManager.get(rid);
        if (currentLock != null && currentLock.record != null) {
            currentLock.record.buffer = bytes;
        }
    }

    @Override
    public boolean lockRecord(ORID rid, ODistributedRequestId requestId, long timeout) {
        ODistributedLock lock = new ODistributedLock(requestId);
        ORawBuffer currentRecord = null;
        boolean newLock = true;
        ODistributedLock currentLock = this.lockManager.putIfAbsent(rid, lock);
        if (currentLock != null) {
            currentRecord = currentLock.record;
            if (requestId.equals(currentLock.reqId)) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: %s locked record %s in database '%s' owned by %s (thread=%d)", requestId, rid, this.databaseName, currentLock.reqId, Thread.currentThread().getId());
                currentLock = null;
                newLock = false;
            } else {
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        if (timeout > 0L) {
                            if (!currentLock.lock.await(timeout, TimeUnit.MILLISECONDS)) {
                                continue;
                            }
                        } else {
                            currentLock.lock.await();
                        }
                        currentLock = this.lockManager.putIfAbsent(rid, lock);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                } while (currentLock != null && (timeout == 0L || System.currentTimeMillis() - startTime < timeout));
            }
        }
        if (currentLock == null) {
            ODatabaseDocumentInternal db;
            if (currentRecord != null) {
                lock.record = currentRecord;
            } else if (rid.isPersistent() && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                lock.record = db.getStorage().getUnderlying().readRecord((ORecordId)rid, null, false, false, null).getResult();
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Locked record %s in database '%s' (reqId=%s thread=%d)", rid, this.databaseName, requestId, Thread.currentThread().getId());
            }
        } else if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Cannot lock record %s in database '%s' owned by %s (reqId=%s thread=%d)", rid, this.databaseName, null, requestId, Thread.currentThread().getId());
        }
        if (currentLock != null) {
            throw new ODistributedRecordLockedException(this.manager.getLocalNodeName(), rid, timeout);
        }
        return newLock;
    }

    @Override
    public void unlockRecord(OIdentifiable iRecord, ODistributedRequestId requestId) {
        if (requestId == null) {
            return;
        }
        ODistributedLock owner = (ODistributedLock)this.lockManager.get(iRecord.getIdentity());
        if (owner != null) {
            if (!owner.reqId.equals(requestId)) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: cannot unlock record %s in database '%s' because owner %s <> current %s (thread=%d)", iRecord, this.databaseName, owner.reqId, requestId, Thread.currentThread().getId());
                return;
            }
            this.lockManager.remove(iRecord.getIdentity());
            owner.lock.countDown();
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: %s unlocked record %s in database '%s' (owner=%s, thread=%d)", requestId, iRecord, this.databaseName, owner != null ? owner.reqId : "null", Thread.currentThread().getId());
        }
    }

    @Override
    public boolean forceLockRecord(ORID rid, ODistributedRequestId requestId) {
        ODistributedLock lock = new ODistributedLock(requestId);
        ORawBuffer currentRecord = null;
        boolean newLock = true;
        ODistributedLock currentLock = this.lockManager.put(rid, lock);
        if (currentLock != null) {
            currentRecord = currentLock.record;
            if (requestId.equals(currentLock.reqId)) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: rid %s was already locked by %s in database '%s' owned by %s (thread=%d)", rid, requestId, this.databaseName, currentLock.reqId, Thread.currentThread().getId());
                currentLock = null;
                newLock = false;
            } else {
                if (currentLock.reqId.getNodeId() == requestId.getNodeId()) {
                    return this.lockRecord(rid, requestId, 0L);
                }
                ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Canceling request %s in database '%s' (reqId=%s thread=%d)", currentLock.reqId, this.databaseName, requestId, Thread.currentThread().getId());
                currentLock.lock.countDown();
                ODistributedTxContext lockedCtx = (ODistributedTxContext)this.activeTxContexts.get(currentLock.reqId);
                if (lockedCtx != null) {
                    lockedCtx.cancel(this.manager, ODatabaseRecordThreadLocal.instance().get());
                } else {
                    ODistributedResponseManager respMgr = this.manager.getMessageService().getResponseManager(requestId);
                    if (respMgr != null) {
                        respMgr.cancel();
                    }
                }
            }
        }
        if (currentLock == null) {
            ODatabaseDocumentInternal db;
            if (currentRecord != null) {
                lock.record = currentRecord;
            } else if (rid.isPersistent() && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                lock.record = db.getStorage().getUnderlying().readRecord((ORecordId)rid, null, false, false, null).getResult();
            }
            if (newLock && ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Locked rid %s in database '%s' (reqId=%s thread=%d)", rid, this.databaseName, requestId, Thread.currentThread().getId());
            }
        } else if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Forced locking of rid %s in database '%s' owned by %s (reqId=%s thread=%d)", rid, this.databaseName, currentLock.reqId, requestId, Thread.currentThread().getId());
        }
        return newLock;
    }

    @Override
    public void unlockResourcesOfServer(ODatabaseDocumentInternal database, String serverName) {
        int nodeLeftId = this.manager.getNodeIdByName(serverName);
        HashSet<ORecordId> rids2Repair = new HashSet<ORecordId>();
        int rollbacks = 0;
        Iterator pendingReqIterator = this.activeTxContexts.values().iterator();
        while (pendingReqIterator.hasNext()) {
            ODistributedTxContext pReq = (ODistributedTxContext)pendingReqIterator.next();
            if (pReq == null || pReq.getReqId().getNodeId() != nodeLeftId) continue;
            ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: rolling back transaction (req=%s)", pReq.getReqId());
            try {
                rids2Repair.addAll(pReq.rollback(database));
                ++rollbacks;
            }
            catch (Exception t) {
                ODistributedServerLog.error((Object)this, this.manager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: error on rolling back transaction (req=%s)", pReq.getReqId());
            }
            pReq.destroy();
            pendingReqIterator.remove();
        }
        int recordLocks = 0;
        for (Map.Entry entry : this.lockManager.entrySet()) {
            ODistributedLock lock = (ODistributedLock)entry.getValue();
            if (lock == null || lock.reqId == null || lock.reqId.getNodeId() != nodeLeftId) continue;
            OLogManager.instance().debug((Object)this, "Unlocking record %s acquired with req=%s", entry.getKey(), lock.reqId);
            ++recordLocks;
        }
        ODistributedServerLog.info((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: rolled back %d transactions and %d single locks in database '%s' owned by server '%s'", rollbacks, recordLocks, this.databaseName, serverName);
        this.getDatabaseRepairer().enqueueRepairRecords(rids2Repair);
    }

    @Override
    public ODistributedTxContext registerTxContext(ODistributedRequestId reqId) {
        return this.registerTxContext(reqId, new ODistributedTxContextImpl(this, reqId));
    }

    @Override
    public ODistributedTxContext registerTxContext(ODistributedRequestId reqId, ODistributedTxContext ctx) {
        ODistributedTxContext prevCtx = this.activeTxContexts.put(reqId, ctx);
        if (prevCtx != ctx && prevCtx != null) {
            prevCtx.destroy();
        }
        return ctx;
    }

    @Override
    public ODistributedTxContext popTxContext(ODistributedRequestId requestId) {
        ODistributedTxContext ctx = (ODistributedTxContext)this.activeTxContexts.remove(requestId);
        ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: pop request %s for database %s -> %s", requestId, this.databaseName, ctx);
        return ctx;
    }

    @Override
    public ODistributedTxContext getTxContext(ODistributedRequestId requestId) {
        ODistributedTxContext ctx = (ODistributedTxContext)this.activeTxContexts.get(requestId);
        ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction: pop request %s for database %s -> %s", requestId, this.databaseName, ctx);
        return ctx;
    }

    @Override
    public ODistributedServerManager getManager() {
        return this.manager;
    }

    public boolean exists() {
        return this.manager.getServerInstance().existsDatabase(this.databaseName);
    }

    @Override
    public ODistributedSyncConfiguration getSyncConfiguration() {
        if (this.syncConfiguration == null) {
            String path = this.manager.getServerInstance().getDatabaseDirectory() + this.databaseName + "/" + DISTRIBUTED_SYNC_JSON_FILENAME;
            File cfgFile = new File(path);
            try {
                this.syncConfiguration = new ODistributedSyncConfiguration(this.manager, this.databaseName, cfgFile);
            }
            catch (IOException e) {
                throw OException.wrapException(new ODistributedException("Cannot open database distributed sync configuration file: " + cfgFile), e);
            }
        }
        return this.syncConfiguration;
    }

    public void filterBeforeThisMomentum(ODistributedMomentum momentum) {
        this.filterByMomentum.set(momentum);
    }

    @Override
    public void handleUnreachableNode(String nodeName) {
        ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), nodeName, ODistributedServerLog.DIRECTION.IN, "Distributed transaction: rolling back all the pending transactions coordinated by the unreachable server '%s'", nodeName);
        OUnreachableServerLocalTask task = new OUnreachableServerLocalTask(nodeName);
        ODistributedRequest rollbackRequest = new ODistributedRequest(null, this.manager.getLocalNodeId(), this.manager.getNextMessageIdCounter(), null, task);
        this.processRequest(rollbackRequest, false);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public ODatabaseDocumentInternal getDatabaseInstance() {
        return this.manager.getServerInstance().openDatabase(this.databaseName, "internal", "internal", null, true);
    }

    @Override
    public long getReceivedRequests() {
        return this.totalReceivedRequests.get();
    }

    @Override
    public long getProcessedRequests() {
        long total = 0L;
        if (this.lockThread != null) {
            total += this.lockThread.getProcessedRequests();
        }
        if (this.nowaitThread != null) {
            total += this.nowaitThread.getProcessedRequests();
        }
        for (ODistributedWorker workerThread : this.workerThreads) {
            if (workerThread == null) continue;
            total += workerThread.getProcessedRequests();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        try {
            if (this.txTimeoutTask != null) {
                this.txTimeoutTask.cancel();
            }
            if (this.repairer != null) {
                this.repairer.shutdown();
            }
            if (this.lockThread != null) {
                this.lockThread.sendShutdown();
            }
            if (this.nowaitThread != null) {
                this.nowaitThread.sendShutdown();
            }
            for (ODistributedWorker workerThread : this.workerThreads) {
                if (workerThread == null) continue;
                workerThread.sendShutdown();
            }
            if (this.lockThread != null) {
                try {
                    this.lockThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.nowaitThread != null) {
                try {
                    this.nowaitThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            for (ODistributedWorker workerThread : this.workerThreads) {
                if (workerThread == null) continue;
                try {
                    workerThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.lockThread = null;
            this.nowaitThread = null;
            this.workerThreads.clear();
            try {
                this.getSyncConfiguration().save();
            }
            catch (IOException e) {
                ODistributedServerLog.warn((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on saving distributed LSN table for database '%s'", this.databaseName);
            }
            this.syncConfiguration = null;
            ODistributedServerLog.info((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Shutting down distributed database manager '%s'. Pending objects: txs=%d locks=%d", this.databaseName, this.activeTxContexts.size(), this.lockManager.size());
            this.lockManager.clear();
            this.activeTxContexts.clear();
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".msgSent");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".msgReceived");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".activeContexts");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".workerThreads");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".recordLocks");
        }
        finally {
            ODistributedServerManager.DB_STATUS serverStatus = this.manager.getDatabaseStatus(this.manager.getLocalNodeName(), this.databaseName);
            if (serverStatus == ODistributedServerManager.DB_STATUS.ONLINE || serverStatus == ODistributedServerManager.DB_STATUS.SYNCHRONIZING) {
                try {
                    this.manager.setDatabaseStatus(this.manager.getLocalNodeName(), this.databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void checkForServerOnline(ODistributedRequest iRequest) throws ODistributedException {
        ODistributedServerManager.NODE_STATUS srvStatus = this.manager.getNodeStatus();
        if (srvStatus == ODistributedServerManager.NODE_STATUS.OFFLINE || srvStatus == ODistributedServerManager.NODE_STATUS.SHUTTINGDOWN) {
            ODistributedServerLog.error((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.OUT, "Local server is not online (status='%s'). Request %s will be ignored", new Object[]{srvStatus, iRequest});
            throw new OOfflineNodeException("Local server is not online (status='" + (Object)((Object)srvStatus) + "'). Request " + iRequest + " will be ignored");
        }
    }

    protected boolean waitForLocalNode(ODistributedConfiguration cfg, Collection<String> iClusterNames, Collection<String> iNodes) {
        boolean waitLocalNode;
        block1: {
            block2: {
                waitLocalNode = false;
                if (!iNodes.contains(this.localNodeName)) break block1;
                if (iClusterNames != null && !iClusterNames.isEmpty()) break block2;
                if (!cfg.isReadYourWrites(null).booleanValue()) break block1;
                waitLocalNode = true;
                break block1;
            }
            for (String clName : iClusterNames) {
                if (!cfg.isReadYourWrites(clName).booleanValue()) continue;
                waitLocalNode = true;
                break;
            }
        }
        return waitLocalNode;
    }

    protected int calculateQuorum(OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType, Collection<String> clusterNames, ODistributedConfiguration cfg, int totalServers, int totalMasterServers, int onlineMasters, boolean checkNodesAreOnline, String localNodeName) {
        int quorum = 1;
        if (clusterNames == null || clusterNames.isEmpty()) {
            clusterNames = new ArrayList<String>(1);
            clusterNames.add(null);
        }
        int totalServerInQuorum = totalServers;
        for (String cluster : clusterNames) {
            int clusterQuorum = 0;
            switch (quorumType) {
                case NONE: {
                    break;
                }
                case READ: {
                    clusterQuorum = cfg.getReadQuorum(cluster, totalServers, localNodeName);
                    break;
                }
                case WRITE: {
                    clusterQuorum = cfg.getWriteQuorum(cluster, totalMasterServers, localNodeName);
                    totalServerInQuorum = totalMasterServers;
                    break;
                }
                case WRITE_ALL_MASTERS: {
                    int cfgQuorum = cfg.getWriteQuorum(cluster, totalMasterServers, localNodeName);
                    clusterQuorum = Math.max(cfgQuorum, onlineMasters);
                    break;
                }
                case ALL: {
                    clusterQuorum = totalServers;
                }
            }
            quorum = Math.max(quorum, clusterQuorum);
        }
        if (quorum < 0) {
            quorum = 0;
        }
        if (checkNodesAreOnline && quorum > totalServerInQuorum) {
            throw new ODistributedException("Quorum (" + quorum + ") cannot be reached on server '" + localNodeName + "' database '" + this.databaseName + "' because it is major than available nodes (" + totalServerInQuorum + ")");
        }
        return quorum;
    }

    protected ODistributedResponse waitForResponse(ODistributedRequest iRequest, ODistributedResponseManager currentResponseMgr) throws InterruptedException {
        long elapsed;
        long beginTime = System.currentTimeMillis();
        if (!currentResponseMgr.waitForSynchronousResponses() && (elapsed = System.currentTimeMillis() - beginTime) > currentResponseMgr.getSynchTimeout()) {
            ODistributedServerLog.warn((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.IN, "Timeout (%dms) on waiting for synchronous responses from nodes=%s responsesSoFar=%s request=(%s)", elapsed, currentResponseMgr.getExpectedNodes(), currentResponseMgr.getRespondingNodes(), iRequest);
        }
        return currentResponseMgr.getFinalResponse();
    }

    @Override
    public void checkNodeInConfiguration(ODistributedConfiguration cfg, final String serverName) {
        this.manager.executeInDistributedDatabaseLock(this.databaseName, 20000L, cfg != null ? cfg.modify() : null, new OCallable<Void, OModifiableDistributedConfiguration>(){

            @Override
            public Void call(OModifiableDistributedConfiguration lastCfg) {
                List<String> foundPartition = lastCfg.addNewNodeInServerList(serverName);
                if (foundPartition != null) {
                    ODistributedServerLog.info((Object)this, ODistributedDatabaseImpl.this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Adding node '%s' in partition: %s db=%s v=%d", serverName, foundPartition, ODistributedDatabaseImpl.this.databaseName, lastCfg.getVersion());
                }
                return null;
            }
        });
    }

    protected String getLocalNodeName() {
        return this.localNodeName;
    }

    private void startAcceptingRequests() {
        int totalWorkers = OGlobalConfiguration.DISTRIBUTED_DB_WORKERTHREADS.getValueAsInteger();
        if (totalWorkers < 0) {
            throw new ODistributedException("Cannot create configured distributed workers (" + totalWorkers + ")");
        }
        if (totalWorkers == 0) {
            int totalDatabases = this.manager.getManagedDatabases().size() + 1;
            int cpus = Runtime.getRuntime().availableProcessors();
            if (cpus > 1) {
                totalWorkers = cpus / totalDatabases;
            }
            if (totalWorkers == 0) {
                totalWorkers = 1;
            }
        }
        this.lockThread = new ODistributedWorker(this, this.databaseName, -3, false){

            @Override
            protected void handleError(ODistributedRequest iRequest, Object responsePayload) {
                ODistributedLockTask task = (ODistributedLockTask)iRequest.getTask();
                task.undo(this.manager);
            }
        };
        this.lockThread.start();
        this.nowaitThread = new ODistributedWorker(this, this.databaseName, -4, true);
        this.nowaitThread.start();
        for (int i = 0; i < totalWorkers; ++i) {
            ODistributedWorker workerThread = new ODistributedWorker(this, this.databaseName, i, true);
            this.workerThreads.add(workerThread);
            workerThread.start();
            ALL_QUEUES.add(i);
        }
    }

    @Override
    public void setLSN(String sourceNodeName, OLogSequenceNumber taskLastLSN, boolean updateLastOperationTimestamp) throws IOException {
        if (taskLastLSN == null) {
            return;
        }
        ODistributedSyncConfiguration cfg = this.getSyncConfiguration();
        cfg.setLastLSN(sourceNodeName, taskLastLSN, updateLastOperationTimestamp);
    }

    @Override
    public ODistributedDatabaseRepairer getDatabaseRepairer() {
        return this.repairer;
    }

    private void startTxTimeoutTimerTask() {
        this.txTimeoutTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ODatabase database = null;
                try {
                    long now = System.currentTimeMillis();
                    long timeout = OGlobalConfiguration.DISTRIBUTED_TX_EXPIRE_TIMEOUT.getValueAsLong();
                    HashSet<ORecordId> rids2Repair = new HashSet<ORecordId>();
                    Iterator<Object> it = ODistributedDatabaseImpl.this.activeTxContexts.values().iterator();
                    while (it.hasNext() && ODistributedDatabaseImpl.this.isRunning()) {
                        long started;
                        long elapsed;
                        ODistributedTxContext ctx = (ODistributedTxContext)it.next();
                        if (ctx == null || (elapsed = now - (started = ctx.getStartedOn())) <= timeout) continue;
                        if (database == null) {
                            database = ODistributedDatabaseImpl.this.getDatabaseInstance();
                        }
                        ODistributedServerLog.debug((Object)this, ODistributedDatabaseImpl.this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed transaction %s on database '%s' is expired after %dms", ctx.getReqId(), ODistributedDatabaseImpl.this.databaseName, elapsed);
                        if (database != null) {
                            database.activateOnCurrentThread();
                        }
                        try {
                            rids2Repair.addAll(ctx.cancel(ODistributedDatabaseImpl.this.manager, (ODatabaseDocumentInternal)database));
                            if (ctx.getReqId().getNodeId() != ODistributedDatabaseImpl.this.manager.getLocalNodeId()) continue;
                            ODistributedDatabaseImpl.this.msgService.timeoutRequest(ctx.getReqId().getMessageId());
                        }
                        catch (Exception t) {
                            ODistributedServerLog.info((Object)this, ODistributedDatabaseImpl.this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on rolling back distributed transaction %s on database '%s' (err=%s)", ctx.getReqId(), ODistributedDatabaseImpl.this.databaseName, t);
                        }
                        finally {
                            it.remove();
                        }
                    }
                    it = ODistributedDatabaseImpl.this.lockManager.entrySet().iterator();
                    while (it.hasNext()) {
                        long elapsed;
                        Map.Entry entry = (Map.Entry)it.next();
                        ODistributedLock lock = (ODistributedLock)entry.getValue();
                        if (lock == null || (elapsed = now - lock.acquiredOn) <= timeout) continue;
                        ODistributedServerLog.debug((Object)this, ODistributedDatabaseImpl.this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Distributed lock on database '%s' record %s is expired after %dms", ODistributedDatabaseImpl.this.databaseName, entry.getKey(), elapsed);
                        it.remove();
                    }
                    ODistributedDatabaseImpl.this.getDatabaseRepairer().enqueueRepairRecords(rids2Repair);
                }
                catch (Exception t) {
                    ODistributedServerLog.info((Object)this, ODistributedDatabaseImpl.this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on checking for expired distributed transaction on database '%s'", ODistributedDatabaseImpl.this.databaseName);
                }
                finally {
                    if (database != null) {
                        database.activateOnCurrentThread();
                        database.close();
                    }
                }
            }
        };
    }

    private boolean isRunning() {
        return this.running;
    }

    public void suspend() {
        boolean parsing = this.parsing.get();
        if (parsing) {
            if (this.lockThread != null) {
                this.lockThread.reset();
            }
            if (this.nowaitThread != null) {
                this.nowaitThread.reset();
            }
            for (ODistributedWorker w : this.workerThreads) {
                if (w == null) continue;
                w.reset();
            }
        }
        this.parsing.set(false);
        if (parsing) {
            while (this.operationsRunnig.get() != 0L) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            this.recordLockManager.reset();
            this.indexKeyLockManager.reset();
        }
    }

    public void resume() {
        this.parsing.set(true);
    }

    @Override
    public String dump() {
        int i;
        ArrayBlockingQueue<ODistributedRequest> queue;
        ODistributedRequest processing;
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("\n\nDATABASE '" + this.databaseName + "' ON SERVER '" + this.manager.getLocalNodeName() + "'");
        buffer.append("\n- " + ODistributedOutput.formatRecordLocks(this.manager, this.databaseName));
        buffer.append("\n- MESSAGES IN QUEUES");
        buffer.append(" (" + (this.workerThreads != null ? this.workerThreads.size() : 0) + " WORKERS):");
        if (this.lockThread != null) {
            processing = this.lockThread.getProcessing();
            queue = this.lockThread.localQueue;
            if (processing != null || !queue.isEmpty()) {
                buffer.append("\n - QUEUE LOCK EXECUTING: " + processing);
                i = 0;
                for (ODistributedRequest m : queue) {
                    if (m == null) continue;
                    buffer.append("\n  - " + i + " = " + m.toString());
                }
            }
        }
        if (this.nowaitThread != null) {
            processing = this.nowaitThread.getProcessing();
            queue = this.nowaitThread.localQueue;
            if (processing != null || !queue.isEmpty()) {
                buffer.append("\n - QUEUE UNLOCK EXECUTING: " + processing);
                i = 0;
                for (ODistributedRequest m : queue) {
                    if (m == null) continue;
                    buffer.append("\n  - " + i + " = " + m.toString());
                }
            }
        }
        if (this.workerThreads != null) {
            for (ODistributedWorker t : this.workerThreads) {
                ODistributedRequest processing2 = t.getProcessing();
                ArrayBlockingQueue<ODistributedRequest> queue2 = t.localQueue;
                if (processing2 == null && queue2.isEmpty()) continue;
                buffer.append("\n  - QUEUE " + t.id + " EXECUTING: " + processing2);
                int i2 = 0;
                for (ODistributedRequest m : queue2) {
                    if (m == null) continue;
                    buffer.append("\n   - " + i2++ + " = " + m.toString());
                }
            }
        }
        return buffer.toString();
    }

    public ConcurrentHashMap<ODistributedRequestId, ODistributedTxContext> getActiveTxContexts() {
        return this.activeTxContexts;
    }

    public class ODistributedLock {
        protected final ODistributedRequestId reqId;
        protected final CountDownLatch lock;
        protected final long acquiredOn;
        protected volatile ORawBuffer record;

        private ODistributedLock(ODistributedRequestId reqId) {
            this.reqId = reqId;
            this.lock = new CountDownLatch(1);
            this.acquiredOn = System.currentTimeMillis();
        }
    }
}

