/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.profiler.OProfilerEntry;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedMessageService;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ODistributedMessageServiceImpl
implements ODistributedMessageService {
    private final OHazelcastPlugin manager;
    private final ConcurrentHashMap<Long, ODistributedResponseManager> responsesByRequestIds;
    private final TimerTask asynchMessageManager;
    final ConcurrentHashMap<String, ODistributedDatabaseImpl> databases = new ConcurrentHashMap();
    private Thread responseThread;
    private long[] responseTimeMetrics = new long[10];
    private volatile boolean running = true;
    private final Map<String, OProfilerEntry> latencies = new HashMap<String, OProfilerEntry>();
    private final Map<String, AtomicLong> messagesStats = new HashMap<String, AtomicLong>();

    public ODistributedMessageServiceImpl(OHazelcastPlugin manager) {
        this.manager = manager;
        this.responsesByRequestIds = new ConcurrentHashMap();
        for (int i = 0; i < this.responseTimeMetrics.length; ++i) {
            this.responseTimeMetrics[i] = -1L;
        }
        this.asynchMessageManager = new TimerTask(){

            @Override
            public void run() {
                ODistributedMessageServiceImpl.this.purgePendingMessages();
            }
        };
    }

    @Override
    public ODistributedDatabaseImpl getDatabase(String iDatabaseName) {
        if (this.databases != null) {
            return (ODistributedDatabaseImpl)this.databases.get(iDatabaseName);
        }
        return null;
    }

    public void shutdown() {
        this.running = false;
        if (this.responseThread != null) {
            this.responseThread.interrupt();
            this.responseThread = null;
        }
        for (Map.Entry m : this.databases.entrySet()) {
            if ("OSystem".equals(m.getKey())) continue;
            try {
                this.manager.setDatabaseStatus(this.manager.getLocalNodeName(), (String)m.getKey(), ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((ODistributedDatabaseImpl)m.getValue()).shutdown();
        }
        this.databases.clear();
        this.asynchMessageManager.cancel();
        for (ODistributedResponseManager req : this.responsesByRequestIds.values()) {
            req.cancel();
        }
        this.responsesByRequestIds.clear();
        this.latencies.clear();
        this.messagesStats.clear();
    }

    @Override
    public ODistributedResponseManager getResponseManager(ODistributedRequestId reqId) {
        return (ODistributedResponseManager)this.responsesByRequestIds.get(reqId.getMessageId());
    }

    @Override
    public void registerRequest(long id, ODistributedResponseManager currentResponseMgr) {
        this.responsesByRequestIds.put(id, currentResponseMgr);
    }

    public void handleUnreachableNode(String nodeName) {
        for (ODistributedResponseManager r : this.responsesByRequestIds.values()) {
            r.removeServerBecauseUnreachable(nodeName);
        }
    }

    public long getAverageResponseTime() {
        long total = 0L;
        int involved = 0;
        for (long metric : this.responseTimeMetrics) {
            if (metric <= -1L) continue;
            total += metric;
            ++involved;
        }
        return total > 0L ? total / (long)involved : 0L;
    }

    @Override
    public ODistributedDatabaseImpl registerDatabase(String iDatabaseName, ODistributedConfiguration cfg) {
        ODistributedDatabaseImpl ddb = (ODistributedDatabaseImpl)this.databases.get(iDatabaseName);
        if (ddb != null) {
            return ddb;
        }
        return new ODistributedDatabaseImpl(this.manager, this, iDatabaseName, cfg);
    }

    @Override
    public ODistributedDatabaseImpl unregisterDatabase(String iDatabaseName) {
        try {
            this.manager.setDatabaseStatus(this.manager.getLocalNodeName(), iDatabaseName, ODistributedServerManager.DB_STATUS.OFFLINE);
        }
        catch (Exception t) {
            ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), null, null, "error un-registering database", t, new Object[0]);
        }
        ODistributedDatabaseImpl db = (ODistributedDatabaseImpl)this.databases.remove(iDatabaseName);
        if (db != null) {
            db.shutdown();
        }
        return db;
    }

    @Override
    public Set<String> getDatabases() {
        ConcurrentHashMap<String, ODistributedDatabaseImpl> map = this.databases;
        HashSet<String> result = new HashSet<String>(map.keySet());
        result.remove("OSystem");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchResponseToThread(ODistributedResponse response) {
        try {
            long msgId = response.getRequestId().getMessageId();
            ODistributedResponseManager asynchMgr = (ODistributedResponseManager)this.responsesByRequestIds.get(msgId);
            if (asynchMgr == null) {
                if (ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)this, this.manager.getLocalNodeName(), response.getExecutorNodeName(), ODistributedServerLog.DIRECTION.IN, "received response for message %d after the timeout (%dms)", msgId, OGlobalConfiguration.DISTRIBUTED_ASYNCH_RESPONSES_TIMEOUT.getValueAsLong());
                }
            } else if (asynchMgr.collectResponse(response)) {
                this.responsesByRequestIds.remove(msgId);
            }
        }
        finally {
            Orient.instance().getProfiler().updateCounter("distributed.node.msgReceived", "Number of replication messages received in current node", 1L, "distributed.node.msgReceived");
            Orient.instance().getProfiler().updateCounter("distributed.node." + response.getExecutorNodeName() + ".msgReceived", "Number of replication messages received in current node from a node", 1L, "distributed.node.*.msgReceived");
        }
    }

    public void timeoutRequest(long msgId) {
        ODistributedResponseManager asynchMgr = (ODistributedResponseManager)this.responsesByRequestIds.remove(msgId);
        if (asynchMgr != null) {
            asynchMgr.timeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument getLatencies() {
        ODocument doc = new ODocument();
        Map<String, OProfilerEntry> map = this.latencies;
        synchronized (map) {
            for (Map.Entry<String, OProfilerEntry> entry : this.latencies.entrySet()) {
                doc.field(entry.getKey(), entry.getValue().toDocument(), OType.EMBEDDED);
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentLatency(String server) {
        Map<String, OProfilerEntry> map = this.latencies;
        synchronized (map) {
            OProfilerEntry l = this.latencies.get(server);
            if (l != null) {
                return (long)(l.average / 1000000.0f);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLatency(String server, long sentOn) {
        Map<String, OProfilerEntry> map = this.latencies;
        synchronized (map) {
            OProfilerEntry latency = this.latencies.get(server);
            if (latency == null) {
                latency = new OProfilerEntry();
                this.latencies.put(server, latency);
            } else {
                latency.updateLastExecution();
            }
            ++latency.entries;
            if (latency.lastExecution - latency.lastReset > 30000L) {
                latency.last = 0L;
                latency.total = 0L;
                latency.average = 0.0f;
                latency.min = 0L;
                latency.max = 0L;
                latency.lastResetEntries = 0L;
                latency.lastReset = latency.lastExecution;
            }
            ++latency.lastResetEntries;
            latency.last = System.nanoTime() - sentOn;
            latency.total += latency.last;
            latency.average = latency.total / latency.lastResetEntries;
            if (latency.last < latency.min) {
                latency.min = latency.last;
            }
            if (latency.last > latency.max) {
                latency.max = latency.last;
            }
        }
    }

    protected void purgePendingMessages() {
        long now = System.nanoTime();
        long timeout = OGlobalConfiguration.DISTRIBUTED_ASYNCH_RESPONSES_TIMEOUT.getValueAsLong();
        Iterator it = this.responsesByRequestIds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry item = it.next();
            ODistributedResponseManager resp = (ODistributedResponseManager)item.getValue();
            long timeElapsed = (now - resp.getSentOn()) / 1000000L;
            if (timeElapsed > timeout) {
                List<String> missingNodes = resp.getMissingNodes();
                ODistributedServerLog.warn((Object)this, this.manager.getLocalNodeName(), missingNodes.toString(), ODistributedServerLog.DIRECTION.IN, "%d missed response(s) for message %d by nodes %s after %dms when timeout is %dms", missingNodes.size(), resp.getMessageId(), missingNodes, timeElapsed, timeout);
                Orient.instance().getProfiler().updateCounter("distributed.db." + resp.getDatabaseName() + ".timeouts", "Number of messages in timeouts", 1L, "distributed.db.*.timeouts");
                Orient.instance().getProfiler().updateCounter("distributed.node.timeouts", "Number of messages in timeouts", 1L, "distributed.node.timeouts");
                resp.timeout();
                it.remove();
                continue;
            }
            if (!resp.isFinished()) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument getMessageStats() {
        ODocument doc = new ODocument();
        Map<String, AtomicLong> map = this.messagesStats;
        synchronized (map) {
            for (Map.Entry<String, AtomicLong> entry : this.messagesStats.entrySet()) {
                doc.field(entry.getKey(), entry.getValue().longValue());
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessageStats(String message) {
        Map<String, AtomicLong> map = this.messagesStats;
        synchronized (map) {
            AtomicLong counter = this.messagesStats.get(message);
            if (counter == null) {
                counter = new AtomicLong();
                this.messagesStats.put(message, counter);
            }
            counter.incrementAndGet();
        }
    }

    @Override
    public long getReceivedRequests() {
        long total = 0L;
        for (ODistributedDatabaseImpl db : this.databases.values()) {
            total += db.getReceivedRequests();
        }
        return total;
    }

    @Override
    public long getProcessedRequests() {
        long total = 0L;
        for (ODistributedDatabaseImpl db : this.databases.values()) {
            total += db.getProcessedRequests();
        }
        return total;
    }
}

