/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1Task;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1TaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxStillRunning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ONewDistributedResponseManager
implements ODistributedResponseManager {
    private final OTransactionPhase1Task iRequest;
    private final Collection<String> iNodes;
    private final Set<String> nodesConcurToTheQuorum;
    private final int availableNodes;
    private final int expectedResponses;
    private final int quorum;
    private volatile long timeout;
    private volatile int responseCount;
    private final List<String> debugNodeReplied = new ArrayList<String>();
    private volatile Map<Integer, List<OTransactionResultPayload>> resultsByType = new HashMap<Integer, List<OTransactionResultPayload>>();
    private volatile IdentityHashMap<OTransactionResultPayload, String> payloadToNode = new IdentityHashMap();
    private volatile boolean finished = false;
    private volatile boolean quorumReached = false;
    private volatile Object finalResult;
    private volatile int stillRunning = 0;
    private volatile int stillRunningWaited = 0;

    public ONewDistributedResponseManager(OTransactionPhase1Task iRequest, Collection<String> iNodes, Set<String> nodesConcurToTheQuorum, int availableNodes, int expectedResponses, int quorum) {
        this.iRequest = iRequest;
        this.iNodes = iNodes;
        this.nodesConcurToTheQuorum = nodesConcurToTheQuorum;
        this.availableNodes = availableNodes;
        this.expectedResponses = expectedResponses;
        this.quorum = quorum;
        this.timeout = iRequest.getSynchronousTimeout(expectedResponses);
    }

    @Override
    public synchronized boolean setLocalResult(String localNodeName, Object localResult) {
        this.debugNodeReplied.add(localNodeName);
        return this.addResult(localNodeName, (OTransactionResultPayload)localResult);
    }

    @Override
    public ODistributedResponse getFinalResponse() {
        return null;
    }

    @Override
    public Object getGenericFinalResponse() {
        return this.finalResult;
    }

    @Override
    public synchronized void removeServerBecauseUnreachable(String node) {
        ++this.responseCount;
        this.checkFinished(new ArrayList<OTransactionResultPayload>());
    }

    @Override
    public synchronized boolean waitForSynchronousResponses() throws InterruptedException {
        boolean interrupted = false;
        while (!interrupted) {
            try {
                if (!this.quorumReached) {
                    this.wait(this.timeout);
                }
                if (this.quorumReached || this.finished) {
                    return this.quorumReached;
                }
                if (this.stillRunning - this.stillRunningWaited > 0) {
                    ++this.stillRunningWaited;
                    this.timeout = this.iRequest.getDistributedTimeout();
                    continue;
                }
                return this.quorumReached;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                interrupted = true;
            }
        }
        return this.quorumReached;
    }

    @Override
    public long getSynchTimeout() {
        return this.timeout;
    }

    @Override
    public void cancel() {
    }

    @Override
    public Set<String> getExpectedNodes() {
        return this.nodesConcurToTheQuorum;
    }

    @Override
    public List<String> getRespondingNodes() {
        return this.debugNodeReplied;
    }

    @Override
    public Collection<String> getConflictServers() {
        return null;
    }

    @Override
    public Set<String> getServersWithoutFollowup() {
        return null;
    }

    @Override
    public boolean addFollowupToServer(String node) {
        return false;
    }

    @Override
    public boolean isSynchronousWaiting() {
        return false;
    }

    @Override
    public ODistributedResponse getQuorumResponse() {
        return null;
    }

    @Override
    public ODistributedRequestId getMessageId() {
        return null;
    }

    @Override
    public ODistributedRequest getRequest() {
        return null;
    }

    @Override
    public Object getResponseFromServer(String server) {
        return null;
    }

    public String getNodeNameFromPayload(OTransactionResultPayload payload) {
        return this.payloadToNode.get(payload);
    }

    @Override
    public int getQuorum() {
        return this.quorum;
    }

    @Override
    public boolean executeInLock(OCallable<Boolean, ODistributedResponseManager> oCallable) {
        return false;
    }

    public synchronized boolean collectResponse(OTransactionPhase1TaskResult response, String senderNodeName) {
        if (response.getResultPayload() instanceof OTxStillRunning) {
            ++this.stillRunning;
            return false;
        }
        this.debugNodeReplied.add(senderNodeName);
        return this.addResult(senderNodeName, response.getResultPayload());
    }

    private boolean addResult(String senderNodeName, OTransactionResultPayload result) {
        List<Object> results = new ArrayList();
        if (this.nodesConcurToTheQuorum.contains(senderNodeName)) {
            results = this.resultsByType.get(result.getResponseType());
            if (results == null) {
                results = new ArrayList();
                results.add(result);
                this.resultsByType.put(result.getResponseType(), results);
            } else {
                results.add(result);
            }
            this.payloadToNode.put(result, senderNodeName);
        }
        ++this.responseCount;
        this.checkFinished(results);
        return this.finished;
    }

    private void checkFinished(List<OTransactionResultPayload> results) {
        if (results.size() >= this.quorum) {
            if (!this.quorumReached) {
                this.quorumReached = true;
                this.finalResult = results;
                this.notifyAll();
            }
            if (this.responseCount == this.expectedResponses) {
                this.finished = true;
            }
        } else if (this.responseCount == this.expectedResponses) {
            if (this.quorumReached) {
                this.finished = true;
            } else {
                this.finished = true;
                this.finalResult = null;
                this.finalResult = null;
                this.notifyAll();
            }
        }
    }

    public synchronized List<OTransactionResultPayload> getAllResponses() {
        ArrayList<OTransactionResultPayload> allResults = new ArrayList<OTransactionResultPayload>();
        for (List<OTransactionResultPayload> res : this.resultsByType.values()) {
            allResults.addAll(res);
        }
        return allResults;
    }

    @Override
    public boolean collectResponse(ODistributedResponse response) {
        if (response.getPayload() instanceof OTransactionPhase1TaskResult) {
            return this.collectResponse((OTransactionPhase1TaskResult)response.getPayload(), response.getExecutorNodeName());
        }
        if (response.getPayload() instanceof RuntimeException) {
            return this.collectResponse(new OTransactionPhase1TaskResult(new OTxException((RuntimeException)response.getPayload())), response.getExecutorNodeName());
        }
        return this.collectResponse(new OTransactionPhase1TaskResult(new OTxException(new ODistributedException("unknown payload:" + response.getPayload()))), response.getExecutorNodeName());
    }

    public synchronized boolean isQuorumReached() {
        return this.quorumReached;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished;
    }

    @Override
    public void timeout() {
    }

    @Override
    public long getSentOn() {
        return 0L;
    }

    @Override
    public List<String> getMissingNodes() {
        return null;
    }

    @Override
    public String getDatabaseName() {
        return null;
    }
}

