/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorageEventListener;
import com.orientechnologies.orient.server.distributed.impl.ONewDistributedResponseManager;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1Task;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase2Task;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentCreation;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentModification;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxKeyLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxRecordLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxUniqueIndex;
import com.orientechnologies.orient.server.distributed.task.ODistributedKeyLockedException;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class ONewDistributedTransactionManager {
    private final ODistributedServerManager dManager;
    private final ODistributedStorage storage;
    private final ODistributedDatabase localDistributedDatabase;
    private static final boolean SYNC_TX_COMPLETED = false;
    private ONewDistributedResponseManager responseManager;

    public ONewDistributedTransactionManager(ODistributedStorage storage, ODistributedServerManager manager, ODistributedDatabase iDDatabase) {
        this.dManager = manager;
        this.storage = storage;
        this.localDistributedDatabase = iDDatabase;
    }

    public List<ORecordOperation> commit(ODatabaseDocumentDistributed database, OTransactionInternal iTx, ODistributedStorageEventListener eventListener) {
        int nretry = database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY);
        int delay = database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY);
        ODistributedDatabaseImpl distributedDatabase = (ODistributedDatabaseImpl)this.dManager.getMessageService().getDatabase(database.getName());
        int count = 0;
        while (true) {
            ODistributedRequestId requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
            distributedDatabase.startOperation();
            try {
                List<ORecordOperation> list = this.retriedCommit(database, iTx, requestId);
                return list;
            }
            catch (OConcurrentCreateException | ODistributedKeyLockedException | ODistributedRecordLockedException ex) {
                if (count > nretry) {
                    ODistributedTxContext context = this.localDistributedDatabase.getTxContext(requestId);
                    if (context != null) {
                        context.destroy();
                    }
                    throw ex;
                }
                try {
                    Thread.sleep(new Random().nextInt(delay));
                }
                catch (InterruptedException e) {
                    OException.wrapException(new OInterruptedException(e.getMessage()), e);
                }
            }
            catch (Error | RuntimeException ex) {
                ODistributedTxContext context = this.localDistributedDatabase.getTxContext(requestId);
                if (context != null) {
                    context.destroy();
                }
                throw ex;
            }
            finally {
                distributedDatabase.endOperation();
            }
            ++count;
        }
    }

    public List<ORecordOperation> retriedCommit(ODatabaseDocumentDistributed database, OTransactionInternal iTx, ODistributedRequestId requestId) {
        String localNodeName = this.dManager.getLocalNodeName();
        iTx.setStatus(OTransaction.TXSTATUS.BEGUN);
        ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.storage.getName());
        Set<String> involvedClusters = this.getInvolvedClusters(iTx.getRecordOperations());
        Set<String> nodes = this.getAvailableNodesButLocal(dbCfg, involvedClusters, localNodeName);
        OTransactionResultPayload localResult = OTransactionPhase1Task.executeTransaction(requestId, database, iTx, true, -1);
        if (localResult.getResponseType() == 2) {
            this.dManager.getMessageService().getDatabase(database.getName()).popTxContext(requestId).destroy();
            int timeout = database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT);
            throw new ODistributedRecordLockedException(this.dManager.getLocalNodeName(), ((OTxRecordLockTimeout)localResult).getLockedId(), timeout);
        }
        if (localResult.getResponseType() == 7) {
            this.dManager.getMessageService().getDatabase(database.getName()).popTxContext(requestId).destroy();
            int timeout = database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT);
            throw new ODistributedKeyLockedException(this.dManager.getLocalNodeName(), (Object)((OTxKeyLockTimeout)localResult).getKey(), timeout);
        }
        OTransactionPhase1Task txTask = !nodes.isEmpty() ? this.createTxTask(iTx, nodes) : null;
        try {
            this.localDistributedDatabase.getSyncConfiguration().setLastLSN(localNodeName, ((OLocalPaginatedStorage)this.storage.getUnderlying()).getLSN(), true);
        }
        catch (IOException e) {
            ODistributedServerLog.debug((Object)this, this.dManager != null ? this.dManager.getLocalNodeName() : "?", null, ODistributedServerLog.DIRECTION.NONE, "Error on updating local LSN configuration for database '%s'", this.storage.getName());
        }
        if (nodes.isEmpty()) {
            switch (localResult.getResponseType()) {
                case 1: {
                    this.localOk(requestId, database);
                    break;
                }
                case 5: {
                    this.localKo(requestId, database);
                    throw ((OTxException)localResult).getException();
                }
                case 3: {
                    this.localKo(requestId, database);
                    ORecordId id = ((OTxUniqueIndex)localResult).getRecordId();
                    String index = ((OTxUniqueIndex)localResult).getIndex();
                    Object key = ((OTxUniqueIndex)localResult).getKey();
                    throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' ", id, key, index), index, id, key);
                }
                case 4: {
                    this.localKo(requestId, database);
                    ORecordId id = ((OTxConcurrentModification)localResult).getRecordId();
                    int version = ((OTxConcurrentModification)localResult).getVersion();
                    throw new OConcurrentModificationException(id, version, 0, 0);
                }
                case 2: {
                    int timeout = database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT);
                    throw new ODistributedRecordLockedException(this.dManager.getLocalNodeName(), ((OTxRecordLockTimeout)localResult).getLockedId(), timeout);
                }
                case 7: {
                    int timeout = database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT);
                    throw new ODistributedKeyLockedException(this.dManager.getLocalNodeName(), (Object)((OTxKeyLockTimeout)localResult).getKey(), timeout);
                }
            }
            return null;
        }
        txTask.setLastLSN(this.getLsn());
        HashSet<String> sentNodes = new HashSet<String>(nodes);
        iTx.setStatus(OTransaction.TXSTATUS.COMMITTING);
        ((ODistributedAbstractPlugin)this.dManager).sendRequest(this.storage.getName(), involvedClusters, nodes, txTask, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, localResult, null, null, (iRequest, iNodes, endCallback, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode) -> {
            this.responseManager = new ONewDistributedResponseManager(txTask, iNodes, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum);
            return this.responseManager;
        });
        this.handleResponse(requestId, this.responseManager, involvedClusters, sentNodes, database, iTx);
        return null;
    }

    public OLogSequenceNumber getLsn() {
        return ((OAbstractPaginatedStorage)this.storage.getUnderlying()).getLSN();
    }

    private void handleResponse(ODistributedRequestId requestId, ONewDistributedResponseManager responseManager, Set<String> involvedClusters, Set<String> nodes, ODatabaseDocumentDistributed database, OTransactionInternal iTx) {
        List results;
        int timeout = database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT);
        int[] involvedClustersIds = new int[involvedClusters.size()];
        int i = 0;
        for (String involvedCluster : involvedClusters) {
            involvedClustersIds[i++] = database.getClusterIdByName(involvedCluster);
        }
        if (responseManager.isQuorumReached()) {
            results = (List)responseManager.getGenericFinalResponse();
            assert (results.size() > 0);
            OTransactionResultPayload resultPayload = (OTransactionResultPayload)results.get(0);
            switch (resultPayload.getResponseType()) {
                case 1: {
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, true, involvedClustersIds, this.getLsn()));
                    this.localOk(requestId, database);
                    break;
                }
                case 5: {
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    this.localKo(requestId, database);
                    throw ((OTxException)resultPayload).getException();
                }
                case 3: {
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    this.localKo(requestId, database);
                    ORecordId id = ((OTxUniqueIndex)resultPayload).getRecordId();
                    String index = ((OTxUniqueIndex)resultPayload).getIndex();
                    Object key = ((OTxUniqueIndex)resultPayload).getKey();
                    throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' ", id, key, index), index, id, key);
                }
                case 4: {
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    this.localKo(requestId, database);
                    ORecordId id = ((OTxConcurrentModification)resultPayload).getRecordId();
                    int version = ((OTxConcurrentModification)resultPayload).getVersion();
                    throw new OConcurrentModificationException(id, version, iTx.getRecordEntry(id).getRecord().getVersion(), iTx.getRecordEntry(id).getType());
                }
                case 6: {
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    this.localKo(requestId, database);
                    throw new OConcurrentCreateException(((OTxConcurrentCreation)resultPayload).getExpectedRid(), ((OTxConcurrentCreation)resultPayload).getActualRid());
                }
                case 2: {
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    this.localKo(requestId, database);
                    throw new ODistributedRecordLockedException(((OTxRecordLockTimeout)resultPayload).getNode(), ((OTxRecordLockTimeout)resultPayload).getLockedId(), timeout);
                }
                case 7: {
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    this.localKo(requestId, database);
                    throw new ODistributedKeyLockedException(((OTxKeyLockTimeout)resultPayload).getNode(), (Object)((OTxKeyLockTimeout)resultPayload).getKey(), timeout);
                }
            }
        } else {
            results = responseManager.getAllResponses();
            ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
            ArrayList<String> messages = new ArrayList<String>();
            for (OTransactionResultPayload result : results) {
                String string = responseManager.getNodeNameFromPayload(result);
                switch (result.getResponseType()) {
                    case 2: {
                        this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                        this.localKo(requestId, database);
                        throw new ODistributedRecordLockedException(((OTxRecordLockTimeout)result).getNode(), ((OTxRecordLockTimeout)result).getLockedId(), timeout);
                    }
                    case 7: {
                        this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                        this.localKo(requestId, database);
                        throw new ODistributedKeyLockedException(((OTxKeyLockTimeout)result).getNode(), (Object)((OTxKeyLockTimeout)result).getKey(), timeout);
                    }
                    case 6: {
                        this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                        this.localKo(requestId, database);
                        throw new OConcurrentCreateException(((OTxConcurrentCreation)result).getExpectedRid(), ((OTxConcurrentCreation)result).getActualRid());
                    }
                    case 1: {
                        messages.add("node: " + string + " success");
                        break;
                    }
                    case 4: {
                        ORecordId recordId = ((OTxConcurrentModification)result).getRecordId();
                        messages.add(String.format("concurrent modification record (node " + string + "): %s database version: %d transaction version: %d", recordId.toString(), ((OTxConcurrentModification)result).getVersion(), iTx.getRecordEntry(recordId).getRecord().getVersion()));
                        break;
                    }
                    case 5: {
                        exceptions.add(((OTxException)result).getException());
                        OLogManager.instance().debug((Object)this, "distributed exception", ((OTxException)result).getException(), new Object[0]);
                        messages.add(String.format("exception (node " + string + "): '%s'", ((OTxException)result).getException().getMessage()));
                        break;
                    }
                    case 3: {
                        messages.add(String.format("unique index violation on index (node " + string + "):'%s' with key:'%s' and rid:'%s'", ((OTxUniqueIndex)result).getIndex(), ((OTxUniqueIndex)result).getKey(), ((OTxUniqueIndex)result).getRecordId()));
                    }
                }
            }
            this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
            this.localKo(requestId, database);
            ODistributedOperationException ex = new ODistributedOperationException(String.format("Request `%s` didn't reach the quorum of '%d', responses: [%s]", requestId, responseManager.getQuorum(), String.join((CharSequence)",", messages)));
            for (Exception exception : exceptions) {
                ex.addSuppressed(exception);
            }
            throw ex;
        }
    }

    private void localKo(ODistributedRequestId requestId, ODatabaseDocumentDistributed database) {
        database.rollback2pc(requestId);
    }

    private void localOk(ODistributedRequestId requestId, ODatabaseDocumentDistributed database) {
        database.commit2pcLocal(requestId);
    }

    private void sendPhase2Task(Set<String> involvedClusters, Set<String> nodes, OTransactionPhase2Task task) {
        this.dManager.sendRequest(this.storage.getName(), involvedClusters, nodes, task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, "OK", null, null);
    }

    protected void checkForClusterIds(OTransactionInternal iTx) {
        for (ORecordOperation op : iTx.getRecordOperations()) {
            ORecordId rid = (ORecordId)op.getRecord().getIdentity();
            switch (op.type) {
                case 3: {
                    assert (rid.isPersistent());
                    break;
                }
            }
        }
    }

    protected Set<String> getAvailableNodesButLocal(ODistributedConfiguration dbCfg, Set<String> involvedClusters, String localNodeName) {
        Set<String> nodes = dbCfg.getServers(involvedClusters);
        nodes.remove(localNodeName);
        return nodes;
    }

    protected Set<String> getInvolvedClusters(Iterable<ORecordOperation> uResult) {
        HashSet<String> involvedClusters = new HashSet<String>();
        for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            involvedClusters.add(this.storage.getClusterNameByRID((ORecordId)record.getIdentity()));
        }
        return involvedClusters;
    }

    protected OTransactionPhase1Task createTxTask(OTransactionInternal transaction, Set<String> nodes) {
        OTransactionPhase1Task txTask = (OTransactionPhase1Task)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(43);
        txTask.init(transaction);
        return txTask;
    }
}

