/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.task.OCopyDatabaseChunkTask;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class OSyncReceiver
implements Runnable {
    private ODistributedAbstractPlugin distributed;
    private final String databaseName;
    private final ODistributedDatabaseChunk firstChunk;
    private final AtomicReference<ODistributedMomentum> momentum;
    private final String iNode;
    private final String dbPath;
    private final CountDownLatch done = new CountDownLatch(1);
    private final CountDownLatch started = new CountDownLatch(1);
    private PipedOutputStream output;
    private PipedInputStream inputStream;

    public OSyncReceiver(ODistributedAbstractPlugin distributed, String databaseName, ODistributedDatabaseChunk firstChunk, AtomicReference<ODistributedMomentum> momentum, String iNode, String dbPath) {
        this.distributed = distributed;
        this.databaseName = databaseName;
        this.firstChunk = firstChunk;
        this.momentum = momentum;
        this.iNode = iNode;
        this.dbPath = dbPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.currentThread().setName("OrientDB installDatabase node=" + this.distributed.nodeName + " db=" + this.databaseName);
            ODistributedDatabaseChunk chunk = this.firstChunk;
            this.momentum.set(chunk.getMomentum());
            this.output = new PipedOutputStream();
            this.inputStream = new PipedInputStream(this.output);
            this.started.countDown();
            try {
                long fileSize = this.writeDatabaseChunk(1, chunk, this.output);
                int chunkNum = 2;
                while (!chunk.last) {
                    ODistributedResponse response = this.distributed.sendRequest(this.databaseName, null, OMultiValue.getSingletonList(this.iNode), new OCopyDatabaseChunkTask(chunk.filePath, chunkNum, chunk.offset + (long)chunk.buffer.length, false), this.distributed.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                    if (response == null) {
                        this.output.close();
                        this.done.countDown();
                        return;
                    }
                    Object result = response.getPayload();
                    if (!(result instanceof Boolean)) {
                        if (result instanceof Exception) {
                            ODistributedServerLog.error((Object)this, this.distributed.nodeName, this.iNode, ODistributedServerLog.DIRECTION.IN, "error on installing database %s in %s (chunk #%d)", (Exception)result, this.databaseName, this.dbPath, chunkNum);
                        } else if (result instanceof ODistributedDatabaseChunk) {
                            chunk = (ODistributedDatabaseChunk)result;
                            fileSize += this.writeDatabaseChunk(chunkNum, chunk, this.output);
                        }
                    }
                    ++chunkNum;
                }
                ODistributedServerLog.info((Object)this, this.distributed.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Database copied correctly, size=%s", OFileUtils.getSizeAsString(fileSize));
            }
            finally {
                try {
                    this.output.flush();
                    this.output.close();
                    this.done.countDown();
                }
                catch (IOException e) {
                    ODistributedServerLog.warn((Object)this, this.distributed.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on closing sync piped stream ", e, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, this.distributed.nodeName, null, ODistributedServerLog.DIRECTION.NONE, "Error on transferring database '%s' ", e, this.databaseName);
            throw OException.wrapException(new ODistributedException("Error on transferring database"), e);
        }
    }

    protected long writeDatabaseChunk(int iChunkId, ODistributedDatabaseChunk chunk, OutputStream out) throws IOException {
        block2: {
            ODistributedServerLog.info((Object)this, this.distributed.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "- writing chunk #%d offset=%d size=%s", iChunkId, chunk.offset, OFileUtils.getSizeAsString(chunk.buffer.length));
            try {
                out.write(chunk.buffer);
            }
            catch (IOException e) {
                if (!chunk.incremental) break block2;
                throw e;
            }
        }
        return chunk.buffer.length;
    }

    public CountDownLatch getStarted() {
        return this.started;
    }

    public PipedInputStream getInputStream() {
        return this.inputStream;
    }

    public CountDownLatch getDone() {
        return this.done;
    }
}

