/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryProxy;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.util.ArrayList;
import java.util.List;

public class OTransactionOptimisticDistributed
extends OTransactionOptimistic {
    private List<ORecordOperation> changes;

    public OTransactionOptimisticDistributed(ODatabaseDocumentInternal database, List<ORecordOperation> changes) {
        super(database);
        this.changes = changes;
    }

    @Override
    public void begin() {
        super.begin();
        for (ORecordOperation change : this.changes) {
            this.allEntries.put(change.getRID(), change);
            this.resolveTracking(change);
        }
    }

    private void resolveTracking(ORecordOperation change) {
        if (change.getRecord() instanceof ODocument) {
            ODocument rec = (ODocument)change.getRecord();
            ArrayList<OClassIndexManager.IndexChange> changes = new ArrayList<OClassIndexManager.IndexChange>();
            switch (change.getType()) {
                case 3: {
                    if (!(change.getRecord() instanceof ODocument)) break;
                    ODocument doc = (ODocument)change.getRecord();
                    OLiveQueryHook.addOp(doc, (byte)3, this.database);
                    OLiveQueryHookV2.addOp(doc, (byte)3, this.database);
                    OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(doc);
                    if (clazz == null) break;
                    OClassIndexManager.processIndexOnCreate(this.database, rec, changes);
                    if (clazz.isFunction()) {
                        this.database.getSharedContext().getFunctionLibrary().createdFunction(doc);
                        Orient.instance().getScriptManager().close(this.database.getName());
                    }
                    if (clazz.isSequence()) {
                        ((OSequenceLibraryProxy)this.database.getMetadata().getSequenceLibrary()).getDelegate().onSequenceCreated(this.database, doc);
                    }
                    if (!clazz.isScheduler()) break;
                    this.database.getMetadata().getScheduler().scheduleEvent(new OScheduledEvent(doc));
                    break;
                }
                case 1: {
                    if (!(change.getRecord() instanceof ODocument)) break;
                    ODocument doc = (ODocument)change.getRecord();
                    ODocument original = (ODocument)this.database.load(doc.getIdentity());
                    if (original == null) {
                        throw new ORecordNotFoundException(doc.getIdentity());
                    }
                    original.merge(doc, false, false);
                    doc = original;
                    OLiveQueryHook.addOp(doc, (byte)1, this.database);
                    OLiveQueryHookV2.addOp(doc, (byte)1, this.database);
                    OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(doc);
                    if (clazz == null) break;
                    OClassIndexManager.processIndexOnUpdate(this.database, doc, changes);
                    if (clazz.isFunction()) {
                        this.database.getSharedContext().getFunctionLibrary().updatedFunction(doc);
                        Orient.instance().getScriptManager().close(this.database.getName());
                    }
                    if (!clazz.isSequence()) break;
                    ((OSequenceLibraryProxy)this.database.getMetadata().getSequenceLibrary()).getDelegate().onSequenceUpdated(this.database, doc);
                    break;
                }
                case 2: {
                    if (!(change.getRecord() instanceof ODocument)) break;
                    ODocument doc = (ODocument)change.getRecord();
                    OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(doc);
                    if (clazz != null) {
                        OClassIndexManager.processIndexOnDelete(this.database, rec, changes);
                        if (clazz.isFunction()) {
                            this.database.getSharedContext().getFunctionLibrary().droppedFunction(doc);
                            Orient.instance().getScriptManager().close(this.database.getName());
                        }
                        if (clazz.isSequence()) {
                            ((OSequenceLibraryProxy)this.database.getMetadata().getSequenceLibrary()).getDelegate().onSequenceDropped(this.database, doc);
                        }
                        if (clazz.isScheduler()) {
                            String eventName = (String)doc.field("name");
                            this.database.getSharedContext().getScheduler().removeEventInternal(eventName);
                        }
                    }
                    OLiveQueryHook.addOp(doc, (byte)2, this.database);
                    OLiveQueryHookV2.addOp(doc, (byte)2, this.database);
                    break;
                }
                case 0: {
                    break;
                }
            }
            for (OClassIndexManager.IndexChange indexChange : changes) {
                this.addIndexEntry(indexChange.index, indexChange.index.getName(), indexChange.operation, indexChange.key, indexChange.value);
            }
        }
    }

    public void setDatabase(ODatabaseDocumentInternal database) {
        this.database = database;
    }
}

