/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class OAbstractReadRecordTask
extends OAbstractRecordReplicatedTask {
    public OAbstractReadRecordTask init(ORecordId iRid) {
        this.rid = iRid;
        return this;
    }

    @Override
    public ORecord getRecord() {
        return this.rid.getRecord();
    }

    @Override
    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ORecord record = (ORecord)database.load(this.rid);
        if (record == null) {
            return null;
        }
        return new ORawBuffer(record);
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        this.rid.toStream(out);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.rid = new ORecordId();
        this.rid.fromStream(in);
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.READ;
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.rid + ")";
    }
}

