/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseTask;
import com.orientechnologies.orient.server.distributed.impl.task.TeeOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class OBackgroundBackup
implements Runnable,
OSyncSource {
    private final TimerTask timer;
    private OSyncDatabaseTask oSyncDatabaseTask;
    private final ODistributedServerManager iManager;
    private final ODatabaseDocumentInternal database;
    private final File resultedBackupFile;
    private final String finalBackupPath;
    private final AtomicBoolean incremental = new AtomicBoolean(false);
    private final AtomicReference<ODistributedMomentum> momentum;
    private final ODistributedDatabase dDatabase;
    private final ODistributedRequestId requestId;
    private final CountDownLatch started = new CountDownLatch(1);
    private final CountDownLatch finished = new CountDownLatch(1);
    private volatile InputStream inputStream;
    public volatile boolean valid = true;
    private volatile long lastRequest;

    public OBackgroundBackup(OSyncDatabaseTask oSyncDatabaseTask, ODistributedServerManager iManager, ODatabaseDocumentInternal database, File resultedBackupFile, String finalBackupPath, OModifiableBoolean incremental, AtomicReference<ODistributedMomentum> momentum, ODistributedDatabase dDatabase, ODistributedRequestId requestId, File completedFile) {
        this.oSyncDatabaseTask = oSyncDatabaseTask;
        this.iManager = iManager;
        this.database = database;
        this.resultedBackupFile = resultedBackupFile;
        this.finalBackupPath = finalBackupPath;
        this.momentum = momentum;
        this.dDatabase = dDatabase;
        this.requestId = requestId;
        this.lastRequest = System.currentTimeMillis();
        long time = database.getConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_CHECK_HEALTH_EVERY) / 3L;
        long maxWait = database.getConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT) * 3L;
        this.timer = Orient.instance().scheduleTask(() -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRequest > maxWait) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.finished.countDown();
                this.valid = false;
            }
        }, time, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("OrientDB SyncDatabase node=" + this.iManager.getLocalNodeName() + " db=" + this.database.getName());
        try {
            try {
                this.database.activateOnCurrentThread();
                ODistributedServerLog.info((Object)this, this.iManager.getLocalNodeName(), this.oSyncDatabaseTask.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "Compressing database '%s' %d clusters %s...", this.database.getName(), this.database.getClusterNames().size(), this.database.getClusterNames());
                if (this.resultedBackupFile.exists()) {
                    this.resultedBackupFile.delete();
                } else {
                    this.resultedBackupFile.getParentFile().mkdirs();
                }
                this.resultedBackupFile.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(this.resultedBackupFile);
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                this.inputStream = new PipedInputStream(pipedOutputStream, 0x800000);
                TeeOutputStream dest = new TeeOutputStream(fileOutputStream, pipedOutputStream);
                if (this.database.getStorage().supportIncremental()) {
                    OWriteAheadLog wal = ((OAbstractPaginatedStorage)this.database.getStorage().getUnderlying()).getWALInstance();
                    OLogSequenceNumber lsn = wal.end();
                    if (lsn == null) {
                        lsn = new OLogSequenceNumber(-1L, -1L);
                    }
                    wal.addCutTillLimit(lsn);
                    try {
                        this.incremental.set(true);
                        this.started.countDown();
                        this.database.getStorage().fullIncrementalBackup(dest);
                    }
                    catch (UnsupportedOperationException u) {
                        throw u;
                    }
                    catch (RuntimeException r) {
                        this.finished.countDown();
                        this.timer.cancel();
                        throw r;
                    }
                    finally {
                        wal.removeCutTillLimit(lsn);
                    }
                    this.finished.countDown();
                    this.timer.cancel();
                    OLogManager.instance().info((Object)this, "Sending Enterprise backup (" + this.database.getName() + ") for node sync", new Object[0]);
                } else {
                    try {
                        OCommandOutputListener listener = null;
                        if (ODistributedServerLog.isDebugEnabled()) {
                            listener = new OCommandOutputListener(){

                                @Override
                                public void onMessage(String iText) {
                                    if (iText.startsWith("\n")) {
                                        iText = iText.substring(1);
                                    }
                                    OLogManager.instance().debug((Object)this, iText, new Object[0]);
                                }
                            };
                        }
                        this.database.backup(dest, null, () -> {
                            this.momentum.set(this.dDatabase.getSyncConfiguration().getMomentum().copy());
                            this.incremental.set(false);
                            this.started.countDown();
                            return null;
                        }, listener, OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION.getValueAsInteger(), 0x800000);
                    }
                    finally {
                        try {
                            ((OutputStream)dest).close();
                        }
                        catch (IOException e2) {
                            OLogManager.instance().debug((Object)this, "Error performing backup ", e2, new Object[0]);
                        }
                        this.finished.countDown();
                        this.timer.cancel();
                    }
                }
                ODistributedServerLog.info((Object)this, this.iManager.getLocalNodeName(), this.oSyncDatabaseTask.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "Backup of database '%s' completed. lastOperationId=%s...", this.database.getName(), this.requestId);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Cannot execute backup of database '%s' for deploy database", e, this.database.getName());
                throw e;
            }
            finally {
                this.finished.countDown();
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            OLogManager.instance().errorNoDb(this, "Error during backup processing, file %s will be deleted\n", e, this.resultedBackupFile);
            try {
                Files.deleteIfExists(Paths.get(this.resultedBackupFile.getAbsolutePath(), new String[0]));
            }
            catch (IOException ioe) {
                OLogManager.instance().errorNoDb(this, "Can not delete file %s\n", ioe, this.resultedBackupFile);
            }
        }
    }

    public void makeStreamFromFile() throws IOException, InterruptedException {
        this.getFinished().await();
        this.inputStream = new FileInputStream(this.finalBackupPath);
    }

    @Override
    public boolean getIncremental() {
        return this.incremental.get();
    }

    public File getResultedBackupFile() {
        return this.resultedBackupFile;
    }

    public String getFinalBackupPath() {
        return this.finalBackupPath;
    }

    public CountDownLatch getStarted() {
        return this.started;
    }

    @Override
    public CountDownLatch getFinished() {
        return this.finished;
    }

    @Override
    public InputStream getInputStream() {
        this.lastRequest = System.currentTimeMillis();
        return this.inputStream;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }
}

