/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OClusterRepairInfoTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 19;
    private int clusterId;

    public OClusterRepairInfoTask() {
    }

    public OClusterRepairInfoTask(int clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        String clusterName = database.getClusterNameById(this.clusterId);
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Repair cluster acquiring information about cluster '%s' db=%s (reqId=%s)...", clusterName, database.getName(), requestId);
        ODatabaseRecordThreadLocal.instance().set(database);
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        ODistributedTxContext reqContext = ddb.registerTxContext(requestId);
        reqContext.lock(new ORecordId(this.clusterId, -1L), OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT.getValueAsLong() * 3L);
        long nextPosition = database.getStorage().getUnderlying().getClusterNextPosition(this.clusterId);
        return nextPosition - 1L;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.clusterId);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.clusterId = in.readInt();
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT.getValueAsLong() * 6L;
    }

    @Override
    public String getName() {
        return "repair_cluster_info";
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public int getFactoryId() {
        return 19;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    public int getClusterId() {
        return this.clusterId;
    }
}

