/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OResurrectRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.List;

public class ODeleteRecordTask
extends OAbstractRecordReplicatedTask {
    public static final int FACTORYID = 4;
    private byte[] previousRecordContent;
    private int previousRecordVersion;

    public ODeleteRecordTask() {
    }

    public ODeleteRecordTask(ORecord record) {
        this.init(record);
    }

    @Override
    public ODeleteRecordTask init(ORecordId rid, int version) {
        super.init(rid, version);
        return this;
    }

    @Override
    public ORecord getRecord() {
        return null;
    }

    @Override
    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.IN, "Deleting record %s/%s v.%d (reqId=%s)", database.getName(), this.rid.toString(), this.version, requestId);
        this.prepareUndoOperation();
        if (this.previousRecord == null) {
            return true;
        }
        ORecord loadedRecord = this.previousRecord;
        try {
            if (loadedRecord instanceof ODocument) {
                if (((ODocument)loadedRecord).isEdge()) {
                    database.delete(((ODocument)loadedRecord).asEdge().get());
                    return true;
                }
                if (((ODocument)loadedRecord).isVertex()) {
                    database.delete(((ODocument)loadedRecord).asVertex().get());
                    return true;
                }
            }
            loadedRecord.delete();
        }
        catch (ORecordNotFoundException oRecordNotFoundException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        return ((OFixCreateRecordTask)dManager.getTaskFactoryManager().getFactoryByServerName(executorNodeName).createTask(20)).init(this.rid, this.version);
    }

    @Override
    public ORemoteTask getUndoTask(ODistributedServerManager dManager, ODistributedRequestId reqId, List<String> servers) {
        if (this.previousRecord == null) {
            return null;
        }
        this.previousRecord = Orient.instance().getRecordFactoryManager().newInstance(ORecordInternal.getRecordType(this.previousRecord), this.rid.getClusterId(), ODatabaseRecordThreadLocal.instance().get());
        ORecordInternal.fill(this.previousRecord, this.rid, this.previousRecordVersion, this.previousRecordContent, true);
        OResurrectRecordTask task = ((OResurrectRecordTask)dManager.getTaskFactoryManager().getFactoryByServerNames(servers).createTask(11)).init(this.previousRecord);
        task.setLockRecords(false);
        return task;
    }

    @Override
    public void checkRecordExists() {
    }

    @Override
    public String getName() {
        return "record_delete";
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.rid + ")";
    }

    @Override
    public int getFactoryId() {
        return 4;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @Override
    public ORecord prepareUndoOperation() {
        if (this.previousRecord == null) {
            OStorageOperationResult<ORawBuffer> loaded = ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying().readRecord(this.rid, null, true, false, null);
            if (loaded == null || loaded.getResult() == null) {
                return null;
            }
            this.previousRecordContent = loaded.getResult().buffer;
            this.previousRecordVersion = loaded.getResult().version;
            this.previousRecord = Orient.instance().getRecordFactoryManager().newInstance(loaded.getResult().recordType, this.rid.getClusterId(), ODatabaseRecordThreadLocal.instance().getIfDefined());
            ORecordInternal.fill(this.previousRecord, this.rid, this.previousRecordVersion, loaded.getResult().getBuffer(), false);
        }
        return this.previousRecord;
    }
}

